/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.internal;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.internal.JDBCDrivers;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.component.ComponentContext;

public class JDBCDriverService
extends Observable
implements LibraryChangeListener {
    private static final TraceComponent tc = Tr.register(JDBCDriverService.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final String FACTORY_PID = "com.ibm.ws.jdbc.jdbcDriver";
    static final String ID = "id";
    public static final String LIBRARY_REF = "libraryRef";
    public static final String JDBC_DRIVER = "jdbcDriver";
    public static final String TARGET_LIBRARY = "sharedLib.target";
    private static final List<String> PROPS_FOR_XA_ONLY = Arrays.asList("ifxIFX_XASPEC");
    private static final List<String> PROPS_NOT_SET_ON_DRIVER = Arrays.asList("isolationLevelSwitchingSupport");
    private static final AtomicBoolean FLAG_ORACLE_LOGGING_ACTIVE = new AtomicBoolean(false);
    private static final AtomicBoolean FLAG_ORACLE_LOGGING_DEACTIVE = new AtomicBoolean(false);
    private static final String ORACLELOG_PARENT_PACKAGENAME = "oracle";
    private ClassLoader classloader;
    private ConnectorService connectorSvc;
    private static ConcurrentLinkedQueue<ClassLoader> embDerbyRefCount = new ConcurrentLinkedQueue();
    private final HashSet<Class<? extends CommonDataSource>> introspectedClasses = new HashSet();
    private final AtomicBoolean isDerbyEmbedded = new AtomicBoolean();
    private boolean isInitialized;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private String name;
    private Dictionary<String, ?> properties;
    private Library sharedLib;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{props});
        }
        this.name = (String)props.get("config.displayId");
        this.lock.writeLock().lock();
        try {
            this.properties = props;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if ("file".equals(props.get("config.source")) && this.name.startsWith("application[")) {
            throw new IllegalArgumentException(ConnectorService.getMessage((String)"UNSUPPORTED_VALUE_J2CA8011", (Object[])new Object[]{this.name, ID, JDBC_DRIVER}));
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    private SQLException classNotFound(Object interfaceNames, Set<String> packagesSearched, String dsId, Throwable cause) {
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        String sharedLibId = this.sharedLib.id();
        Collection<String> driverJARs = JDBCDriverService.getClasspath(this.sharedLib, false);
        String message = sharedLibId.startsWith("com.ibm.ws.jdbc.jdbcDriver-") ? AdapterUtil.getNLSMessage("DSRA4001.no.suitable.driver.nested", interfaceNames, dsId, driverJARs, packagesSearched) : AdapterUtil.getNLSMessage("DSRA4000.no.suitable.driver", interfaceNames, dsId, sharedLibId, driverJARs, packagesSearched);
        return new SQLNonTransientException(message, cause);
    }

    private <T extends CommonDataSource> T create(final String className, final Hashtable<?, ?> props, String dsID) throws SQLException {
        boolean trace;
        if (this.classloader != null && className.startsWith("org.apache.derby.jdbc.Embedded") && this.isDerbyEmbedded.compareAndSet(false, true)) {
            embDerbyRefCount.add(this.classloader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"ref count for shutdown", (Object[])new Object[]{this.classloader, embDerbyRefCount});
            }
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"create", (Object[])new Object[]{className, this.classloader, PropertyService.hidePasswords(props)});
        }
        if (className.startsWith(ORACLELOG_PARENT_PACKAGENAME) && FLAG_ORACLE_LOGGING_ACTIVE.compareAndSet(false, true)) {
            this.setupOracleLogging();
        }
        if (className.startsWith("oracle.ucp.jdbc") && !props.containsKey("connectionFactoryClassName")) {
            if (className.equals("oracle.ucp.jdbc.PoolDataSourceImpl") && props instanceof PropertyService) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting connectionFactoryClassName property to oracle.jdbc.pool.OracleDataSource", (Object[])new Object[0]);
                }
                ((PropertyService)props).setProperty("connectionFactoryClassName", "oracle.jdbc.pool.OracleDataSource");
            } else if (className.equals("oracle.ucp.jdbc.PoolXADataSourceImpl") && props instanceof PropertyService) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting connectionFactoryClassName property to oracle.jdbc.xa.client.OracleXADataSource", (Object[])new Object[0]);
                }
                ((PropertyService)props).setProperty("connectionFactoryClassName", "oracle.jdbc.xa.client.OracleXADataSource");
            }
        }
        try {
            CommonDataSource ds = (CommonDataSource)AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T run() throws Exception {
                    ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
                    try {
                        ClassLoader loader;
                        if (JDBCDriverService.this.classloader == null) {
                            loader = origTCCL;
                        } else {
                            loader = JDBCDriverService.this.classloader;
                            Thread.currentThread().setContextClassLoader(loader);
                        }
                        Class<?> dsClass = loader.loadClass(className);
                        JDBCDriverService.this.introspectedClasses.add(dsClass);
                        CommonDataSource ds = (CommonDataSource)dsClass.newInstance();
                        Hashtable p = (Hashtable)props.clone();
                        for (PropertyDescriptor descriptor : Introspector.getBeanInfo(dsClass).getPropertyDescriptors()) {
                            String name = descriptor.getName();
                            Object value = p.remove(name);
                            if (value == null && name.equals("url")) {
                                value = p.remove("URL");
                            }
                            boolean isPassword = PropertyService.isPassword(name);
                            if (value == null) continue;
                            try {
                                if (value instanceof String) {
                                    String str = (String)value;
                                    if (!"connectionProperties".equals(name) || !className.startsWith("oracle.jdbc") || str.contains("javax.net.ssl.keyStorePassword") || str.contains("javax.net.ssl.trustStorePassword")) {
                                        // empty if block
                                    }
                                    str = JDBCDriverService.decodeOracleConnectionPropertiesPwds(str);
                                    if (isPassword) {
                                        str = PasswordUtil.getCryptoAlgorithm((String)str) == null ? str : PasswordUtil.decode((String)str);
                                    }
                                    JDBCDriverService.setProperty(ds, descriptor, str, !isPassword);
                                    continue;
                                }
                                if (trace && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("set " + name + " = " + value), (Object[])new Object[0]);
                                }
                                Class<?> targetType = descriptor.getWriteMethod().getParameterTypes()[0];
                                value = JDBCDriverService.coerceType(targetType, value);
                                descriptor.getWriteMethod().invoke((Object)ds, value);
                            }
                            catch (Throwable x) {
                                if (x instanceof InvocationTargetException) {
                                    x = x.getCause();
                                }
                                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"217", (Object)this, (Object[])new Object[]{className, name, value});
                                boolean isURL = ("URL".equals(name) || "url".equals(name)) && value instanceof String;
                                SQLException failure = (SQLException)JDBCDriverService.this.connectorSvc.ignoreWarnOrFail(tc, x, SQLException.class, "PROP_SET_ERROR", new Object[]{name, "=" + (isPassword ? "******" : (isURL ? PropertyService.filterURL((String)value) : value)), AdapterUtil.stackTraceToString(x)});
                                if (failure == null) continue;
                                throw failure;
                            }
                        }
                        if (!p.isEmpty()) {
                            for (Object propertyName : p.keySet()) {
                                SQLException failure;
                                if (PROPS_FOR_XA_ONLY.contains(propertyName) && !(ds instanceof XADataSource) || PROPS_NOT_SET_ON_DRIVER.contains(propertyName) || (failure = (SQLException)JDBCDriverService.this.connectorSvc.ignoreWarnOrFail(tc, null, SQLException.class, "PROP_NOT_FOUND", new Object[]{className, propertyName})) == null) continue;
                                throw failure;
                            }
                        }
                        CommonDataSource commonDataSource = ds;
                        return commonDataSource;
                    }
                    finally {
                        if (JDBCDriverService.this.classloader != null) {
                            Thread.currentThread().setContextClassLoader(origTCCL);
                        }
                    }
                }
            });
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"create", (Object)ds);
            }
            return (T)ds;
        }
        catch (PrivilegedActionException privX) {
            SQLException sqlX;
            Throwable x = privX.getCause();
            FFDCFilter.processException((Throwable)x, (String)JDBCDriverService.class.getName(), (String)"234");
            int lastDot = className.lastIndexOf(46);
            Set<String> searched = Collections.singleton(lastDot > 0 ? className.substring(0, lastDot) : className);
            SQLException sQLException = x instanceof ClassNotFoundException ? this.classNotFound(className, searched, dsID, x) : (sqlX = x instanceof SQLException ? (SQLException)x : new SQLNonTransientException(x));
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"create", (Object)x);
            }
            throw sqlX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createAnyPreferLegacyOrder(Properties props, String dataSourceID) throws Exception {
        this.lock.readLock().lock();
        try {
            Driver driver;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            String vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties";
            String className = (String)this.properties.get(ConnectionPoolDataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true))) || null != (className = (String)this.properties.get(DataSource.class.getName())) || null != (className = JDBCDrivers.getDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getDataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true))) || null != (className = (String)this.properties.get(XADataSource.class.getName())) || null != (className = JDBCDrivers.getXADataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getXADataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true)))) {
                Object t = this.create(className, props, dataSourceID);
                return t;
            }
            String url = props.getProperty("URL", props.getProperty("url"));
            if (url != null && (driver = this.loadDriver(null, url, this.classloader, props, dataSourceID)) != null) {
                Driver driver2 = driver;
                return driver2;
            }
            LinkedHashSet<String> packagesSearched = new LinkedHashSet<String>();
            AbstractMap.SimpleEntry<Integer, String> dsEntry = JDBCDrivers.inferDataSourceClassFromDriver(this.classloader, packagesSearched, 1, 0, 2);
            if (dsEntry == null) {
                List<String> interfaceNames = Arrays.asList(ConnectionPoolDataSource.class.getName(), DataSource.class.getName(), XADataSource.class.getName(), Driver.class.getName());
                throw this.classNotFound(interfaceNames, packagesSearched, dataSourceID, null);
            }
            className = dsEntry.getValue();
            Object t = this.create(className, props, dataSourceID);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createAnyPreferXADataSource(Properties props, String dataSourceID) throws Exception {
        this.lock.readLock().lock();
        try {
            Driver driver;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            String vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties";
            String className = (String)this.properties.get(XADataSource.class.getName());
            if (null != className || null != (className = JDBCDrivers.getXADataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getXADataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true))) || null != (className = (String)this.properties.get(ConnectionPoolDataSource.class.getName())) || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getConnectionPoolDataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true))) || null != (className = (String)this.properties.get(DataSource.class.getName())) || null != (className = JDBCDrivers.getDataSourceClassName(vendorPropertiesPID)) || null != (className = JDBCDrivers.getDataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true)))) {
                Object t = this.create(className, props, dataSourceID);
                return t;
            }
            String url = props.getProperty("URL", props.getProperty("url"));
            if (url != null && (driver = this.loadDriver(null, url, this.classloader, props, "dataSource[DefaultDataSource]")) != null) {
                Driver driver2 = driver;
                return driver2;
            }
            LinkedHashSet<String> packagesSearched = new LinkedHashSet<String>();
            AbstractMap.SimpleEntry<Integer, String> dsEntry = JDBCDrivers.inferDataSourceClassFromDriver(this.classloader, packagesSearched, 2, 1, 0);
            if (dsEntry == null) {
                List<String> interfaceNames = Arrays.asList(XADataSource.class.getName(), ConnectionPoolDataSource.class.getName(), DataSource.class.getName(), Driver.class.getName());
                throw this.classNotFound(interfaceNames, packagesSearched, dataSourceID, null);
            }
            className = dsEntry.getValue();
            Object t = this.create(className, props, dataSourceID);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props, String dataSourceID) throws SQLException {
        this.lock.readLock().lock();
        try {
            String vendorPropertiesPID;
            String className;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            if ((className = (String)this.properties.get(ConnectionPoolDataSource.class.getName())) == null && (className = JDBCDrivers.getConnectionPoolDataSourceClassName(vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties")) == null) {
                if ("com.ibm.ws.jdbc.dataSource.properties.oracle.ucp".equals(vendorPropertiesPID)) {
                    throw new SQLNonTransientException(AdapterUtil.getNLSMessage("DSRA4015.no.ucp.connection.pool.datasource", dataSourceID, ConnectionPoolDataSource.class.getName()));
                }
                className = JDBCDrivers.getConnectionPoolDataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true));
                if (className == null) {
                    LinkedHashSet<String> packagesSearched = new LinkedHashSet<String>();
                    AbstractMap.SimpleEntry<Integer, String> dsEntry = JDBCDrivers.inferDataSourceClassFromDriver(this.classloader, packagesSearched, 1);
                    String string = className = dsEntry == null ? null : dsEntry.getValue();
                    if (className == null) {
                        throw this.classNotFound(ConnectionPoolDataSource.class.getName(), packagesSearched, dataSourceID, null);
                    }
                }
            }
            ConnectionPoolDataSource connectionPoolDataSource = (ConnectionPoolDataSource)this.create(className, props, dataSourceID);
            return connectionPoolDataSource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource createDataSource(Properties props, String dataSourceID) throws SQLException {
        this.lock.readLock().lock();
        try {
            String className;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            if ((className = (String)this.properties.get(DataSource.class.getName())) == null) {
                String vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties";
                className = JDBCDrivers.getDataSourceClassName(vendorPropertiesPID);
                if (className == null && (className = JDBCDrivers.getDataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true))) == null) {
                    LinkedHashSet<String> packagesSearched = new LinkedHashSet<String>();
                    AbstractMap.SimpleEntry<Integer, String> dsEntry = JDBCDrivers.inferDataSourceClassFromDriver(this.classloader, packagesSearched, 0);
                    String string = className = dsEntry == null ? null : dsEntry.getValue();
                    if (className == null) {
                        throw this.classNotFound(DataSource.class.getName(), packagesSearched, dataSourceID, null);
                    }
                }
            }
            DataSource dataSource = (DataSource)this.create(className, props, dataSourceID);
            return dataSource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XADataSource createXADataSource(Properties props, String dataSourceID) throws SQLException {
        this.lock.readLock().lock();
        try {
            String className;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            if ((className = (String)this.properties.get(XADataSource.class.getName())) == null) {
                String vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties";
                className = JDBCDrivers.getXADataSourceClassName(vendorPropertiesPID);
                if (className == null && (className = JDBCDrivers.getXADataSourceClassName(JDBCDriverService.getClasspath(this.sharedLib, true))) == null) {
                    LinkedHashSet<String> packagesSearched = new LinkedHashSet<String>();
                    AbstractMap.SimpleEntry<Integer, String> dsEntry = JDBCDrivers.inferDataSourceClassFromDriver(this.classloader, packagesSearched, 2);
                    String string = className = dsEntry == null ? null : dsEntry.getValue();
                    if (className == null) {
                        throw this.classNotFound(XADataSource.class.getName(), packagesSearched, dataSourceID, null);
                    }
                }
            }
            XADataSource xADataSource = (XADataSource)this.create(className, props, dataSourceID);
            return xADataSource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDriver(String url, Properties props, String dataSourceID) throws Exception {
        this.lock.readLock().lock();
        try {
            Driver driver;
            String className;
            if (!this.isInitialized) {
                try {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    if (!this.isInitialized) {
                        if (!this.loadFromApp()) {
                            this.classloader = AdapterUtil.getClassLoaderWithPriv(this.sharedLib);
                        }
                        this.isInitialized = true;
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            if ((className = (String)this.properties.get(Driver.class.getName())) == null) {
                String vendorPropertiesPID;
                String string = vendorPropertiesPID = props instanceof PropertyService ? ((PropertyService)props).getFactoryPID() : "com.ibm.ws.jdbc.dataSource.properties";
                if ("com.ibm.ws.jdbc.dataSource.properties.oracle.ucp".equals(vendorPropertiesPID)) {
                    throw new SQLNonTransientException(AdapterUtil.getNLSMessage("DSRA4015.no.ucp.connection.pool.datasource", dataSourceID, Driver.class.getName()));
                }
            }
            if ((driver = this.loadDriver(className, url, this.classloader, props, dataSourceID)) == null) {
                throw this.classNotFound(Driver.class.getName(), Collections.singleton("META-INF/services/java.sql.Driver"), dataSourceID, null);
            }
            Driver driver2 = driver;
            return driver2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        Logger parentLogger;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
        }
        if (FLAG_ORACLE_LOGGING_DEACTIVE.compareAndSet(false, true) && !(parentLogger = Logger.getLogger(ORACLELOG_PARENT_PACKAGENAME)).getUseParentHandlers()) {
            for (Handler h : parentLogger.getHandlers()) {
                h.close();
            }
        }
        this.lock.writeLock().lock();
        try {
            if (this.isInitialized) {
                if (this.classloader != null) {
                    if (this.isDerbyEmbedded.get()) {
                        this.shutdownDerbyEmbedded();
                    }
                    this.classloader = null;
                }
                Iterator<Class<? extends CommonDataSource>> it = this.introspectedClasses.iterator();
                while (it.hasNext()) {
                    Introspector.flushFromCaches(it.next());
                    it.remove();
                }
                this.isInitialized = false;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"deactivate");
        }
    }

    public ClassLoader getClassLoaderForLibraryRef() {
        this.lock.readLock().lock();
        try {
            ClassLoader classLoader = this.classloader;
            return classLoader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static Collection<String> getClasspath(Library sharedLib, boolean upperCaseFileNamesOnly) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClasspath", (Object[])new Object[]{sharedLib});
        }
        LinkedList<String> classpath = new LinkedList<String>();
        if (sharedLib != null && sharedLib.getFiles() != null) {
            for (File file : sharedLib.getFiles()) {
                classpath.add(upperCaseFileNamesOnly ? file.getName().toUpperCase() : file.getAbsolutePath());
            }
        }
        if (sharedLib != null && sharedLib.getFilesets() != null) {
            for (Fileset fileset : sharedLib.getFilesets()) {
                for (File file : fileset.getFileset()) {
                    classpath.add(upperCaseFileNamesOnly ? file.getName().toUpperCase() : file.getAbsolutePath());
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClasspath", classpath);
        }
        return classpath;
    }

    private Driver loadDriver(final String className, String url, final ClassLoader classloader, Properties props, String dataSourceID) throws Exception {
        Iterable<Driver> drivers;
        Object loginTimeout;
        int index;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"loadDriver", (Object[])new Object[]{className, PropertyService.filterURL(url), classloader});
        }
        if ((index = url.toLowerCase().indexOf("logintimeout")) != -1) {
            int length = url.length();
            if ((index += 13) < length && !url.substring(index, index + 1).equals("0")) {
                throw new SQLNonTransientException(AdapterUtil.getNLSMessage("DSRA4005.invalid.logintimeout", dataSourceID));
            }
            if (index + 1 < length && !Character.isDigit(url.charAt(index + 1))) {
                throw new SQLNonTransientException(AdapterUtil.getNLSMessage("DSRA4005.invalid.logintimeout", dataSourceID));
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Allowing value of 0 for loginTimeout in URL", (Object[])new Object[0]);
            }
        }
        if ((loginTimeout = props.get("loginTimeout")) != null && !loginTimeout.toString().equals("0")) {
            throw new SQLNonTransientException(AdapterUtil.getNLSMessage("DSRA4005.invalid.logintimeout", dataSourceID));
        }
        if (className == null) {
            drivers = classloader == null ? ServiceLoader.load(Driver.class) : ServiceLoader.load(Driver.class, classloader);
        } else {
            Driver driver = AccessController.doPrivileged(new PrivilegedExceptionAction<Driver>(){

                @Override
                public Driver run() throws Exception {
                    ClassLoader loader = classloader == null ? Thread.currentThread().getContextClassLoader() : classloader;
                    Class<?> driverClass = loader.loadClass(className);
                    return (Driver)driverClass.newInstance();
                }
            });
            drivers = Collections.singleton(driver);
        }
        SQLException failure = null;
        for (Driver driver : drivers) {
            boolean acceptsURL;
            try {
                acceptsURL = driver.acceptsURL(url);
            }
            catch (SQLException x) {
                if (failure == null) {
                    failure = x;
                }
                acceptsURL = false;
            }
            if (acceptsURL) {
                if (classloader != null && url.startsWith("jdbc:derby:") && this.isDerbyEmbedded.compareAndSet(false, true)) {
                    embDerbyRefCount.add(classloader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"ref count for shutdown", (Object[])new Object[]{classloader, embDerbyRefCount});
                    }
                }
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"loadDriver", (Object)driver);
                }
                return driver;
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)(driver + " does not accept url"), (Object[])new Object[0]);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"loadDriver", failure);
        }
        if (failure == null) {
            return null;
        }
        throw failure;
    }

    public boolean loadFromApp() {
        return Boolean.parseBoolean((String)this.properties.get("ibm.internal.nonship.function")) && "ibm.internal.simulate.no.library.do.not.ship".equals(this.sharedLib.id());
    }

    public void libraryNotification() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"libraryNotification", (Object[])new Object[0]);
        }
        this.modified(null, true);
    }

    protected void modified(ComponentContext context) {
        Dictionary newProperties = context.getProperties();
        this.modified(newProperties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modified(Dictionary<String, ?> newProperties, boolean logMessage) {
        boolean trace;
        block14: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[]{newProperties});
            }
            boolean replaced = false;
            this.lock.writeLock().lock();
            try {
                if (this.isInitialized) {
                    if (this.classloader != null) {
                        if (this.isDerbyEmbedded.compareAndSet(true, false)) {
                            this.shutdownDerbyEmbedded();
                        }
                        this.classloader = null;
                    }
                    Iterator<Class<? extends CommonDataSource>> it = this.introspectedClasses.iterator();
                    while (it.hasNext()) {
                        Introspector.flushFromCaches(it.next());
                        it.remove();
                    }
                    replaced = true;
                    this.isInitialized = false;
                }
                if (newProperties != null) {
                    this.properties = newProperties;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (replaced) {
                try {
                    this.setChanged();
                    this.notifyObservers();
                }
                catch (Throwable x) {
                    FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"254", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)x.getMessage(), (Object[])new Object[]{AdapterUtil.stackTraceToString(x)});
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    private static void setProperty(Object obj, PropertyDescriptor pd, String value, boolean doTraceValue) throws Exception {
        Method setter;
        Object param = null;
        String propName = pd.getName();
        if (tc.isDebugEnabled()) {
            if ("URL".equals(propName) || "url".equals(propName)) {
                Tr.debug((TraceComponent)tc, (String)("set " + propName + " = " + PropertyService.filterURL(value)), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("set " + propName + " = " + (doTraceValue ? value : "******")), (Object[])new Object[0]);
            }
        }
        if ((setter = pd.getWriteMethod()) == null) {
            throw new NoSuchMethodException(AdapterUtil.getNLSMessage("NO_SETTER_METHOD", propName));
        }
        Class<?> paramType = setter.getParameterTypes()[0];
        if (!paramType.isPrimitive()) {
            if (paramType.equals(String.class)) {
                param = value;
            } else if (paramType.equals(Properties.class)) {
                param = AdapterUtil.toProperties(value);
            } else if (paramType.equals(Character.class)) {
                param = Character.valueOf(value.charAt(0));
            } else if (paramType.equals(char[].class)) {
                param = value.toCharArray();
            } else if (paramType.isEnum()) {
                try {
                    param = Enum.valueOf(paramType, value.toUpperCase());
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(AdapterUtil.getNLSMessage("DSRA4016.enum.property.vaue.not.valid", value, propName), ex);
                }
            } else {
                param = paramType.getConstructor(String.class).newInstance(value);
            }
        } else if (paramType.equals(Integer.TYPE)) {
            param = Integer.valueOf(value);
        } else if (paramType.equals(Long.TYPE)) {
            param = Long.valueOf(value);
        } else if (paramType.equals(Boolean.TYPE)) {
            param = Boolean.valueOf(value);
        } else if (paramType.equals(Double.TYPE)) {
            param = Double.valueOf(value);
        } else if (paramType.equals(Float.TYPE)) {
            param = Float.valueOf(value);
        } else if (paramType.equals(Short.TYPE)) {
            param = Short.valueOf(value);
        } else if (paramType.equals(Byte.TYPE)) {
            param = Byte.valueOf(value);
        } else if (paramType.equals(Character.TYPE)) {
            param = Character.valueOf(value.charAt(0));
        }
        setter.invoke(obj, param);
    }

    protected void setSharedLib(Library lib) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setSharedLib", (Object[])new Object[]{lib});
        }
        this.sharedLib = lib;
    }

    @FFDCIgnore(value={Exception.class})
    private void setupOracleLogging() {
        Level traceLevel;
        Formatter formatter;
        String method = "setupCustomOracleLogging";
        String ORACLELOG_ENABLE_TRACE = "oracle.jdbc.Trace";
        String ORACLELOG_FILE_SIZE_LIMIT = "oracleLogFileSizeLimit";
        String ORACLELOG_FILE_COUNT = "oracleLogFileCount";
        String ORACLELOG_FILENAME = "oracleLogFileName";
        String ORACLELOG_TRACELEVEL = "oracleLogTraceLevel";
        String ORACLELOG_FORMAT = "oracleLogFormat";
        String ORACLELOG_PACKAGENAME = "oracleLogPackageName";
        Logger parentLogger = Logger.getLogger(ORACLELOG_PARENT_PACKAGENAME);
        if (!parentLogger.getUseParentHandlers()) {
            return;
        }
        if (System.getProperty("oracleLogFileName") != null == (System.getProperty("oracleLogPackageName") != null) && System.getProperty("oracleLogPackageName") != null == Boolean.getBoolean("oracle.jdbc.Trace")) {
            if (!Boolean.getBoolean("oracle.jdbc.Trace")) {
                return;
            }
        } else {
            if (tc.isInfoEnabled() && Boolean.getBoolean("oracle.jdbc.Trace")) {
                Tr.info((TraceComponent)tc, (String)"ORACLE_TRACE_ENABLE_INFO", (Object[])new Object[]{"oracle.jdbc.Trace", "oracleLogFileName, oracleLogPackageName"});
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupCustomOracleLogging", (Object[])new Object[0]);
        }
        String fileName = null;
        String packageName = null;
        int fileSizeLimit = -1;
        int fileCountLimit = -1;
        boolean defaultFileSizeLimit = false;
        boolean defaultFileCountLimit = true;
        SimpleFormatter defaultFormatter = new SimpleFormatter();
        Level defaultLevel = Level.INFO;
        HashMap<String, Exception> parseExceptions = new HashMap<String, Exception>();
        String holder = null;
        holder = System.getProperty("oracleLogFileName");
        if (holder != null && !holder.equals("")) {
            fileName = holder;
        }
        if ((holder = System.getProperty("oracleLogPackageName")) != null && !holder.equals("")) {
            packageName = holder;
        }
        holder = System.getProperty("oracleLogFileSizeLimit");
        try {
            if (holder != null && !holder.equals("")) {
                fileSizeLimit = Integer.parseInt(holder);
                if (fileSizeLimit < 0) {
                    throw new NumberFormatException("oracleLogFileSizeLimit < 0");
                }
            } else {
                fileSizeLimit = 0;
            }
        }
        catch (NumberFormatException e) {
            fileSizeLimit = 0;
            parseExceptions.put("oracleLogFileSizeLimit", e);
        }
        holder = System.getProperty("oracleLogFileCount");
        try {
            if (holder != null && !holder.equals("")) {
                fileCountLimit = Integer.parseInt(holder);
                if (fileCountLimit < 1) {
                    throw new NumberFormatException("oracleLogFileCount < 1");
                }
            } else {
                fileCountLimit = 1;
            }
        }
        catch (NumberFormatException e) {
            fileCountLimit = 1;
            parseExceptions.put("oracleLogFileCount", e);
        }
        holder = System.getProperty("oracleLogFormat");
        try {
            formatter = holder != null && !holder.equals("") ? (holder.toLowerCase().contains("simpleformatter") ? defaultFormatter : (holder.toLowerCase().contains("xmlformatter") ? new XMLFormatter() : (Formatter)Class.forName(holder).getConstructor(new Class[0]).newInstance(new Object[0]))) : defaultFormatter;
        }
        catch (Exception e) {
            formatter = defaultFormatter;
            parseExceptions.put("oracleLogFormat", e);
        }
        holder = System.getProperty("oracleLogTraceLevel");
        try {
            traceLevel = holder != null && !holder.equals("") ? Level.parse(holder) : defaultLevel;
        }
        catch (IllegalArgumentException e) {
            traceLevel = defaultLevel;
            parseExceptions.put("oracleLogTraceLevel", e);
        }
        if (tc.isWarningEnabled() && !parseExceptions.isEmpty()) {
            for (Map.Entry entry : parseExceptions.entrySet()) {
                Tr.warning((TraceComponent)tc, (String)"ORACLE_TRACE_PARSE_WARNING", (Object[])new Object[]{entry.getKey(), ((Exception)entry.getValue()).getClass().getName() + ": " + ((Exception)entry.getValue()).getLocalizedMessage()});
            }
        }
        int directoryEnds = fileName.contains("/") ? fileName.lastIndexOf("/") : 0;
        String originalFileName = fileName;
        fileName = fileName.substring(0, directoryEnds) + (fileName.contains(".") ? fileName.substring(directoryEnds).replaceFirst("\\.", ".%g.%u.") : fileName.substring(directoryEnds).concat(".%g.%u.log"));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ORACLELOG_FILENAME is:  " + originalFileName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ORACLELOG_PACKAGENAME is: " + packageName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ORACLELOG_FILE_SIZE_LIMIT is: " + fileSizeLimit), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ORACLELOG_FILE_COUNT is: " + fileCountLimit), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ORACLELOG_FORMAT is: " + formatter.getClass()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ORACLELOG_TRACELEVEL is: " + traceLevel.getName()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("File name provided to java.util.logging: " + fileName), (Object[])new Object[0]);
        }
        Logger logger = Logger.getLogger(packageName);
        try {
            FileHandler handler = new FileHandler(fileName, fileSizeLimit, fileCountLimit);
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            parentLogger.setLevel(traceLevel);
            parentLogger.setUseParentHandlers(false);
            parentLogger.addHandler(handler);
            LogManager.getLogManager().addLogger(parentLogger);
            if (!logger.getName().equalsIgnoreCase(parentLogger.getName())) {
                logger.setLevel(traceLevel);
                logger.setParent(parentLogger);
                logger.setUseParentHandlers(true);
                LogManager.getLogManager().addLogger(logger);
            }
        }
        catch (IOException iox) {
            Tr.warning((TraceComponent)tc, (String)"ORACLE_TRACE_WARNING", (Object[])new Object[]{fileName, iox});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupCustomOracleLogging");
        }
    }

    private void shutdownDerbyEmbedded() {
        block9: {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object[])new Object[]{this.classloader, embDerbyRefCount});
            }
            if (embDerbyRefCount.remove(this.classloader) && !embDerbyRefCount.contains(this.classloader)) {
                try {
                    Class<?> EmbDS = AdapterUtil.forNameWithPriv("org.apache.derby.jdbc.EmbeddedDataSource40", true, this.classloader);
                    DataSource ds = (DataSource)EmbDS.newInstance();
                    EmbDS.getMethod("setShutdownDatabase", String.class).invoke((Object)ds, "shutdown");
                    ds.getConnection().close();
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded");
                    }
                    break block9;
                }
                catch (SQLException x) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)(x.getSQLState() + ' ' + x.getErrorCode() + ':' + x.getMessage()));
                    }
                    break block9;
                }
                catch (Throwable x) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)x);
                    }
                    break block9;
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdownDerbyEmbedded", (Object)false);
            }
        }
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    protected void unsetSharedLib(Library lib) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unsetSharedLib", (Object[])new Object[]{lib});
        }
        this.modified(null, false);
    }

    public static String decodeOracleConnectionPropertiesPwds(String connProp) throws InvalidPasswordDecodingException, UnsupportedCryptoAlgorithmException {
        String regex = "Password\\s*=\\s*(.*?)\\s*(;|$)";
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("Password\\s*=\\s*(.*?)\\s*(;|$)");
        Matcher matcher = pattern.matcher(connProp);
        while (matcher.find()) {
            String password = matcher.group(1);
            password = PasswordUtil.getCryptoAlgorithm((String)password) == null ? password : PasswordUtil.decode((String)matcher.group(1));
            matcher.appendReplacement(sb, matcher.group(0).replace(matcher.group(1), password));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Trivial
    private static Object coerceType(Class<?> desiredType, Object val) {
        if (desiredType.isAssignableFrom(val.getClass())) {
            return val;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"coerceType", (Object[])new Object[]{val.getClass().getName() + " -> " + desiredType.getName()});
        }
        if (val instanceof String) {
            String str = (String)val;
            if (desiredType == Long.TYPE || desiredType == Long.class) {
                return Long.valueOf(str);
            }
            if (desiredType == Integer.TYPE || desiredType == Integer.class) {
                return Integer.valueOf(str);
            }
            if (desiredType == Short.TYPE || desiredType == Short.class) {
                return Short.valueOf(str);
            }
        } else {
            if (desiredType == String.class) {
                return val.toString();
            }
            if (val instanceof Number) {
                Number num = (Number)val;
                if (desiredType == Long.TYPE || desiredType == Long.class) {
                    return num.longValue();
                }
                if (desiredType == Integer.TYPE || desiredType == Integer.class) {
                    return num.intValue();
                }
                if (desiredType == Short.TYPE || desiredType == Short.class) {
                    return num.shortValue();
                }
            }
        }
        return val;
    }
}

