/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.srt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.inputstream.HttpInputStreamConnectWeb;
import com.ibm.ws.webcontainer.srt.SRTInputStream;
import com.ibm.ws.webcontainer31.async.AsyncAlreadyReadCallback;
import com.ibm.ws.webcontainer31.async.AsyncContext31Impl;
import com.ibm.ws.webcontainer31.async.AsyncReadCallback;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.srt.SRTServletRequest31;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.ee7.HttpInputStreamEE7;
import jakarta.servlet.ReadListener;
import java.io.IOException;
import java.io.InputStream;

public class SRTInputStream31
extends SRTInputStream {
    protected HttpInputStreamEE7 httpin;
    private ReadListener listener = null;
    private InterChannelCallback callback;
    private SRTServletRequest31 request;
    private final Object lockObj = new Object(){};
    private final Object completeLockObj = new Object(){};
    private boolean asyncReadOutstanding = false;
    private boolean readLineCall = false;
    private boolean isClosed = false;
    private static final TraceComponent tc = Tr.register(SRTInputStream31.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");

    public SRTInputStream31(SRTServletRequest31 request) {
        this.request = request;
    }

    public void init(InputStream in) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing the stream : " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if (in != null) {
            if (in instanceof HttpInputStreamEE7) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"init , Servlet 3.1 enabled, casting to HttpInputStreamExtended", (Object[])new Object[0]);
                }
                this.httpin = (HttpInputStreamEE7)in;
            }
            this.in = in;
            if (in instanceof HttpInputStreamConnectWeb) {
                this.inStream = (HttpInputStreamConnectWeb)in;
            }
        } else {
            this.httpin = null;
            this.in = null;
            this.inStream = null;
        }
        this.listener = null;
        this.asyncReadOutstanding = false;
        this.readLineCall = false;
        this.isClosed = false;
    }

    public boolean isFinished() {
        if (this.isClosed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Stream is closed so it is finished", (Object[])new Object[0]);
            }
            return true;
        }
        boolean isFinished = this.httpin.isFinished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isFinished returning : " + isFinished), (Object[])new Object[0]);
        }
        return isFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isReady", (Object[])new Object[]{this.listener});
        }
        if (this.listener == null || this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isReady", (Object)"ReadListener not set or isFinished returned true");
            }
            return true;
        }
        boolean isReady = false;
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.asyncReadOutstanding) {
                if (!this.checkAvailable()) {
                    isReady = this.httpin.asyncCheckBuffers(this.callback);
                    if (!isReady) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"asyncCheckBuffers returned false. An async read is now outstanding or no more data", (Object[])new Object[0]);
                        }
                        this.asyncReadOutstanding = true;
                    }
                } else {
                    isReady = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isReady", (Object)(isReady + " " + this.listener));
        }
        return isReady;
    }

    private boolean checkAvailable() {
        int i;
        block3: {
            i = 0;
            try {
                i = this.in.available();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Current amount immediately available in buffers : " + i), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("There was an IOException during the checkAvailable method : " + e), (Object[])new Object[0]);
            }
        }
        return i > 0;
    }

    public void setReadListener(ReadListener arg0) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setReadListener", (Object[])new Object[]{this.listener});
        }
        if (arg0 == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.is.null", (Object[])new Object[0]);
            }
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.is.null", (Object[])new Object[0]));
        }
        if (!this.request.isAsyncStarted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.async.not.started", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.async.not.started", (Object[])new Object[0]));
        }
        if (this.listener != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"readlistener.already.started", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"readlistener.already.started", (Object[])new Object[0]));
        }
        this.listener = arg0;
        ThreadContextManager tcm = new ThreadContextManager();
        this.callback = this.getISC() == null ? new AsyncAlreadyReadCallback(this, tcm) : new AsyncReadCallback(this, tcm, this.request.getAsyncContext());
        AsyncContext31Impl ac = (AsyncContext31Impl)this.request.getAsyncContext();
        try {
            ac.startReadListener(tcm, this);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An exception occurred while setting the ReadListener : " + e), (Object[])new Object[0]);
            }
            this.listener.onError((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setReadListener", (Object)this.listener);
        }
    }

    public HttpInboundServiceContext getISC() {
        return this.httpin.getISC();
    }

    public void initialRead() {
        this.httpin.initialRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int returnByte;
        if (this.isClosed || this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nothing to read, stream is closed : " + this.isClosed + ", or finished : " + this.isFinished()), (Object[])new Object[0]);
            }
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{"SRTInputStream31.read()"});
        }
        if (this.request.isAsyncStarted() && this.getReadListener() != null) {
            SRTInputStream31 sRTInputStream31 = this;
            synchronized (sRTInputStream31) {
                this.isReadyFalseCheck();
                returnByte = super.read();
            }
        } else {
            returnByte = super.read();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)("SRTInputStream31.read() : " + returnByte));
        }
        return returnByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] output) throws IOException {
        if (this.isClosed || this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nothing to read, stream is closed : " + this.isClosed + ", or finished : " + this.isFinished()), (Object[])new Object[0]);
            }
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{"SRTInputStream31.read(byte[])"});
        }
        if (output == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]);
            }
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]));
        }
        int returnSize = 0;
        if (this.request.isAsyncStarted() && this.getReadListener() != null) {
            SRTInputStream31 sRTInputStream31 = this;
            synchronized (sRTInputStream31) {
                this.isReadyFalseCheck();
                returnSize = super.read(output);
            }
        } else {
            returnSize = super.read(output);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)("SRTInputStream31.read(byte[]) : " + returnSize));
        }
        return returnSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] output, int offset, int length) throws IOException {
        if (this.isClosed || this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nothing to read, stream is closed : " + this.isClosed + ", or finished : " + this.isFinished()), (Object[])new Object[0]);
            }
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object[])new Object[]{"SRTInputStream31.read(byte[], int, int)"});
        }
        if (output == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]);
            }
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]));
        }
        if (offset < 0 || length < 0 || length > output.length - offset) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{offset, length, output.length});
            }
            throw new IndexOutOfBoundsException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{offset, length, output.length}));
        }
        int returnSize = 0;
        if (this.request.isAsyncStarted() && this.getReadListener() != null) {
            SRTInputStream31 sRTInputStream31 = this;
            synchronized (sRTInputStream31) {
                this.isReadyFalseCheck();
                returnSize = super.read(output, offset, length);
            }
        } else {
            returnSize = super.read(output, offset, length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)("SRTInputStream31.read(byte[], int, int) : " + returnSize));
        }
        return returnSize;
    }

    private void isReadyFalseCheck() {
        if (this.listener != null && !this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking for readLine or if there is data available : " + this.readLineCall + ", " + this.checkAvailable()), (Object[])new Object[0]);
            }
            if (!this.readLineCall && !this.checkAvailable()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"read.failed.isReady.false", (Object[])new Object[0]);
                }
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"read.failed.isReady.false", (Object[])new Object[0]));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ReadListener is not set or the stream is finished : " + this.listener + ", " + this.isFinished()), (Object[])new Object[0]);
        }
    }

    public ReadListener getReadListener() {
        return this.listener;
    }

    public void setAsyncReadOutstanding(boolean asyncReadOutstanding) {
        this.asyncReadOutstanding = asyncReadOutstanding;
    }

    public void prepareAsyncReadListener() {
        AsyncContext31Impl ac = (AsyncContext31Impl)this.request.getAsyncContext();
        ac.continueReadListener();
    }

    public Object getCompleteLockObj() {
        return this.completeLockObj;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        if (this.isClosed || this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nothing to read, stream is closed : " + this.isClosed + ", or finished : " + this.isFinished()), (Object[])new Object[0]);
            }
            return -1;
        }
        this.readLineCall = true;
        int readLineReturn = super.readLine(b, off, len);
        this.readLineCall = false;
        return readLineReturn;
    }

    public long skip(long n) throws IOException {
        if (this.isClosed || this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nothing to read, stream is closed : " + this.isClosed + ", or finished : " + this.isFinished()), (Object[])new Object[0]);
            }
            return -1L;
        }
        return super.skip(n);
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The input stream has been closed : " + (Object)((Object)this) + " read Listener running ->" + this.listener), (Object[])new Object[0]);
        }
        this.isClosed = true;
        this.listener = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The input stream has been closed : " + (Object)((Object)this) + " read Listener ->" + this.listener), (Object[])new Object[0]);
        }
        super.close();
    }

    public void restart() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"restart", (Object[])new Object[]{"SRTInputStream31: Start re-read of data"});
        }
        this.isClosed = false;
        super.restart();
    }

    public InterChannelCallback getCallback() {
        return this.callback;
    }
}

