/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.upgrade;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer31.srt.SRTUpgradeInputStream31;
import com.ibm.ws.webcontainer31.srt.SRTUpgradeOutputStream31;
import com.ibm.ws.webcontainer31.upgrade.HttpUpgradeHandlerWrapper;
import com.ibm.ws.webcontainer31.util.UpgradeInputByteBufferUtil;
import com.ibm.ws.webcontainer31.util.UpgradeOutputByteBufferUtil;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.WebConnection;
import java.io.IOException;

public class UpgradedWebConnectionImpl
implements WebConnection {
    private static final TraceComponent tc = Tr.register(UpgradedWebConnectionImpl.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private TCPConnectionContext tcpConn;
    private VirtualConnection virtualConn;
    private ConnectionLink deviceConnLink;
    private ConnectionLink connLink;
    private ConnectionLink dispatcherLink;
    private SRTUpgradeInputStream31 _in;
    private UpgradeInputByteBufferUtil _inbb;
    protected SRTUpgradeOutputStream31 _out;
    protected UpgradeOutputByteBufferUtil _outbb;
    HttpUpgradeHandlerWrapper _upgradeHandler;
    protected boolean _outputStreamObtained = false;
    private IExtendedRequest _req;
    private boolean webConnection_closeComplete = false;
    private boolean upgradeHandler_DestroyComplete = false;
    private boolean upgradeHandler_DestroyStarted = false;
    private boolean outputStream_CloseStartedFromWC = false;
    private boolean webConnection_closeOngoing = false;
    private boolean inputCallback = false;
    private Exception closeUpgradeException = null;

    public UpgradedWebConnectionImpl(IExtendedRequest req, HttpUpgradeHandlerWrapper upgradeHandler) {
        this._req = req;
        this._upgradeHandler = upgradeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.webConnection_closeComplete) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WebConnection close previously completed ...return ", (Object[])new Object[0]);
            }
            return;
        }
        if (this.upgradeHandler_DestroyStarted) {
            return;
        }
        UpgradedWebConnectionImpl upgradedWebConnectionImpl = this;
        synchronized (upgradedWebConnectionImpl) {
            if (this.webConnection_closeComplete || this.webConnection_closeOngoing) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WebConnection close previously completed .....return ", (Object[])new Object[0]);
                }
                return;
            }
            this.webConnection_closeOngoing = true;
            if (!this.upgradeHandler_DestroyComplete && this._upgradeHandler != null) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("call Handler destroy " + this._upgradeHandler), (Object[])new Object[0]);
                    }
                    this.upgradeHandler_DestroyStarted = true;
                    this._upgradeHandler.destroy();
                }
                finally {
                    this.upgradeHandler_DestroyComplete = true;
                    this.upgradeHandler_DestroyStarted = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Handler destroy successful" + this._upgradeHandler), (Object[])new Object[0]);
                    }
                }
            }
            if (this._in != null && this._in.getInputBufferHelper().get_tcpChannelCallback() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" input callback", (Object[])new Object[0]);
                }
                this.inputCallback = true;
            }
            try {
                if (this._in != null) {
                    this._in.close();
                }
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" closing of inputStream failed ..", (Object[])new Object[0]);
                }
                this.closeUpgradeException = ioe;
            }
            this.closeOutputandConnection();
        }
    }

    protected void closeOutputandConnection() {
        boolean hasOutputCallback_CloseLinkHere = false;
        if (this._out != null && this._out.callback != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" output callback", (Object[])new Object[0]);
            }
            hasOutputCallback_CloseLinkHere = true;
        }
        try {
            if (this._out != null) {
                this.setOutputStream_CloseStartedFromWC(true);
                this._out.close();
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" closing of outputStream failed ..", (Object[])new Object[0]);
            }
            this.closeUpgradeException = ioe;
        }
        if (this._outbb.isOutputStream_closed()) {
            try {
                if (hasOutputCallback_CloseLinkHere || this.inputCallback) {
                    this.virtualConn.getStateMap().put("CloseUpgradedWebConnection", "true");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" call dispatcherLink close--> " + this.dispatcherLink), (Object[])new Object[0]);
                    }
                    this.dispatcherLink.close(this.virtualConn, this.closeUpgradeException);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" no callbacks, don't close here... ", (Object[])new Object[0]);
                }
            }
            finally {
                this.webConnection_closeComplete = true;
                this.webConnection_closeOngoing = false;
                this._in = null;
                this._out = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" webConnection_closeComplete--> " + this.webConnection_closeComplete), (Object[])new Object[0]);
                }
            }
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._in == null) {
            this._in = new SRTUpgradeInputStream31();
            this._inbb = new UpgradeInputByteBufferUtil(this);
            this._in.init(this._inbb);
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._out == null) {
            this._out = new SRTUpgradeOutputStream31();
            this._outbb = new UpgradeOutputByteBufferUtil(this);
            this._out.init(this._outbb, this._req);
        }
        return this._out;
    }

    public TCPConnectionContext getTCPConnectionContext() {
        return this.tcpConn;
    }

    public void setTCPConnectionContext(TCPConnectionContext input) {
        this.tcpConn = input;
    }

    public ConnectionLink getDeviceConnLink() {
        return this.deviceConnLink;
    }

    public void setDeviceConnLink(ConnectionLink input) {
        this.deviceConnLink = input;
    }

    public VirtualConnection getVirtualConnection() {
        return this.virtualConn;
    }

    public void setVirtualConnection(VirtualConnection input) {
        this.virtualConn = input;
    }

    public void setConnLink(ConnectionLink connLink) {
        this.connLink = connLink;
    }

    public void setHttpDisapctherConnLink(ConnectionLink dispatcherLink) {
        this.dispatcherLink = dispatcherLink;
    }

    public boolean isOutputStream_CloseStartedFromWC() {
        return this.outputStream_CloseStartedFromWC;
    }

    public void setOutputStream_CloseStartedFromWC(boolean outputStream_CloseStartedFromWC) {
        this.outputStream_CloseStartedFromWC = outputStream_CloseStartedFromWC;
    }
}

