/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.helper.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.rest.RestRouteCache;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.List;

@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String INSTRUMENTATION_NAME = "io.openliberty.microprofile.telemetry";
    private static final String REST_RESOURCE_CLASS = "rest.resource.class";
    private static final String REST_RESOURCE_METHOD = "rest.resource.method";
    private static final String SPAN_CONTEXT = "otel.span.server.context";
    private static final String SPAN_PARENT_CONTEXT = "otel.span.server.parentContext";
    static final String SPAN_SCOPE = "otel.span.server.scope";
    private static final HttpServerAttributesGetterImpl HTTP_SERVER_ATTRIBUTES_GETTER;
    private static final NetServerAttributesGetterImpl NET_SERVER_ATTRIBUTES_GETTER;
    private static final RestRouteCache ROUTE_CACHE;
    private Instrumenter<ContainerRequestContext, ContainerResponseContext> instrumenter;
    @jakarta.ws.rs.core.Context
    private ResourceInfo resourceInfo;
    static final long serialVersionUID = -5522463118019607328L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TelemetryContainerFilter() {
    }

    @Inject
    public TelemetryContainerFilter(OpenTelemetry openTelemetry) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER));
        this.instrumenter = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)HttpServerAttributesExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).addAttributesExtractor((AttributesExtractor)NetServerAttributesExtractor.create((NetServerAttributesGetter)NET_SERVER_ATTRIBUTES_GETTER)).buildServerInstrumenter((TextMapGetter)new ContainerRequestContextTextMapGetter());
    }

    public void filter(ContainerRequestContext request) {
        Context parentContext = Context.current();
        if (!AgentDetection.isAgentActive() && this.instrumenter != null && this.instrumenter.shouldStart(parentContext, (Object)request)) {
            request.setProperty(REST_RESOURCE_CLASS, (Object)this.resourceInfo.getResourceClass());
            request.setProperty(REST_RESOURCE_METHOD, (Object)this.resourceInfo.getResourceMethod());
            Context spanContext = this.instrumenter.start(parentContext, (Object)request);
            Scope scope = spanContext.makeCurrent();
            request.setProperty(SPAN_CONTEXT, (Object)spanContext);
            request.setProperty(SPAN_PARENT_CONTEXT, (Object)parentContext);
            request.setProperty(SPAN_SCOPE, (Object)scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Context spanContext = (Context)request.getProperty(SPAN_CONTEXT);
        if (spanContext == null) {
            return;
        }
        try {
            if (this.instrumenter != null) {
                this.instrumenter.end(spanContext, (Object)request, (Object)response, null);
            }
        }
        finally {
            request.removeProperty(REST_RESOURCE_CLASS);
            request.removeProperty(REST_RESOURCE_METHOD);
            request.removeProperty(SPAN_CONTEXT);
            request.removeProperty(SPAN_PARENT_CONTEXT);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryContainerFilter", TelemetryContainerFilter.class, (String)"TELEMETRY", null);
        HTTP_SERVER_ATTRIBUTES_GETTER = new HttpServerAttributesGetterImpl();
        NET_SERVER_ATTRIBUTES_GETTER = new NetServerAttributesGetterImpl();
        ROUTE_CACHE = new RestRouteCache();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpServerAttributesGetterImpl
    implements HttpServerAttributesGetter<ContainerRequestContext, ContainerResponseContext> {
        static final long serialVersionUID = -5934440682609557535L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpServerAttributesGetterImpl() {
        }

        public String flavor(ContainerRequestContext request) {
            return null;
        }

        public String route(ContainerRequestContext request) {
            Method resourceMethod;
            Class resourceClass = (Class)request.getProperty(TelemetryContainerFilter.REST_RESOURCE_CLASS);
            String route = ROUTE_CACHE.getRoute(resourceClass, resourceMethod = (Method)request.getProperty(TelemetryContainerFilter.REST_RESOURCE_METHOD));
            if (route == null) {
                String contextRoot = request.getUriInfo().getBaseUri().getPath();
                UriBuilder template = UriBuilder.fromPath((String)contextRoot);
                if (resourceClass.isAnnotationPresent(Path.class)) {
                    template.path(resourceClass);
                }
                if (resourceMethod.isAnnotationPresent(Path.class)) {
                    template.path(resourceMethod);
                }
                route = template.toTemplate();
                ROUTE_CACHE.putRoute(resourceClass, resourceMethod, route);
            }
            return route;
        }

        public String method(ContainerRequestContext request) {
            return request.getMethod();
        }

        public String target(ContainerRequestContext request) {
            URI requestUri = request.getUriInfo().getRequestUri();
            String path = requestUri.getPath();
            String query = requestUri.getQuery();
            if (path != null && query != null && !query.isEmpty()) {
                return path + "?" + query;
            }
            return path;
        }

        public String scheme(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getScheme();
        }

        public Integer statusCode(ContainerRequestContext request, ContainerResponseContext response, @Nullable Throwable error) {
            return response.getStatus();
        }

        public List<String> requestHeader(ContainerRequestContext request, String name) {
            return (List)request.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public List<String> responseHeader(ContainerRequestContext request, ContainerResponseContext response, String name) {
            return (List)response.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryContainerFilter$HttpServerAttributesGetterImpl", HttpServerAttributesGetterImpl.class, (String)"TELEMETRY", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class NetServerAttributesGetterImpl
    implements NetServerAttributesGetter<ContainerRequestContext> {
        static final long serialVersionUID = -5638024563139446858L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NetServerAttributesGetterImpl() {
        }

        public String transport(ContainerRequestContext request) {
            return "ip_tcp";
        }

        public String hostName(ContainerRequestContext request) {
            return request.getUriInfo().getBaseUri().getHost();
        }

        public Integer hostPort(ContainerRequestContext request) {
            return request.getUriInfo().getBaseUri().getPort();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryContainerFilter$NetServerAttributesGetterImpl", NetServerAttributesGetterImpl.class, (String)"TELEMETRY", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContainerRequestContextTextMapGetter
    implements TextMapGetter<ContainerRequestContext> {
        static final long serialVersionUID = 3391957575289944268L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ContainerRequestContextTextMapGetter() {
        }

        public Iterable<String> keys(ContainerRequestContext carrier) {
            return carrier.getHeaders().keySet();
        }

        public String get(ContainerRequestContext carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return (String)((List)carrier.getHeaders().getOrDefault((Object)key, Collections.singletonList(null))).get(0);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.rest.TelemetryContainerFilter$ContainerRequestContextTextMapGetter", ContainerRequestContextTextMapGetter.class, (String)"TELEMETRY", null);
        }
    }
}

