/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.security.jwt.config.MpConfigProperties;
import java.util.Optional;
import java.util.Set;

public interface MpConfigProxyService {
    public static final TraceComponent tc = Tr.register(MpConfigProxyService.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");

    public String getVersion();

    default public boolean isMpConfigAvailable() {
        return true;
    }

    public MpConfigProxy getConfigProxy(ClassLoader var1);

    @Sensitive
    default public MpConfigProperties getConfigProperties(ClassLoader cl) {
        MpConfigProxy config = this.getConfigProxy(cl);
        Set<String> propertyNames = this.getSupportedConfigPropertyNames();
        MpConfigProperties mpConfigProps = new MpConfigProperties();
        for (String propertyName : propertyNames) {
            Optional<String> value = config.getOptionalValue(propertyName, String.class);
            if (value != null && value.isPresent()) {
                String valueString = value.get().trim();
                if (!valueString.isEmpty()) {
                    mpConfigProps.put((Object)propertyName, (Object)valueString);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(propertyName + " is empty. Ignore it."), (Object[])new Object[0]);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)(propertyName + " is not in mpConfig."), (Object[])new Object[0]);
        }
        return mpConfigProps;
    }

    public Set<String> getSupportedConfigPropertyNames();

    default public boolean isAcceptableMpConfigProperty(String propertyName) {
        return this.getSupportedConfigPropertyNames().contains(propertyName);
    }

    public static interface MpConfigProxy {
        public <T> Optional<T> getOptionalValue(String var1, Class<T> var2);
    }
}

