/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.config.xml.LibertyVariable;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={Introspector.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ConfigVariableIntrospection
implements Introspector {
    ConfigVariables configVariables;
    static final long serialVersionUID = -4777433941672167497L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setVariables(ConfigVariables cv) {
        this.configVariables = cv;
    }

    protected void unsetVariables(ConfigVariables cv) {
        if (cv == this.configVariables) {
            this.configVariables = null;
        }
    }

    public String getIntrospectorName() {
        return "ConfigVariables";
    }

    public String getIntrospectorDescription() {
        return "Lists all variables from server configuration files, command line properties, and the file system";
    }

    public void introspect(PrintWriter writer) {
        writer.println("User Config Variables");
        writer.println("---------------------");
        Collection<LibertyVariable> env = this.getConfigVariables();
        for (LibertyVariable lv : env) {
            if (lv.getSource() != LibertyVariable.Source.XML_CONFIG) continue;
            writer.print(lv.getName());
            writer.print("=");
            if (lv.getObscuredValue() != null) {
                writer.println(lv.getObscuredValue().replaceAll("\\\n", "<nl>"));
                continue;
            }
            if (lv.getDefaultValue() != null) {
                writer.println(lv.getDefaultValue().replaceAll("\\\n", "<nl>"));
                continue;
            }
            writer.println("[NO VALUE DEFINED]");
        }
        writer.println("---------------------\n");
        writer.println("Service Binding Variables from " + this.configVariables.getFileSystemVariableRootDirectories());
        writer.println("---------------------");
        for (LibertyVariable lv : env) {
            if (lv.getSource() != LibertyVariable.Source.FILE_SYSTEM) continue;
            writer.print(lv.getName());
            writer.print("=");
            writer.println(lv.getObscuredValue().replaceAll("\\\n", "<nl>"));
        }
        writer.println("---------------------\n");
        writer.println("Command Line Variables");
        writer.println("---------------------");
        for (LibertyVariable lv : env) {
            if (lv.getSource() != LibertyVariable.Source.COMMAND_LINE) continue;
            writer.print(lv.getName());
            writer.print("=");
            writer.println(lv.getObscuredValue().replaceAll("\\\n", "<nl>"));
        }
        writer.println("---------------------");
        writer.flush();
    }

    @Sensitive
    private Collection<LibertyVariable> getConfigVariables() {
        return AccessController.doPrivileged(new PrivilegedAction<Collection<LibertyVariable>>(){
            static final long serialVersionUID = -5139350255189499844L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Collection<LibertyVariable> run() {
                return ConfigVariableIntrospection.this.configVariables.getAllLibertyVariables();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.ConfigVariableIntrospection$1", 1.class, null, null);
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.diagnostics.osgi.ConfigVariableIntrospection", ConfigVariableIntrospection.class, null, null);
    }
}

