/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl;
import com.ibm.ws.annocache.info.internal.ActivityTimerImpl;
import com.ibm.ws.annocache.info.internal.ClassInfoCacheImpl;
import com.ibm.ws.annocache.info.internal.ClassInfoImpl;
import com.ibm.ws.annocache.info.internal.ClassVisitorImpl_Info;
import com.ibm.ws.annocache.info.internal.InfoStoreFactoryImpl;
import com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl;
import com.ibm.ws.annocache.info.internal.PackageInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.info.InfoStore;
import com.ibm.wsspi.annocache.info.InfoStoreException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class InfoStoreImpl
implements InfoStore {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.info");
    private static final Logger stateLogger = Logger.getLogger("com.ibm.ws.annocache.info.state");
    public static final String CLASS_NAME = "InfoStoreImpl";
    protected final String hashText;
    protected final InfoStoreFactoryImpl infoStoreFactory;
    protected final ClassSource_Aggregate classSource;
    protected ClassInfoCacheImpl classInfoCache;
    protected int streamCount;
    protected ActivityTimerImpl activityTimer;
    protected long streamTime;
    protected long scanTime;
    protected long ruleTime;
    static final long serialVersionUID = 7291389056753665444L;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getHashText", new Object[0]);
        }
        String string = this.hashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getHashText", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InfoStoreImpl(InfoStoreFactoryImpl infoStoreFactory, ClassSource_Aggregate classSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "<init>", new Object[]{infoStoreFactory, classSource});
        }
        this.activityTimer = new ActivityTimerImpl();
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.infoStoreFactory = infoStoreFactory;
        this.classSource = classSource;
        this.classInfoCache = new ClassInfoCacheImpl(this);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.getHashText());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InfoStoreFactoryImpl getInfoStoreFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getInfoStoreFactory", new Object[0]);
        }
        InfoStoreFactoryImpl infoStoreFactoryImpl = this.infoStoreFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            infoStoreFactoryImpl = infoStoreFactoryImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getInfoStoreFactory", infoStoreFactoryImpl);
        }
        return infoStoreFactoryImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate getClassSource() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getClassSource", new Object[0]);
        }
        ClassSource_Aggregate classSource_Aggregate = this.classSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSource_Aggregate = classSource_Aggregate;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getClassSource", classSource_Aggregate);
        }
        return classSource_Aggregate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void open() throws InfoStoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "open", new Object[0]);
        }
        String methodName = "open";
        try {
            this.getClassSource().open();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.info.internal.InfoStoreImpl", (String)"98", (Object)this, (Object[])new Object[0]);
            String eMsg = "[ " + this.getHashText() + " ] Failed to open class source ";
            throw InfoStoreException.wrap(logger, CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "open");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() throws InfoStoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "close", new Object[0]);
        }
        String methodName = "close";
        try {
            this.getClassSource().close();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.info.internal.InfoStoreImpl", (String)"122", (Object)this, (Object[])new Object[0]);
            String eMsg = "[ " + this.getHashText() + " ] Failed to close class source ";
            throw InfoStoreException.wrap(logger, CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void scanClass(String className) throws InfoStoreException {
        Object[] logParms;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "scanClass", new Object[]{className});
        }
        String methodName = "scanClass";
        if (logger.isLoggable(Level.FINER)) {
            logParms = new Object[]{this.getHashText(), className};
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] ENTER", logParms);
        } else {
            logParms = null;
        }
        ClassInfoImpl classInfo = this.getNonDelayedClassInfo(className);
        if (classInfo != null) {
            if (logParms != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] RETURN Already loaded", logParms);
            }
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "scanClass");
            }
            return;
        }
        this.scanNewClass(className);
        if (logParms != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] RETURN New load", logParms);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "scanClass");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void scanNewClass(String className) throws InfoStoreException {
        Object[] logParms;
        String methodName;
        block15: {
            String resourceName;
            block14: {
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "scanNewClass", new Object[]{className});
                }
                methodName = "scanNewClass";
                if (logger.isLoggable(Level.FINER)) {
                    logParms = new Object[]{this.getHashText(), className, null};
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] ENTER", logParms);
                } else {
                    logParms = null;
                }
                this.incrementStreamCount();
                this.startStreamTime();
                resourceName = ClassSourceImpl.resourceNameFromClassName(className);
                InputStream inputStream = null;
                try {
                    inputStream = this.getClassSource().openResourceStream(className, resourceName);
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.info.internal.InfoStoreImpl", (String)"183", (Object)this, (Object[])new Object[]{className});
                    String eMsg = "[ " + this.getHashText() + " ] Failed to open input stream for resource [ " + resourceName + " ] class [ " + className + " ] from [ " + this.getClassSource().getApplicationName() + ":" + this.getClassSource().getModuleName() + " ]";
                    throw InfoStoreException.wrap(logger, CLASS_NAME, methodName, eMsg, (Throwable)e);
                }
                if (inputStream == null) break block14;
                try {
                    this.scanNewClass(resourceName, className, inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        this.getClassSource().closeResourceStream(className, resourceName, inputStream);
                    }
                    catch (ClassSource_Exception classSource_Exception) {
                        void e;
                        FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.info.internal.InfoStoreImpl", (String)"204", (Object)this, (Object[])new Object[]{className});
                        String eMsg = "[ " + this.getHashText() + " ] Failed to close input stream for resource [ " + resourceName + " ] for class [ " + className + " ]";
                        throw InfoStoreException.wrap(logger, CLASS_NAME, methodName, eMsg, (Throwable)e);
                    }
                    this.endStreamTime();
                    throw throwable;
                }
                try {
                    this.getClassSource().closeResourceStream(className, resourceName, inputStream);
                }
                catch (ClassSource_Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.annocache.info.internal.InfoStoreImpl", (String)"204", (Object)this, (Object[])new Object[]{className});
                    String eMsg = "[ " + this.getHashText() + " ] Failed to close input stream for resource [ " + resourceName + " ] for class [ " + className + " ]";
                    throw InfoStoreException.wrap(logger, CLASS_NAME, methodName, eMsg, (Throwable)e);
                }
                this.endStreamTime();
                break block15;
            }
            this.endStreamTime();
            if (logParms != null) {
                logParms[2] = resourceName;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Failed to open input stream for Class [ {1} ], resource [ {2} ]", logParms);
            }
        }
        if (logParms != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] RETURN", logParms);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "scanNewClass");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void scanNewClass(String resourceName, String className, InputStream inputStream) throws InfoStoreException {
        Object[] logParms;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "scanNewClass", new Object[]{resourceName, className, inputStream});
        }
        String methodName = "scanNewClass";
        if (logger.isLoggable(Level.FINER)) {
            logParms = new Object[]{this.getHashText(), className, resourceName};
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER Class [ {1} ] from resource [ {2} ]", logParms);
        } else {
            logParms = null;
        }
        this.startScanTime();
        try {
            ClassReader classReader;
            try {
                classReader = new ClassReader(inputStream);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.annocache.info.internal.InfoStoreImpl", (String)"256", (Object)this, (Object[])new Object[]{resourceName, className, inputStream});
                String eMsg = "Class [ " + className + " ] from resource [ " + resourceName + " ] Exception creating reader";
                throw InfoStoreException.wrap(logger, CLASS_NAME, methodName, eMsg, (Throwable)e);
            }
            ClassVisitorImpl_Info infoVisitor = new ClassVisitorImpl_Info(this, className);
            try {
                classReader.accept((ClassVisitor)infoVisitor, 7);
            }
            catch (Exception eMsg) {
                void e;
                FFDCFilter.processException((Throwable)eMsg, (String)"com.ibm.ws.annocache.info.internal.InfoStoreImpl", (String)"270", (Object)this, (Object[])new Object[]{resourceName, className, inputStream});
                String eMsg2 = "Target [ " + className + " ] from resource [ " + resourceName + " ] Processing exception: " + e.getMessage();
                throw InfoStoreException.wrap(logger, CLASS_NAME, methodName, eMsg2, (Throwable)e);
            }
        }
        finally {
            this.endScanTime();
        }
        if (logParms != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN Class [ {1} ] from resource [ {2} ]", logParms);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "scanNewClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoCacheImpl getClassInfoCache() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getClassInfoCache", new Object[0]);
        }
        ClassInfoCacheImpl classInfoCacheImpl = this.classInfoCache;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoCacheImpl = classInfoCacheImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getClassInfoCache", classInfoCacheImpl);
        }
        return classInfoCacheImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internDescription(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internDescription", new Object[]{name});
        }
        String string = this.getClassInfoCache().internDescription(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internDescription", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internPackageName(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internPackageName", new Object[]{packageName});
        }
        String string = this.getClassInfoCache().internPackageName(packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internPackageName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internClassName(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internClassName", new Object[]{className});
        }
        String string = this.getClassInfoCache().internClassName(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internMethodName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internMethodName", new Object[]{name});
        }
        String string = this.getClassInfoCache().internMethodName(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internMethodName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String internFieldName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internFieldName", new Object[]{name});
        }
        String string = this.getClassInfoCache().internFieldName(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "internFieldName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PackageInfoImpl basicGetPackageInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "basicGetPackageInfo", new Object[]{name});
        }
        PackageInfoImpl packageInfoImpl = this.getClassInfoCache().basicGetPackageInfo(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "basicGetPackageInfo", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PackageInfoImpl basicAddPackageInfo(String name, int access) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "basicAddPackageInfo", new Object[]{name, access});
        }
        PackageInfoImpl packageInfoImpl = this.getClassInfoCache().basicAddPackageInfo(name, access);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "basicAddPackageInfo", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PackageInfoImpl getPackageInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getPackageInfo", new Object[]{name});
        }
        PackageInfoImpl packageInfoImpl = this.getClassInfoCache().getPackageInfo(name, false);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getPackageInfo", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected PackageInfoImpl getPackageInfo(String name, boolean doForce) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getPackageInfo", new Object[]{name, doForce});
        }
        PackageInfoImpl packageInfoImpl = this.getClassInfoCache().getPackageInfo(name, doForce);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getPackageInfo", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoImpl getDelayableClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getDelayableClassInfo", new Object[]{name});
        }
        ClassInfoImpl classInfoImpl = this.getClassInfoCache().getDelayableClassInfo(name, true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getDelayableClassInfo", classInfoImpl);
        }
        return classInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClassInfoImpl getNonDelayedClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getNonDelayedClassInfo", new Object[]{name});
        }
        ClassInfoImpl classInfoImpl = this.getClassInfoCache().getNonDelayedClassInfo(name, true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getNonDelayedClassInfo", classInfoImpl);
        }
        return classInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClassInfoImpl getDelayableClassInfo(Type type) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getDelayableClassInfo", new Object[]{type});
        }
        ClassInfoImpl classInfoImpl = this.getClassInfoCache().getDelayableClassInfo(type);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getDelayableClassInfo", classInfoImpl);
        }
        return classInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean addClassInfo(NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "addClassInfo", new Object[]{classInfo});
        }
        boolean bl = this.getClassInfoCache().addClassInfo(classInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "addClassInfo", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl createClassInfo(String name, String superName, int access, String[] interfaces) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "createClassInfo", new Object[]{name, superName, access, interfaces});
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.getClassInfoCache().createClassInfo(name, superName, access, interfaces);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "createClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl resolveClassInfo(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "resolveClassInfo", new Object[]{name});
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.getClassInfoCache().resolveClassInfo(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "resolveClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void recordAccess(NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "recordAccess", new Object[]{classInfo});
        }
        this.getClassInfoCache().recordAccess(classInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "recordAccess");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void removeAsDelayable(NonDelayedClassInfoImpl classInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "removeAsDelayable", new Object[]{classInfo});
        }
        this.getClassInfoCache().removeAsDelayable(classInfo);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "removeAsDelayable");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logState() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "logState", new Object[0]);
        }
        if (stateLogger.isLoggable(Level.FINER)) {
            this.log(stateLogger);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "logState");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "log", new Object[]{useLogger});
        }
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "log");
            }
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "BEGIN STATE [ {0} ]", this.getHashText());
        this.getClassInfoCache().log(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "END STATE [ {0} ]", this.getHashText());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "log");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent tc) {
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        this.getClassInfoCache().log(tc);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getStreamCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getStreamCount", new Object[0]);
        }
        long l = this.streamCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getStreamCount", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void incrementStreamCount() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "incrementStreamCount", new Object[0]);
        }
        ++this.streamCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "incrementStreamCount");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startActivity() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startActivity", new Object[0]);
        }
        this.activityTimer.startActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startActivity");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected long endActivity() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endActivity", new Object[0]);
        }
        long l = this.activityTimer.endActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endActivity", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getStreamTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getStreamTime", new Object[0]);
        }
        long l = this.streamTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getStreamTime", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startStreamTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startStreamTime", new Object[0]);
        }
        this.startActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startStreamTime");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endStreamTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endStreamTime", new Object[0]);
        }
        this.streamTime += this.endActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endStreamTime");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getScanTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getScanTime", new Object[0]);
        }
        long l = this.scanTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getScanTime", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startScanTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startScanTime", new Object[0]);
        }
        this.startActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startScanTime");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endScanTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endScanTime", new Object[0]);
        }
        this.scanTime += this.endActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endScanTime");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getRuleTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getRuleTime", new Object[0]);
        }
        long l = this.ruleTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "getRuleTime", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void startRuleTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startRuleTime", new Object[0]);
        }
        this.startActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "startRuleTime");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endRuleTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endRuleTime", new Object[0]);
        }
        this.ruleTime += this.endActivity();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.InfoStoreImpl", "endRuleTime");
        }
    }
}

