/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.smallrye.metrics.exporters.Exporter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PrometheusMetricsExporter
implements Exporter {
    private static final String CLASS_NAME = PrometheusMetricsExporter.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private static final String NEW_LINE = "\n";
    private static final String PROM_HELP = "# HELP";
    private static final String PROM_TYPE = "# TYPE";
    private final List<MeterRegistry> prometheusRegistryList;
    private final PrometheusMeterRegistry prometheusMeterRegistry;

    public PrometheusMetricsExporter() {
        String METHOD_NAME = "PrometheusMetricsExporter";
        this.prometheusRegistryList = Metrics.globalRegistry.getRegistries().stream().filter(registry -> registry instanceof PrometheusMeterRegistry).collect(Collectors.toList());
        if (this.prometheusRegistryList == null || this.prometheusRegistryList.size() == 0) {
            throw new IllegalStateException("Prometheus registry was not found in the global registry");
        }
        if (this.prometheusRegistryList.size() > 1 && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "PrometheusMetricsExporter", "Found {0} instances of Prometheus MeterRegistry in the global registry, the first instance found will be used", this.prometheusRegistryList.size());
        }
        this.prometheusMeterRegistry = (PrometheusMeterRegistry)this.prometheusRegistryList.get(0);
    }

    @Override
    public String exportAllScopes() {
        StringBuilder sb = new StringBuilder();
        for (MeterRegistry meterRegistry : this.prometheusRegistryList) {
            PrometheusMeterRegistry promMeterRegistry = (PrometheusMeterRegistry)meterRegistry;
            String scraped = promMeterRegistry.scrape("text/plain; version=0.0.4; charset=utf-8").replaceFirst("# EOF\r?\n?", "");
            sb.append(scraped);
        }
        return sb.toString();
    }

    @Override
    public String exportOneScope(String scope) {
        String scrapeOutput = this.prometheusMeterRegistry.scrape("text/plain; version=0.0.4; charset=utf-8").replaceFirst("# EOF\r?\n?", "");
        return this.filterScope(scrapeOutput, scope);
    }

    @Override
    public String exportMetricsByName(String scope, String metricName) {
        return this.filterMetrics(metricName, scope);
    }

    @Override
    public String exportOneMetricAcrossScopes(String metricName) {
        return this.filterMetrics(metricName);
    }

    public String filterMetrics(String name) {
        return this.filterMetrics(name, null);
    }

    public String filterMetrics(String metricName, String scope) {
        HashSet<String> unitTypesSet = new HashSet<String>();
        unitTypesSet.add("");
        HashSet<String> meterSuffixSet = new HashSet<String>();
        meterSuffixSet.add("");
        for (Meter m : this.prometheusMeterRegistry.find(metricName).meters()) {
            unitTypesSet.add("_" + m.getId().getBaseUnit());
            this.resolveMeterSuffixes(meterSuffixSet, m.getId().getType());
        }
        Set<String> scrapeMeterNames = this.calculateMeterNamesToScrape(metricName, meterSuffixSet, unitTypesSet);
        String scrapeOutput = this.prometheusMeterRegistry.scrape("text/plain; version=0.0.4; charset=utf-8", scrapeMeterNames).replaceFirst("\r?\n?# EOF", "");
        return scope == null || scope.isEmpty() ? scrapeOutput : this.filterScope(scrapeOutput, scope);
    }

    public String filterScope(String scrapeOutput, String scope) {
        String[] lines = scrapeOutput.split("\r?\n");
        StringBuilder outputBuilder = new StringBuilder();
        StringBuilder tempBuilder = new StringBuilder();
        String scopeString = "scope=\"" + scope + "\"";
        int metricLineCount = 0;
        for (String line : lines) {
            if (line.startsWith(PROM_HELP)) {
                if (metricLineCount > 2) {
                    outputBuilder.append((CharSequence)tempBuilder);
                }
                metricLineCount = 0;
                tempBuilder = new StringBuilder();
            } else if (!line.startsWith(PROM_TYPE) && !line.contains(scopeString)) continue;
            tempBuilder.append(line);
            tempBuilder.append(NEW_LINE);
            ++metricLineCount;
        }
        if (metricLineCount > 2) {
            outputBuilder.append((CharSequence)tempBuilder);
        }
        return outputBuilder.toString();
    }

    private String resolvePrometheusName(String input) {
        String output = input;
        if ((output = output.replaceAll("[-+.!?@#$%^&*`'\\s]+", "_")).matches("^[0-9]+.*")) {
            output = "m_" + output;
        }
        if (output.matches("^_+.*")) {
            output = "m_" + output;
        }
        output = output.replaceAll("[^A-Za-z0-9_]", "");
        return output;
    }

    private void resolveMeterSuffixes(Set<String> set, Meter.Type inputType) {
        String METHOD_NAME = "resolveMeterSuffixes";
        switch (inputType) {
            case COUNTER: {
                set.add("_total");
                break;
            }
            case DISTRIBUTION_SUMMARY: 
            case TIMER: 
            case LONG_TASK_TIMER: {
                set.add("_count");
                set.add("_sum");
                set.add("_max");
                break;
            }
            default: {
                if (!LOGGER.isLoggable(Level.FINEST)) break;
                LOGGER.logp(Level.FINEST, CLASS_NAME, "resolveMeterSuffixes", "Unsupported Meter type: {0} ", inputType.name());
            }
        }
    }

    private Set<String> calculateMeterNamesToScrape(String name, Set<String> meterSuffixSet, Set<String> unitTypeSet) {
        String METHOD_NAME = "calculateMeterNamesToScrape";
        String promName = this.resolvePrometheusName(name);
        HashSet<String> retSet = new HashSet<String>();
        for (String unit : unitTypeSet) {
            for (String suffix : meterSuffixSet) {
                retSet.add(promName + unit + suffix);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "calculateMeterNamesToScrape", "The meter names to scrape: " + retSet);
        }
        return retSet;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }
}

