/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.h2internal.H2RateState;
import com.ibm.ws.http.channel.h2internal.StreamState;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.exceptions.RefusedStreamException;
import com.ibm.ws.http.channel.h2internal.exceptions.StreamClosedException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameContinuation;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameGoAway;
import com.ibm.ws.http.channel.h2internal.frames.FrameHeaders;
import com.ibm.ws.http.channel.h2internal.frames.FramePPHeaders;
import com.ibm.ws.http.channel.h2internal.frames.FramePing;
import com.ibm.ws.http.channel.h2internal.frames.FramePriority;
import com.ibm.ws.http.channel.h2internal.frames.FrameRstStream;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import com.ibm.ws.http.channel.h2internal.frames.FrameWindowUpdate;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.H2Headers;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class H2StreamProcessor {
    private static final TraceComponent tc = Tr.register(H2StreamProcessor.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private H2HttpInboundLinkWrap h2HttpInboundLinkWrap = null;
    private H2InboundLink muxLink = null;
    private ArrayList<byte[]> headerBlock;
    private ArrayList<byte[]> dataPayload;
    private int myID = -1;
    private int weight = 0;
    private boolean exclusive = false;
    private int streamDependency = 0;
    private FrameTypes frameType;
    private StreamState state = StreamState.IDLE;
    private Frame currentFrame;
    private boolean endStream = false;
    private long closeTime = 0L;
    private boolean headersCompleted = false;
    private int expectedContentLength = -1;
    private boolean isConnectStream = false;
    private boolean connection_preface_settings_ack_rcvd = false;
    private boolean connection_preface_settings_rcvd = false;
    private long streamWindowUpdateWriteInitialSize;
    private long streamWindowUpdateWriteLimit;
    private long streamReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    private volatile Queue<WsByteBuffer> streamReadReady = new ConcurrentLinkedQueue<WsByteBuffer>();
    private int streamReadSize = 0;
    private long actualReadCount = 0L;
    private final CountDownLatch readLatch = new CountDownLatch(1);
    private CountDownLatch firstReadLatch = null;
    private boolean rstStreamSent = false;
    private int emptyFrameReceivedCount = 0;
    private int passCount = 0;
    private boolean waitingForWebContainer = false;

    public H2StreamProcessor(Integer id, H2HttpInboundLinkWrap link, H2InboundLink m) {
        this(id, link, m, StreamState.IDLE);
    }

    public H2StreamProcessor(Integer id, H2HttpInboundLinkWrap link, H2InboundLink m, StreamState state) {
        this.myID = id;
        this.h2HttpInboundLinkWrap = link;
        this.muxLink = m;
        this.streamReadWindowSize = this.muxLink.getLocalConnectionSettings().getInitialWindowSize();
        this.updateStreamState(state);
        this.streamWindowUpdateWriteInitialSize = this.muxLink.getInitialWindowSize();
        this.streamWindowUpdateWriteLimit = this.muxLink.getInitialWindowSize();
    }

    protected void completeConnectionPreface() throws Http2Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"completeConnectionPreface entry: about to send preface SETTINGS frame", (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)("completeConnectionPreface MaxStreams is " + this.muxLink.config.getH2MaxConcurrentStreams() + " InitWindowSize is " + this.muxLink.config.getH2SettingsInitialWindowSize() + " MaxFrameSize is " + this.muxLink.config.getH2MaxFrameSize()), (Object[])new Object[0]);
        FrameSettings settings = Constants.SPEC_INITIAL_WINDOW_SIZE != this.muxLink.getLocalConnectionSettings().getInitialWindowSize() ? new FrameSettings(0, -1, -1, this.muxLink.config.getH2MaxConcurrentStreams(), this.muxLink.getLocalConnectionSettings().getInitialWindowSize(), this.muxLink.getLocalConnectionSettings().getMaxFrameSize(), -1, false) : new FrameSettings(0, -1, -1, this.muxLink.config.getH2MaxConcurrentStreams(), -1, this.muxLink.getLocalConnectionSettings().getMaxFrameSize(), -1, false);
        this.frameType = FrameTypes.SETTINGS;
        this.processNextFrame(settings, Constants.Direction.WRITING_OUT);
        if (Constants.SPEC_INITIAL_WINDOW_SIZE != this.muxLink.config.getH2ConnectionWindowSize()) {
            int updateSize = this.muxLink.config.getH2ConnectionWindowSize() - Constants.SPEC_INITIAL_WINDOW_SIZE;
            this.muxLink.connectionReadWindowSize = this.muxLink.config.getH2ConnectionWindowSize();
            FrameWindowUpdate wup = new FrameWindowUpdate(0, updateSize, false);
            this.processNextFrame(wup, Constants.Direction.WRITING_OUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processNextFrame(Frame frame, Constants.Direction direction) throws ProtocolException, StreamClosedException, FlowControlException {
        boolean doDebugWhile = false;
        FlowControlException FCEToThrow = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processNextFrame-entry:  stream: " + this.myID + " frame type: " + frame.getFrameType().toString() + " direction: " + direction.toString() + " H2InboundLink hc: " + ((Object)((Object)this.muxLink)).hashCode()), (Object[])new Object[0]);
        }
        if (this.rstStreamSent) {
            block88: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"{0} frame received on stream {1} after RST_STREAM sent", (Object[])new Object[]{frame.getFrameType(), this.myID});
                }
                try {
                    this.updateStreamReadWindow();
                }
                catch (Http2Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block88;
                    Tr.debug((TraceComponent)tc, (String)"hit an exception updating the read window on stream {0}", (Object[])new Object[]{this.myID});
                }
            }
            return;
        }
        if (this.isStreamClosed()) {
            if (direction.equals((Object)Constants.Direction.WRITING_OUT) && !this.muxLink.isWriteContinuationExpected()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processNextFrame: stream is closed - cannot write out anything else on stream-id: " + this.myID), (Object[])new Object[0]);
                }
                if (frame.getFrameType().equals((Object)FrameTypes.DATA)) {
                    throw new StreamClosedException("stream was already closed!");
                }
                return;
            }
            if (direction.equals((Object)Constants.Direction.READ_IN) && !frame.getFrameType().equals((Object)FrameTypes.PUSH_PROMISE)) {
                if (frame.getFrameType() == FrameTypes.PRIORITY || frame.getFrameType() == FrameTypes.RST_STREAM || frame.getFrameType() == FrameTypes.WINDOW_UPDATE) {
                    return;
                }
                if (this.muxLink.streamTable.containsKey(this.myID)) {
                    throw new StreamClosedException((Object)((Object)frame.getFrameType()) + " frame received on a closed stream");
                }
                throw new ProtocolException((Object)((Object)frame.getFrameType()) + " frame received on a closed stream");
            }
        }
        ADDITIONAL_FRAME addFrame = ADDITIONAL_FRAME.FIRST_TIME;
        Http2Exception addFrameException = null;
        H2RateState h2rs = this.muxLink.getH2RateState();
        block33: while (addFrame != ADDITIONAL_FRAME.NO) {
            block90: {
                this.currentFrame = frame;
                if (doDebugWhile) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame- in while: stream-id: " + this.myID + " frame type: " + frame.getFrameType().toString() + " direction: " + direction.toString()), (Object[])new Object[0]);
                    }
                } else {
                    doDebugWhile = true;
                }
                if (addFrame == ADDITIONAL_FRAME.RESET) {
                    this.updateStreamState(StreamState.HALF_CLOSED_LOCAL);
                    this.currentFrame = new FrameRstStream(this.myID, addFrameException.getErrorCode(), false);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame: exception encountered.  Sending RST_STREAM on stream " + this.myID + " with the error code " + addFrameException.getErrorString()), (Object[])new Object[0]);
                    }
                    direction = Constants.Direction.WRITING_OUT;
                }
                if (addFrame == ADDITIONAL_FRAME.GOAWAY) {
                    this.updateStreamState(StreamState.HALF_CLOSED_LOCAL);
                    this.muxLink.setStatusLinkToGoAwaySending();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame: addFrame GOAWAY: HighestClientStreamId: " + this.muxLink.getGoawayPromisedStreamId()), (Object[])new Object[0]);
                    }
                    this.currentFrame = new FrameGoAway(0, addFrameException.getMessage().getBytes(), addFrameException.getErrorCode(), this.muxLink.getGoawayPromisedStreamId(), false);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame: exception encountered.  Sending a GOAWAY frame with the error code " + addFrameException.getErrorString()), (Object[])new Object[0]);
                    }
                    direction = Constants.Direction.WRITING_OUT;
                }
                this.frameType = this.currentFrame.getFrameType();
                if (this.frameType == FrameTypes.RST_STREAM && addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                    addFrame = ADDITIONAL_FRAME.RESET;
                } else if (this.frameType == FrameTypes.GOAWAY && addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                    addFrame = ADDITIONAL_FRAME.GOAWAY;
                }
                try {
                    if (direction == Constants.Direction.READ_IN) {
                        this.currentFrame.validate(this.muxLink.getLocalConnectionSettings());
                    } else {
                        this.currentFrame.validate(this.muxLink.getRemoteConnectionSettings());
                    }
                }
                catch (Http2Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame: " + (Object)((Object)this.currentFrame.getFrameType()) + " received on stream " + this.myID + " is not a valid frame: " + e.getErrorString()), (Object[])new Object[0]);
                    }
                    if (addFrame == ADDITIONAL_FRAME.FIRST_TIME || addFrame == ADDITIONAL_FRAME.RESET || addFrame == ADDITIONAL_FRAME.GOAWAY) {
                        addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                        addFrameException = e;
                        continue;
                    }
                    if (direction == Constants.Direction.READ_IN) {
                        addFrame = ADDITIONAL_FRAME.RESET;
                        addFrameException = e;
                        continue;
                    }
                    addFrame = ADDITIONAL_FRAME.NO;
                    continue;
                }
                if (direction == Constants.Direction.READ_IN) {
                    block89: {
                        H2StreamProcessor e4;
                        if (this.muxLink.checkIfGoAwaySendingOrClosing()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processNextFrame: " + (Object)((Object)this.currentFrame.getFrameType()) + " received on stream " + this.myID + " after a GOAWAY was sent or Closing invoked.  This frame will be ignored."), (Object[])new Object[0]);
                            }
                            return;
                        }
                        if (addFrame == null || addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                            if (H2StreamProcessor.isControlFrame(frame)) {
                                h2rs.incrementReadControlFrameCount();
                            } else {
                                h2rs.incrementReadNonControlFrameCount();
                            }
                            if (h2rs.isControlRatioExceeded() || h2rs.isStreamMisbehaving(this.emptyFrameReceivedCount)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"processNextFrame: too many no-op frames received, sending GOAWAY", (Object[])new Object[0]);
                                }
                                addFrame = ADDITIONAL_FRAME.GOAWAY;
                                if (h2rs.isStreamMisbehaving(this.emptyFrameReceivedCount)) {
                                    addFrameException = new ProtocolException("too many empty frames generated");
                                    continue;
                                }
                                addFrameException = new ProtocolException("too many control frames generated");
                                continue;
                            }
                        }
                        if (this.frameType == FrameTypes.PUSHPROMISEHEADERS) {
                            this.getHeadersFromFrame();
                            this.setHeadersComplete();
                            try {
                                this.processCompleteHeaders(true);
                                this.setReadyForRead();
                            }
                            catch (Http2Exception he) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("H2StreamProcessor.sendRequestToWc(): ProcessCompleteHeaders Exception: " + he), (Object[])new Object[0]);
                                }
                                addFrame = ADDITIONAL_FRAME.RESET;
                                addFrameException = he;
                                continue;
                            }
                            return;
                        }
                        if (this.muxLink.isContinuationExpected() && (this.frameType != FrameTypes.CONTINUATION || !this.muxLink.isContinuationExpected())) {
                            addFrame = ADDITIONAL_FRAME.GOAWAY;
                            addFrameException = new ProtocolException("Did not receive the expected continuation frame");
                            continue;
                        }
                        if (this.frameType == FrameTypes.SETTINGS || this.frameType == FrameTypes.GOAWAY || this.frameType == FrameTypes.PING) {
                            switch (this.frameType) {
                                case SETTINGS: {
                                    try {
                                        this.processSETTINGSFrame();
                                        break;
                                    }
                                    catch (Http2Exception e2) {
                                        if (addFrame != ADDITIONAL_FRAME.FIRST_TIME) continue block33;
                                        addFrame = ADDITIONAL_FRAME.GOAWAY;
                                        addFrameException = e2;
                                        continue block33;
                                    }
                                }
                                case GOAWAY: {
                                    this.processGOAWAYFrame();
                                    this.updateStreamState(StreamState.CLOSED);
                                    break;
                                }
                                case PING: {
                                    try {
                                        this.processPINGFrame();
                                        break;
                                    }
                                    catch (Http2Exception e3) {
                                        if (addFrame != ADDITIONAL_FRAME.FIRST_TIME) continue block33;
                                        addFrame = ADDITIONAL_FRAME.GOAWAY;
                                        addFrameException = e3;
                                        continue block33;
                                    }
                                }
                            }
                            return;
                        }
                        try {
                            this.verifyReadFrameSequence();
                        }
                        catch (Http2Exception e4) {
                            addFrame = e4.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : (addFrame == ADDITIONAL_FRAME.FIRST_TIME ? ADDITIONAL_FRAME.RESET : ADDITIONAL_FRAME.NO);
                            addFrameException = e4;
                            continue;
                        }
                        if (this.frameType == FrameTypes.PRIORITY) {
                            this.processPriorityFrame();
                            return;
                        }
                        if (this.frameType == FrameTypes.RST_STREAM) {
                            this.processRstFrame();
                            e4 = this;
                            synchronized (e4) {
                                this.notifyAll();
                            }
                            return;
                        }
                        try {
                            if (this.frameType != FrameTypes.WINDOW_UPDATE) break block89;
                            this.processWindowUpdateFrame();
                            e4 = this;
                            synchronized (e4) {
                                this.notifyAll();
                            }
                        }
                        catch (Http2Exception e5) {
                            if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                                addFrame = e5.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                                addFrameException = e5;
                                continue;
                            }
                            addFrame = ADDITIONAL_FRAME.NO;
                            continue;
                        }
                    }
                    try {
                        this.updateStreamReadWindow();
                    }
                    catch (Http2Exception e) {
                        if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                            addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                            addFrameException = e;
                            continue;
                        }
                        addFrame = ADDITIONAL_FRAME.NO;
                        continue;
                    }
                    try {
                        this.readWriteTransitionState(direction);
                        break block90;
                    }
                    catch (CompressionException e) {
                        if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                            addFrame = ADDITIONAL_FRAME.GOAWAY;
                            addFrameException = e;
                            continue;
                        }
                        addFrame = ADDITIONAL_FRAME.NO;
                        continue;
                    }
                    catch (Http2Exception e) {
                        if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                            addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                            addFrameException = e;
                            continue;
                        }
                        addFrame = ADDITIONAL_FRAME.NO;
                        continue;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processNextFrame Writing out data", (Object[])new Object[0]);
                }
                try {
                    this.verifyWriteFrameSequence();
                    if ((addFrame == null || addFrame == ADDITIONAL_FRAME.FIRST_TIME) && h2rs.isControlRatioExceeded()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"processNextFrame: too many control processed, sending GOAWAY", (Object[])new Object[0]);
                        }
                        addFrame = ADDITIONAL_FRAME.GOAWAY;
                        addFrameException = new ProtocolException("too many control frames generated");
                        addFrameException.setConnectionError(false);
                        continue;
                    }
                    if (addFrameException != null && addFrameException.isConnectionError()) {
                        this.readWriteTransitionState(direction, addFrameException);
                    } else {
                        this.readWriteTransitionState(direction);
                    }
                }
                catch (CompressionException e) {
                    if (addFrame == ADDITIONAL_FRAME.FIRST_TIME || addFrame == ADDITIONAL_FRAME.RESET) {
                        Tr.info((TraceComponent)tc, (String)"A Header compression error occurred!  This connection is no longer valid.", (Object[])new Object[0]);
                        addFrame = ADDITIONAL_FRAME.GOAWAY;
                        addFrameException = e;
                        continue;
                    }
                    addFrame = ADDITIONAL_FRAME.NO;
                    continue;
                }
                catch (Http2Exception e) {
                    if (!(this.muxLink.checkIfGoAwaySendingOrClosing() || addFrame != ADDITIONAL_FRAME.FIRST_TIME && addFrame != ADDITIONAL_FRAME.RESET)) {
                        if (this.frameType == FrameTypes.DATA && e instanceof FlowControlException) {
                            FCEToThrow = (FlowControlException)e;
                        }
                        addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                        addFrameException = e;
                        continue;
                    }
                    addFrame = ADDITIONAL_FRAME.NO;
                    continue;
                }
            }
            addFrame = ADDITIONAL_FRAME.NO;
        }
        if (FCEToThrow != null) {
            throw FCEToThrow;
        }
    }

    private void readWriteTransitionState(Constants.Direction direction) throws Http2Exception {
        this.readWriteTransitionState(direction, null);
    }

    private void readWriteTransitionState(Constants.Direction direction, Exception e) throws Http2Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readWriteTransitionState: entry: frame type: " + (Object)((Object)this.currentFrame.getFrameType()) + " state: " + (Object)((Object)this.state)), (Object[])new Object[0]);
        }
        if (this.currentFrame.getFrameType() == FrameTypes.GOAWAY || this.currentFrame.getFrameType() == FrameTypes.RST_STREAM) {
            try {
                this.writeFrameSync();
            }
            finally {
                this.rstStreamSent = true;
                this.muxLink.getH2RateState().setStreamReset();
                this.updateStreamState(StreamState.CLOSED);
                if (this.currentFrame.getFrameType() == FrameTypes.GOAWAY) {
                    this.muxLink.closeConnectionLink(e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readWriteTransitionState: return: state: " + (Object)((Object)this.state)), (Object[])new Object[0]);
                }
            }
            return;
        }
        switch (this.state) {
            case IDLE: {
                this.processIdle(direction);
                break;
            }
            case RESERVED_LOCAL: {
                this.processReservedLocal(direction);
                break;
            }
            case RESERVED_REMOTE: {
                this.processReservedRemote(direction);
                break;
            }
            case OPEN: {
                this.processOpen(direction);
                break;
            }
            case HALF_CLOSED_REMOTE: {
                this.processHalfClosedRemote(direction);
                break;
            }
            case HALF_CLOSED_LOCAL: {
                this.processHalfClosedLocal(direction);
                break;
            }
            case CLOSED: {
                this.processClosed(direction);
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readWriteTransitionState: exit: state: " + (Object)((Object)this.state)), (Object[])new Object[0]);
        }
    }

    private void updateStreamState(StreamState state) {
        this.state = state;
        if (StreamState.CLOSED.equals((Object)state)) {
            this.setCloseTime(System.currentTimeMillis());
            this.muxLink.closeStream(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current stream state for stream " + this.myID + " : " + (Object)((Object)this.state)), (Object[])new Object[0]);
        }
    }

    public void initializePromisedStream() {
        this.updateStreamState(StreamState.RESERVED_LOCAL);
    }

    private void processSETTINGSFrame() throws FlowControlException, Http2Exception {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processSETTINGSFrame entry:\n" + this.currentFrame.toString()), (Object[])new Object[0]);
            }
            if (!this.connection_preface_settings_rcvd && !((FrameSettings)this.currentFrame).flagAckSet()) {
                this.connection_preface_settings_rcvd = true;
            }
            if (((FrameSettings)this.currentFrame).flagAckSet()) {
                if (!this.connection_preface_settings_ack_rcvd) {
                    this.connection_preface_settings_ack_rcvd = true;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"received a new settings frame: updating connection settings and sending out SETTINGS ACK", (Object[])new Object[0]);
                }
                if (((FrameSettings)this.currentFrame).getInitialWindowSize() != -1) {
                    int newSize = ((FrameSettings)this.currentFrame).getInitialWindowSize();
                    this.muxLink.changeInitialWindowSizeAllStreams(newSize);
                }
                this.muxLink.getRemoteConnectionSettings().updateSettings((FrameSettings)this.currentFrame);
                this.muxLink.getVirtualConnection().getStateMap().put("h2_frame_size", this.muxLink.getRemoteConnectionSettings().getMaxFrameSize());
                this.currentFrame = new FrameSettings(0, -1, -1, -1, -1, -1, -1, false);
                this.currentFrame.setAckFlag();
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processSETTINGSFrame:  stream: " + this.myID + " frame type: " + this.currentFrame.getFrameType().toString() + " direction: " + (Object)((Object)Constants.Direction.WRITING_OUT) + " H2InboundLink hc: " + ((Object)((Object)this.muxLink)).hashCode()), (Object[])new Object[0]);
                    }
                    this.writeFrameSync();
                }
                catch (FlowControlException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)("writeSync caught (logically unexpected) FlowControlException: " + e), (Object[])new Object[0]);
                }
            }
        }
        if (this.connection_preface_settings_rcvd && this.connection_preface_settings_ack_rcvd && this.muxLink.checkInitAndOpen()) {
            this.muxLink.initLock.countDown();
        }
    }

    private void processPriorityFrame() {
        FramePriority castFrame = (FramePriority)this.currentFrame;
        this.exclusive = castFrame.isExclusive();
        this.streamDependency = castFrame.getStreamDependency();
        this.weight = castFrame.getWeight();
        this.muxLink.getWorkQ().updateNodeFrameParameters(this.myID, this.weight, this.streamDependency, this.exclusive);
    }

    private void processWindowUpdateFrame() throws FlowControlException {
        FrameWindowUpdate castFrame = (FrameWindowUpdate)this.currentFrame;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processWindowUpdateFrame: streamID: " + castFrame.getStreamId() + " desired increment: " + castFrame.getWindowSizeIncrement()), (Object[])new Object[0]);
        }
        if (this.myID == 0) {
            this.muxLink.incrementConnectionWindowUpdateLimit(castFrame.getWindowSizeIncrement());
        } else {
            long temp = this.streamWindowUpdateWriteLimit + (long)castFrame.getWindowSizeIncrement();
            if ((temp &= Integer.MIN_VALUE) != 0L) {
                String s = "processWindowUpdateFrame: out of bounds increment, current stream write limit: " + this.streamWindowUpdateWriteLimit + " total would have been: " + temp;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)s, (Object[])new Object[0]);
                }
                FlowControlException e = new FlowControlException(s);
                e.setConnectionError(false);
                throw e;
            }
            this.streamWindowUpdateWriteLimit += (long)castFrame.getWindowSizeIncrement();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processWindowUpdateFrame: new write limit is: " + this.streamWindowUpdateWriteLimit), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStreamReadWindow() throws Http2Exception {
        long frameSize;
        if (this.currentFrame instanceof FrameData && (frameSize = (long)this.currentFrame.getPayloadLength()) > 0L) {
            Object object = this.muxLink.getReadWindowSync();
            synchronized (object) {
                int windowChange;
                this.streamReadWindowSize -= frameSize;
                this.muxLink.connectionReadWindowSize -= frameSize;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateStreamReadWindow: stream read limit: " + this.streamReadWindowSize + " connection limit:" + this.muxLink.connectionReadWindowSize), (Object[])new Object[0]);
                }
                if (this.streamReadWindowSize < 0L || this.muxLink.connectionReadWindowSize < 0L) {
                    throw new FlowControlException("Too much data received from the remote client");
                }
                if (!this.muxLink.limitWindowUpdateFrames || this.muxLink.connectionReadWindowSize < (long)(this.muxLink.config.getH2ConnectionWindowSize() / 2)) {
                    windowChange = (int)((long)this.muxLink.config.getH2ConnectionWindowSize() - this.muxLink.connectionReadWindowSize);
                    FrameWindowUpdate wuf = new FrameWindowUpdate(0, windowChange, false);
                    this.muxLink.getStream(0).processNextFrame(wuf, Constants.Direction.WRITING_OUT);
                    this.muxLink.connectionReadWindowSize += (long)windowChange;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateStreamReadWindow: window update sent; connection limit:" + this.muxLink.connectionReadWindowSize), (Object[])new Object[0]);
                    }
                }
                if (!this.muxLink.limitWindowUpdateFrames || this.streamReadWindowSize < (long)(this.muxLink.getLocalConnectionSettings().getInitialWindowSize() / 2)) {
                    windowChange = (int)((long)this.muxLink.getLocalConnectionSettings().getInitialWindowSize() - this.streamReadWindowSize);
                    Frame savedFrame = this.currentFrame;
                    if (!this.currentFrame.flagEndStreamSet()) {
                        this.currentFrame = new FrameWindowUpdate(this.myID, windowChange, false);
                        this.writeFrameSync();
                        this.streamReadWindowSize += (long)windowChange;
                        this.currentFrame = savedFrame;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("updateStreamReadWindow: window update sent; new stream read limit: " + this.streamReadWindowSize), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDataWaitingForWindowUpdate() {
        H2StreamProcessor h2StreamProcessor = this;
        synchronized (h2StreamProcessor) {
            this.notifyAll();
        }
    }

    protected void connectionWindowSizeUpdated() {
        this.flushDataWaitingForWindowUpdate();
    }

    protected void updateInitialWindowsUpdateSize(int newSize) throws FlowControlException {
        if (this.myID == 0) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"updateInitialWindowsUpdateSize entry: stream {0} newSize: {1}", (Object[])new Object[]{this.myID, newSize});
        }
        long diff = (long)newSize - this.streamWindowUpdateWriteInitialSize;
        this.streamWindowUpdateWriteInitialSize = newSize;
        this.streamWindowUpdateWriteLimit += diff;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("streamWindowUpdateWriteInitialSize updated to: " + this.streamWindowUpdateWriteInitialSize), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("streamWindowUpdateWriteLimit updated to: " + this.streamWindowUpdateWriteLimit), (Object[])new Object[0]);
        }
        this.flushDataWaitingForWindowUpdate();
    }

    public void sendGOAWAYFrame(Http2Exception e) throws Http2Exception {
        boolean doGoAwayFromHere;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendGOAWAYFrame:  :close: H2InboundLink hc: " + ((Object)((Object)this.muxLink)).hashCode()), (Object[])new Object[0]);
        }
        if (!(doGoAwayFromHere = this.muxLink.setStatusLinkToGoAwaySending())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sendGOAWAYFrame: another thread is handling the close :close: H2InboundLink hc: " + ((Object)((Object)this.muxLink)).hashCode()), (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendGOAWAYFrame sending a GOAWAY with Last-Stream-ID " + this.muxLink.getGoawayPromisedStreamId() + " and exception " + e.toString()), (Object[])new Object[0]);
        }
        FrameGoAway frame = new FrameGoAway(0, e.getMessage().getBytes(), e.getErrorCode(), this.muxLink.getGoawayPromisedStreamId(), false);
        this.processNextFrame(frame, Constants.Direction.WRITING_OUT);
    }

    private void processGOAWAYFrame() {
        boolean doGoAwayFromHere;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processGOAWAYFrame entry: begin connection shutdown and send reciprocal GOAWAY to client :close: H2InboundLink hc: " + ((Object)((Object)this.muxLink)).hashCode()), (Object[])new Object[0]);
        }
        if (!(doGoAwayFromHere = this.muxLink.setStatusLinkToGoAwaySending())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sendGOAWAYFrame: another thread is handling the close :close: H2InboundLink hc: " + ((Object)((Object)this.muxLink)).hashCode()), (Object[])new Object[0]);
            }
            return;
        }
        this.updateStreamState(StreamState.CLOSED);
        this.currentFrame = new FrameGoAway(0, new byte[0], 0, this.muxLink.getGoawayPromisedStreamId(), false);
        try {
            this.writeFrameSync();
        }
        catch (FlowControlException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("writeSync caught (logically unexpected) FlowControlException: " + e), (Object[])new Object[0]);
            }
        }
        catch (Http2Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("writeSync caught Http2Exception: " + e), (Object[])new Object[0]);
            }
        }
        finally {
            this.muxLink.closeConnectionLink(null);
        }
    }

    private void processPINGFrame() throws Http2Exception {
        block5: {
            if (this.currentFrame.flagAckSet()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processPINGFrame: ignore PING received with ACK set", (Object[])new Object[0]);
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processPINGFrame entry: send reciprocal PING frame to client", (Object[])new Object[0]);
            }
            byte[] data = ((FramePing)this.currentFrame).getPayload();
            this.currentFrame = new FramePing(0, data, false);
            this.currentFrame.setAckFlag();
            try {
                this.writeFrameSync();
            }
            catch (FlowControlException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("writeSync caught (logically unexpected) FlowControlException: " + e), (Object[])new Object[0]);
            }
        }
    }

    private void processRstFrame() {
        int error = ((FrameRstStream)this.currentFrame).getErrorCode();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processRstFrame: error received from peer: " + utils.getErrorFromCode(error)), (Object[])new Object[0]);
        }
        this.updateStreamState(StreamState.CLOSED);
    }

    private void processIdle(Constants.Direction direction) throws Http2Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processIdle entry: stream " + this.myID), (Object[])new Object[0]);
        }
        if (direction == Constants.Direction.READ_IN) {
            if (this.frameType == FrameTypes.HEADERS) {
                this.muxLink.incrementActiveClientStreams();
                if (this.muxLink.getActiveClientStreams() > this.muxLink.getLocalConnectionSettings().getMaxConcurrentStreams()) {
                    RefusedStreamException rse = new RefusedStreamException("too many client-initiated streams are currently active; rejecting this stream");
                    rse.setConnectionError(false);
                    throw rse;
                }
                this.processHeadersPriority();
                this.getHeadersFromFrame();
                if (this.currentFrame.flagEndHeadersSet()) {
                    this.processCompleteHeaders(false);
                    this.setHeadersComplete();
                } else {
                    this.muxLink.setContinuationExpected(true);
                }
                if (this.currentFrame.flagEndStreamSet()) {
                    this.endStream = true;
                    this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                    if (this.currentFrame.flagEndHeadersSet()) {
                        this.setReadyForRead();
                    }
                } else {
                    this.updateStreamState(StreamState.OPEN);
                }
            }
        } else {
            if (this.frameType == FrameTypes.HEADERS) {
                this.updateStreamState(StreamState.OPEN);
            }
            this.writeFrameSync();
        }
    }

    private void processOpen(Constants.Direction direction) throws ProtocolException, FlowControlException, CompressionException, Http2Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processOpen entry: stream " + this.myID), (Object[])new Object[0]);
        }
        if (direction == Constants.Direction.READ_IN) {
            if (this.frameType == FrameTypes.DATA) {
                if (!this.h2HttpInboundLinkWrap.setAndGetIsGrpc()) {
                    this.getBodyFromFrame();
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.endStream = true;
                        this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                        this.processCompleteData(true);
                        this.setReadyForRead();
                    }
                } else if (this.passCount == 0) {
                    this.firstReadLatch = new CountDownLatch(1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processOpen: first DATA frame read. using firstReadLatch of: " + this.firstReadLatch.hashCode()), (Object[])new Object[0]);
                    }
                    ++this.passCount;
                    this.getBodyFromFrame();
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.endStream = true;
                        this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                    }
                    this.processCompleteData(true);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processOpen: first DATA frame read. calling setReadyForRead() getEndStream returns: " + this.getEndStream()), (Object[])new Object[0]);
                    }
                    this.setReadyForRead();
                } else {
                    this.dataPayload = null;
                    if (this.passCount == 1) {
                        ++this.passCount;
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"processOpen: another DATA frame received, wait for the first data frame to get processed completely", (Object[])new Object[0]);
                            }
                            this.firstReadLatch.await();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"processOpen: finished waiting for first DATA to be fully processed", (Object[])new Object[0]);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    this.getBodyFromFrame();
                    WsByteBuffer buf = this.processCompleteData(false);
                    if (buf != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("calling setNewBodyBuffer with: " + buf), (Object[])new Object[0]);
                        }
                        this.h2HttpInboundLinkWrap.setAndStoreNewBodyBuffer(buf);
                        if (this.currentFrame.flagEndStreamSet()) {
                            this.endStream = true;
                            this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                        }
                        this.h2HttpInboundLinkWrap.invokeAppComplete();
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"did not call setNewBodyBuffer. buf was null", (Object[])new Object[0]);
                        }
                        if (this.currentFrame.flagEndStreamSet()) {
                            this.endStream = true;
                            this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("new buffer saved and app complete() invoked; getEndStream returns: " + this.getEndStream()), (Object[])new Object[0]);
                    }
                }
            } else if (this.frameType == FrameTypes.CONTINUATION || this.frameType == FrameTypes.HEADERS) {
                this.getHeadersFromFrame();
                if (this.currentFrame.flagEndHeadersSet()) {
                    this.muxLink.setContinuationExpected(false);
                    this.processCompleteHeaders(false);
                    this.setHeadersComplete();
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.endStream = true;
                        this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                        this.setReadyForRead();
                    }
                } else {
                    this.muxLink.setContinuationExpected(true);
                }
            }
        } else {
            if (this.frameType != FrameTypes.PUSH_PROMISE && (this.frameType == FrameTypes.HEADERS || this.frameType == FrameTypes.CONTINUATION)) {
                if (this.currentFrame.flagEndHeadersSet()) {
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.endStream = true;
                        this.updateStreamState(StreamState.HALF_CLOSED_LOCAL);
                    }
                } else if (this.currentFrame.flagEndStreamSet()) {
                    this.endStream = true;
                }
            }
            boolean writeCompleted = this.writeFrameSync();
            if (this.frameType == FrameTypes.DATA && writeCompleted && this.currentFrame.flagEndStreamSet()) {
                this.endStream = true;
                this.updateStreamState(StreamState.HALF_CLOSED_LOCAL);
            }
        }
    }

    private void processClosed(Constants.Direction direction) {
    }

    private void processHalfClosedLocal(Constants.Direction direction) throws FlowControlException, Http2Exception {
        if (direction == Constants.Direction.WRITING_OUT) {
            this.writeFrameSync();
            if (this.currentFrame.getFrameType() == FrameTypes.RST_STREAM) {
                this.endStream = true;
                this.updateStreamState(StreamState.HALF_CLOSED_LOCAL);
            }
        } else if (this.currentFrame.getFrameType() == FrameTypes.RST_STREAM || this.currentFrame.flagEndStreamSet()) {
            this.endStream = true;
            this.updateStreamState(StreamState.CLOSED);
        }
    }

    private void processHalfClosedRemote(Constants.Direction direction) throws FlowControlException, CompressionException, ProtocolException, Http2Exception {
        if (direction == Constants.Direction.WRITING_OUT) {
            boolean writeCompleted = this.writeFrameSync();
            if (this.frameType == FrameTypes.HEADERS || this.frameType == FrameTypes.CONTINUATION) {
                if (this.currentFrame.flagEndHeadersSet()) {
                    this.muxLink.setWriteContinuationExpected(false);
                } else {
                    this.muxLink.setWriteContinuationExpected(true);
                }
            }
            if ((this.currentFrame.getFrameType() == FrameTypes.RST_STREAM || this.currentFrame.flagEndStreamSet() && !this.muxLink.isWriteContinuationExpected()) && writeCompleted) {
                this.endStream = true;
                this.updateStreamState(StreamState.CLOSED);
            }
        } else if (this.currentFrame.getFrameType() == FrameTypes.RST_STREAM) {
            this.endStream = true;
            this.updateStreamState(StreamState.CLOSED);
        } else if (this.frameType == FrameTypes.CONTINUATION) {
            this.getHeadersFromFrame();
            if (this.currentFrame.flagEndHeadersSet()) {
                this.processCompleteHeaders(false);
                this.setHeadersComplete();
                this.setReadyForRead();
            }
        }
    }

    private void processReservedRemote(Constants.Direction direction) {
    }

    private void processReservedLocal(Constants.Direction direction) throws FlowControlException, Http2Exception {
        if (direction == Constants.Direction.WRITING_OUT) {
            if ((this.currentFrame.getFrameType() == FrameTypes.HEADERS || this.currentFrame.getFrameType() == FrameTypes.CONTINUATION) && this.currentFrame.flagEndHeadersSet()) {
                this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
            }
            this.writeFrameSync();
        }
    }

    private boolean isWindowLimitExceeded(FrameData dataFrame) {
        if (this.streamWindowUpdateWriteLimit - (long)dataFrame.getPayloadLength() < 0L || this.muxLink.getWorkQ().getConnectionWriteLimit() - dataFrame.getPayloadLength() < 0) {
            String s = "Cannot write Data Frame because it would exceed the stream window update limit.streamWindowUpdateWriteLimit: " + this.streamWindowUpdateWriteLimit + "\nstreamWindowUpdateWriteInitialSize: " + this.streamWindowUpdateWriteInitialSize + "\nconnection window size: " + this.muxLink.getWorkQ().getConnectionWriteLimit() + "\nframe size: " + dataFrame.getPayloadLength();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)s, (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public void sendRequestToWc(FramePPHeaders frame) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"H2StreamProcessor.sendRequestToWc()", (Object[])new Object[0]);
        }
        if (null == frame) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"H2StreamProcessor.sendRequestToWc(): Frame is null", (Object[])new Object[0]);
            }
        } else {
            WsByteBuffer buf = frame.buildFrameForWrite();
            TCPReadRequestContext readi = this.h2HttpInboundLinkWrap.getConnectionContext().getReadInterface();
            readi.setBuffer(buf);
            try {
                this.processNextFrame(frame, Constants.Direction.READ_IN);
            }
            catch (Http2Exception he) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("H2StreamProcessor.sendRequestToWc(): ProcessNextFrame() error, Exception: " + he), (Object[])new Object[0]);
                }
                buf.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"H2StreamProcessor.sendRequestToWc()");
        }
    }

    private void verifyReadFrameSequence() throws ProtocolException, StreamClosedException {
        if (!this.currentFrame.isReadFrame()) {
            throw new ProtocolException("Write frame was given for Read frame processing");
        }
        switch (this.frameType) {
            case DATA: {
                if (this.state == StreamState.IDLE) {
                    throw new ProtocolException("DATA Frame Received in the wrong state of: " + (Object)((Object)this.state));
                }
                if (this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_LOCAL) break;
                StreamClosedException se = new StreamClosedException("DATA Frame Received in the wrong state of: " + (Object)((Object)this.state));
                se.setConnectionError(false);
                throw se;
            }
            case HEADERS: {
                if (this.state == StreamState.HALF_CLOSED_REMOTE || this.state == StreamState.CLOSED) {
                    throw new StreamClosedException("HEADERS Frame Received in the wrong state of: " + (Object)((Object)this.state));
                }
                if (this.state != StreamState.IDLE && this.state != StreamState.OPEN) {
                    throw new ProtocolException("HEADERS Frame Received in the wrong state of: " + (Object)((Object)this.state));
                }
                if (this.state == StreamState.OPEN && !this.currentFrame.flagEndStreamSet()) {
                    throw new ProtocolException("second HEADERS frame received with no EOS set");
                }
                if (!this.isConnectStream) break;
                ProtocolException pe = new ProtocolException("HEADERS frame received on a CONNECT stream");
                pe.setConnectionError(false);
                throw pe;
            }
            case PRIORITY: {
                break;
            }
            case RST_STREAM: {
                if (this.state != StreamState.IDLE) break;
                throw new ProtocolException("RST_STREAM Frame Received in the wrong state of: " + (Object)((Object)this.state));
            }
            case PUSH_PROMISE: {
                throw new ProtocolException("PUSH_PROMISE Frame Received on server side");
            }
            case WINDOW_UPDATE: {
                if (this.state != StreamState.IDLE || this.myID == 0) break;
                throw new ProtocolException("WINDOW_UPDATE Frame Received in the wrong state of: " + (Object)((Object)this.state));
            }
            case CONTINUATION: {
                if (this.state == StreamState.IDLE) {
                    throw new ProtocolException("CONTINUATION Frame Received in the wrong state of: " + (Object)((Object)this.state));
                }
                if (this.state == StreamState.CLOSED) {
                    throw new StreamClosedException("CONTINUATION Frame Received in the wrong state of: " + (Object)((Object)this.state));
                }
                if (!this.muxLink.isContinuationExpected()) {
                    throw new ProtocolException("CONTINUATION Frame Received when not in a Continuation State");
                }
                if (!this.isConnectStream) break;
                ProtocolException pe = new ProtocolException("CONTINUATION frame received on a CONNECT stream");
                pe.setConnectionError(false);
                throw pe;
            }
        }
    }

    private void verifyWriteFrameSequence() throws ProtocolException {
        if (!this.currentFrame.isWriteFrame()) {
            throw new ProtocolException("Read frame was given for Write frame processing");
        }
        switch (this.frameType) {
            case DATA: {
                if (this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_REMOTE) break;
                throw new ProtocolException("DATA Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case HEADERS: {
                if (this.state == StreamState.IDLE || this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_REMOTE || this.state == StreamState.RESERVED_LOCAL) break;
                throw new ProtocolException("HEADERS Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case PRIORITY: {
                if (!this.muxLink.isWriteContinuationExpected()) break;
                throw new ProtocolException("PRIORITY Frame sent when in a Continuation State of: " + (Object)((Object)this.state));
            }
            case RST_STREAM: {
                if (this.state != StreamState.IDLE) break;
                throw new ProtocolException("RST_STREAM Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case SETTINGS: {
                break;
            }
            case PUSH_PROMISE: {
                if (this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_REMOTE) break;
                throw new ProtocolException("PUSH_PROMISE Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case WINDOW_UPDATE: {
                break;
            }
            case CONTINUATION: {
                if (this.muxLink.isWriteContinuationExpected()) break;
                throw new ProtocolException("CONTINUATION Frame sent when not in a Continuation State");
            }
        }
    }

    private void setHeadersComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("completed headers have been received stream " + this.myID), (Object[])new Object[0]);
        }
        this.headersCompleted = true;
        this.muxLink.setContinuationExpected(false);
    }

    private void processHeadersPriority() {
        FrameHeaders castFrame = (FrameHeaders)this.currentFrame;
        if (castFrame.flagPrioritySet()) {
            int weight = castFrame.getWeight();
            int streamDependency = castFrame.getStreamDependency();
            boolean exclusive = castFrame.isExclusive();
            this.muxLink.getWorkQ().updateNodeFrameParameters(this.myID, weight, streamDependency, exclusive);
        }
    }

    private void getHeadersFromFrame() {
        byte[] hbf = null;
        if (this.currentFrame.getFrameType() == FrameTypes.HEADERS || this.currentFrame.getFrameType() == FrameTypes.PUSHPROMISEHEADERS) {
            hbf = ((FrameHeaders)this.currentFrame).getHeaderBlockFragment();
        } else if (this.currentFrame.getFrameType() == FrameTypes.CONTINUATION) {
            hbf = ((FrameContinuation)this.currentFrame).getHeaderBlockFragment();
        }
        if (hbf != null && hbf.length > 0) {
            if (this.headerBlock == null) {
                this.headerBlock = new ArrayList();
            }
            this.headerBlock.add(hbf);
        } else {
            ++this.emptyFrameReceivedCount;
        }
    }

    private void processCompleteHeaders(boolean isPush) throws CompressionException, ProtocolException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processCompleteHeaders entry: stream " + this.myID), (Object[])new Object[0]);
        }
        if (this.headerBlock != null) {
            WsByteBufferPoolManager bufManager = HttpDispatcher.getBufferManager();
            WsByteBuffer buf = bufManager.allocate(this.getByteCount(this.headerBlock));
            int firstBlockLength = this.headerBlock.get(0).length;
            for (byte[] byteArray : this.headerBlock) {
                buf.put(byteArray);
            }
            buf.flip();
            this.headerBlock = null;
            boolean isFirstLineComplete = false;
            HashMap<String, String> pseudoHeaders = new HashMap<String, String>();
            ArrayList<H2HeaderField> headers = new ArrayList<H2HeaderField>();
            H2HeaderField current = null;
            boolean isFirstHeader = true;
            boolean processTrailerHeaders = this.headersCompleted;
            while (buf.hasRemaining()) {
                boolean isFirstHeaderBlock = buf.position() < firstBlockLength;
                try {
                    current = H2Headers.decodeHeader(buf, this.muxLink.getReadTable(), isFirstHeader && isFirstHeaderBlock, processTrailerHeaders && !isPush, this.muxLink.getLocalConnectionSettings());
                }
                catch (Http2Exception e) {
                    buf.release();
                    throw e;
                }
                if (current == null) continue;
                isFirstHeader = false;
                if (!isFirstLineComplete) {
                    if (current.getName().startsWith(":")) {
                        if (pseudoHeaders.get(current.getName()) != null) {
                            this.muxLink.getReadTable().setDynamicTableValidity(false);
                            buf.release();
                            ProtocolException pe = new ProtocolException("Invalid pseudo-header for decompression context: " + current.toString());
                            pe.setConnectionError(false);
                            throw pe;
                        }
                        pseudoHeaders.put(current.getName(), current.getValue());
                        continue;
                    }
                    isFirstLineComplete = true;
                    if (H2Headers.getContentLengthValue(current) > -1) {
                        this.expectedContentLength = H2Headers.getContentLengthValue(current);
                    }
                    headers.add(current);
                    continue;
                }
                if (current.getName().startsWith(":")) {
                    this.muxLink.getReadTable().setDynamicTableValidity(false);
                    buf.release();
                    throw new CompressionException("Invalid pseudo-header decoded: all pseudo-headers must appear in the header block before regular header fields.");
                }
                if (H2Headers.getContentLengthValue(current) > -1) {
                    this.expectedContentLength = H2Headers.getContentLengthValue(current);
                }
                headers.add(current);
            }
            buf.release();
            if ((isPush || !processTrailerHeaders) && this.h2HttpInboundLinkWrap.getHeadersLength() == 0) {
                if (!this.isValidH2Request(pseudoHeaders)) {
                    this.muxLink.setContinuationExpected(false);
                    this.muxLink.setWriteContinuationExpected(false);
                    ProtocolException e = new ProtocolException("An invalid request was received on stream-id: " + this.myID);
                    e.setConnectionError(false);
                    throw e;
                }
                if (pseudoHeaders.get(":authority") != null) {
                    this.muxLink.setAuthority(pseudoHeaders.get(":authority"));
                }
                this.h2HttpInboundLinkWrap.setReadHeaders(headers);
                this.h2HttpInboundLinkWrap.setReadPseudoHeaders(pseudoHeaders);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processCompleteHeaders no header block set: stream " + this.myID), (Object[])new Object[0]);
        }
    }

    private boolean isValidH2Request(HashMap<String, String> pseudoHeaders) {
        if (MethodValues.CONNECT.getName().equals(pseudoHeaders.get(":method"))) {
            if (pseudoHeaders.get(":path") == null && pseudoHeaders.get(":scheme") == null && pseudoHeaders.get(":authority") != null) {
                this.isConnectStream = true;
                return true;
            }
            return false;
        }
        return pseudoHeaders.get(":method") != null && pseudoHeaders.get(":path") != null && pseudoHeaders.get(":scheme") != null;
    }

    private void getBodyFromFrame() {
        if (this.dataPayload == null) {
            this.dataPayload = new ArrayList();
        }
        if (this.currentFrame.getFrameType() == FrameTypes.DATA) {
            if (this.currentFrame.getPayloadLength() == 0) {
                ++this.emptyFrameReceivedCount;
            } else {
                this.dataPayload.add(((FrameData)this.currentFrame).getData());
            }
        }
    }

    private WsByteBuffer processCompleteData(boolean store) throws ProtocolException {
        WsByteBufferPoolManager bufManager = HttpDispatcher.getBufferManager();
        WsByteBuffer buf = bufManager.allocate(this.getByteCount(this.dataPayload));
        for (byte[] bytes : this.dataPayload) {
            buf.put(bytes);
        }
        buf.flip();
        int actualContentLength = buf.remaining();
        if (this.expectedContentLength != -1 && actualContentLength != this.expectedContentLength) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processCompleteData release buffer and throw ProtocolException", (Object[])new Object[0]);
            }
            buf.release();
            ProtocolException pe = new ProtocolException("content-length header did not match the expected amount of data received");
            pe.setConnectionError(false);
            throw pe;
        }
        if (this.expectedContentLength == -1 && actualContentLength > 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processCompleteData no content-length header was sent for stream-id: " + this.streamId() + " but it received " + actualContentLength + " bytes of of body data"), (Object[])new Object[0]);
        }
        this.h2HttpInboundLinkWrap.setH2ContentLength(actualContentLength);
        if (store) {
            this.moveDataIntoReadBufferArray(buf);
        }
        return buf;
    }

    private void setReadyForRead() throws ProtocolException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setReadyForRead entry: stream id:" + this.myID), (Object[])new Object[0]);
        }
        this.muxLink.updateGoawayPromisedStreamId(this.myID);
        if (this.headersCompleted) {
            ExecutorService executorService = CHFWBundle.getExecutorService();
            Http2Ready readyThread = new Http2Ready(this.h2HttpInboundLinkWrap);
            executorService.execute(readyThread);
        }
    }

    protected boolean isWaitingForWC() {
        return this.waitingForWebContainer;
    }

    private void moveDataIntoReadBufferArray(WsByteBuffer newReadBuffer) {
        int size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moveDataIntoReadBufferArray entry: stream " + this.myID + " buffer: " + newReadBuffer), (Object[])new Object[0]);
        }
        if (newReadBuffer != null && (size = newReadBuffer.remaining()) > 0) {
            this.streamReadReady.add(newReadBuffer);
            this.streamReadSize += size;
            this.readLatch.countDown();
        }
    }

    public VirtualConnection read(long numBytes, WsByteBuffer[] requestBuffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("read entry: stream " + this.myID + " request: " + requestBuffers + " num bytes requested: " + numBytes + " num bytes available: " + this.streamReadSize), (Object[])new Object[0]);
        }
        long streamByteCount = this.streamReadSize;
        long requestByteCount = this.bytesRemaining(requestBuffers);
        int reqArrayIndex = 0;
        if (numBytes > (long)this.streamReadSize || requestBuffers == null) {
            if (this.headersCompleted) {
                return this.h2HttpInboundLinkWrap.getVirtualConnection();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("read exit: stream " + this.myID + " more bytes requested than available for read: " + numBytes + " > " + this.streamReadSize), (Object[])new Object[0]);
            }
            return null;
        }
        this.actualReadCount = streamByteCount < requestByteCount ? streamByteCount : requestByteCount;
        int bytesRead = 0;
        while ((long)bytesRead < this.actualReadCount) {
            while (requestBuffers[reqArrayIndex].position() == requestBuffers[reqArrayIndex].limit()) {
                ++reqArrayIndex;
            }
            while (!this.streamReadReady.isEmpty() && !this.streamReadReady.peek().hasRemaining()) {
                this.streamReadReady.poll().release();
            }
            requestBuffers[reqArrayIndex].put(this.streamReadReady.peek().get());
            ++bytesRead;
        }
        this.streamReadSize = (int)((long)this.streamReadSize - this.actualReadCount);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("read exit: " + this.streamId() + " num bytes remaining to be read: " + this.streamReadSize), (Object[])new Object[0]);
        }
        return this.h2HttpInboundLinkWrap.getVirtualConnection();
    }

    public void countDownFirstReadLatch(boolean force) {
        if (this.firstReadLatch != null && this.firstReadLatch.getCount() > 0L) {
            if (force || this.streamReadSize == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("counting down firstReadLatch: " + this.firstReadLatch.hashCode() + " on stream " + this.myID + " force: " + force), (Object[])new Object[0]);
                }
                this.firstReadLatch.countDown();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("not counting down firstReadLatch: " + this.firstReadLatch.hashCode() + " becuase " + this.streamReadSize + " bytes remain on stream " + this.myID), (Object[])new Object[0]);
            }
        }
    }

    public long readCount(long numBytes, WsByteBuffer[] requestBuffers) {
        if (this.read(numBytes, requestBuffers) != null) {
            return this.actualReadCount;
        }
        return 0L;
    }

    private long bytesRemaining(@Sensitive WsByteBuffer[] bufs) {
        long count = 0L;
        int length = bufs.length;
        for (int i = 0; i < length; ++i) {
            if (bufs[i] == null) {
                return count;
            }
            count += (long)bufs[i].remaining();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bytesRemaining: the array passed into stream " + this.myID + " has " + count + " bytes remaining"), (Object[])new Object[0]);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean writeFrameSync() throws FlowControlException, Http2Exception {
        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync entry: stream: " + this.myID), (Object[])new Object[0]);
        }
        if (!(currentFrame = this.currentFrame).getFrameType().equals((Object)FrameTypes.GOAWAY) && this.isStreamClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync exit - stream " + this.myID + " is closed"), (Object[])new Object[0]);
            }
            return false;
        }
        if (currentFrame.isWriteFrame() && currentFrame.getInitialized()) {
            writeFrameBuffer = null;
            writeFrameBuffers = null;
            writeTimeout = this.muxLink.config.getWriteTimeout();
            try {
                if (currentFrame.getFrameType() == FrameTypes.DATA) {
                    data = (FrameData)currentFrame;
                    timedOut = false;
                    if (this.isWindowLimitExceeded((FrameData)currentFrame)) {
                        startTime = System.currentTimeMillis();
                        elapsed = 0L;
                        while (this.isWindowLimitExceeded((FrameData)currentFrame) && !timedOut) {
                            var11_15 = this;
                            synchronized (var11_15) {
                                this.wait(1000L);
                            }
                            elapsed = System.currentTimeMillis() - startTime;
                            if (this.state.equals((Object)StreamState.CLOSED) || this.muxLink.checkIfGoAwaySendingOrClosing()) {
                                var11_16 = false;
                                return var11_16;
                            }
                            if (elapsed >= (long)writeTimeout) {
                                timedOut = true;
                                continue;
                            }
                            writeTimeout = (int)((long)writeTimeout - elapsed);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("stream: " + this.myID + " write window wait complete; waited " + elapsed + " ms, timed out = " + timedOut), (Object[])new Object[0]);
                        }
                    }
                    if (!timedOut) {
                        writeFrameBuffers = data.buildFrameArrayForWrite();
                        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("stream: " + this.myID + " write with timeout: " + writeTimeout), (Object[])new Object[0]);
                        }
                        this.muxLink.writeSync(null, writeFrameBuffers, data.getWriteFrameLength(), writeTimeout, data.getFrameType(), data.getPayloadLength(), this.myID);
                        this.streamWindowUpdateWriteLimit -= (long)currentFrame.getPayloadLength();
                        if (!TraceComponent.isAnyTracingEnabled() || !H2StreamProcessor.tc.isDebugEnabled()) ** GOTO lbl79
                        Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("stream: " + this.myID + " Data payload written - new streamWindowUpdateWriteLimit: " + this.streamWindowUpdateWriteLimit), (Object[])new Object[0]);
                    }
                    up = new FlowControlException("Write failed. Window limit exceeded. Stream will be Reset.");
                    up.setConnectionError(false);
                    throw up;
                }
                writeFrameBuffer = currentFrame.buildFrameForWrite();
                if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("stream: " + this.myID + " write with timeout: " + writeTimeout), (Object[])new Object[0]);
                }
                this.muxLink.writeSync(writeFrameBuffer, null, currentFrame.getWriteFrameLength(), writeTimeout, currentFrame.getFrameType(), currentFrame.getPayloadLength(), this.myID);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync caught an IOException: " + e), (Object[])new Object[0]);
                }
                if (!(e instanceof SocketTimeoutException)) {
                    this.updateStreamState(StreamState.CLOSED);
                    this.muxLink.closeConnectionLink(e, false);
                }
                up = new Http2Exception(e.getMessage());
                up.setConnectionError(true);
                throw up;
            }
            catch (InterruptedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !H2StreamProcessor.tc.isDebugEnabled()) ** GOTO lbl79
                Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync interrupted: " + e), (Object[])new Object[0]);
            }
            finally {
                if (writeFrameBuffer != null) {
                    writeFrameBuffer.release();
                } else if (writeFrameBuffers != null) {
                    for (i = 0; i < writeFrameBuffers.length; ++i) {
                        if (writeFrameBuffers[i] == null || i == 1) continue;
                        writeFrameBuffers[i].release();
                    }
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)"writeFrameSync internal flow issue - exiting method ", (Object[])new Object[0]);
        }
lbl79:
        // 8 sources

        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync exit: stream-id: " + this.myID), (Object[])new Object[0]);
        }
        return true;
    }

    public boolean isStreamClosed() {
        if (this.myID == 0 && !this.endStream) {
            return false;
        }
        if (this.state == StreamState.CLOSED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isStreamClosed stream closed; " + this.streamId()), (Object[])new Object[0]);
            }
            return true;
        }
        boolean rc = this.muxLink.checkIfGoAwaySendingOrClosing();
        if (rc && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isStreamClosed stream closed via muxLink check; " + this.streamId()), (Object[])new Object[0]);
        }
        return rc;
    }

    public boolean isHalfClosed() {
        return this.state == StreamState.HALF_CLOSED_LOCAL || this.state == StreamState.HALF_CLOSED_REMOTE;
    }

    protected void setCloseTime(long x) {
        this.closeTime = x;
    }

    protected long getCloseTime() {
        return this.closeTime;
    }

    public boolean waitForConnectionInit() {
        try {
            boolean rc;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("waitForConnectionInit: waiting for the H2 connection to complete initialization on " + this.streamId()), (Object[])new Object[0]);
            }
            if (rc = this.muxLink.initLock.await(30000L, TimeUnit.MILLISECONDS)) {
                if (!this.muxLink.checkIfGoAwaySendingOrClosing()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("waitForConnectionInit: stop waiting, H2 connection initialized " + this.streamId()), (Object[])new Object[0]);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"waitForConnectionInit: stop waiting, h2 initialization error ", (Object[])new Object[0]);
                    }
                    rc = false;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"waitForConnectionInit: stop waiting, timed out waiting for client ", (Object[])new Object[0]);
                }
                this.muxLink.close(this.muxLink.initialVC, new ProtocolException("http/2 protocol initialization failed"));
            }
            return rc;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected CountDownLatch getReadLatch() {
        return this.readLatch;
    }

    private String streamId() {
        return "stream-id: " + this.myID;
    }

    private int getByteCount(ArrayList<byte[]> listOfByteArrays) {
        int count = 0;
        for (byte[] byteArray : listOfByteArrays) {
            if (byteArray == null) continue;
            count += byteArray.length;
        }
        return count;
    }

    public int getId() {
        return this.myID;
    }

    public H2HttpInboundLinkWrap getWrappedInboundLink() {
        return this.h2HttpInboundLinkWrap;
    }

    public static boolean isControlFrame(Frame frame) {
        switch (frame.getFrameType()) {
            case PRIORITY: {
                return true;
            }
            case RST_STREAM: {
                return true;
            }
            case SETTINGS: {
                return true;
            }
            case PING: {
                return true;
            }
            case GOAWAY: {
                return true;
            }
        }
        return false;
    }

    public boolean getEndStream() {
        return this.endStream;
    }

    private class Http2Ready
    implements Runnable {
        private H2HttpInboundLinkWrap h2HttpInboundLinkWrap = null;

        public Http2Ready(H2HttpInboundLinkWrap x) {
            this.h2HttpInboundLinkWrap = x;
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("new thread calling h2HttpInboundLinkWrap.ready(...): stream id:" + H2StreamProcessor.this.myID), (Object[])new Object[0]);
            }
            try {
                H2StreamProcessor.this.waitingForWebContainer = true;
                boolean closing = H2StreamProcessor.this.muxLink.checkIfGoAwaySendingOrClosing();
                if (!closing) {
                    this.h2HttpInboundLinkWrap.ready(this.h2HttpInboundLinkWrap.vc);
                }
            }
            finally {
                if (H2StreamProcessor.this.getEndStream()) {
                    H2StreamProcessor.this.headersCompleted = false;
                }
                H2StreamProcessor.this.waitingForWebContainer = false;
            }
        }
    }

    public static enum ADDITIONAL_FRAME {
        FIRST_TIME,
        NO,
        RESET,
        GOAWAY,
        DATA;

    }

    public static enum PROCESS_TYPE {
        DEFAULT,
        PAYLOAD_FIRST;

    }
}

