/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.internal.HttpEndpointImpl;
import com.ibm.ws.http.internal.VirtualHostMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.ChainEventListener;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.InvalidRuntimeStateException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpChain
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register(HttpChain.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private final StopWait stopWait = new StopWait();
    private final HttpEndpointImpl owner;
    private final boolean isHttps;
    private String endpointName;
    private String tcpName;
    private String sslName;
    private String httpName;
    private String dispatcherName;
    private String chainName;
    private ChannelFramework cfw;
    private EndPointMgr endpointMgr;
    private final AtomicInteger chainState;
    private volatile boolean enabled;
    private volatile ActiveConfiguration currentConfig;
    static final long serialVersionUID = 5163648858449586316L;

    public HttpChain(HttpEndpointImpl owner, boolean isHttps) {
        this.chainState = new AtomicInteger(ChainState.UNINITIALIZED.val);
        this.enabled = false;
        this.currentConfig = null;
        this.owner = owner;
        this.isHttps = isHttps;
    }

    /*
     * WARNING - void declaration
     */
    public void init(String endpointId, Object componentId, CHFWBundle cfBundle) {
        block5: {
            String root = endpointId + (this.isHttps ? "-ssl" : "");
            this.cfw = cfBundle.getFramework();
            this.endpointMgr = cfBundle.getEndpointManager();
            this.endpointName = root;
            this.tcpName = root;
            this.sslName = "SSL-" + root;
            this.httpName = "HTTP-" + root;
            this.dispatcherName = "HTTPD-" + root;
            this.chainName = "CHAIN-" + root;
            try {
                ChainData cd = this.cfw.getChain(this.chainName);
                if (cd != null) {
                    this.cfw.stopChain(cd, 0L);
                    this.cfw.destroyChain(cd);
                    this.cfw.removeChain(cd);
                }
            }
            catch (ChannelException cd) {
                FFDCFilter.processException((Throwable)cd, (String)"com.ibm.ws.http.internal.HttpChain", (String)"165", (Object)this, (Object[])new Object[]{endpointId, componentId, cfBundle});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{this, e});
                }
            }
            catch (ChainException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.internal.HttpChain", (String)"169", (Object)this, (Object[])new Object[]{endpointId, componentId, cfBundle});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{this, e});
            }
        }
    }

    public void enable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("enable chain " + this), (Object[])new Object[0]);
        }
        this.enabled = true;
    }

    public void disable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("disable chain " + this), (Object[])new Object[0]);
        }
        this.enabled = false;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={InvalidRuntimeStateException.class})
    public synchronized void stop() {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("stop chain " + this), (Object[])new Object[0]);
            }
            this.endpointMgr.removeEndPoint(this.endpointName);
            if (this.currentConfig == null || this.chainState.get() <= ChainState.QUIESCED.val) {
                return;
            }
            try {
                ChainData cd = this.cfw.getChain(this.chainName);
                if (cd != null) {
                    this.cfw.stopChain(cd, this.cfw.getDefaultChainQuiesceTimeout());
                    this.stopWait.waitForStop(this.cfw.getDefaultChainQuiesceTimeout(), this);
                    try {
                        this.cfw.destroyChain(cd);
                        this.cfw.removeChain(cd);
                    }
                    catch (InvalidRuntimeStateException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Error destroying or removing chain " + this.chainName), (Object[])new Object[]{this, e});
                        }
                    }
                }
            }
            catch (ChannelException cd) {
                FFDCFilter.processException((Throwable)cd, (String)"com.ibm.ws.http.internal.HttpChain", (String)"235", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{this, e});
                }
            }
            catch (ChainException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.internal.HttpChain", (String)"239", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error stopping chain " + this.chainName), (Object[])new Object[]{this, e});
            }
        }
    }

    @FFDCIgnore(value={ChannelException.class, ChainException.class})
    public synchronized void update(String resolvedHostName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("update chain " + this), (Object[])new Object[0]);
        }
        if (!this.enabled || FrameworkState.isStopping()) {
            return;
        }
        ActiveConfiguration oldConfig = this.currentConfig;
        boolean validOldConfig = oldConfig == null ? false : oldConfig.validConfiguration;
        Map<String, Object> tcpOptions = this.owner.getTcpOptions();
        Map<String, Object> sslOptions = this.isHttps ? this.owner.getSslOptions() : null;
        Map<String, Object> httpOptions = this.owner.getHttpOptions();
        Map<String, Object> endpointOptions = this.owner.getEndpointOptions();
        Map<String, Object> remoteIpOptions = this.owner.getRemoteIpConfig();
        Map<String, Object> compressionOptions = this.owner.getCompressionConfig();
        Map<String, Object> samesiteOptions = this.owner.getSamesiteConfig();
        Map<String, Object> headersOptions = this.owner.getHeadersConfig();
        ActiveConfiguration newConfig = new ActiveConfiguration(this.isHttps, tcpOptions, sslOptions, httpOptions, remoteIpOptions, compressionOptions, samesiteOptions, headersOptions, endpointOptions, resolvedHostName);
        if (newConfig.configPort < 0 || !newConfig.complete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Stopping chain due to configuration " + newConfig), (Object[])new Object[0]);
            }
            this.currentConfig = newConfig;
            this.stop();
        } else {
            try {
                ChainData cd;
                ChannelData httpDispatcher;
                ChannelData httpChannel;
                ChannelData sslChannel;
                HashMap<String, Object> chanProps;
                boolean sameConfig = newConfig.unchanged(oldConfig);
                if (validOldConfig && sameConfig) {
                    int state = this.chainState.get();
                    if (state == ChainState.STARTED.val) {
                        sameConfig = oldConfig.validateActivePort();
                        if (sameConfig) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Configuration is unchanged, and chain is already started: " + oldConfig), (Object[])new Object[0]);
                            }
                            return;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Configuration is unchanged, but chain is running with a mismatched configuration: " + oldConfig), (Object[])new Object[0]);
                        }
                    } else if (state == ChainState.QUIESCED.val) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Configuration is unchanged, chain is quiescing, wait for stop: " + newConfig), (Object[])new Object[0]);
                        }
                        this.stopWait.waitForStop(this.cfw.getDefaultChainQuiesceTimeout(), this);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Configuration is unchanged, chain must be started: " + newConfig), (Object[])new Object[0]);
                    }
                }
                if (!sameConfig) {
                    ChainData cd2;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("New/changed chain configuration " + newConfig), (Object[])new Object[0]);
                    }
                    if ((cd2 = this.cfw.getChain(this.chainName)) != null) {
                        this.cfw.stopChain(cd2, this.cfw.getDefaultChainQuiesceTimeout());
                        this.stopWait.waitForStop(this.cfw.getDefaultChainQuiesceTimeout(), this);
                        this.cfw.destroyChain(cd2);
                        this.cfw.removeChain(cd2);
                    }
                    if (newConfig.tcpChanged(oldConfig)) {
                        this.removeChannel(this.tcpName);
                    }
                    if (newConfig.sslChanged(oldConfig)) {
                        this.removeChannel(this.sslName);
                    }
                    if (newConfig.httpChanged(oldConfig)) {
                        this.removeChannel(this.httpName);
                    }
                    if (newConfig.endpointChanged(oldConfig)) {
                        this.removeChannel(this.dispatcherName);
                    }
                }
                this.currentConfig = newConfig;
                EndPointInfo ep = this.endpointMgr.defineEndPoint(this.endpointName, newConfig.configHost, newConfig.configPort);
                ChannelData tcpChannel = this.cfw.getChannel(this.tcpName);
                if (tcpChannel == null) {
                    String typeName = (String)tcpOptions.get("type");
                    chanProps = new HashMap<String, Object>(tcpOptions);
                    chanProps.put("endPointName", this.endpointName);
                    chanProps.put("hostname", ep.getHost());
                    chanProps.put("port", String.valueOf(ep.getPort()));
                    tcpChannel = this.cfw.addChannel(this.tcpName, this.cfw.lookupFactory(typeName), chanProps);
                }
                if (this.isHttps && (sslChannel = this.cfw.getChannel(this.sslName)) == null) {
                    chanProps = new HashMap<String, Object>(sslOptions);
                    if (this.owner.getProtocolVersion() != null) {
                        chanProps.put("protocolVersionInternal", this.owner.getProtocolVersion());
                    }
                    sslChannel = this.cfw.addChannel(this.sslName, this.cfw.lookupFactory("SSLChannel"), chanProps);
                }
                if ((httpChannel = this.cfw.getChannel(this.httpName)) == null) {
                    chanProps = new HashMap<String, Object>(httpOptions);
                    chanProps.put("accessLogID", this.owner.getName());
                    if (this.owner.getProtocolVersion() != null) {
                        chanProps.put("protocolVersionInternal", this.owner.getProtocolVersion());
                    }
                    if (remoteIpOptions.get("id").equals("defaultRemoteIp")) {
                        chanProps.put("useRemoteIpInternal", "false");
                        chanProps.put("proxiesInternal", null);
                        chanProps.put("useRemoteIpInAccessLogInternal", null);
                    } else {
                        chanProps.put("useRemoteIpInternal", "true");
                        if (remoteIpOptions.containsKey("proxies")) {
                            chanProps.put("proxiesInternal", remoteIpOptions.get("proxies"));
                        }
                        if (remoteIpOptions.containsKey("useRemoteIpInAccessLog")) {
                            chanProps.put("useRemoteIpInAccessLogInternal", remoteIpOptions.get("useRemoteIpInAccessLog"));
                        }
                    }
                    if (compressionOptions.get("id").equals("defaultCompression")) {
                        chanProps.put("useAutoCompressionInternal", "false");
                        chanProps.put("compressionListByTypesInternal", null);
                        chanProps.put("serverPreferredAlgorithmInternal", null);
                    } else {
                        chanProps.put("useAutoCompressionInternal", "true");
                        if (compressionOptions.containsKey("types")) {
                            chanProps.put("compressionListByTypesInternal", compressionOptions.get("types"));
                        }
                        if (compressionOptions.containsKey("serverPreferredAlgorithm")) {
                            chanProps.put("serverPreferredAlgorithmInternal", compressionOptions.get("serverPreferredAlgorithm"));
                        }
                    }
                    if (samesiteOptions.get("id").equals("defaultSameSite")) {
                        chanProps.put("sameSiteInternal", "false");
                        chanProps.put("sameSiteLaxInternal", null);
                        chanProps.put("sameSiteNoneInternal", null);
                        chanProps.put("sameSiteStrictInternal", null);
                    } else {
                        boolean enableSameSite = false;
                        if (samesiteOptions.containsKey("lax")) {
                            enableSameSite = true;
                            chanProps.put("sameSiteLaxInternal", samesiteOptions.get("lax"));
                        }
                        if (samesiteOptions.containsKey("none")) {
                            enableSameSite = true;
                            chanProps.put("sameSiteNoneInternal", samesiteOptions.get("none"));
                        }
                        if (samesiteOptions.containsKey("strict")) {
                            enableSameSite = true;
                            chanProps.put("sameSiteStrictInternal", samesiteOptions.get("strict"));
                        }
                        chanProps.put("sameSiteInternal", enableSameSite);
                    }
                    if (headersOptions.get("id").equals("defaultHeaders")) {
                        chanProps.put("headersInternal", "false");
                        chanProps.put("headersAddInternal", null);
                        chanProps.put("headersSetInternal", null);
                        chanProps.put("headersSetIfMissingInternal", null);
                        chanProps.put("headersRemoveInternal", null);
                    } else {
                        boolean enableHeadersFeature = false;
                        if (headersOptions.containsKey("add")) {
                            enableHeadersFeature = true;
                            chanProps.put("headersAddInternal", headersOptions.get("add"));
                        }
                        if (headersOptions.containsKey("set")) {
                            enableHeadersFeature = true;
                            chanProps.put("headersSetInternal", headersOptions.get("set"));
                        }
                        if (headersOptions.containsKey("setIfMissing")) {
                            enableHeadersFeature = true;
                            chanProps.put("headersSetIfMissingInternal", headersOptions.get("setIfMissing"));
                        }
                        if (headersOptions.containsKey("remove")) {
                            enableHeadersFeature = true;
                            chanProps.put("headersRemoveInternal", headersOptions.get("remove"));
                        }
                        chanProps.put("headersInternal", enableHeadersFeature);
                    }
                    httpChannel = this.cfw.addChannel(this.httpName, this.cfw.lookupFactory("HTTPInboundChannel"), chanProps);
                }
                if ((httpDispatcher = this.cfw.getChannel(this.dispatcherName)) == null) {
                    chanProps = new HashMap();
                    chanProps.put("httpEndpoint", this.owner.getPid());
                    httpDispatcher = this.cfw.addChannel(this.dispatcherName, this.cfw.lookupFactory("HTTPDispatcherChannel"), chanProps);
                }
                if (null == (cd = this.cfw.getChain(this.chainName))) {
                    String[] chanList = this.isHttps ? new String[]{this.tcpName, this.sslName, this.httpName, this.dispatcherName} : new String[]{this.tcpName, this.httpName, this.dispatcherName};
                    cd = this.cfw.addChain(this.chainName, FlowType.INBOUND, chanList);
                    cd.setEnabled(this.enabled);
                    this.cfw.addChainEventListener((ChainEventListener)this, this.chainName);
                    this.cfw.initChain(this.chainName);
                }
                newConfig.validConfiguration = true;
            }
            catch (ChannelException e) {
                this.handleStartupError((Exception)((Object)e), newConfig);
            }
            catch (ChainException e) {
                this.handleStartupError((Exception)((Object)e), newConfig);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.internal.HttpChain", (String)"529", (Object)this, (Object[])new Object[]{resolvedHostName});
                Tr.error((TraceComponent)tc, (String)"config.httpChain.error", (Object[])new Object[]{this.tcpName, e.toString()});
                this.handleStartupError(e, newConfig);
            }
            if (newConfig.validConfiguration) {
                try {
                    this.cfw.startChain(this.chainName);
                }
                catch (ChannelException e) {
                    this.handleStartupError((Exception)((Object)e), newConfig);
                }
                catch (ChainException e) {
                    this.handleStartupError((Exception)((Object)e), newConfig);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.internal.HttpChain", (String)"543", (Object)this, (Object[])new Object[]{resolvedHostName});
                    Tr.error((TraceComponent)tc, (String)"start.httpChain.error", (Object[])new Object[]{this.tcpName, e.toString()});
                    this.handleStartupError(e, newConfig);
                }
            }
        }
    }

    @FFDCIgnore(value={ChannelException.class, ChainException.class})
    private void removeChannel(String name) {
        block4: {
            try {
                this.cfw.removeChannel(name);
            }
            catch (ChannelException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + name), (Object[])new Object[]{this, e});
                }
            }
            catch (ChainException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + name), (Object[])new Object[]{this, e});
            }
        }
    }

    private void handleStartupError(Exception e, ActiveConfiguration cfg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Error starting chain " + this.chainName), (Object[])new Object[]{this, e});
        }
        if (this.owner.onError() == OnErrorUtil.OnError.FAIL) {
            this.owner.shutdownFramework();
        } else {
            String topic = this.owner.getEventTopic() + "/FAILED";
            this.postEvent(topic, cfg, e);
        }
    }

    public int getActivePort() {
        ActiveConfiguration cfg = this.currentConfig;
        if (cfg != null) {
            return cfg.getActivePort();
        }
        return -1;
    }

    public void chainInitialized(ChainData chainData) {
        this.chainState.set(ChainState.INITIALIZED.val);
    }

    public synchronized void chainStarted(ChainData chainData) {
        this.chainState.set(ChainState.STARTED.val);
        ActiveConfiguration cfg = this.currentConfig;
        int port = cfg.getActivePort();
        if (port > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("New configuration started " + cfg), (Object[])new Object[0]);
            }
            VirtualHostMap.notifyStarted(this.owner, () -> cfg.resolvedHost, port, this.isHttps);
            String topic = this.owner.getEventTopic() + "/STARTED";
            this.postEvent(topic, cfg, null);
        }
    }

    public void chainStopped(ChainData chainData) {
        ActiveConfiguration cfg = this.currentConfig;
        int oldState = this.chainState.getAndSet(ChainState.STOPPED.val);
        if (oldState > ChainState.QUIESCED.val) {
            this.quiesceChain();
        }
        this.stopWait.notifyStopped();
        String topic = this.owner.getEventTopic() + "/STOPPED";
        this.postEvent(topic, cfg, null);
        cfg.clearActivePort();
    }

    public void chainQuiesced(ChainData chainData) {
        int oldState = this.chainState.getAndSet(ChainState.QUIESCED.val);
        if (oldState > ChainState.QUIESCED.val) {
            this.quiesceChain();
        }
    }

    private void quiesceChain() {
        ActiveConfiguration cfg = this.currentConfig;
        VirtualHostMap.notifyStopped(this.owner, cfg.resolvedHost, cfg.activePort, this.isHttps);
    }

    public void chainDestroyed(ChainData chainData) {
        this.chainState.set(ChainState.DESTROYED.val);
    }

    public void chainUpdated(ChainData chainData) {
    }

    private void postEvent(String t, ActiveConfiguration c, Exception e) {
        EventAdmin engine;
        HashMap<String, Object> eventProps = new HashMap<String, Object>(4);
        eventProps.put("name", this.endpointName);
        eventProps.put("activePort", c.activePort);
        eventProps.put("configHost", c.configHost);
        eventProps.put("configPort", c.configPort);
        eventProps.put("isHttps", this.isHttps);
        if (e != null) {
            eventProps.put("exception", e.toString());
        }
        if ((engine = this.owner.getEventAdmin()) != null) {
            Event event = new Event(t, eventProps);
            engine.postEvent(event);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@=" + System.identityHashCode(this) + ",enabled=" + this.enabled + ",state=" + ChainState.printState(this.chainState.get()) + ",chainName=" + this.chainName + ",config=" + this.currentConfig + "]";
    }

    public int getChainState() {
        return this.chainState.get();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class StopWait {
        static final long serialVersionUID = 1336683977449397493L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        StopWait() {
        }

        synchronized void waitForStop(long timeout, HttpChain chain) {
            long start;
            long interval = timeout + 2345L;
            for (long waited = 0L; HttpChain.this.chainState.get() > ChainState.STOPPED.val && waited < interval; waited += System.nanoTime() - start) {
                start = System.nanoTime();
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)HttpChain.this, (TraceComponent)tc, (String)"Waiting for chain stop", (Object[])new Object[]{waited, interval});
                    }
                    this.wait(interval - waited);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.internal.HttpChain$StopWait", (String)"955", (Object)this, (Object[])new Object[]{timeout, chain});
                }
            }
        }

        synchronized void notifyStopped() {
            this.notifyAll();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpChain$StopWait", StopWait.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class ActiveConfiguration {
        final boolean isHttps;
        final int configPort;
        final String configHost;
        final String resolvedHost;
        final Map<String, Object> tcpOptions;
        final Map<String, Object> sslOptions;
        final Map<String, Object> httpOptions;
        final Map<String, Object> remoteIp;
        final Map<String, Object> compression;
        final Map<String, Object> samesite;
        final Map<String, Object> headers;
        final Map<String, Object> endpointOptions;
        volatile int activePort = -1;
        boolean validConfiguration = false;
        static final long serialVersionUID = -5545319087145007917L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ActiveConfiguration(boolean isHttps, Map<String, Object> tcp, Map<String, Object> ssl, Map<String, Object> http, Map<String, Object> remoteIp, Map<String, Object> compression, Map<String, Object> samesite, Map<String, Object> headers, Map<String, Object> endpoint, String resolvedHostName) {
            this.isHttps = isHttps;
            this.tcpOptions = tcp;
            this.sslOptions = ssl;
            this.httpOptions = http;
            this.remoteIp = remoteIp;
            this.compression = compression;
            this.samesite = samesite;
            this.headers = headers;
            this.endpointOptions = endpoint;
            String attribute = isHttps ? "httpsPort" : "httpPort";
            this.configPort = MetatypeUtils.parseInteger((Object)"httpEndpoint", (String)attribute, (Object)this.endpointOptions.get(attribute), (int)-1);
            this.configHost = (String)this.endpointOptions.get("host");
            this.resolvedHost = resolvedHostName;
        }

        public void clearActivePort() {
            this.activePort = -1;
        }

        public boolean validateActivePort() {
            try {
                return this.activePort == HttpChain.this.cfw.getListeningPort(HttpChain.this.chainName);
            }
            catch (ChainException chainException) {
                FFDCFilter.processException((Throwable)chainException, (String)"com.ibm.ws.http.internal.HttpChain$ActiveConfiguration", (String)"801", (Object)this, (Object[])new Object[0]);
                return false;
            }
        }

        @FFDCIgnore(value={ChainException.class})
        public int getActivePort() {
            if (this.configPort < 0) {
                return -1;
            }
            if (this.activePort == -1) {
                try {
                    this.activePort = HttpChain.this.cfw.getListeningPort(HttpChain.this.chainName);
                }
                catch (ChainException ce) {
                    this.activePort = -1;
                }
            }
            return this.activePort;
        }

        @Trivial
        public boolean complete() {
            if (this.tcpOptions == null || this.httpOptions == null) {
                return false;
            }
            return !this.isHttps || this.sslOptions != null;
        }

        protected boolean unchanged(ActiveConfiguration other) {
            if (other == null) {
                return false;
            }
            if (this.isHttps) {
                return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions && this.sslOptions == other.sslOptions && this.httpOptions == other.httpOptions && this.remoteIp == other.remoteIp && this.compression == other.compression && this.samesite == other.samesite && this.headers == other.headers && !this.endpointChanged(other);
            }
            return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions && this.httpOptions == other.httpOptions && this.remoteIp == other.remoteIp && this.compression == other.compression && this.samesite == other.samesite && this.headers == other.headers && !this.endpointChanged(other);
        }

        protected boolean tcpChanged(ActiveConfiguration other) {
            if (other == null) {
                return true;
            }
            return !this.configHost.equals(other.configHost) || this.configPort != other.configPort || this.tcpOptions != other.tcpOptions;
        }

        protected boolean sslChanged(ActiveConfiguration other) {
            if (other == null) {
                return true;
            }
            return this.sslOptions != other.sslOptions;
        }

        protected boolean httpChanged(ActiveConfiguration other) {
            if (other == null) {
                return true;
            }
            return this.httpOptions != other.httpOptions || this.remoteIp != other.remoteIp || this.compression != other.compression || this.samesite != other.samesite || this.headers != other.headers;
        }

        protected boolean endpointChanged(ActiveConfiguration other) {
            if (other == null) {
                return true;
            }
            return !this.endpointOptions.get("service.pid").equals(other.endpointOptions.get("service.pid"));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[host=" + this.configHost + ",resolvedHost=" + this.resolvedHost + ",port=" + this.configPort + ",listening=" + this.activePort + ",complete=" + this.complete() + ",tcpOptions=" + System.identityHashCode(this.tcpOptions) + ",httpOptions=" + System.identityHashCode(this.httpOptions) + ",remoteIp=" + System.identityHashCode(this.remoteIp) + ",compression=" + System.identityHashCode(this.compression) + ",samesite=" + System.identityHashCode(this.samesite) + ",headers=" + System.identityHashCode(this.headers) + ",sslOptions=" + (this.isHttps ? Integer.valueOf(System.identityHashCode(this.sslOptions)) : "0") + ",endpointOptions=" + this.endpointOptions.get("service.pid") + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpChain$ActiveConfiguration", ActiveConfiguration.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    }

    static enum ChainState {
        UNINITIALIZED(0, "UNINITIALIZED"),
        DESTROYED(1, "DESTROYED"),
        INITIALIZED(2, "INITIALIZED"),
        STOPPED(3, "STOPPED"),
        QUIESCED(4, "QUIESCED"),
        STARTED(5, "STARTED");

        final int val;
        final String name;

        @Trivial
        private ChainState(int val, String name) {
            this.val = val;
            this.name = "name";
        }

        @Trivial
        public static final String printState(int state) {
            switch (state) {
                case 0: {
                    return "UNINITIALIZED";
                }
                case 1: {
                    return "DESTROYED";
                }
                case 2: {
                    return "INITIALIZED";
                }
                case 3: {
                    return "STOPPED";
                }
                case 4: {
                    return "QUIESCED";
                }
                case 5: {
                    return "STARTED";
                }
            }
            return "UNKNOWN";
        }
    }
}

