/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.HttpDateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HttpDateFormatImpl
implements HttpDateFormat {
    private static final TraceComponent tc = Tr.register(HttpDateFormatImpl.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private final CachedTime c1123Time = new CachedTime("EEE, dd MMM uuuu HH:mm:ss z", true);
    private final CachedTime c1036Time = new CachedTime("EEEE, dd-MMM-uu HH:mm:ss z", true);
    private final CachedTime cAsciiTime = new CachedTime("EEE MMM  d HH:mm:ss uuuu", true);
    private final CachedTime cNCSATime = new CachedTime("dd/MMM/uuuu:HH:mm:ss Z", false);
    private final CachedTime c2109Time = new CachedTime("EEE, dd-MMM-uu HH:mm:ss z", true);
    static final long serialVersionUID = 5295781518997590937L;

    public static HttpDateFormat getInstance() {
        return HttpDateFormatHolder.dateFormatSvc;
    }

    @Override
    public byte[] getRFC1123TimeAsBytes() {
        return this.c1123Time.getTimeAsBytes(0L);
    }

    @Override
    public byte[] getRFC1123TimeAsBytes(long range) {
        return this.c1123Time.getTimeAsBytes(range);
    }

    @Override
    public String getRFC1123Time() {
        return this.c1123Time.getTimeAsString(0L);
    }

    @Override
    public String getRFC1123Time(long range) {
        return this.c1123Time.getTimeAsString(range);
    }

    @Override
    public String getRFC1123Time(Date inDate) {
        return this.c1123Time.formatter.format(inDate.toInstant());
    }

    @Override
    public byte[] getRFC1036TimeAsBytes() {
        return this.c1036Time.getTimeAsBytes(0L);
    }

    @Override
    public byte[] getRFC1036TimeAsBytes(long range) {
        return this.c1036Time.getTimeAsBytes(range);
    }

    @Override
    public String getRFC1036Time() {
        return this.c1036Time.getTimeAsString(0L);
    }

    @Override
    public String getRFC1036Time(long range) {
        return this.c1036Time.getTimeAsString(range);
    }

    @Override
    public String getRFC1036Time(Date inDate) {
        return this.c1036Time.formatter.format(inDate.toInstant());
    }

    @Override
    public byte[] getRFC2109TimeAsBytes() {
        return this.c2109Time.getTimeAsBytes(0L);
    }

    @Override
    public byte[] getRFC2109TimeAsBytes(long range) {
        return this.c2109Time.getTimeAsBytes(range);
    }

    @Override
    public String getRFC2109Time() {
        return this.c2109Time.getTimeAsString(0L);
    }

    @Override
    public String getRFC2109Time(long range) {
        return this.c2109Time.getTimeAsString(range);
    }

    @Override
    public String getRFC2109Time(Date inDate) {
        return this.c2109Time.formatter.format(inDate.toInstant());
    }

    @Override
    public byte[] getASCIITimeAsBytes() {
        return this.cAsciiTime.getTimeAsBytes(0L);
    }

    @Override
    public byte[] getASCIITimeAsBytes(long range) {
        return this.cAsciiTime.getTimeAsBytes(range);
    }

    @Override
    public String getASCIITime() {
        return this.cAsciiTime.getTimeAsString(0L);
    }

    @Override
    public String getASCIITime(long range) {
        return this.cAsciiTime.getTimeAsString(range);
    }

    @Override
    public String getASCIITime(Date inDate) {
        return this.cAsciiTime.formatter.format(inDate.toInstant());
    }

    @Override
    public byte[] getNCSATimeAsBytes() {
        return this.cNCSATime.getTimeAsBytes(0L);
    }

    @Override
    public byte[] getNCSATimeAsBytes(long range) {
        return this.cNCSATime.getTimeAsBytes(range);
    }

    @Override
    public String getNCSATime() {
        return this.cNCSATime.getTimeAsString(0L);
    }

    @Override
    public String getNCSATime(long range) {
        return this.cNCSATime.getTimeAsString(range);
    }

    @Override
    public String getNCSATime(Date inDate) {
        return this.cNCSATime.formatter.format(inDate.toInstant());
    }

    private Date attemptParse(DateTimeFormatter format, String input) {
        ParsePosition pos = new ParsePosition(0);
        try {
            TemporalAccessor accessor = format.parse((CharSequence)input, pos);
            if (0 == pos.getIndex() || pos.getIndex() != input.length()) {
                return null;
            }
            return Date.from(Instant.from(accessor));
        }
        catch (DateTimeException accessor) {
            FFDCFilter.processException((Throwable)accessor, (String)"com.ibm.ws.http.internal.HttpDateFormatImpl", (String)"430", (Object)this, (Object[])new Object[]{format, input});
            return null;
        }
    }

    @Override
    public Date parseRFC1123Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc1123 parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.c1123Time.formatter, input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseRFC1036Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc1036 parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.c1036Time.formatter, input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseRFC2109Time(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc2109 parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.c2109Time.formatter, input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseASCIITime(String input) throws ParseException {
        Date d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ascii parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (null == (d = this.attemptParse(this.cAsciiTime.formatter, input))) {
            throw new ParseException("Unparseable [" + input + "]", 0);
        }
        return d;
    }

    @Override
    public Date parseTime(String input) throws ParseException {
        Date parsedDate;
        String data;
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseTime parsing [" + input + "]"), (Object[])new Object[0]);
        }
        if (-1 != (i = (data = input).indexOf(59, 0))) {
            char c;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring excess data following semi-colon in date", (Object[])new Object[0]);
            }
            while (i > 20 && (' ' == (c = data.charAt(i - 1)) || '\t' == c)) {
                --i;
            }
            if (20 >= i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not enough data left to make a valid date", (Object[])new Object[0]);
                }
                throw new ParseException("Invalid date [" + input + "]", 0);
            }
            data = input.substring(0, i);
        }
        if (null == (parsedDate = this.attemptParse(this.c1123Time.formatter, data)) && null == (parsedDate = this.attemptParse(this.c1036Time.formatter, data)) && null == (parsedDate = this.attemptParse(this.cAsciiTime.formatter, data)) && null == (parsedDate = this.attemptParse(this.c2109Time.formatter, data))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Time does not match supported formats", (Object[])new Object[0]);
            }
            throw new ParseException("Unparseable [" + data + "]", 0);
        }
        return parsedDate;
    }

    @Override
    public Date parseTime(byte[] inBytes) throws ParseException {
        return this.parseTime(GenericUtils.getEnglishString(inBytes));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CachedTime {
        static final ZoneId gmt;
        static final Set<TemporalField> resolverFields;
        private final AtomicReference<CachedFormattedTime> cachedTime = new AtomicReference();
        final DateTimeFormatter formatter;
        static final long serialVersionUID = -2077078450073985572L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CachedTime(String pattern, boolean gmtTimeZone) {
            DateTimeFormatter dateFormatter;
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern(pattern);
            this.formatter = dateFormatter = builder.toFormatter(Locale.US).withZone(gmtTimeZone ? gmt : ZoneId.systemDefault()).withResolverFields(resolverFields);
        }

        private CachedFormattedTime updateTime(long tolerance) {
            long now = HttpDispatcher.getApproxTime();
            long strippedMillis = now - now % 1000L;
            CachedFormattedTime cachedFormattedTime = this.cachedTime.get();
            if (cachedFormattedTime != null) {
                if (strippedMillis == cachedFormattedTime.timeWithStrippedMillis) {
                    return cachedFormattedTime;
                }
                if (tolerance > 1000L && now - cachedFormattedTime.timeInMilliseconds <= tolerance) {
                    return cachedFormattedTime;
                }
            }
            String sTime = this.formatter.format(Instant.ofEpochMilli(strippedMillis));
            CachedFormattedTime newCachedFormattedTime = new CachedFormattedTime(now, strippedMillis, sTime);
            this.cachedTime.compareAndSet(cachedFormattedTime, newCachedFormattedTime);
            return newCachedFormattedTime;
        }

        byte[] getTimeAsBytes(long tolerance) {
            return this.updateTime(tolerance).getBytes();
        }

        String getTimeAsString(long tolerance) {
            return this.updateTime((long)tolerance).formattedTimeString;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpDateFormatImpl$CachedTime", CachedTime.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
            gmt = ZoneId.of("GMT");
            HashSet<ChronoField> fields = new HashSet<ChronoField>();
            fields.add(ChronoField.YEAR);
            fields.add(ChronoField.MONTH_OF_YEAR);
            fields.add(ChronoField.DAY_OF_MONTH);
            fields.add(ChronoField.HOUR_OF_DAY);
            fields.add(ChronoField.MINUTE_OF_HOUR);
            fields.add(ChronoField.SECOND_OF_MINUTE);
            fields.add(ChronoField.INSTANT_SECONDS);
            fields.add(ChronoField.NANO_OF_SECOND);
            resolverFields = Collections.unmodifiableSet(fields);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CachedFormattedTime {
        final long timeInMilliseconds;
        final long timeWithStrippedMillis;
        final String formattedTimeString;
        volatile byte[] bytes = null;
        static final long serialVersionUID = 3232319048907730850L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CachedFormattedTime(long time, long timeWithoutMillis, String formattedString) {
            this.timeInMilliseconds = time;
            this.timeWithStrippedMillis = timeWithoutMillis;
            this.formattedTimeString = formattedString;
        }

        byte[] getBytes() {
            if (this.bytes == null) {
                byte[] ba = new byte[this.formattedTimeString.length()];
                int length = ba.length;
                for (int i = 0; i < length; ++i) {
                    ba[i] = (byte)this.formattedTimeString.charAt(i);
                }
                this.bytes = ba;
            }
            return this.bytes;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpDateFormatImpl$CachedFormattedTime", CachedFormattedTime.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpDateFormatHolder {
        private static HttpDateFormat dateFormatSvc;
        static final long serialVersionUID = -7121337060516268311L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpDateFormatHolder() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpDateFormatImpl$HttpDateFormatHolder", HttpDateFormatHolder.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
            dateFormatSvc = new HttpDateFormatImpl();
        }
    }
}

