/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.CallbackContextHelper;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.interceptors.InterceptorMetaData;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.interceptors.InvocationContextImpl;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.CallbackKind;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ConstructionCallback;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import jakarta.ejb.EJBException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public abstract class ManagedBeanOBase
extends BeanO
implements ConstructionCallback {
    private static final String CLASS_NAME = ManagedBeanOBase.class.getName();
    private static final TraceComponent tc = Tr.register(ManagedBeanOBase.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    public Object ivEjbInstance;
    public ManagedObjectContext ivEjbManagedObjectContext;
    public ManagedObject<?> ivManagedObject;
    public Object[] ivInterceptors;

    public ManagedBeanOBase(EJSContainer c, EJSHome h) {
        super(c, h);
    }

    public void setEnterpriseBean(Object bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setEnterpriseBean : " + Util.identity((Object)bean)), (Object[])new Object[0]);
        }
        this.ivEjbInstance = bean;
    }

    private void createInterceptors(InterceptorMetaData imd) {
        this.ivInterceptors = new Object[imd.ivInterceptorClasses.length];
        try {
            imd.createInterceptorInstances(this.getInjectionEngine(), this.ivInterceptors, this.ivEjbManagedObjectContext, this);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".ManagedBeanOBase"), (String)"177", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"interceptor creation failure", (Object[])new Object[]{t});
            }
            throw ExceptionUtil.EJBException("Interceptor creation failure", t);
        }
    }

    @Override
    public <T> T getInjectionTargetContextData(Class<T> type) {
        Object data;
        if (this.ivEjbManagedObjectContext != null && (data = this.ivEjbManagedObjectContext.getContextData(type)) != null) {
            return (T)data;
        }
        return super.getInjectionTargetContextData(type);
    }

    protected void injectInstance(ManagedObject<?> managedObject, Object instance, InjectionTargetContext injectionContext) throws EJBException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("injectInstance : " + Util.identity(managedObject) + ", " + injectionContext), (Object[])new Object[0]);
        }
        BeanMetaData bmd = this.home.beanMetaData;
        if (bmd.ivBeanInjectionTargets != null) {
            try {
                if (managedObject != null) {
                    managedObject.inject(bmd.ivBeanInjectionTargets, injectionContext);
                } else {
                    InjectionEngine injectionEngine = this.getInjectionEngine();
                    for (InjectionTarget injectionTarget : bmd.ivBeanInjectionTargets) {
                        injectionEngine.inject(this.ivEjbInstance, injectionTarget, injectionContext);
                    }
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ManagedObjectException)) {
                    FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".injectInstance"), (String)"151", (Object)this);
                    if (isTraceOn && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"injectInstance : Injection failure", (Object)t);
                    }
                    throw ExceptionUtil.EJBException("Injection failure", t);
                }
                Throwable cause = t.getCause();
                FFDCFilter.processException((Throwable)cause, (String)(CLASS_NAME + ".injectInstance"), (String)"157", (Object)this);
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"injectInstance : Injection failure", (Object)cause);
                }
                throw ExceptionUtil.EJBException("Injection failure", cause);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"injectInstance");
        }
    }

    protected void releaseManagedObjectContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("releaseManagedObjectContext : " + this.ivEjbManagedObjectContext), (Object[])new Object[0]);
        }
        if (this.ivEjbManagedObjectContext != null) {
            this.ivEjbManagedObjectContext.release();
        }
    }

    protected void createInterceptorsAndInstance(CallbackContextHelper contextHelper) throws InvocationTargetException {
        InterceptorMetaData imd;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createInterceptorsAndInstance : " + contextHelper), (Object[])new Object[0]);
        }
        BeanMetaData bmd = this.home.beanMetaData;
        ManagedObjectFactory<?> managedObjectFactory = bmd.ivEnterpriseBeanFactory;
        if (managedObjectFactory != null) {
            try {
                this.ivEjbManagedObjectContext = managedObjectFactory.createContext();
            }
            catch (ManagedObjectException e) {
                throw ExceptionUtil.EJBException("AroundConstruct interceptors for the " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module in the " + bmd._moduleMetaData.ivAppName + " application resulted in an exception being thrown from the ManagedObjectFactory.createContext() method", e);
            }
        }
        if ((imd = bmd.ivInterceptorMetaData) != null && !bmd.managedObjectManagesInjectionAndInterceptors) {
            InterceptorProxy[] aroundConstructProxies;
            this.createInterceptors(imd);
            if (bmd.ivCallbackKind == CallbackKind.InvocationContext && (aroundConstructProxies = imd.ivAroundConstructInterceptors) != null) {
                InvocationContextImpl<?> context = this.callAroundConstructInterceptors(aroundConstructProxies, contextHelper);
                if (this.ivEjbInstance == null) {
                    if (context.ivAroundConstructException != null) {
                        Throwable t = context.ivAroundConstructException.getCause();
                        if (t == null) {
                            t = context.ivAroundConstructException;
                        }
                        throw ExceptionUtil.EJBException("AroundConstruct interceptors for the " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module in the " + bmd._moduleMetaData.ivAppName + " application resulted in an exception being thrown from the constructor of the " + bmd.enterpriseBeanClassName + " class.", t);
                    }
                    throw new EJBException("AroundConstruct interceptors for the " + bmd.enterpriseBeanName + " bean in the " + bmd._moduleMetaData.ivName + " module in the " + bmd._moduleMetaData.ivAppName + " application did not call InvocationContext.proceed()");
                }
            }
        }
        if (this.ivEjbInstance == null) {
            this.createInstance();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInterceptorsAndInstance");
        }
    }

    private void createInstance() throws InvocationTargetException {
        ManagedObjectFactory<?> ejbManagedObjectFactory;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInstance", (Object[])new Object[0]);
        }
        if ((ejbManagedObjectFactory = this.home.beanMetaData.ivEnterpriseBeanFactory) != null) {
            this.createInstanceUsingMOF(ejbManagedObjectFactory);
        } else {
            this.createInstanceUsingConstructor();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInstance");
        }
    }

    private void createInstanceUsingMOF(ManagedObjectFactory<?> ejbManagedObjectFactory) throws InvocationTargetException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInstanceUsingMOF", (Object[])new Object[0]);
        }
        try {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"calling ManagedObjectFactory.createManagedObject(InvocationContext)", (Object[])new Object[0]);
            }
            InvocationContextImpl invCtx = this.getInvocationContext();
            this.ivManagedObject = ejbManagedObjectFactory.createManagedObject((ManagedObjectInvocationContext)invCtx);
            this.ivEjbManagedObjectContext = this.ivManagedObject.getContext();
            this.setEnterpriseBean(this.ivManagedObject.getObject());
        }
        catch (ManagedObjectException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof Exception) {
                if (cause instanceof InvocationTargetException) {
                    throw (InvocationTargetException)cause;
                }
                throw new InvocationTargetException(cause);
            }
            throw new EJBException(this.home.beanMetaData.enterpriseBeanClassName, (Exception)((Object)e));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".createInstanceUsingMOF"), (String)"321", (Object)this);
            throw new EJBException(this.home.beanMetaData.enterpriseBeanClassName, e);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInstanceUsingMOF");
        }
    }

    private void createInstanceUsingConstructor() throws InvocationTargetException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInstanceUsingConstructor", (Object[])new Object[0]);
        }
        try {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"calling Constructor.newInstance", (Object[])new Object[0]);
            }
            Constructor<?> con = this.home.beanMetaData.getEnterpriseBeanClassConstructor();
            this.setEnterpriseBean(con.newInstance(new Object[0]));
        }
        catch (InvocationTargetException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".createInstanceUsingConstructor"), (String)"360", (Object)this);
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".createInstanceUsingConstructor"), (String)"364", (Object)this);
            throw new EJBException(this.home.beanMetaData.enterpriseBeanClassName, e);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInstanceUsingConstructor");
        }
    }

    protected InvocationContextImpl getInvocationContext() {
        InvocationContextImpl invocationContext = this.createInvocationContext();
        invocationContext.initialize(this.ivEjbInstance, this.ivEjbManagedObjectContext, this.ivInterceptors);
        return invocationContext;
    }

    protected InvocationContextImpl createInvocationContext() {
        return new InvocationContextImpl();
    }

    private InvocationContextImpl<?> callAroundConstructInterceptors(InterceptorProxy[] proxies, CallbackContextHelper contextHelper) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"callAroundConstructInterceptors", (Object[])new Object[0]);
        }
        InvocationContextImpl invCtx = this.createInvocationContext();
        try {
            BeanMetaData bmd = this.home.beanMetaData;
            ManagedObjectFactory<?> managedObjectFactory = bmd.ivEnterpriseBeanFactory;
            invCtx.initializeForAroundConstruct(this.ivEjbManagedObjectContext, this.ivInterceptors, proxies);
            if (managedObjectFactory == null) {
                this.setEnterpriseBean(invCtx.aroundConstruct(this, new Object[0], null));
            } else {
                this.ivManagedObject = managedObjectFactory.createManagedObject((ManagedObjectInvocationContext)invCtx);
                this.setEnterpriseBean(this.ivManagedObject.getObject());
            }
            InvocationContextImpl invocationContextImpl = invCtx;
            return invocationContextImpl;
        }
        catch (Throwable t) {
            if (!(t instanceof ManagedObjectException)) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".callAroundConstructInterceptors"), (String)"377", (Object)this);
                if (invCtx.ivAroundConstructException != null) {
                    InvocationContextImpl managedObjectFactory = invCtx;
                    return managedObjectFactory;
                }
                throw ExceptionUtil.EJBException("AroundConstruct interceptor failure", t);
            }
            Throwable cause = t.getCause();
            FFDCFilter.processException((Throwable)cause, (String)(CLASS_NAME + ".callAroundConstructInterceptors"), (String)"386", (Object)this);
            if (invCtx.ivAroundConstructException != null) {
                InvocationContextImpl invocationContextImpl = invCtx;
                return invocationContextImpl;
            }
            throw ExceptionUtil.EJBException("AroundConstruct interceptor failure", cause);
        }
        finally {
            if (contextHelper != null) {
                contextHelper.resetContextData();
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"callAroundConstructInterceptors");
            }
        }
    }

    public Constructor<?> getConstructor() {
        return this.home.beanMetaData.getEnterpriseBeanClassConstructor();
    }

    public Object proceed(Object[] parameters, Map data) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"proceed: calling Constructor.newInstance", (Object[])new Object[0]);
        }
        return this.getConstructor().newInstance(parameters);
    }
}

