/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channelfw.base;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;

public abstract class OutboundProtocolLink
implements OutboundConnectionLink {
    private static final TraceComponent tc = Tr.register(OutboundProtocolLink.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private ConnectionLink linkOnDeviceSide = null;
    private ConnectionReadyCallback linkOnApplicationSide = null;
    protected VirtualConnection vc = null;

    @Override
    public VirtualConnection getVirtualConnection() {
        return this.vc;
    }

    @Override
    public void setDeviceLink(ConnectionLink next) {
        this.linkOnDeviceSide = next;
    }

    @Override
    public void setApplicationCallback(ConnectionReadyCallback next) {
        this.linkOnApplicationSide = next;
    }

    @Override
    public ConnectionLink getDeviceLink() {
        return this.linkOnDeviceSide;
    }

    @Override
    public ConnectionReadyCallback getApplicationCallback() {
        return this.linkOnApplicationSide;
    }

    protected void destroy() {
        this.vc = null;
        this.linkOnApplicationSide = null;
        this.linkOnDeviceSide = null;
    }

    public void init(VirtualConnection connection) {
        this.vc = connection;
    }

    @Override
    public void close(VirtualConnection conn, Exception e) {
        ConnectionLink deviceLink = this.getDeviceLink();
        if (deviceLink != null) {
            deviceLink.close(conn, e);
        }
    }

    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        ConnectionReadyCallback appside = this.getApplicationCallback();
        this.destroy();
        if (appside != null) {
            appside.destroy(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    @Override
    public void connect(Object address) throws Exception {
        ((OutboundConnectionLink)this.getDeviceLink()).connect(address);
        this.postConnectProcessing(this.getVirtualConnection());
    }

    @Override
    public void connectAsynch(Object address) {
        ((OutboundConnectionLink)this.getDeviceLink()).connectAsynch(address);
    }

    @Override
    public void ready(VirtualConnection conn) {
        this.postConnectProcessing(conn);
        this.getApplicationCallback().ready(conn);
    }

    protected abstract void postConnectProcessing(VirtualConnection var1);
}

