/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inmemory.resource;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.inmemory.resource.InMemoryResources;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationEnvironment;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class InMemoryTagFileResources
implements TagFileResources,
InMemoryResources {
    protected JspInputSource inputSource = null;
    protected File sourceFile = null;
    protected long sourceFileTimestamp = 0L;
    protected File generatedSourceFile = null;
    protected String className = null;
    protected String packageName = null;
    protected CharArrayWriter generatedSourceWriter = null;
    protected Map<String, byte[]> classBytesMap = new HashMap<String, byte[]>();
    static final long serialVersionUID = -764120792915554961L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public InMemoryTagFileResources(JspInputSource inputSource, TagFileInfo tfi, JspCoreContext context, JspTranslationEnvironment env) {
        this.inputSource = inputSource;
        if (inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            this.sourceFile = new File(context.getRealPath(inputSource.getRelativeURL()));
        } else {
            String file = inputSource.getContextURL().getFile();
            this.sourceFile = new File(file.substring(file.indexOf("file:") + 5, file.indexOf("!/")));
        }
        String tagFilePath = null;
        String tldOriginatorId = null;
        TagLibraryInfoImpl tli = (TagLibraryInfoImpl)tfi.getTagInfo().getTagLibrary();
        tldOriginatorId = tli.getOriginatorId();
        if (tfi.getPath().startsWith("/WEB-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/WEB-INF/tags") + 13);
        } else if (tfi.getPath().startsWith("/META-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/META-INF/tags") + 14);
        }
        tagFilePath = tagFilePath.substring(0, tagFilePath.lastIndexOf("/"));
        tagFilePath = tagFilePath.replace('/', File.separatorChar);
        tagFilePath = Constants.TAGFILE_PACKAGE_PATH + tldOriginatorId + tagFilePath;
        this.packageName = tagFilePath.replace(File.separatorChar, '.');
        this.className = tfi.getPath();
        this.className = this.className.substring(this.className.lastIndexOf(47) + 1);
        this.className = this.className.substring(0, this.className.indexOf(".tag"));
        this.className = env.mangleClassName(this.className);
        this.generatedSourceFile = new File(System.getProperty("java.io.tmpdir") + File.separator + tagFilePath + this.sourceFile.getName() + ".gen");
        this.generatedSourceWriter = new CharArrayWriter();
    }

    @Override
    public void syncGeneratedSource() {
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public File getGeneratedSourceFile() {
        return this.generatedSourceFile;
    }

    @Override
    public Writer getGeneratedSourceWriter() {
        return this.generatedSourceWriter;
    }

    @Override
    public char[] getGeneratedSourceChars() {
        return this.generatedSourceWriter.toCharArray();
    }

    @Override
    public JspInputSource getInputSource() {
        return this.inputSource;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean isExternallyTranslated() {
        return false;
    }

    @Override
    public boolean isOutdated() {
        return this.sourceFile.lastModified() > this.sourceFileTimestamp;
    }

    @Override
    public void sync() {
        this.sourceFileTimestamp = this.sourceFile.lastModified();
        this.generatedSourceWriter.reset();
    }

    @Override
    public void setCurrentRequest(HttpServletRequest request) {
    }

    @Override
    public byte[] getClassBytes(String className) {
        return this.classBytesMap.get(className);
    }

    @Override
    public void setClassBytes(byte[] bytes, String className) {
        this.classBytesMap.put(className, bytes);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.inmemory.resource.InMemoryTagFileResources", InMemoryTagFileResources.class, null, null);
    }
}

