/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.resource;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.util.FileSystem;
import com.ibm.ws.util.WSUtil;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class ResourceUtil {
    private static Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.resource.ResourceUtil";
    private static final boolean isOS400;
    private static final boolean isWindows;
    static final long serialVersionUID = 1736249590888169151L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ResourceUtil() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void sync(long sourceFileTimeStamp, File generatedSourceFile, File classFile, String className, boolean keepgenerated, boolean keepGeneratedclassfiles) {
        boolean rc;
        boolean delete;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "sync", new Object[]{sourceFileTimeStamp, generatedSourceFile, classFile, className, keepgenerated, keepGeneratedclassfiles});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "sync", "Synching for sourceFile ts [" + sourceFileTimeStamp + "]");
        }
        if (!keepGeneratedclassfiles) {
            delete = classFile.delete();
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (delete ? "Deleted" : "Unable to delete") + " classFile [" + classFile + "]");
            }
            File[] icList = generatedSourceFile.getParentFile().listFiles(new InnerclassFilenameFilter(className));
            for (int i = 0; i < icList.length; ++i) {
                if (!icList[i].isFile()) continue;
                boolean innerDelete = icList[i].delete();
                if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINEST)) continue;
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (innerDelete ? "Deleted" : "Unable to delete") + " inner classFile [" + icList[i] + "]");
            }
        } else {
            rc = classFile.setLastModified(sourceFileTimeStamp);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "sync", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for classFile [" + classFile + "] [" + classFile.lastModified() + "]");
            }
        }
        if (generatedSourceFile.exists()) {
            if (!keepgenerated) {
                delete = generatedSourceFile.delete();
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "sync", (delete ? "Deleted" : "Unable to delete") + " generatedSourceFile [" + generatedSourceFile + "]");
                }
            } else {
                rc = generatedSourceFile.setLastModified(sourceFileTimeStamp);
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "sync", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + generatedSourceFile + "] [" + generatedSourceFile.lastModified() + "]");
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "sync");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void sync(File sourceFile, File generatedSourceFile, File classFile, String className, boolean keepgenerated, boolean keepGeneratedclassfiles) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "sync", new Object[]{sourceFile, generatedSourceFile, classFile, className, keepgenerated, keepGeneratedclassfiles});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "sync", "Synching for sourceFile [" + sourceFile + "] ts [" + sourceFile.lastModified() + "]");
        }
        ResourceUtil.sync(sourceFile.lastModified(), generatedSourceFile, classFile, className, keepgenerated, keepGeneratedclassfiles);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "sync");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isOutdated(Entry containerEntry, File sourceFile, File generatedSourceFile, File classFile, Entry webinfClassEntry, File webinfClassFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isOutdated", new Object[]{containerEntry, sourceFile, generatedSourceFile, classFile, webinfClassEntry, webinfClassFile});
        }
        boolean bl = ResourceUtil.isOutdated(-1L, containerEntry, sourceFile, generatedSourceFile, classFile, webinfClassEntry, webinfClassFile);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isOutdated", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isOutdated(long lastModified, Entry containerEntry, File sourceFile, File generatedSourceFile, File classFile, Entry webinfClassEntry, File webinfClassFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isOutdated", new Object[]{lastModified, containerEntry, sourceFile, generatedSourceFile, classFile, webinfClassEntry, webinfClassFile});
        }
        boolean outdated = true;
        boolean hasContainer = containerEntry != null;
        boolean isContainerOrEDR = lastModified != -1L;
        long sourceLastModified = lastModified;
        if (hasContainer) {
            sourceLastModified = containerEntry.getLastModified();
            isContainerOrEDR = true;
        }
        if (sourceFile != null || isContainerOrEDR) {
            if (!isContainerOrEDR && !sourceFile.exists()) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isOutdated", "sourceFile [" + sourceFile + "] does not exist");
                }
                boolean bl = true;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting(CLASS_NAME, "isOutdated", bl);
                }
                return bl;
            }
            if (!isContainerOrEDR) {
                sourceLastModified = sourceFile.lastModified();
            }
            try {
                if (classFile.exists() && ResourceUtil.jspCaseCheck(classFile, classFile.getAbsolutePath())) {
                    if (sourceLastModified == classFile.lastModified()) {
                        outdated = false;
                    } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        if (containerEntry != null) {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "containerEntry [" + containerEntry.getPath() + "]");
                        } else if (sourceFile != null) {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile [" + sourceFile + "]");
                        } else {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "lastModified passed directly [" + lastModified + "]");
                        }
                        logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "classFile [" + classFile + "]");
                        logger.logp(Level.FINER, CLASS_NAME, "isOutdated", "sourceFile ts [" + sourceLastModified + "] differs from tempDirClassFile ts [" + classFile.lastModified() + "]. Recompile JSP.");
                    }
                } else if (webinfClassFile != null && webinfClassFile.exists() && ResourceUtil.jspCaseCheck(webinfClassFile, webinfClassFile.getAbsolutePath()) || webinfClassEntry != null) {
                    long webinfLastModified = 0L;
                    webinfLastModified = webinfClassEntry != null ? webinfClassEntry.getLastModified() : webinfClassFile.lastModified();
                    if (sourceLastModified == webinfLastModified) {
                        outdated = false;
                    } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        if (containerEntry != null) {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "containerEntry [" + containerEntry.getPath() + "]");
                        } else if (sourceFile != null) {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile [" + sourceFile + "]");
                        } else {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "lastModified passed directly [" + lastModified + "]");
                        }
                        if (webinfClassEntry != null) {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "webinfClassEntry [" + webinfClassEntry.getPath() + "]");
                        } else {
                            logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "webinfClassFile [" + webinfClassFile + "]");
                        }
                        logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", "sourceFile ts [" + sourceLastModified + "] differs from webinfClassFile ts [" + webinfLastModified + "]. Recompile JSP.");
                    }
                }
            }
            catch (IOException e) {
                boolean bl = true;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting(CLASS_NAME, "isOutdated", bl);
                }
                return bl;
            }
            if (outdated && !generatedSourceFile.getParentFile().exists()) {
                boolean rc = FileUtils.ensureDirExists((File)generatedSourceFile.getParentFile());
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + generatedSourceFile.getParentFile() + "]");
                }
            }
        } else {
            outdated = false;
        }
        boolean bl = outdated;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isOutdated", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isOutdated(File sourceFile, File generatedSourceFile, File classFile, File webinfClassFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isOutdated", new Object[]{sourceFile, generatedSourceFile, classFile, webinfClassFile});
        }
        boolean bl = ResourceUtil.isOutdated(null, sourceFile, generatedSourceFile, classFile, null, webinfClassFile);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isOutdated", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isTagFileOutdated(long sourceLastModified, File generatedSourceFile, File classFile, Entry webinfEntry, File webinfClassFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isTagFileOutdated", new Object[]{sourceLastModified, generatedSourceFile, classFile, webinfEntry, webinfClassFile});
        }
        boolean outdated = true;
        if (generatedSourceFile.exists()) {
            if (sourceLastModified == generatedSourceFile.lastModified()) {
                outdated = false;
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "generatedSourceFile [" + generatedSourceFile + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + sourceLastModified + "] differs from generatedSourceFile ts [" + generatedSourceFile.lastModified() + "]. Recompile tag file.");
            }
        } else if (classFile.exists()) {
            if (sourceLastModified == classFile.lastModified()) {
                outdated = false;
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "classFile [" + classFile + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + sourceLastModified + "] differs from tempDirClassFile ts [" + classFile.lastModified() + "]. Recompile tag file.");
            }
        } else if (webinfClassFile != null && webinfClassFile.exists()) {
            if (sourceLastModified == webinfClassFile.lastModified()) {
                outdated = false;
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "webinfClassFile [" + webinfClassFile + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + sourceLastModified + "] differs from webinfClassFile ts [" + webinfClassFile.lastModified() + "]. Recompile tag file.");
            }
        } else if (webinfEntry != null) {
            if (sourceLastModified == webinfEntry.getLastModified()) {
                outdated = false;
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", "webinfEntry [" + webinfEntry.getPath() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "isTagfileOutdated", "sourceFile ts [" + sourceLastModified + "] differs from webinfEntry ts [" + webinfEntry.getLastModified() + "]. Recompile tag file.");
            }
        }
        if (outdated && !generatedSourceFile.getParentFile().exists()) {
            boolean rc = FileUtils.ensureDirExists((File)generatedSourceFile.getParentFile());
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isTagFileOutdated", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + generatedSourceFile.getParentFile() + "]");
            }
        }
        boolean bl = outdated;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isTagFileOutdated", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isTagFileOutdated(File sourceFile, File generatedSourceFile, File classFile, File webinfClassFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isTagFileOutdated", new Object[]{sourceFile, generatedSourceFile, classFile, webinfClassFile});
        }
        if (!sourceFile.exists()) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isTagFileOutdated", "sourceFile [" + sourceFile + "] does not exist");
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isTagFileOutdated", bl);
            }
            return bl;
        }
        boolean bl = ResourceUtil.isTagFileOutdated(sourceFile.lastModified(), generatedSourceFile, classFile, null, webinfClassFile);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isTagFileOutdated", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void syncGeneratedSource(File sourceFile, File generatedSourceFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "syncGeneratedSource", new Object[]{sourceFile, generatedSourceFile});
        }
        ResourceUtil.syncGeneratedSource(sourceFile.lastModified(), generatedSourceFile);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "syncGeneratedSource");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void syncGeneratedSource(long sourceFileTime, File generatedSourceFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "syncGeneratedSource", new Object[]{sourceFileTime, generatedSourceFile});
        }
        if (generatedSourceFile.exists()) {
            boolean rc = generatedSourceFile.setLastModified(sourceFileTime);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "syncGeneratedSource", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + generatedSourceFile + "] [" + generatedSourceFile.lastModified() + "]");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "syncGeneratedSource");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void syncTagFile(File sourceFile, File generatedSourceFile, File classFile, boolean keepgenerated, boolean keepGeneratedclassfiles) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "syncTagFile", new Object[]{sourceFile, generatedSourceFile, classFile, keepgenerated, keepGeneratedclassfiles});
        }
        ResourceUtil.syncTagFile(sourceFile.lastModified(), generatedSourceFile, classFile, keepgenerated, keepGeneratedclassfiles);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "syncTagFile");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void syncTagFile(long sourceFileTime, File generatedSourceFile, File classFile, boolean keepgenerated, boolean keepGeneratedclassfiles) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "syncTagFile", new Object[]{sourceFileTime, generatedSourceFile, classFile, keepgenerated, keepGeneratedclassfiles});
        }
        if (sourceFileTime == generatedSourceFile.lastModified()) {
            boolean rc;
            boolean delete;
            if (!keepGeneratedclassfiles) {
                delete = classFile.delete();
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (delete ? "Deleted" : "Unable to delete") + " classFile [" + classFile + "]");
                }
            } else {
                rc = classFile.setLastModified(sourceFileTime);
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for classFile [" + classFile + "] [" + classFile.lastModified() + "]");
                }
            }
            if (generatedSourceFile.exists()) {
                if (!keepgenerated) {
                    delete = generatedSourceFile.delete();
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (delete ? "Deleted" : "Unable to delete") + " generatedSourceFile [" + generatedSourceFile + "]");
                    }
                } else {
                    rc = generatedSourceFile.setLastModified(sourceFileTime);
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "syncTagFile", (rc ? "Updated" : "Unable to update") + " lastModified timestamp for generatedSourceFile [" + generatedSourceFile + "] [" + generatedSourceFile.lastModified() + "]");
                    }
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "syncTagFile");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean jspCaseCheck(File file, String matchString) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "jspCaseCheck", new Object[]{file, matchString});
        }
        if (isOS400) {
            boolean bl = FileSystem.uriCaseCheck((File)file, (String)matchString);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "jspCaseCheck", bl);
            }
            return bl;
        }
        if (isWindows) {
            matchString = WSUtil.resolveURI((String)matchString);
            matchString = matchString.replace('/', File.separatorChar);
            int lastSeparator = matchString.lastIndexOf(File.separatorChar);
            matchString = matchString.substring(++lastSeparator);
            String canPath = file.getCanonicalPath();
            lastSeparator = canPath.lastIndexOf(File.separatorChar);
            if (!matchString.equals(canPath = canPath.substring(++lastSeparator))) {
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting(CLASS_NAME, "jspCaseCheck", bl);
                }
                return bl;
            }
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "jspCaseCheck", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        isOS400 = System.getProperty("os.name").toLowerCase().equals("os/400");
        isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        logger = Logger.getLogger("com.ibm.ws.jsp");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class InnerclassFilenameFilter
    implements FilenameFilter {
        String filename = null;
        static final long serialVersionUID = -7749386302531374193L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InnerclassFilenameFilter(String filename) {
            this.filename = filename;
        }

        @Override
        public boolean accept(File dir, String name) {
            String nameStart;
            int dollarIndex = name.indexOf("$");
            return dollarIndex > -1 && this.filename.equals(nameStart = name.substring(0, dollarIndex));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.resource.ResourceUtil$InnerclassFilenameFilter", InnerclassFilenameFilter.class, null, null);
        }
    }
}

