/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DataFormatHelper {
    private static ThreadLocal<String> threadids;
    private static final DateTimeFormatter localeDateFormatter;
    private static final DateTimeFormatter isoDateFormatter;

    public static String identityToString(Object o) {
        return o == null ? null : o.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o));
    }

    public static String sensitiveToString(Object o) {
        return o == null ? null : "<sensitive " + o.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o)) + '>';
    }

    public static final String formatCurrentTime() {
        return '[' + localeDateFormatter.format(ZonedDateTime.now()) + ']';
    }

    public static final String formatTime(long timestamp) {
        return localeDateFormatter.format(Instant.ofEpochMilli(timestamp));
    }

    public static final String formatTime(long timestamp, boolean useIsoDateFormat) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return useIsoDateFormat ? isoDateFormatter.format(instant) : localeDateFormatter.format(instant);
    }

    public static final String getThreadId() {
        String id = threadids.get();
        if (null == id) {
            id = DataFormatHelper.getThreadId(Thread.currentThread());
            threadids.set(id);
        }
        return id;
    }

    public static final String getThreadId(Thread thread) {
        return DataFormatHelper.padHexString((int)thread.getId(), 8);
    }

    public static final String padHexString(int num, int width) {
        String zeroPad = "0000000000000000";
        String str = Integer.toHexString(num);
        int length = str.length();
        if (length >= width) {
            return str;
        }
        StringBuilder buffer = new StringBuilder("0000000000000000".substring(0, width));
        buffer.replace(width - length, width, str);
        return buffer.toString();
    }

    public static final String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        if (t == null) {
            p.println("none");
        } else {
            DataFormatHelper.printStackTrace(p, t);
        }
        return DataFormatHelper.escape(s.toString());
    }

    private static final void printStackTrace(PrintWriter p, Throwable t) {
        t.printStackTrace(p);
        if (DataFormatHelper.printFieldStackTrace(p, t, "org.omg.CORBA.portable.UnknownException", "originalEx")) {
            return;
        }
    }

    private static final boolean printFieldStackTrace(PrintWriter p, Throwable t, String className, String fieldName) {
        for (Class<?> c = t.getClass(); c != Object.class; c = c.getSuperclass()) {
            if (!c.getName().equals(className)) continue;
            try {
                Object value = c.getField(fieldName).get(t);
                if (value instanceof Throwable && value != t.getCause()) {
                    p.append(fieldName).append(": ");
                    DataFormatHelper.printStackTrace(p, (Throwable)value);
                }
                return true;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public static final String escape(String src) {
        if (src == null) {
            return "";
        }
        StringBuilder result = null;
        int max = src.length();
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = src.charAt(i);
            if ((Character.isWhitespace(c) || !Character.isISOControl(c)) && Character.getType(c) != 0) continue;
            String hexVal = Integer.toHexString(c);
            String replacement = "\\u" + ("0000" + hexVal).substring(hexVal.length());
            if (result == null) {
                result = new StringBuilder(src);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return src;
        }
        return result.toString();
    }

    static {
        String pattern;
        threadids = new ThreadLocal();
        isoDateFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault());
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('y', 'u');
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            pattern = newPattern = newPattern.trim();
        } else {
            pattern = "dd/MMM/uuuu HH:mm:ss:SSS z";
        }
        localeDateFormatter = DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.systemDefault());
    }
}

