/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.ffdc.FFDCFilter;
import jakarta.transaction.Synchronization;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public class RegisteredSyncs {
    private static final TraceComponent tc;
    public static final int SYNC_TIER_OUTER = 0;
    public static final int SYNC_TIER_NORMAL = 1;
    public static final int SYNC_TIER_INNER = 2;
    public static final int SYNC_TIER_RRS = 3;
    protected final TransactionImpl _tran;
    static final int SYNC_ARRAY_SIZE = 4;
    protected final List[] _syncs = new ArrayList[4];
    static final int DEFAULT_DEPTH_LIMIT = 5;
    protected static final int _depthLimit;

    protected RegisteredSyncs(TransactionImpl tran) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RegisteredSyncs", (Object[])new Object[]{tran});
        }
        this._tran = tran;
    }

    public void distributeBefore() {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"distributeBefore", (Object[])new Object[]{this});
            }
            boolean setRollback = false;
            try {
                this.coreDistributeBefore();
            }
            catch (Throwable exc) {
                Tr.error((TraceComponent)tc, (String)"WTRN0074_SYNCHRONIZATION_EXCEPTION", (Object[])new Object[]{"before_completion", exc});
                this._tran.setOriginalException(exc);
                setRollback = true;
            }
            List RRSsyncs = this._syncs[3];
            if (RRSsyncs != null) {
                for (int j = 0; j < RRSsyncs.size(); ++j) {
                    Synchronization sync = (Synchronization)RRSsyncs.get(j);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("driving RRS before sync[" + j + "]"), (Object[])new Object[]{Util.identity(sync)});
                    }
                    try {
                        sync.beforeCompletion();
                        continue;
                    }
                    catch (Throwable exc) {
                        Tr.error((TraceComponent)tc, (String)"WTRN0074_SYNCHRONIZATION_EXCEPTION", (Object[])new Object[]{"before_completion", exc});
                        setRollback = true;
                    }
                }
            }
            if (setRollback && this._tran != null) {
                try {
                    this._tran.setRollbackOnly();
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)tc, (String)"setRollbackOnly raised exception", (Object[])new Object[]{ex});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeBefore");
        }
    }

    protected void coreDistributeBefore() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"coreDistributeBefore", (Object[])new Object[0]);
        }
        for (int i = 0; i < this._syncs.length - 1; ++i) {
            List syncs = this._syncs[i];
            if (syncs == null) continue;
            int depth = 0;
            int currentLast = syncs.size();
            for (int j = 0; j < syncs.size(); ++j) {
                if (j == currentLast) {
                    ++depth;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("depth limit incremented to " + depth), (Object[])new Object[0]);
                    }
                    if (depth >= _depthLimit) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"depth limit exceeded", (Object[])new Object[0]);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"coreDistributeBefore");
                        }
                        throw new IndexOutOfBoundsException("Synchronization beforeCompletion limit exceeded");
                    }
                    currentLast = syncs.size();
                }
                Synchronization sync = (Synchronization)syncs.get(j);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("driving before sync[" + j + "]"), (Object[])new Object[]{Util.identity(sync)});
                }
                sync.beforeCompletion();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"coreDistributeBefore");
        }
    }

    public void distributeAfter(int status) {
        List RRSsyncs;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"distributeAfter", (Object[])new Object[]{this, Util.printStatus(status)});
        }
        if ((RRSsyncs = this._syncs[3]) != null) {
            int RRSstatus = status == 5 ? 3 : status;
            int j = RRSsyncs.size();
            while (--j >= 0) {
                Synchronization sync = (Synchronization)RRSsyncs.get(j);
                try {
                    if (tc.isEntryEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("driving RRS after sync[" + j + "]"), (Object[])new Object[]{Util.identity(sync)});
                    }
                    sync.afterCompletion(RRSstatus);
                }
                catch (Throwable exc) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0074_SYNCHRONIZATION_EXCEPTION", (Object[])new Object[]{"after_completion", exc});
                }
            }
        }
        this.coreDistributeAfter(status);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"distributeAfter");
        }
    }

    protected void coreDistributeAfter(int status) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"coreDistributeAfter", (Object[])new Object[]{Util.printStatus(status)});
        }
        int i = this._syncs.length - 1;
        while (--i >= 0) {
            List syncs = this._syncs[i];
            if (syncs == null) continue;
            for (int j = 0; j < syncs.size(); ++j) {
                Synchronization sync = (Synchronization)syncs.get(j);
                try {
                    if (tc.isEntryEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("driving after sync[" + j + "]"), (Object[])new Object[]{Util.identity(sync)});
                    }
                    sync.afterCompletion(status);
                    continue;
                }
                catch (Throwable exc) {
                    if (this.distributeAfterException(exc)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"RuntimeException ... will be ignored", (Object[])new Object[]{exc});
                        continue;
                    }
                    Tr.error((TraceComponent)tc, (String)"WTRN0074_SYNCHRONIZATION_EXCEPTION", (Object[])new Object[]{"after_completion", exc});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"coreDistributeAfter");
        }
    }

    protected boolean distributeAfterException(Throwable t) {
        return false;
    }

    protected void add(Synchronization sync, int tier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"add", (Object[])new Object[]{sync, tier});
        }
        if (sync == null) {
            String msg = "Synchronization object was null";
            NullPointerException npe = new NullPointerException("Synchronization object was null");
            FFDCFilter.processException((Throwable)npe, (String)(this.getClass().getName() + ".add"), (String)"223", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"add", (Object)npe);
            }
            throw npe;
        }
        if (this._syncs[tier] == null) {
            this._syncs[tier] = new ArrayList();
        }
        this._syncs[tier].add(sync);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"add");
        }
    }

    static {
        Integer depthLimit;
        tc = Tr.register(RegisteredSyncs.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
        try {
            depthLimit = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.ws.Transaction.JTA.beforeCompletionDepthLimit", 5);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.RegisteredSyncs.<clinit>", (String)"132");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting depth limit", (Object[])new Object[]{e});
            }
            depthLimit = null;
        }
        int n = _depthLimit = depthLimit != null ? depthLimit : 5;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("beforeCompletion depth limit: " + _depthLimit), (Object[])new Object[0]);
        }
    }
}

