/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.websphere.logging.hpel.reader.ServerInstanceLogRecordList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;

public class MergedRepository
implements Iterable<RepositoryLogRecord> {
    private final WeakHashMap<RepositoryLogRecord, Properties> headerMap = new WeakHashMap();
    private final ServerInstanceLogRecordList[] servers;

    public Properties getHeader(RepositoryLogRecord record) {
        if (!this.headerMap.containsKey(record)) {
            throw new IllegalArgumentException("Record was not return by an iterator over this instance");
        }
        return this.headerMap.get(record);
    }

    public MergedRepository(Iterable<ServerInstanceLogRecordList> servers) {
        if (servers == null) {
            this.servers = new ServerInstanceLogRecordList[0];
        } else {
            int count = 0;
            for (ServerInstanceLogRecordList server : servers) {
                ++count;
            }
            this.servers = new ServerInstanceLogRecordList[count];
            count = 0;
            for (ServerInstanceLogRecordList server : servers) {
                this.servers[count++] = server;
            }
        }
    }

    public MergedRepository(ServerInstanceLogRecordList[] servers) {
        this.servers = servers == null ? new ServerInstanceLogRecordList[0] : servers;
    }

    @Override
    public Iterator<RepositoryLogRecord> iterator() {
        return new MergedIterator();
    }

    private static final class RepositoryLogRecordUnique
    implements RepositoryLogRecord {
        private static final long serialVersionUID = -2454049300014355679L;
        private final RepositoryLogRecord delegate;

        RepositoryLogRecordUnique(RepositoryLogRecord delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getExtension(String name) {
            return this.delegate.getExtension(name);
        }

        @Override
        public Map<String, String> getExtensions() {
            return this.delegate.getExtensions();
        }

        @Override
        public String getFormattedMessage() {
            return this.delegate.getFormattedMessage();
        }

        @Override
        public Level getLevel() {
            return this.delegate.getLevel();
        }

        @Override
        public int getLocalizable() {
            return this.delegate.getLocalizable();
        }

        @Override
        public String getLocalizedMessage() {
            return this.delegate.getLocalizedMessage();
        }

        @Override
        public String getLoggerName() {
            return this.delegate.getLoggerName();
        }

        @Override
        public String getMessageID() {
            return this.delegate.getMessageID();
        }

        @Override
        public String getMessageLocale() {
            return this.delegate.getMessageLocale();
        }

        @Override
        public long getMillis() {
            return this.delegate.getMillis();
        }

        @Override
        public Object[] getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        public byte[] getRawData() {
            return this.delegate.getRawData();
        }

        @Override
        public String getRawMessage() {
            return this.delegate.getRawMessage();
        }

        @Override
        public RepositoryPointer getRepositoryPointer() {
            return this.delegate.getRepositoryPointer();
        }

        @Override
        public String getResourceBundleName() {
            return this.delegate.getResourceBundleName();
        }

        @Override
        public long getSequence() {
            return this.delegate.getSequence();
        }

        @Override
        public String getSourceClassName() {
            return this.delegate.getSourceClassName();
        }

        @Override
        public String getSourceMethodName() {
            return this.delegate.getSourceMethodName();
        }

        @Override
        public String getStackTrace() {
            return this.delegate.getStackTrace();
        }

        @Override
        public int getThreadID() {
            return this.delegate.getThreadID();
        }
    }

    private class MergedIterator
    implements Iterator<RepositoryLogRecord> {
        private final IteratorState[] list;
        private int count;

        MergedIterator() {
            this.list = new IteratorState[MergedRepository.this.servers.length];
            this.count = 0;
            for (int i = 0; i < MergedRepository.this.servers.length; ++i) {
                this.list[i] = new IteratorState(MergedRepository.this.servers[i]);
                if (this.list[i].next == null) continue;
                ++this.count;
            }
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public RepositoryLogRecord next() {
            RepositoryLogRecord next = null;
            if (this.count > 0) {
                int index = 0;
                for (int i = 1; i < this.list.length; ++i) {
                    if (this.list[index].next != null && (this.list[i].next == null || this.list[index].next.getMillis() <= this.list[i].next.getMillis())) continue;
                    index = i;
                }
                next = this.list[index].next;
                this.list[index].next = this.list[index].it.next();
                if (this.list[index].next == null) {
                    --this.count;
                }
                if (next != null) {
                    next = new RepositoryLogRecordUnique(next);
                    MergedRepository.this.headerMap.put(next, MergedRepository.this.servers[index].getHeader());
                }
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method is not applicable to this class");
        }
    }

    private static class IteratorState {
        final Iterator<RepositoryLogRecord> it;
        RepositoryLogRecord next;

        IteratorState(Iterable<RepositoryLogRecord> list) {
            this.it = list.iterator();
            this.next = this.it.next();
        }
    }
}

