/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.rpc;

import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;

public final class RpcSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final RpcAttributesGetter<REQUEST> getter;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(RpcAttributesGetter<REQUEST> attributesExtractor) {
        return new RpcSpanNameExtractor<REQUEST>(attributesExtractor);
    }

    private RpcSpanNameExtractor(RpcAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public String extract(REQUEST request) {
        String service = this.getter.service(request);
        String method = this.getter.method(request);
        if (service == null || method == null) {
            return "RPC request";
        }
        return service + '/' + method;
    }
}

