/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.internal.DenyReply;
import com.ibm.ws.webcontainer.security.internal.RedirectReply;
import com.ibm.ws.webcontainer.security.internal.SRTServletRequestUtils;
import com.ibm.ws.webcontainer.security.internal.WebReply;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HTTPSRedirectHandler {
    private static final TraceComponent tc = Tr.register(HTTPSRedirectHandler.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = -3103286160096161340L;

    public boolean shouldRedirectToHttps(WebRequest webRequest) {
        return webRequest.isSSLRequired() && !webRequest.getHttpServletRequest().isSecure();
    }

    public WebReply getHTTPSRedirectWebReply(HttpServletRequest req) {
        Integer httpsPort = (Integer)SRTServletRequestUtils.getPrivateAttribute(req, "SecurityRedirectPort");
        if (httpsPort == null) {
            Tr.error((TraceComponent)tc, (String)"SSL_PORT_IS_NULL", (Object[])new Object[0]);
            return new DenyReply("Resource must be accessed with a secure connection try again using an HTTPS connection.");
        }
        URL originalURL = null;
        String urlString = null;
        try {
            urlString = req.getRequestURL().toString();
            originalURL = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.webcontainer.security.internal.HTTPSRedirectHandler", (String)"60", (Object)this, (Object[])new Object[]{req});
            Tr.error((TraceComponent)tc, (String)"SSL_REQ_URL_MALFORMED_EXCEPTION", (Object[])new Object[]{urlString});
            return new DenyReply("Resource must be accessed with a secure connection try again using an HTTPS connection.");
        }
        String queryString = req.getQueryString();
        try {
            URL redirectURL = new URL("https", originalURL.getHost(), httpsPort, originalURL.getPath() + (queryString == null ? "" : "?" + queryString));
            return new RedirectReply(redirectURL.toString(), null);
        }
        catch (MalformedURLException redirectURL) {
            FFDCFilter.processException((Throwable)redirectURL, (String)"com.ibm.ws.webcontainer.security.internal.HTTPSRedirectHandler", (String)"75", (Object)this, (Object[])new Object[]{req});
            Tr.error((TraceComponent)tc, (String)"SSL_REQ_URL_MALFORMED_EXCEPTION", (Object[])new Object[]{"https" + originalURL.getHost() + httpsPort + originalURL.getPath() + (queryString == null ? "" : "?" + queryString)});
            return new DenyReply("Resource must be accessed with a secure connection try again using an HTTPS connection.");
        }
    }
}

