/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility;

import com.ibm.ws.install.featureUtility.cli.FeatureAction;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.feature.internal.cmdline.ArgumentsImpl;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import java.util.List;

public class FeatureUtilityExecutor {
    public static void main(String[] argsArray) {
        ExitCode rc;
        ArgumentsImpl args = new ArgumentsImpl(argsArray);
        String actionName = args.getAction();
        if (actionName == null) {
            rc = FeatureAction.help.handleTask((Arguments)args);
        } else {
            try {
                FeatureAction action;
                List invalid;
                if (FeatureUtilityExecutor.looksLikeHelp(actionName)) {
                    actionName = FeatureAction.help.toString();
                }
                if (!(invalid = args.findInvalidOptions((action = FeatureAction.getEnum(actionName)).getCommandOptions())).isEmpty()) {
                    System.out.println(NLS.getMessage((String)"unknown.options", (Object[])new Object[]{action, invalid}));
                    FeatureAction.help.handleTask((Arguments)new ArgumentsImpl(new String[]{"help", action.toString()}));
                    rc = ReturnCode.BAD_ARGUMENT;
                } else if (action != FeatureAction.help && action.numPositionalArgs() >= 0 && args.getPositionalArguments().size() != action.numPositionalArgs()) {
                    System.out.println(NLS.getMessage((String)"missing.args", (Object[])new Object[]{action, action.numPositionalArgs(), args.getPositionalArguments().size()}));
                    rc = ReturnCode.BAD_ARGUMENT;
                } else {
                    rc = action.handleTask((Arguments)args);
                }
            }
            catch (IllegalArgumentException iae) {
                rc = FeatureAction.help.handleTask((Arguments)new ArgumentsImpl(new String[]{FeatureAction.help.toString(), actionName}));
            }
        }
        System.exit(rc.getValue());
    }

    public static ReturnCode returnCode(int rc) {
        for (ReturnCode r : ReturnCode.values()) {
            if (r.getValue() != rc) continue;
            return r;
        }
        return ReturnCode.RUNTIME_EXCEPTION;
    }

    private static boolean looksLikeHelp(String taskname) {
        int start;
        if (taskname == null) {
            return false;
        }
        int len = taskname.length();
        for (start = 0; start < len && !Character.isLetter(taskname.charAt(start)); ++start) {
        }
        return FeatureAction.help.toString().equalsIgnoreCase(taskname.substring(start).toLowerCase());
    }
}

