/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import jakarta.resource.ResourceException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Collections;
import java.util.Properties;

public class MicrosoftSQLServerHelper
extends DatabaseHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(MicrosoftSQLServerHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private transient com.ibm.ejs.ras.TraceComponent jdbcTC = Tr.register((String)"com.ibm.ws.sqlserver.logwriter", (String)"WAS.database", null);
    private Method methodSetResponseBuffering;
    private static final String RESPONSE_BUFFERING = "responseBuffering";
    private String responseBuffering;

    MicrosoftSQLServerHelper(WSManagedConnectionFactoryImpl mcf) {
        super(mcf);
        this.dataStoreHelperClassName = "com.ibm.websphere.rsadapter.MicrosoftSQLServerDataStoreHelper";
        mcf.defaultIsolationLevel = 4;
        mcf.supportsGetTypeMap = false;
        mcf.supportsIsReadOnly = false;
        Properties props = mcf.dsConfig.get().vendorProps;
        String string = this.responseBuffering = props.containsKey(RESPONSE_BUFFERING) ? props.getProperty(RESPONSE_BUFFERING) : "adaptive";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("Default responseBuffering = " + this.responseBuffering), (Object[])new Object[0]);
        }
        Collections.addAll(this.staleConCodes, 230, 6001, 6002, 6005, 6006);
    }

    @Override
    public int branchCouplingSupported(int couplingType) {
        if (couplingType == 1) {
            return 32768;
        }
        return 0;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        if (this.dataStoreHelper != null) {
            this.doStatementCleanupLegacy(stmt);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object[])new Object[]{AdapterUtil.toString(stmt)});
        }
        stmt.setCursorName(null);
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(Integer.MAX_VALUE);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
        stmt = (PreparedStatement)WSJdbcTracer.getImpl(stmt);
        if (this.responseBuffering != null && this.methodSetResponseBuffering == null) {
            try {
                this.methodSetResponseBuffering = stmt.getClass().getMethod("setResponseBuffering", String.class);
            }
            catch (NoSuchMethodException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"ResponseBuffering not supported.", (Object[])new Object[0]);
                }
                this.responseBuffering = null;
            }
        }
        if (this.responseBuffering != null) {
            try {
                this.methodSetResponseBuffering.invoke((Object)stmt, this.responseBuffering);
            }
            catch (InvocationTargetException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object)x.getCause());
                }
                throw (SQLException)x.getCause();
            }
            catch (IllegalAccessException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"ResponseBuffering not supported.", (Object[])new Object[0]);
                }
                this.responseBuffering = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup");
        }
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"getPrintWriter", (Object[])new Object[0]);
        }
        if (this.genPw == null) {
            this.genPw = new PrintWriter((Writer)new TraceWriter(this.jdbcTC), true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPrintWriter", (Object)this.genPw);
        }
        return this.genPw;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return this.jdbcTC;
    }

    @Override
    boolean isAuthException(SQLException x) {
        int ec = x.getErrorCode();
        return x instanceof SQLInvalidAuthorizationSpecException || x.getSQLState() != null && x.getSQLState().startsWith("28") || ec >= 18450 && ec <= 18452 || ec >= 18456 && ec <= 18461 || ec == 18470 || ec == 18483 || ec >= 18485 && ec <= 18488;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return TraceComponent.isAnyTracingEnabled() && this.jdbcTC.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !this.jdbcTC.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    @Override
    public boolean supportsSubjectDoAsForKerberos() {
        return this.driverMajorVersion >= 4 || this.driverMajorVersion == 0;
    }
}

