/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.telemetry.internal.cdi.BaggageProxy;
import io.openliberty.microprofile.telemetry.internal.cdi.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.cdi.SpanProxy;
import io.openliberty.microprofile.telemetry.internal.helper.AgentDetection;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenTelemetryProducer {
    private static final TraceComponent tc = Tr.register(OpenTelemetryProducer.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.common.resources.MPTelemetry");
    private static final String INSTRUMENTATION_NAME = "io.openliberty.microprofile.telemetry";
    private static final String ENV_DISABLE_PROPERTY = "OTEL_SDK_DISABLED";
    private static final String CONFIG_DISABLE_PROPERTY = "otel.sdk.disabled";
    private static final String ENV_METRICS_EXPORTER_PROPERTY = "OTEL_METRICS_EXPORTER";
    private static final String CONFIG_METRICS_EXPORTER_PROPERTY = "otel.metrics.exporter";
    private static final String ENV_LOGS_EXPORTER_PROPERTY = "OTEL_LOGS_EXPORTER";
    private static final String CONFIG_LOGS_EXPORTER_PROPERTY = "otel.logs.exporter";
    private static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    @Inject
    private Config config;
    static final long serialVersionUID = -2395922042667310569L;

    @ApplicationScoped
    @Produces
    public OpenTelemetryInfo getOpenTelemetryInfo() {
        OpenTelemetry openTelemetry;
        if (AgentDetection.isAgentActive()) {
            return new OpenTelemetryInfo(true, GlobalOpenTelemetry.get());
        }
        HashMap<String, String> telemetryProperties = this.getTelemetryProperties();
        if (!this.checkDisabled(telemetryProperties) && (openTelemetry = AccessController.doPrivileged(() -> AutoConfiguredOpenTelemetrySdk.builder().addPropertiesCustomizer(x -> telemetryProperties).addResourceCustomizer(this::customizeResource).setServiceClassLoader(Thread.currentThread().getContextClassLoader()).setResultAsGlobal(false).registerShutdownHook(false).build().getOpenTelemetrySdk())) != null) {
            return new OpenTelemetryInfo(true, openTelemetry);
        }
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        String applicationName = cData.getJ2EEName().getApplication();
        Tr.info((TraceComponent)tc, (String)"CWMOT5100.tracing.is.disabled", (Object[])new Object[]{applicationName});
        return new OpenTelemetryInfo(false, OpenTelemetry.noop());
    }

    private String getServiceName(ConfigProperties c) {
        String appName = c.getString(SERVICE_NAME_PROPERTY);
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (appName == null && cmd != null) {
            appName = cmd.getModuleMetaData().getApplicationMetaData().getName();
        }
        return appName;
    }

    private Resource customizeResource(Resource resource, ConfigProperties c) {
        ResourceBuilder builder = resource.toBuilder();
        builder.put(ResourceAttributes.SERVICE_NAME, (Object)this.getServiceName(c));
        return builder.build();
    }

    public void disposeOpenTelemetry(@Disposes OpenTelemetry openTelemetry) {
        if (AgentDetection.isAgentActive()) {
            return;
        }
        if (openTelemetry instanceof OpenTelemetrySdk) {
            SdkLoggerProvider loggerProvider;
            SdkMeterProvider meterProvider;
            OpenTelemetrySdk sdk = (OpenTelemetrySdk)openTelemetry;
            ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
            SdkTracerProvider tracerProvider = sdk.getSdkTracerProvider();
            if (tracerProvider != null) {
                results.add(tracerProvider.shutdown());
            }
            if ((meterProvider = sdk.getSdkMeterProvider()) != null) {
                results.add(meterProvider.shutdown());
            }
            if ((loggerProvider = sdk.getSdkLoggerProvider()) != null) {
                results.add(loggerProvider.shutdown());
            }
            CompletableResultCode.ofAll(results).join(10L, TimeUnit.SECONDS);
        }
    }

    private boolean checkDisabled(Map<String, String> oTelConfigs) {
        if (oTelConfigs.get(ENV_DISABLE_PROPERTY) != null) {
            return Boolean.valueOf(oTelConfigs.get(ENV_DISABLE_PROPERTY));
        }
        if (oTelConfigs.get(CONFIG_DISABLE_PROPERTY) != null) {
            return Boolean.valueOf(oTelConfigs.get(CONFIG_DISABLE_PROPERTY));
        }
        return true;
    }

    private HashMap<String, String> getTelemetryProperties() {
        HashMap<String, String> telemetryProperties = new HashMap<String, String>();
        for (String propertyName : this.config.getPropertyNames()) {
            if (!propertyName.startsWith("otel.")) continue;
            this.config.getOptionalValue(propertyName, String.class).ifPresent(value -> telemetryProperties.put(propertyName, (String)value));
        }
        telemetryProperties.put(CONFIG_METRICS_EXPORTER_PROPERTY, "none");
        telemetryProperties.put(CONFIG_LOGS_EXPORTER_PROPERTY, "none");
        telemetryProperties.put(ENV_METRICS_EXPORTER_PROPERTY, "none");
        telemetryProperties.put(ENV_LOGS_EXPORTER_PROPERTY, "none");
        return telemetryProperties;
    }

    @Produces
    public Tracer getTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer(INSTRUMENTATION_NAME);
    }

    @Produces
    @ApplicationScoped
    public Span getSpan() {
        return new SpanProxy();
    }

    @Produces
    @ApplicationScoped
    public Baggage getBaggage() {
        return new BaggageProxy();
    }

    @ApplicationScoped
    @Produces
    public OpenTelemetry getOpenTelemetry(OpenTelemetryInfo openTelemetryInfo) {
        return openTelemetryInfo.getOpenTelemetry();
    }
}

