/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.cdi.MethodRequest;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.util.SpanNames;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.AccessController;

@WithSpan
@Interceptor
@Priority(value=100)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WithSpanInterceptor {
    private static final TraceComponent tc = Tr.register(WithSpanInterceptor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.common.resources.MPTelemetry");
    private final String instrumentationName = "io.openliberty.microprofile.telemetry";
    private final Instrumenter<MethodRequest, Void> instrumenter;
    static final long serialVersionUID = 2723964912613403401L;

    public WithSpanInterceptor() {
        this.instrumenter = null;
    }

    @Inject
    public WithSpanInterceptor(OpenTelemetry openTelemetry) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.openliberty.microprofile.telemetry", (SpanNameExtractor)new MethodRequestSpanNameExtractor());
        MethodSpanAttributesExtractor attributesExtractor = MethodSpanAttributesExtractor.newInstance(MethodRequest::getMethod, (ParameterAttributeNamesExtractor)new WithSpanParameterAttributeNamesExtractor(), MethodRequest::getArgs);
        this.instrumenter = builder.addAttributesExtractor((AttributesExtractor)attributesExtractor).buildInstrumenter(methodRequest -> WithSpanInterceptor.spanKindFromMethod(methodRequest.getMethod()));
    }

    private static SpanKind spanKindFromMethod(Method method) {
        WithSpan annotation = method.getDeclaredAnnotation(WithSpan.class);
        if (annotation == null) {
            return SpanKind.INTERNAL;
        }
        return annotation.kind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object span(InvocationContext invocationContext) throws Exception {
        MethodRequest methodRequest = new MethodRequest(invocationContext.getMethod(), invocationContext.getParameters());
        Context parentContext = Context.current();
        Context spanContext = null;
        Scope scope = null;
        boolean shouldStart = this.instrumenter.shouldStart(parentContext, (Object)methodRequest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Method " + invocationContext.getMethod().toString() + " Should start: " + shouldStart), (Object[])new Object[0]);
        }
        if (shouldStart) {
            spanContext = this.instrumenter.start(parentContext, (Object)methodRequest);
            scope = spanContext.makeCurrent();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("spanContext " + spanContext.toString() + " has started and is now the current context"), (Object[])new Object[0]);
            }
        }
        try {
            Object result = invocationContext.proceed();
            if (shouldStart) {
                this.instrumenter.end(spanContext, (Object)methodRequest, null, null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("spanContext " + spanContext.toString() + " has ended"), (Object[])new Object[0]);
                }
            }
            Object object = result;
            return object;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class MethodRequestSpanNameExtractor
    implements SpanNameExtractor<MethodRequest> {
        static final long serialVersionUID = -2862093003405790995L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MethodRequestSpanNameExtractor() {
        }

        public String extract(MethodRequest methodRequest) {
            return AccessController.doPrivileged(() -> {
                WithSpan annotation = methodRequest.getMethod().getDeclaredAnnotation(WithSpan.class);
                String spanName = annotation.value();
                if (spanName.isEmpty()) {
                    spanName = SpanNames.fromMethod((Method)methodRequest.getMethod());
                }
                return spanName;
            });
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.cdi.WithSpanInterceptor$MethodRequestSpanNameExtractor", MethodRequestSpanNameExtractor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.common.resources.MPTelemetry");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class WithSpanParameterAttributeNamesExtractor
    implements ParameterAttributeNamesExtractor {
        static final long serialVersionUID = -2792438100570492187L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private WithSpanParameterAttributeNamesExtractor() {
        }

        private static String attributeName(Parameter parameter) {
            SpanAttribute spanAttribute = parameter.getDeclaredAnnotation(SpanAttribute.class);
            if (spanAttribute == null) {
                return null;
            }
            String value = spanAttribute.value();
            if (!value.isEmpty()) {
                return value;
            }
            if (parameter.isNamePresent()) {
                return parameter.getName();
            }
            return null;
        }

        public String[] extract(Method method, Parameter[] parameters) {
            String[] attributeNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                attributeNames[i] = WithSpanParameterAttributeNamesExtractor.attributeName(parameters[i]);
            }
            return attributeNames;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.cdi.WithSpanInterceptor$WithSpanParameterAttributeNamesExtractor", WithSpanParameterAttributeNamesExtractor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.common.resources.MPTelemetry");
        }
    }
}

