/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitImpl;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.PeerLostLogOwnershipException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import java.util.ArrayList;

public class SQLRecoverableUnitSectionImpl
implements RecoverableUnitSection {
    private static final TraceComponent tc = Tr.register(SQLRecoverableUnitSectionImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static final int INITIAL_DATA_CAPACITY = 10;
    private int _identity = 0;
    private ArrayList<byte[]> _unwrittenData = null;
    private ArrayList<byte[]> _writtenData = null;
    private boolean _singleData = false;
    private boolean _singleDataUpdated;
    private byte[] _lastDataItem = null;
    private long _recoverableUnitIdentity = 0L;
    private SQLMultiScopeRecoveryLog _recLog = null;
    private SQLRecoverableUnitImpl _recUnit = null;
    private String _serverName = null;
    private String _clientName = null;
    private int _clientVersion = 0;
    private String _logName = null;
    private int _logIdentifier = 0;
    private final String _traceId;

    SQLRecoverableUnitSectionImpl(SQLMultiScopeRecoveryLog recLog, SQLRecoverableUnitImpl recUnit, long recoverableUnitIdentity, int identity, boolean singleData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLRecoverableUnitSectionImpl", (Object[])new Object[]{recLog, recUnit, recoverableUnitIdentity, identity, singleData});
        }
        this._recLog = recLog;
        this._recoverableUnitIdentity = recoverableUnitIdentity;
        this._identity = identity;
        this._singleData = singleData;
        this._recUnit = recUnit;
        this._unwrittenData = new ArrayList(10);
        this._writtenData = new ArrayList(10);
        this._serverName = recLog.serverName();
        this._clientName = recLog.clientName();
        this._clientVersion = recLog.clientVersion();
        this._logName = recLog.logName();
        this._logIdentifier = recLog.logIdentifier();
        this._traceId = "SQLRecoverableUnitSectionImpl:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLRecoverableUnitSectionImpl", (Object)this);
        }
    }

    public void addData(byte[] data) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addData", (Object[])new Object[]{RLSUtils.toHexString((byte[])data, (int)32), this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addData", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        if (this._singleData) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Section can hold only a single data item.", (Object[])new Object[0]);
            }
            if (this._writtenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is existing WRITTEN data.", (Object[])new Object[0]);
                }
                this._writtenData.clear();
                this._unwrittenData.add(0, data);
                this._singleDataUpdated = true;
                this._lastDataItem = data;
            } else if (this._unwrittenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is existing UNWRITTEN data.", (Object[])new Object[0]);
                }
                this._unwrittenData.clear();
                this._unwrittenData.add(0, data);
                this._lastDataItem = data;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is no existing data.", (Object[])new Object[0]);
                }
                this._unwrittenData.add(0, data);
                this._lastDataItem = data;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Section holds multiple data items", (Object[])new Object[0]);
            }
            this._unwrittenData.add(data);
            this._lastDataItem = data;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addData");
        }
    }

    public void addData(int index, byte[] data) throws InternalLogException {
        int currentSize;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addData", (Object[])new Object[]{index, RLSUtils.toHexString((byte[])data, (int)32), this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addData", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        if (index > 0) {
            --index;
        }
        if (index == (currentSize = this._writtenData.size())) {
            this._writtenData.add(data);
        } else if (index < currentSize) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("NMTEST: Replacing item (expect trace 'null') at index: " + index), (Object[])new Object[]{this._writtenData.get(index)});
            }
            this._writtenData.set(index, data);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("NMTEST: Adding null elements: " + (index - currentSize)), (Object[])new Object[0]);
            }
            while (index-- > currentSize) {
                this._writtenData.add(null);
            }
            this._writtenData.add(data);
        }
        this._lastDataItem = this._writtenData.get(this._writtenData.size() - 1);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addData");
        }
    }

    public void write() throws InternalLogException {
        this.write(true);
    }

    void write(boolean throttle) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object[])new Object[]{throttle, this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        while (this._unwrittenData.size() > 0) {
            byte[] data = this._unwrittenData.get(0);
            int index = this._writtenData.size();
            try {
                if (this._singleData) {
                    if (this._singleDataUpdated) {
                        this._recLog.updateRUSection(this._recoverableUnitIdentity, this._identity, data, throttle);
                    } else {
                        this._recLog.writeRUSection(this._recoverableUnitIdentity, this._identity, index, data, throttle);
                    }
                } else {
                    this._recLog.writeRUSection(this._recoverableUnitIdentity, this._identity, 1 + index, data, throttle);
                }
            }
            catch (PeerLostLogOwnershipException ple) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"write", (Object)((Object)ple));
                }
                throw ple;
            }
            catch (InternalLogException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLRecoverableUnitSectionImpl.write", (String)"437", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"write", (Object)((Object)exc));
                }
                throw exc;
            }
            this._unwrittenData.remove(0);
            this._writtenData.add(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"force", (Object[])new Object[]{this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        try {
            this._recUnit.forceSections();
        }
        catch (PeerLostLogOwnershipException ple) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)((Object)ple));
            }
            throw ple;
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLRecoverableUnitSectionImpl.force", (String)"509", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)((Object)exc));
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"force");
        }
    }

    public LogCursor data() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"data", (Object[])new Object[]{this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"data", (Object)this);
            }
            throw this._recLog.getFailureException();
        }
        if (tc.isEventEnabled()) {
            int writtenDataBlocks = 0;
            int unwrittenDataBlocks = 0;
            if (this._writtenData != null) {
                writtenDataBlocks = this._writtenData.size();
            }
            if (this._unwrittenData != null) {
                unwrittenDataBlocks = this._unwrittenData.size();
            }
            Tr.event((TraceComponent)tc, (String)("#writtenDataBlocks = " + writtenDataBlocks + " #unwrittenDataBlocks = " + unwrittenDataBlocks), (Object[])new Object[0]);
        }
        LogCursorImpl cursor = null;
        cursor = this._singleData ? (this._writtenData.size() > 0 ? new LogCursorImpl(null, (Object)this._writtenData.get(0)) : new LogCursorImpl(null, (Object)this._unwrittenData.get(0))) : new LogCursorImpl(null, this._writtenData, this._unwrittenData, false, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"data", (Object)cursor.initialSize());
        }
        return cursor;
    }

    @Trivial
    public int identity() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"identity {0} {1}", (Object[])new Object[]{this, this._identity});
        }
        return this._identity;
    }

    public byte[] lastData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lastData", (Object[])new Object[]{this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lastData", (Object)RLSUtils.toHexString((byte[])this._lastDataItem, (int)32));
        }
        return this._lastDataItem;
    }

    public String toString() {
        return this._traceId;
    }
}

