/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.ear.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.application.lifecycle.ApplicationStartBarrier;
import java.util.concurrent.Future;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationHandler.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "type:String=ear"})
public class EARApplicationHandlerImpl
implements ApplicationHandler<DeployedAppInfo> {
    private static final TraceComponent _tc = Tr.register(EARApplicationHandlerImpl.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.ear.internal.EARApplicationHandlerImpl");
    private FutureMonitor _monitor;
    private DeployedAppInfoFactory deployedAppFactory;
    private boolean isClient = false;
    static final long serialVersionUID = 7352189122923858117L;

    /*
     * WARNING - void declaration
     */
    public ApplicationMonitoringInformation setUpApplicationMonitoring(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        EARDeployedAppInfo deployedApp;
        try {
            deployedApp = (EARDeployedAppInfo)this.deployedAppFactory.createDeployedAppInfo(applicationInformation);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Created application [ " + deployedApp.getName() + " ] : Path [ " + deployedApp.getContainer().getPath() + " ]"), (Object[])new Object[0]);
            }
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARApplicationHandlerImpl", (String)"58", (Object)this, (Object[])new Object[]{applicationInformation});
            throw new IllegalStateException((Throwable)e);
        }
        return deployedApp.createApplicationMonitoringInformation();
    }

    public Future<Boolean> install(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        Future result = this._monitor.createFuture(Boolean.class);
        String name = applicationInformation.getName();
        EARDeployedAppInfo deployedApp = (EARDeployedAppInfo)((Object)applicationInformation.getHandlerInfo());
        if (!deployedApp.hasModules()) {
            Tr.error((TraceComponent)_tc, (String)"error.no.modules", (Object[])new Object[]{name});
            this._monitor.setResult(result, (Object)false);
            return result;
        }
        if (!deployedApp.deployApp(result)) {
            if (this.isClient) {
                Tr.error((TraceComponent)_tc, (String)"error.client.not.installed", (Object[])new Object[]{name});
            } else {
                Tr.error((TraceComponent)_tc, (String)"error.not.installed", (Object[])new Object[]{name});
            }
            this._monitor.setResult(result, (Object)false);
            return result;
        }
        return result;
    }

    public Future<Boolean> uninstall(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        EARDeployedAppInfo deployedApp = (EARDeployedAppInfo)((Object)applicationInformation.getHandlerInfo());
        if (deployedApp == null) {
            return this._monitor.createFutureWithResult((Object)false);
        }
        boolean success = deployedApp.uninstallApp();
        return this._monitor.createFutureWithResult((Object)success);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setFutureMonitor(FutureMonitor fm) {
        this._monitor = fm;
    }

    protected void unsetFutureMonitor(FutureMonitor fm) {
    }

    @Reference(name="deployedAppFactory", target="(type=ear)")
    protected void setDeployedAppFactory(DeployedAppInfoFactory deployedAppFactory) {
        this.deployedAppFactory = deployedAppFactory;
    }

    protected void unsetDeployedAppFactory(DeployedAppInfoFactory deployedAppFactory) {
    }

    @Activate
    protected void activate(ComponentContext context) {
        if (context.getBundleContext().getProperty("wlp.process.type").equals("client")) {
            this.isClient = true;
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    @Reference
    private void setApplicationStartBarrier(ApplicationStartBarrier applicationStartBarrier) {
    }
}

