/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.config;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.client.OidcProviderMetadata;
import io.openliberty.security.oidcclientcore.config.OidcMetadataService;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={MetadataUtils.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class MetadataUtils {
    public static final TraceComponent tc = Tr.register(MetadataUtils.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private static volatile OidcMetadataService oidcMetadataService;
    static final long serialVersionUID = 235148710089838218L;

    @Reference(name="oidcMetadataService", policy=ReferencePolicy.DYNAMIC)
    public void setOidcMetadataService(OidcMetadataService oidcMetadataServiceRef) {
        oidcMetadataService = oidcMetadataServiceRef;
    }

    public void unsetOidcMetadataService(OidcMetadataService oidcMetadataServiceRef) {
        oidcMetadataService = null;
    }

    public static <T> T getValueFromProviderOrDiscoveryMetadata(OidcClientConfig oidcClientConfig, Function<OidcProviderMetadata, T> metadataMethodToCall, String discoveryMetadataKey) throws OidcDiscoveryException, OidcClientConfigurationException {
        T value = MetadataUtils.getValueFromProviderMetadata(oidcClientConfig, metadataMethodToCall, discoveryMetadataKey);
        if (value != null) {
            return value;
        }
        return MetadataUtils.getValueFromDiscoveryMetadata(oidcClientConfig, discoveryMetadataKey);
    }

    public static <T> T getValueFromProviderMetadata(OidcClientConfig oidcClientConfig, Function<OidcProviderMetadata, T> metadataMethodToCall, String discoveryMetadataKey) {
        T value;
        OidcProviderMetadata providerMetadata = oidcClientConfig.getProviderMetadata();
        if (providerMetadata != null && (value = metadataMethodToCall.apply(providerMetadata)) != null && !value.toString().isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(discoveryMetadataKey + " found in the provider metadata: [" + value + "]"), (Object[])new Object[0]);
            }
            return value;
        }
        return null;
    }

    public static JSONObject getProviderDiscoveryMetaData(OidcClientConfig oidcClientConfig) throws OidcClientConfigurationException, OidcDiscoveryException {
        return oidcMetadataService.getProviderDiscoveryMetadata(oidcClientConfig);
    }

    public static <T> T getValueFromDiscoveryMetadata(OidcClientConfig oidcClientConfig, String key) throws OidcDiscoveryException, OidcClientConfigurationException {
        Object value = null;
        JSONObject providerDiscoveryMetadata = oidcMetadataService.getProviderDiscoveryMetadata(oidcClientConfig);
        if (providerDiscoveryMetadata != null) {
            value = providerDiscoveryMetadata.get((Object)key);
        }
        if (value == null || value.toString().isEmpty()) {
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"DISCOVERY_METADATA_MISSING_VALUE", (Object[])new Object[]{key});
            throw new OidcDiscoveryException(oidcClientConfig.getClientId(), oidcClientConfig.getProviderURI(), nlsMessage);
        }
        return (T)value;
    }

    public static String[] getStringArrayValueFromProviderOrDiscoveryMetadata(OidcClientConfig oidcClientConfig, Function<OidcProviderMetadata, String[]> metadataMethodToCall, String discoveryMetadataKey) throws OidcDiscoveryException, OidcClientConfigurationException {
        String[] value;
        if (metadataMethodToCall != null && (value = MetadataUtils.getValueFromProviderMetadata(oidcClientConfig, metadataMethodToCall, discoveryMetadataKey)) != null && value.length > 0) {
            return value;
        }
        return MetadataUtils.getAndConvertJsonArrayFromDiscoveryData(oidcClientConfig, discoveryMetadataKey);
    }

    static String[] getAndConvertJsonArrayFromDiscoveryData(OidcClientConfig oidcClientConfig, String discoveryMetadataKey) throws OidcDiscoveryException, OidcClientConfigurationException {
        JSONArray valueFromDiscovery = (JSONArray)MetadataUtils.getValueFromDiscoveryMetadata(oidcClientConfig, discoveryMetadataKey);
        String[] values = new String[valueFromDiscovery.size()];
        for (int i = 0; i < valueFromDiscovery.size(); ++i) {
            values[i] = (String)valueFromDiscovery.get(i);
        }
        return values;
    }

    public static String getAuthorizationEndpoint(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getValueFromProviderOrDiscoveryMetadata(oidcClientConfig, metadata -> metadata.getAuthorizationEndpoint(), "authorization_endpoint");
    }

    public static String getTokenEndpoint(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getValueFromProviderOrDiscoveryMetadata(oidcClientConfig, metadata -> metadata.getTokenEndpoint(), "token_endpoint");
    }

    public static String getUserInfoEndpoint(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getValueFromProviderOrDiscoveryMetadata(oidcClientConfig, metadata -> metadata.getUserinfoEndpoint(), "userinfo_endpoint");
    }

    public static String getJwksUri(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getValueFromProviderOrDiscoveryMetadata(oidcClientConfig, metadata -> metadata.getJwksURI(), "jwks_uri");
    }

    public static String getEndSessionEndpoint(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getValueFromProviderOrDiscoveryMetadata(oidcClientConfig, metadata -> metadata.getEndSessionEndpoint(), "end_session_endpoint");
    }

    public static String getIssuer(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getValueFromProviderOrDiscoveryMetadata(oidcClientConfig, metadata -> metadata.getIssuer(), "issuer");
    }

    public static String[] getIdTokenSigningAlgorithmsSupported(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getStringArrayValueFromProviderOrDiscoveryMetadata(oidcClientConfig, metadata -> metadata.getIdTokenSigningAlgorithmsSupported(), "id_token_signing_alg_values_supported");
    }

    public static String[] getUserInfoSigningAlgorithmsSupported(OidcClientConfig oidcClientConfig) throws OidcDiscoveryException, OidcClientConfigurationException {
        return MetadataUtils.getStringArrayValueFromProviderOrDiscoveryMetadata(oidcClientConfig, null, "userinfo_signing_alg_values_supported");
    }
}

