/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.cdi.beans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesProvider;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.jakartasec.OpenIdAuthenticationMechanismDefinitionHolder;
import io.openliberty.security.jakartasec.OpenIdAuthenticationMechanismDefinitionWrapper;
import io.openliberty.security.jakartasec.credential.OidcTokensCredential;
import io.openliberty.security.jakartasec.identitystore.OpenIdContextImpl;
import io.openliberty.security.jakartasec.identitystore.OpenIdContextUtils;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequestUtils;
import io.openliberty.security.oidcclientcore.client.Client;
import io.openliberty.security.oidcclientcore.client.ClientManager;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.exceptions.AuthenticationResponseException;
import io.openliberty.security.oidcclientcore.exceptions.TokenRequestException;
import io.openliberty.security.oidcclientcore.exceptions.UnsupportedResponseTypeException;
import io.openliberty.security.oidcclientcore.http.OriginalResourceRequest;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.storage.StorageFactory;
import io.openliberty.security.oidcclientcore.token.TokenResponse;
import io.openliberty.security.oidcclientcore.utils.Utils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import jakarta.security.enterprise.identitystore.openid.RefreshToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.security.auth.Subject;
import org.jboss.weld.proxy.WeldClientProxy;

@Default
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final TraceComponent tc = Tr.register(OidcHttpAuthenticationMechanism.class, (String)"JAKARTASEC", (String)"io.openliberty.security.jakartasec.cdi.internal.resources.JakartaSecurity30Messages");
    private static final String AUTH_TYPE_PROPERTY = "jakarta.servlet.http.authType";
    private static final String AUTH_TYPE_JAKARTA_OIDC = "JAKARTA_OIDC";
    private static final String CHECKING_FOR_EXPIRED_TOKEN = "CHECKING_FOR_EXPIRED_TOKEN";
    private static final String JASPIC_PROVIDER_PERFORMED_REQUEST_LOGOUT = "JASPIC_PROVIDER_PERFORMED_REQUEST_LOGOUT";
    @Inject
    IdentityStoreHandler identityStoreHandler;
    private ModulePropertiesProvider mpp = this.getModulePropertiesProvider();
    private final com.ibm.ws.security.javaeesec.cdi.beans.Utils utils = this.getUtils();
    private final AuthorizationRequestUtils requestUtils = this.getRequestUtils();
    static final long serialVersionUID = 196354553254133761L;

    private OpenIdAuthenticationMechanismDefinitionWrapper getOpenIdAuthenticationMechanismDefinition(HttpServletRequest request) {
        Properties props = this.mpp.getAuthMechProperties(OidcHttpAuthenticationMechanism.class);
        String baseURL = this.requestUtils.getBaseURL(request);
        OpenIdAuthenticationMechanismDefinitionHolder openIdAuthenticationMechanismDefinitionHolder = (OpenIdAuthenticationMechanismDefinitionHolder)props.get("oidc_annotation");
        return new OpenIdAuthenticationMechanismDefinitionWrapper(openIdAuthenticationMechanismDefinitionHolder.getOpenIdAuthenticationMechanismDefinition(), baseURL);
    }

    protected ModulePropertiesProvider getModulePropertiesProvider() {
        Instance modulePropertiesProviderInstance = this.getCDI().select(ModulePropertiesProvider.class, new Annotation[0]);
        if (modulePropertiesProviderInstance != null) {
            return (ModulePropertiesProvider)modulePropertiesProviderInstance.get();
        }
        return null;
    }

    protected com.ibm.ws.security.javaeesec.cdi.beans.Utils getUtils() {
        return new com.ibm.ws.security.javaeesec.cdi.beans.Utils();
    }

    protected AuthorizationRequestUtils getRequestUtils() {
        return new AuthorizationRequestUtils();
    }

    @FFDCIgnore(value={IllegalStateException.class})
    protected CDI getCDI() {
        try {
            return CDI.current();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public AuthenticationStatus validateRequest(HttpServletRequest req, HttpServletResponse res, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        HttpServletRequest request = httpMessageContext.getRequest();
        HttpServletResponse response = httpMessageContext.getResponse();
        Client client = this.getClient(request);
        boolean alreadyAuthenticated = this.isAlreadyAuthenticated(request);
        if (this.isAuthenticationRequired(httpMessageContext, alreadyAuthenticated) && !this.containsStoredState(request, response, client)) {
            status = this.processStartFlow(client, httpMessageContext);
        } else if (this.isCallbackRequest(request)) {
            status = this.processCallback(client, httpMessageContext);
        } else if (alreadyAuthenticated) {
            status = this.checkForExpiredTokensAndProcessIfNeeded(client, request, response, httpMessageContext);
        } else if (!httpMessageContext.isProtected()) {
            status = AuthenticationStatus.NOT_DONE;
        }
        return status;
    }

    protected Client getClient(HttpServletRequest request) {
        return ClientManager.getClientFor((OidcClientConfig)this.getOpenIdAuthenticationMechanismDefinition(request));
    }

    private boolean isAuthenticationRequired(HttpMessageContext httpMessageContext, boolean alreadyAuthenticated) {
        return this.isProtectedResourceWithoutBeingAuthenticated(httpMessageContext, alreadyAuthenticated) || this.isProgrammaticAuthenticationWithoutBeingAuthenticated(httpMessageContext, alreadyAuthenticated);
    }

    private boolean isProtectedResourceWithoutBeingAuthenticated(HttpMessageContext httpMessageContext, boolean alreadyAuthenticated) {
        return httpMessageContext.isProtected() && !alreadyAuthenticated;
    }

    private boolean isProgrammaticAuthenticationWithoutBeingAuthenticated(HttpMessageContext httpMessageContext, boolean alreadyAuthenticated) {
        return this.isNewAuthentication(httpMessageContext.getAuthParameters()) || httpMessageContext.isAuthenticationRequest() && !alreadyAuthenticated;
    }

    private boolean isNewAuthentication(AuthenticationParameters authParameters) {
        if (authParameters != null) {
            return authParameters.isNewAuthentication();
        }
        return false;
    }

    private boolean containsStoredState(HttpServletRequest request, HttpServletResponse response, Client client) {
        String state = request.getParameter("state");
        if (state == null) {
            return false;
        }
        OidcClientConfig clientConfig = client.getOidcClientConfig();
        Storage storage = StorageFactory.instantiateStorage((HttpServletRequest)request, (HttpServletResponse)response, (boolean)clientConfig.isUseSession());
        return storage.get(OidcStorageUtils.getStateStorageKey((String)state)) != null;
    }

    private boolean isAlreadyAuthenticated(HttpServletRequest request) {
        return request.getUserPrincipal() != null;
    }

    /*
     * WARNING - void declaration
     */
    private AuthenticationStatus processStartFlow(Client client, HttpMessageContext httpMessageContext) {
        HttpServletRequest request = httpMessageContext.getRequest();
        HttpServletResponse response = httpMessageContext.getResponse();
        request.setAttribute("IS_CONTAINER_INITIATED_FLOW", (Object)(!httpMessageContext.isAuthenticationRequest() ? 1 : 0));
        AuthenticationStatus status = AuthenticationStatus.SEND_CONTINUE;
        try {
            ProviderAuthenticationResult providerAuthenticationResult = client.startFlow(request, response);
            status = this.processStartFlowResult(providerAuthenticationResult, httpMessageContext);
        }
        catch (Exception providerAuthenticationResult) {
            void e;
            FFDCFilter.processException((Throwable)providerAuthenticationResult, (String)"io.openliberty.security.jakartasec.cdi.beans.OidcHttpAuthenticationMechanism", (String)"218", (Object)this, (Object[])new Object[]{client, httpMessageContext});
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            response.setStatus(401);
        }
        return status;
    }

    private AuthenticationStatus processStartFlowResult(ProviderAuthenticationResult providerAuthenticationResult, HttpMessageContext httpMessageContext) {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        if (providerAuthenticationResult != null) {
            AuthResult authResult = providerAuthenticationResult.getStatus();
            if (AuthResult.REDIRECT_TO_PROVIDER.equals((Object)authResult)) {
                status = httpMessageContext.redirect(providerAuthenticationResult.getRedirectUrl());
            } else if (AuthResult.SEND_401.equals((Object)authResult)) {
                status = httpMessageContext.responseUnauthorized();
            }
        }
        return status;
    }

    private boolean isCallbackRequest(HttpServletRequest request) {
        return request.getParameter("state") != null;
    }

    @FFDCIgnore(value={AuthenticationResponseException.class})
    private AuthenticationStatus processCallback(Client client, HttpMessageContext httpMessageContext) throws AuthenticationException {
        OidcClientConfig clientConfig;
        HttpServletRequest request = httpMessageContext.getRequest();
        HttpServletResponse response = httpMessageContext.getResponse();
        AuthenticationStatus status = AuthenticationStatus.SEND_CONTINUE;
        try {
            ProviderAuthenticationResult providerAuthenticationResult = client.continueFlow(request, response);
            status = this.processContinueFlowResult(providerAuthenticationResult, httpMessageContext, client);
        }
        catch (AuthenticationResponseException e) {
            switch (e.getValidationResult()) {
                case NOT_VALIDATED_RESULT: {
                    status = AuthenticationStatus.NOT_DONE;
                    break;
                }
                case INVALID_RESULT: {
                    Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
                    status = AuthenticationStatus.SEND_CONTINUE;
                    response.setStatus(401);
                }
            }
        }
        catch (TokenRequestException | UnsupportedResponseTypeException e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.security.jakartasec.cdi.beans.OidcHttpAuthenticationMechanism", (String)"274", (Object)this, (Object[])new Object[]{client, httpMessageContext});
            Tr.error((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            response.setStatus(401);
        }
        if (status == AuthenticationStatus.SUCCESS && (clientConfig = client.getOidcClientConfig()).isRedirectToOriginalResource()) {
            this.restoreOriginalResourceRequest(clientConfig, httpMessageContext);
        }
        return status;
    }

    private void restoreOriginalResourceRequest(OidcClientConfig clientConfig, HttpMessageContext httpMessageContext) {
        Optional<HttpServletRequest> originalResourceRequest = this.getOriginalResourceRequest(clientConfig, httpMessageContext);
        if (originalResourceRequest.isPresent()) {
            httpMessageContext.setRequest(originalResourceRequest.get());
            httpMessageContext.getMessageInfo().setRequestMessage((Object)originalResourceRequest.get());
        }
    }

    private Optional<HttpServletRequest> getOriginalResourceRequest(OidcClientConfig clientConfig, HttpMessageContext httpMessageContext) {
        HttpServletRequest request = httpMessageContext.getRequest();
        HttpServletResponse response = httpMessageContext.getResponse();
        OriginalResourceRequest originalResourceRequest = null;
        if (this.hasPreviouslyStoredOriginalResourceRequest(request, response, clientConfig)) {
            originalResourceRequest = this.recreateOriginalResourceRequest(request, response, clientConfig.isUseSession());
        }
        return Optional.ofNullable(originalResourceRequest);
    }

    private boolean hasPreviouslyStoredOriginalResourceRequest(HttpServletRequest request, HttpServletResponse response, OidcClientConfig clientConfig) {
        String state;
        String stateHash;
        Storage storage = StorageFactory.instantiateStorage((HttpServletRequest)request, (HttpServletResponse)response, (boolean)clientConfig.isUseSession());
        String storedMethod = storage.get("WASOidcReqMethod" + (stateHash = Utils.getStrHashCode((String)(state = request.getParameter("state")))));
        return storedMethod != null && !storedMethod.isEmpty();
    }

    protected OriginalResourceRequest recreateOriginalResourceRequest(HttpServletRequest request, HttpServletResponse response, boolean useSession) {
        return new OriginalResourceRequest(request, response, useSession);
    }

    private AuthenticationStatus processContinueFlowResult(ProviderAuthenticationResult providerAuthenticationResult, HttpMessageContext httpMessageContext, Client client) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        if (providerAuthenticationResult != null) {
            AuthResult authResult = providerAuthenticationResult.getStatus();
            if (AuthResult.SUCCESS.equals((Object)authResult)) {
                status = this.handleOidcLogin(providerAuthenticationResult, httpMessageContext, client);
            } else if (AuthResult.REDIRECT.equals((Object)authResult)) {
                status = httpMessageContext.redirect(providerAuthenticationResult.getRedirectUrl());
            }
        }
        return status;
    }

    private AuthenticationStatus handleOidcLogin(ProviderAuthenticationResult providerAuthenticationResult, HttpMessageContext httpMessageContext, Client client) throws AuthenticationException {
        return this.createAndValidateOidcTokensCredential(providerAuthenticationResult, client, httpMessageContext);
    }

    AuthenticationStatus createAndValidateOidcTokensCredential(ProviderAuthenticationResult providerAuthenticationResult, Client client, HttpMessageContext httpMessageContext) throws AuthenticationException {
        HttpServletRequest request = httpMessageContext.getRequest();
        HttpServletResponse response = httpMessageContext.getResponse();
        OidcTokensCredential credential = this.createOidcTokensCredential(providerAuthenticationResult, request, response, client);
        return this.validateCredentials(credential, httpMessageContext);
    }

    private OidcTokensCredential createOidcTokensCredential(ProviderAuthenticationResult providerAuthenticationResult, HttpServletRequest request, HttpServletResponse response, Client client) {
        TokenResponse tokenResponse;
        OidcTokensCredential credential = null;
        Hashtable customProperties = providerAuthenticationResult.getCustomProperties();
        if (customProperties != null && (tokenResponse = (TokenResponse)customProperties.get("TOKEN_RESPONSE")) != null) {
            credential = new OidcTokensCredential(tokenResponse, client, request, response);
            credential.setOpenIdContext((OpenIdContext)this.getOpenIdContext());
        }
        return credential;
    }

    private AuthenticationStatus validateCredentials(OidcTokensCredential credential, HttpMessageContext httpMessageContext) throws AuthenticationException {
        int rspStatus;
        String issuer = this.getIssuerFromIdentityToken();
        Subject clientSubject = httpMessageContext.getClientSubject();
        AuthenticationStatus status = this.utils.handleAuthenticate(this.getCDI(), issuer, (Credential)credential, clientSubject, httpMessageContext);
        if (status == AuthenticationStatus.SUCCESS) {
            this.setOpenIdContextInSubject(clientSubject, credential.getOpenIdContext());
            Map messageInfoMap = httpMessageContext.getMessageInfo().getMap();
            messageInfoMap.put(AUTH_TYPE_PROPERTY, AUTH_TYPE_JAKARTA_OIDC);
            messageInfoMap.put("jakarta.servlet.http.registerSession", Boolean.TRUE.toString());
            rspStatus = 200;
        } else if (status == AuthenticationStatus.NOT_DONE) {
            rspStatus = 200;
        } else {
            rspStatus = 401;
            status = AuthenticationStatus.SEND_CONTINUE;
        }
        httpMessageContext.getResponse().setStatus(rspStatus);
        return status;
    }

    private String getIssuerFromIdentityToken() {
        OpenIdContext openIdContext = OpenIdContextUtils.getOpenIdContextFromSubject();
        String issuer = "defaultRealm";
        if (openIdContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The openIdContext is null, can't get the issuer, will be set to the default realm: " + issuer), (Object[])new Object[0]);
            }
        } else {
            IdentityToken idToken = openIdContext.getIdentityToken();
            if (idToken == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The IdentityToken is null, can't get the issuer, will be set to the default realm: " + issuer), (Object[])new Object[0]);
                }
            } else {
                Map claims = idToken.getClaims();
                if (claims == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("The claims map on the IdentityToken is null, can't get the issuer, will be set to the default realm: " + issuer), (Object[])new Object[0]);
                    }
                } else {
                    String issuerFromMap = (String)claims.get("iss");
                    if (issuerFromMap == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("iss returned null from the claims map, can't get the issuer, will be set to the default realm: " + issuer), (Object[])new Object[0]);
                        }
                    } else {
                        issuer = issuerFromMap;
                    }
                }
            }
        }
        return issuer;
    }

    protected OpenIdContextImpl getOpenIdContext() {
        OpenIdContext openIdContext;
        OpenIdContextImpl openIdContextImpl = null;
        Instance openIdContextInstance = this.getCDI().select(OpenIdContext.class, new Annotation[0]);
        if (openIdContextInstance != null && (openIdContext = (OpenIdContext)openIdContextInstance.get()) instanceof WeldClientProxy) {
            openIdContextImpl = (OpenIdContextImpl)((WeldClientProxy)openIdContext).getMetadata().getContextualInstance();
        }
        return openIdContextImpl;
    }

    private void setOpenIdContextInSubject(Subject clientSubject, OpenIdContext openIdContext) {
        if (openIdContext != null) {
            String newCacheKey;
            clientSubject.getPrivateCredentials().add(openIdContext);
            Hashtable hashtable = this.utils.getSubjectExistingHashtable(clientSubject);
            if (hashtable != null && (newCacheKey = this.getNewCustomCacheKeyValue(openIdContext)) != null) {
                hashtable.put("com.ibm.wsspi.security.cred.cacheKey", newCacheKey);
            }
        }
    }

    private String getNewCustomCacheKeyValue(OpenIdContext openIdContext) {
        IdentityToken idToken = openIdContext.getIdentityToken();
        if (idToken != null) {
            return String.valueOf(idToken.hashCode());
        }
        AccessToken accessToken = openIdContext.getAccessToken();
        if (accessToken != null) {
            return String.valueOf(accessToken.hashCode());
        }
        return null;
    }

    private AuthenticationStatus checkForExpiredTokensAndProcessIfNeeded(Client client, HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        ProviderAuthenticationResult providerAuthenticationResult;
        OpenIdContext openIdContext = OpenIdContextUtils.getOpenIdContextFromSubject();
        if (openIdContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The openIdContext from OpenIdContextUtils.getOpenIdContextFromSubject is null, the ProviderAuthenticationResult is set to failure", (Object[])new Object[0]);
            }
            providerAuthenticationResult = new ProviderAuthenticationResult(AuthResult.FAILURE, 500);
        } else {
            IdentityToken idToken = openIdContext.getIdentityToken();
            boolean isAccessTokenExpired = openIdContext.getAccessToken().isExpired();
            boolean isIdTokenExpired = false;
            String idTokenString = null;
            if (idToken != null) {
                isIdTokenExpired = idToken.isExpired();
                idTokenString = idToken.getToken();
            }
            request.setAttribute(CHECKING_FOR_EXPIRED_TOKEN, (Object)true);
            providerAuthenticationResult = client.checkForExpiredTokensAndProcessIfNeeded(request, response, isAccessTokenExpired, isIdTokenExpired, idTokenString, this.getRefreshToken(openIdContext));
            request.removeAttribute(CHECKING_FOR_EXPIRED_TOKEN);
        }
        return this.processResultFromExpirationCheck(providerAuthenticationResult, client, httpMessageContext);
    }

    private String getRefreshToken(OpenIdContext openIdContext) {
        RefreshToken refreshToken;
        Optional optionalRefreshToken = openIdContext.getRefreshToken();
        if (optionalRefreshToken.isPresent() && (refreshToken = (RefreshToken)optionalRefreshToken.get()) != null) {
            return refreshToken.getToken();
        }
        return null;
    }

    private AuthenticationStatus processResultFromExpirationCheck(ProviderAuthenticationResult providerAuthenticationResult, Client client, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        if (providerAuthenticationResult != null) {
            AuthResult authResult = providerAuthenticationResult.getStatus();
            if (AuthResult.REDIRECT_TO_PROVIDER.equals((Object)authResult)) {
                status = httpMessageContext.redirect(providerAuthenticationResult.getRedirectUrl());
            } else if (AuthResult.SUCCESS.equals((Object)authResult)) {
                status = this.updateOpenIdContextWithRefreshedTokens(providerAuthenticationResult, client, httpMessageContext);
            } else if (AuthResult.CONTINUE.equals((Object)authResult)) {
                status = this.noProcessingNeededFromExpirationCheck(httpMessageContext);
            }
        }
        return status;
    }

    private AuthenticationStatus updateOpenIdContextWithRefreshedTokens(ProviderAuthenticationResult providerAuthenticationResult, Client client, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return this.createAndValidateOidcTokensCredential(providerAuthenticationResult, client, httpMessageContext);
    }

    private AuthenticationStatus noProcessingNeededFromExpirationCheck(HttpMessageContext httpMessageContext) {
        httpMessageContext.getResponse().setStatus(200);
        httpMessageContext.getMessageInfo().getMap().put(AUTH_TYPE_PROPERTY, AUTH_TYPE_JAKARTA_OIDC);
        return AuthenticationStatus.NOT_DONE;
    }

    public void cleanSubject(HttpServletRequest req, HttpServletResponse resp, HttpMessageContext httpMessageContext) {
        boolean checkingForExpiredToken;
        HttpServletRequest request = httpMessageContext.getRequest();
        HttpServletResponse response = httpMessageContext.getResponse();
        Object checkingForExpiredTokenObject = request.getAttribute(CHECKING_FOR_EXPIRED_TOKEN);
        boolean bl = checkingForExpiredToken = checkingForExpiredTokenObject == null ? false : (Boolean)checkingForExpiredTokenObject;
        if (!checkingForExpiredToken) {
            IdentityToken idToken;
            String idTokenString = null;
            OpenIdContext openIdContext = OpenIdContextUtils.getOpenIdContextFromSubject();
            if (openIdContext != null && (idToken = openIdContext.getIdentityToken()) != null) {
                idTokenString = idToken.getToken();
            }
            Client client = this.getClient(request);
            ProviderAuthenticationResult providerAuthenticationResult = client.logout(request, response, idTokenString);
            request.setAttribute(JASPIC_PROVIDER_PERFORMED_REQUEST_LOGOUT, (Object)"true");
            this.processLogoutResult(providerAuthenticationResult, httpMessageContext);
        }
    }

    private void processLogoutResult(ProviderAuthenticationResult providerAuthenticationResult, HttpMessageContext httpMessageContext) {
        AuthResult authResult = providerAuthenticationResult.getStatus();
        if (AuthResult.REDIRECT_TO_PROVIDER.equals((Object)authResult)) {
            httpMessageContext.redirect(providerAuthenticationResult.getRedirectUrl());
        }
    }
}

