/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIServiceUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.concurrent.internal.cdi.ConcurrencyExtensionMetadata;
import io.openliberty.concurrent.internal.cdi.ConcurrencyResourceBean;
import io.openliberty.concurrent.internal.cdi.interceptor.AsyncInterceptor;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrencyExtension
implements Extension {
    private static final TraceComponent tc = Tr.register(ConcurrencyExtension.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    private static final Set<Annotation> DEFAULT_QUALIFIER = Set.of(Default.Literal.INSTANCE);
    private final Set<Set<Annotation>> contextServiceQualifiers = new HashSet<Set<Annotation>>();
    private final Set<Set<Annotation>> executorQualifiers = new HashSet<Set<Annotation>>();
    private final Set<Set<Annotation>> scheduledExecutorQualifiers = new HashSet<Set<Annotation>>();
    static final long serialVersionUID = -6151724058190761421L;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType bindingType = beanManager.createAnnotatedType(Asynchronous.class);
        beforeBeanDiscovery.addInterceptorBinding(bindingType);
        AnnotatedType interceptorType = beanManager.createAnnotatedType(AsyncInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(interceptorType, CDIServiceUtils.getAnnotatedTypeIdentifier((AnnotatedType)interceptorType, this.getClass()));
    }

    public <T> void processContextServiceInjectionPoint(@Observes ProcessInjectionPoint<T, ContextService> event) {
        if (ConcurrencyExtensionMetadata.eeVersion.getMajor() >= 11) {
            InjectionPoint injectionPoint = event.getInjectionPoint();
            Set qualifiers = injectionPoint.getQualifiers();
            this.contextServiceQualifiers.add(qualifiers);
        }
    }

    public <T> void processExecutorInjectionPoint(@Observes ProcessInjectionPoint<T, ManagedExecutorService> event) {
        if (ConcurrencyExtensionMetadata.eeVersion.getMajor() >= 11) {
            InjectionPoint injectionPoint = event.getInjectionPoint();
            Set qualifiers = injectionPoint.getQualifiers();
            this.executorQualifiers.add(qualifiers);
        }
    }

    public <T> void processScheduledExecutorInjectionPoint(@Observes ProcessInjectionPoint<T, ManagedScheduledExecutorService> event) {
        if (ConcurrencyExtensionMetadata.eeVersion.getMajor() >= 11) {
            InjectionPoint injectionPoint = event.getInjectionPoint();
            Set qualifiers = injectionPoint.getQualifiers();
            this.scheduledExecutorQualifiers.add(qualifiers);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (ConcurrencyExtensionMetadata.eeVersion.getMajor() >= 11) {
            ConcurrencyResourceBean<ManagedScheduledExecutorService> bean;
            String name;
            String filter;
            CDI cdi = CDI.current();
            for (Set<Annotation> qualifiers : this.contextServiceQualifiers) {
                if (cdi.select(ContextService.class, qualifiers.toArray(new Annotation[qualifiers.size()])).isResolvable()) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ContextService already exists with qualifiers " + qualifiers), (Object[])new Object[0]);
                    continue;
                }
                filter = null;
                if (DEFAULT_QUALIFIER.equals(qualifiers)) {
                    filter = "(id=DefaultContextService)";
                } else {
                    for (Annotation q : qualifiers) {
                        if (!Named.class.equals(q.annotationType())) continue;
                        name = ((Named)q).value();
                        filter = new StringBuilder(name.length() + 21).append("(id=contextService[").append(name).append("])").toString();
                    }
                }
                if (filter == null) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("No producer or ContextServiceDefinition for qualifiers " + qualifiers), (Object[])new Object[0]);
                    continue;
                }
                bean = new ConcurrencyResourceBean<ContextService>(ContextService.class, filter, Set.of(ContextService.class), qualifiers);
                event.addBean((Bean)bean);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Added ContextService bean with qualifiers " + qualifiers), (Object[])new Object[0]);
            }
            this.contextServiceQualifiers.clear();
            for (Set<Annotation> qualifiers : this.executorQualifiers) {
                if (cdi.select(ManagedExecutorService.class, qualifiers.toArray(new Annotation[qualifiers.size()])).isResolvable()) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ManagedExecutorService already exists with qualifiers " + qualifiers), (Object[])new Object[0]);
                    continue;
                }
                filter = null;
                if (DEFAULT_QUALIFIER.equals(qualifiers)) {
                    filter = "(id=DefaultManagedExecutorService)";
                } else {
                    for (Annotation q : qualifiers) {
                        if (!Named.class.equals(q.annotationType())) continue;
                        name = ((Named)q).value();
                        filter = new StringBuilder(name.length() + 29).append("(id=managedExecutorService[").append(name).append("])").toString();
                    }
                }
                if (filter == null) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("No producer or ManagedExecutorDefinition for qualifiers " + qualifiers), (Object[])new Object[0]);
                    continue;
                }
                bean = new ConcurrencyResourceBean<ManagedExecutorService>(ManagedExecutorService.class, filter, Set.of(ManagedExecutorService.class, ExecutorService.class, Executor.class), qualifiers);
                event.addBean((Bean)bean);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Added ManagedExecutorService bean with qualifiers " + qualifiers), (Object[])new Object[0]);
            }
            this.executorQualifiers.clear();
            for (Set<Annotation> qualifiers : this.scheduledExecutorQualifiers) {
                if (cdi.select(ManagedScheduledExecutorService.class, qualifiers.toArray(new Annotation[qualifiers.size()])).isResolvable()) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ManagedScheduledExecutorService already exists with qualifiers " + qualifiers), (Object[])new Object[0]);
                    continue;
                }
                filter = null;
                if (DEFAULT_QUALIFIER.equals(qualifiers)) {
                    filter = "(id=DefaultManagedScheduledExecutorService)";
                } else {
                    for (Annotation q : qualifiers) {
                        if (!Named.class.equals(q.annotationType())) continue;
                        name = ((Named)q).value();
                        filter = new StringBuilder(name.length() + 38).append("(id=managedScheduledExecutorService[").append(name).append("])").toString();
                    }
                }
                if (filter == null) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("No producer or ManagedScheduledExecutorDefinition for qualifiers " + qualifiers), (Object[])new Object[0]);
                    continue;
                }
                bean = new ConcurrencyResourceBean<ManagedScheduledExecutorService>(ManagedScheduledExecutorService.class, filter, Set.of(ManagedScheduledExecutorService.class, ScheduledExecutorService.class), qualifiers);
                event.addBean(bean);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Added ManagedScheduledExecutorService bean with qualifiers " + qualifiers), (Object[])new Object[0]);
            }
            this.scheduledExecutorQualifiers.clear();
        }
    }
}

