/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConcurrencyResourceBean<T>
implements Bean<T>,
PassivationCapable {
    private static final TraceComponent tc = Tr.register(ConcurrencyResourceBean.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private final Set<Type> beanTypes;
    private final String filter;
    private final Set<Annotation> qualifiers;
    private final Class<T> resourceType;
    static final long serialVersionUID = -1997512693926719551L;

    public ConcurrencyResourceBean(Class<T> resourceType, String filter, Set<Type> types, Set<Annotation> qualifiers) {
        this.filter = filter;
        this.resourceType = resourceType;
        this.beanTypes = types;
        this.qualifiers = qualifiers;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    public T create(CreationalContext<T> cc) {
        Collection refs;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"create", (Object[])new Object[]{cc, this.resourceType, this.filter, this.qualifiers});
        }
        Bundle bundle = FrameworkUtil.getBundle(ConcurrencyResourceBean.class);
        BundleContext bundleContext = priv.getBundleContext(bundle);
        try {
            refs = priv.getServiceReferences(bundleContext, this.resourceType, this.filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void x;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"io.openliberty.concurrent.internal.cdi.ConcurrencyResourceBean", (String)"99", (Object)this, (Object[])new Object[]{cc});
            throw new IllegalArgumentException((Throwable)x);
        }
        Iterator it = refs.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("The " + this.resourceType.getName() + " resource with " + this.filter + " filter cannot be found or is unavailable.");
        }
        Object instance = priv.getService(bundleContext, (ServiceReference)it.next());
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"create", (Object)instance);
        }
        return (T)instance;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Class<T> getBeanClass() {
        return this.resourceType;
    }

    public String getId() {
        return this.getClass().getName() + ':' + this.resourceType.getClass().getSimpleName() + ":" + this.qualifiers + ':' + this.filter;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.beanTypes;
    }

    public boolean isAlternative() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode()) + ' ' + this.resourceType.getClass().getSimpleName() + ' ' + this.filter + " with qualifiers " + this.qualifiers;
    }
}

