/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.util.EntryResource;
import com.ibm.ws.webcontainer.util.ExtDocRootFile;
import com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils;
import com.ibm.ws.webcontainer.util.FileResource;
import com.ibm.ws.webcontainer.util.MetaInfResourceFinder;
import com.ibm.ws.webcontainer.util.MetaInfResourcesFileUtils;
import com.ibm.ws.webcontainer.util.ZipFileResource;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class DocumentRootUtils {
    private static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.util.DocumentRootUtils";
    private boolean useContentLength = false;
    private File matchedFile;
    private ZipFileResource matchedZipFile;
    private EntryResource matchedEntry;
    private URL matchedURL;
    private String edrRoot = null;
    private String pfedrRoot = null;
    private ServletContext ctxt;
    private String baseDir;
    private ExtendedDocumentRootUtils edr = null;
    private ExtendedDocumentRootUtils pfedr = null;
    private MetaInfResourcesFileUtils metaInfRes = null;
    private boolean searchpfEDR = false;
    private boolean searchEDR = false;
    private boolean searchMetaInfRes = true;
    boolean matchFromEDR = false;
    boolean matchFromMetaInfRes = false;
    boolean matchIsADirectory = false;
    private WebAppConfiguration appConfig;
    private String attributeType;
    public static final String STATIC_FILE = "staticFile";
    public static final String JSP = "jsp";
    private static final String PFEDR = "preFragmentExtendedDocumentRoot";
    public static final String EDR = "extendedDocumentRoot";

    public DocumentRootUtils(ServletContext context, String extendedDocumentRoot, String preFragmentExtendedDocumentRoot) {
        this.pfedrRoot = preFragmentExtendedDocumentRoot;
        this.edrRoot = extendedDocumentRoot;
        this.ctxt = context;
        this.baseDir = null;
        if (this.pfedrRoot != null) {
            this.searchpfEDR = true;
        }
        if (this.edrRoot != null) {
            this.searchEDR = true;
        }
        if (WCCustomProperties.SKIP_META_INF_RESOURCES_PROCESSING) {
            this.searchMetaInfRes = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "Document Root Utils created with context.", "pfEDR = " + this.pfedrRoot + ", edr = " + this.edrRoot);
        }
    }

    public DocumentRootUtils(ServletContext context, WebAppConfiguration config, String type) {
        this.appConfig = config;
        this.ctxt = context;
        this.baseDir = null;
        this.attributeType = type;
        this.searchpfEDR = true;
        this.searchEDR = true;
        if (WCCustomProperties.SKIP_META_INF_RESOURCES_PROCESSING) {
            this.searchMetaInfRes = false;
        }
        this.edrRoot = this.getRoot(EDR);
        this.pfedrRoot = this.getRoot(PFEDR);
        this.ctxt = context;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "Document Root Utils created with context and config.", "type = " + this.attributeType);
        }
    }

    public DocumentRootUtils(String baseDirectory, String extendedDocumentRoot, String preFragmentExtendedDocumentRoot) {
        this.pfedrRoot = preFragmentExtendedDocumentRoot;
        this.edrRoot = extendedDocumentRoot;
        this.ctxt = null;
        this.baseDir = baseDirectory;
        if (this.pfedrRoot != null) {
            this.searchpfEDR = true;
        }
        if (this.edrRoot != null) {
            this.searchEDR = true;
        }
        if (WCCustomProperties.SKIP_META_INF_RESOURCES_PROCESSING) {
            this.searchMetaInfRes = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "Document Root Utils created with baseDir : " + this.baseDir + ".", "pfEDR = " + this.pfedrRoot + ", edr = " + this.edrRoot);
        }
    }

    public boolean hasDocRoot() {
        return this.getedr() || this.getpfedr();
    }

    public boolean searchPathExists() {
        boolean result = false;
        if (this.getedr()) {
            result = this.edr.searchPathExists();
        }
        if (!result && this.getpfedr()) {
            result = this.pfedr.searchPathExists();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "searchPathExists", " ", result);
        }
        return result;
    }

    public void handleDocumentRoots(String filename, boolean _searchEDR) throws FileNotFoundException, IOException {
        this.handleDocumentRoots(filename, this.searchpfEDR, this.searchMetaInfRes, _searchEDR);
    }

    public void handleDocumentRoots(String filename) throws FileNotFoundException, IOException {
        this.handleDocumentRoots(filename, this.searchpfEDR, this.searchMetaInfRes, this.searchEDR);
    }

    public void handleDocumentRoots(String filename, Map<String, URL> metaInfCache) throws FileNotFoundException, IOException {
        this.handleDocumentRoots(filename, this.searchpfEDR, this.searchMetaInfRes, this.searchEDR, metaInfCache);
    }

    public void handleDocumentRoots(String filename, boolean searchpfEDR, boolean searchMetaInf, boolean searchEDR) throws FileNotFoundException, IOException {
        this.handleDocumentRoots(filename, searchpfEDR, searchMetaInf, searchEDR, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentRoots(String filename, boolean searchpfEDR, boolean searchMetaInf, boolean searchEDR, Map<String, URL> metaInfCache) throws FileNotFoundException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "handleDocumentRoots", "search: pfedr = " + searchpfEDR + ", MetaInf = " + searchMetaInf + ", edr = " + searchEDR + ", filename --> " + filename);
        }
        boolean foundMatch = false;
        this.matchedFile = null;
        this.matchedZipFile = null;
        this.matchedEntry = null;
        this.matchedURL = null;
        this.matchFromEDR = false;
        this.matchFromMetaInfRes = false;
        this.matchIsADirectory = false;
        boolean trailingSlashRemoved = false;
        while (filename.endsWith("/")) {
            filename = filename.substring(0, filename.length() - 1);
            trailingSlashRemoved = true;
        }
        if (searchpfEDR && this.getpfedr()) {
            foundMatch = this.checkEDR(this.pfedr, filename);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "match " + (foundMatch ? " found " : "not found") + " in preFragmentExtendedDocumentRoot : " + foundMatch);
            }
        }
        if (!foundMatch && searchMetaInf && this.getMetaInfRes()) {
            if (metaInfCache != null) {
                Map<String, URL> map = metaInfCache;
                synchronized (map) {
                    if (metaInfCache.containsKey(filename)) {
                        this.matchedURL = metaInfCache.get(filename);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "got cached META-INF name->[{0}], URL->[{1}]", new Object[]{filename, this.matchedURL});
                        }
                        foundMatch = true;
                    }
                }
            }
            if (!foundMatch) {
                Object metaInfFinder;
                Entry potentialMatch;
                if (this.ctxt != null && (potentialMatch = ((MetaInfResourceFinder)(metaInfFinder = ((WebApp)this.ctxt).getMetaInfResourceFinder())).findResourceInModule(filename, true)) != null) {
                    this.matchedEntry = new EntryResource(potentialMatch);
                }
                boolean bl = foundMatch = this.matchedEntry != null || this.matchedFile != null || this.matchedZipFile != null;
                if (foundMatch) {
                    this.matchFromMetaInfRes = true;
                    if (metaInfCache != null) {
                        this.matchedURL = this.getURL();
                        if (this.matchedURL != null) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "adding to META-INF cache name->[{0}], URL->[{1}]", new Object[]{filename, this.matchedURL});
                            }
                            metaInfFinder = metaInfCache;
                            synchronized (metaInfFinder) {
                                metaInfCache.put(filename, this.matchedURL);
                            }
                        }
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "match " + (foundMatch ? " found " : "not found") + " in META-INF/resources : " + foundMatch);
            }
        }
        if (!foundMatch && searchEDR && this.getedr()) {
            foundMatch = this.checkEDR(this.edr, filename);
            if (foundMatch) {
                this.matchFromEDR = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "match " + (foundMatch ? " found " : "not found") + " in ExtendedDocumentRoot : " + foundMatch);
            }
        }
        if (foundMatch) {
            if (this.matchedZipFile != null) {
                ZipEntry matchedZipEntry;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "found in zip : " + this.matchedZipFile.getZipFile() + ", entry : " + this.matchedZipFile.getZipEntry().getName());
                }
                if ((matchedZipEntry = this.matchedZipFile.getZipFile().getEntry(this.matchedZipFile.getZipEntry().getName() + "/")) != null) {
                    this.matchIsADirectory = true;
                }
            } else if (this.matchedFile != null) {
                this.matchIsADirectory = this.matchedFile.isDirectory();
            } else if (this.matchedEntry != null) {
                Entry internal = this.matchedEntry.getEntry();
                Container possibleContainer = null;
                try {
                    possibleContainer = (Container)internal.adapt(Container.class);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    // empty catch block
                }
                if (internal.getSize() == 0L && possibleContainer != null) {
                    this.matchIsADirectory = true;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "match " + (this.matchIsADirectory ? " is " : "is not") + " a directory");
            }
            if (!this.matchIsADirectory && trailingSlashRemoved) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "match found was for a directory but filename had a trailing slash");
                }
                foundMatch = false;
            }
        }
        if (!foundMatch) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleDocumentRoots", "file not found");
            }
            this.matchedFile = null;
            this.matchedZipFile = null;
            this.matchedEntry = null;
            this.matchFromEDR = false;
            this.matchFromMetaInfRes = false;
            this.matchIsADirectory = false;
            throw new FileNotFoundException(filename);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "handleExtendedRoots", "match found. Matched URL = " + (this.matchedURL == null ? "null." : this.matchedURL.toString()));
        }
    }

    public InputStream getInputStream() {
        InputStream result;
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getInputStream", "getInputStream for ExtendedDocumentRoot this -->" + this);
            }
            result = null;
            try {
                if (this.matchedZipFile != null) {
                    result = this.matchedZipFile.getIS();
                } else if (this.matchedFile != null) {
                    result = new FileInputStream(this.matchedFile);
                } else if (this.matchedEntry != null) {
                    result = this.matchedEntry.getIS();
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block8;
                logger.logp(Level.FINE, CLASS_NAME, "getInputStream", "exception : " + e);
            }
        }
        return result;
    }

    public boolean isDirectory() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isMatchADirectory", "result = " + this.matchIsADirectory);
        }
        return this.matchIsADirectory;
    }

    public File getMatchedFile() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMatchedFile", "file --> [" + this.matchedFile + "]");
        }
        return this.matchedFile;
    }

    public EntryResource getMatchedEntryResource() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMatchedEntryResource", "entry --> [" + this.matchedEntry + "]");
        }
        return this.matchedEntry;
    }

    public long getLastModifiedMatchedFile() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLastModifiedMatchedFile", "file --> [" + (this.matchedFile == null ? 0L : this.matchedFile.lastModified()) + "]");
        }
        return this.matchedFile == null ? 0L : this.matchedFile.lastModified();
    }

    public String getFilePath() {
        String path = null;
        try {
            if (this.matchedFile != null) {
                path = this.matchedFile.getCanonicalPath();
            } else if (this.matchedZipFile != null) {
                path = this.matchedZipFile.getMatch().getCanonicalPath();
            } else if (this.matchedEntry != null) {
                path = this.matchedEntry.getPath();
            }
        }
        catch (IOException ioe) {
            Object[] args = new Object[]{ioe};
            logger.logp(Level.SEVERE, CLASS_NAME, "getFilePath", "Engine.Exception.[{0}]", args);
        }
        return path;
    }

    public boolean useContentLength() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "useContentLength", "length --> [" + this.useContentLength + "]");
        }
        return this.useContentLength;
    }

    public ZipFileResource getMatchedZipFileResource() {
        if (this.matchedZipFile != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getMatchedZipFile", "is zip file");
            }
            return this.matchedZipFile;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMatchedZipFile", "not zip file");
        }
        return null;
    }

    private URL getURL() {
        try {
            if (this.matchedURL == null) {
                if (this.matchedZipFile != null) {
                    this.matchedURL = this.matchedZipFile.getURL();
                } else if (this.matchedFile != null) {
                    this.matchedURL = this.matchedFile.toURI().toURL();
                } else if (this.matchedEntry != null) {
                    this.matchedURL = this.matchedEntry.getEntry().getResource();
                }
            }
        }
        catch (MalformedURLException e) {
            Object[] args = new Object[]{e};
            logger.logp(Level.SEVERE, CLASS_NAME, "getURL", "Engine.Exception.[{0}]", args);
        }
        return this.matchedURL;
    }

    public URL getURL(String filename, Map<String, URL> metaInfCache) throws MalformedURLException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getURL", "filename = " + filename + " a metaInfCache was " + (metaInfCache == null ? "not provided." : "provided."));
        }
        URL returnURL = null;
        try {
            this.handleDocumentRoots(filename, metaInfCache);
            returnURL = this.getURL();
        }
        catch (FileNotFoundException fnf) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getURL", "file not found.");
            }
            returnURL = null;
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getURL", "IOException");
            }
            returnURL = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getURL", " URL = " + (returnURL == null ? "null." : returnURL.toString()));
        }
        return returnURL;
    }

    public Set<String> getResourcePaths(String filename, boolean searchMetaInf) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getResourcePaths", "filename = " + filename);
        }
        HashSet<String> paths = new HashSet<String>();
        if (this.getpfedr()) {
            paths.addAll(this.pfedr.getResourcePaths(filename));
        }
        if (searchMetaInf && this.getMetaInfRes()) {
            paths.addAll(this.metaInfRes.getResourcePaths(filename));
        }
        if (this.getedr()) {
            paths.addAll(this.edr.getResourcePaths(filename));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getResourcePaths");
        }
        return paths;
    }

    public boolean isMatchedFromEDR() {
        return this.matchFromEDR;
    }

    public boolean isMatchedFromMetaInfRes() {
        return this.matchFromMetaInfRes;
    }

    private String getRoot(String attributeName) {
        String root = this.attributeType.equals(STATIC_FILE) ? (String)this.appConfig.getFileServingAttributes().get(attributeName) : this.appConfig.getJspAttributes().get(attributeName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRoot", "Attribute name = " + attributeName + ", type = " + this.attributeType + ", value = " + root);
        }
        return root;
    }

    private boolean getMetaInfRes() {
        if (this.searchMetaInfRes) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleDocumentRoots", "create MetaInfResourcesFileUtils");
            }
            this.metaInfRes = this.ctxt == null ? new MetaInfResourcesFileUtils(this.baseDir) : new MetaInfResourcesFileUtils(this.ctxt);
        }
        return this.metaInfRes != null;
    }

    private boolean getpfedr() {
        if (this.searchpfEDR) {
            if (this.pfedrRoot == null) {
                this.pfedrRoot = this.getRoot(PFEDR);
            }
            if (this.pfedrRoot != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getpfedr", "create preFragmentExtendedDocumentRoot", this.pfedrRoot);
                }
                this.pfedr = this.ctxt == null ? new ExtendedDocumentRootUtils(this.baseDir, this.pfedrRoot) : new ExtendedDocumentRootUtils(this.ctxt, this.pfedrRoot);
                if (!this.pfedr.searchPathExists()) {
                    this.pfedr = null;
                }
            }
            if (this.pfedr == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getpfedr", "failed to create preFragmentExtendedDocumentRoot", this.pfedrRoot);
                }
                this.searchpfEDR = false;
            }
        }
        return this.pfedr != null;
    }

    private boolean getedr() {
        if (this.searchEDR) {
            if (this.edrRoot == null) {
                this.edrRoot = this.getRoot(EDR);
            }
            if (this.edrRoot != null) {
                logger.logp(Level.FINE, CLASS_NAME, "getedr", "create ExtendedDocumentRoot", this.edrRoot);
                this.edr = this.ctxt == null ? new ExtendedDocumentRootUtils(this.baseDir, this.edrRoot) : new ExtendedDocumentRootUtils(this.ctxt, this.edrRoot);
                if (!this.edr.searchPathExists()) {
                    this.edr = null;
                }
            }
            if (this.edr == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getedr", "failed to create ExtendedDocumentRoot", this.edrRoot);
                }
                this.searchEDR = false;
            }
        }
        return this.edr != null;
    }

    private boolean checkEDR(ExtendedDocumentRootUtils edr, String filename) {
        boolean matched = false;
        try {
            edr.handleExtendedDocumentRoots(filename);
            ExtDocRootFile edrFile = edr.getExtDocRootFile();
            if (edrFile instanceof ZipFileResource) {
                this.matchedZipFile = (ZipFileResource)edrFile;
                logger.logp(Level.FINE, CLASS_NAME, "checkEDR", "matched Zip");
            } else if (edrFile instanceof FileResource) {
                this.matchedFile = ((FileResource)edrFile).getMatch();
                logger.logp(Level.FINE, CLASS_NAME, "checkEDR", "matched File");
            } else if (edrFile instanceof EntryResource) {
                this.matchedEntry = (EntryResource)edrFile;
                logger.logp(Level.FINE, CLASS_NAME, "checkEDR", "matched Entry");
            }
            boolean bl = matched = this.matchedZipFile != null || this.matchedFile != null || this.matchedEntry != null;
            if (matched) {
                this.useContentLength = edr.useContentLength();
            }
        }
        catch (Exception e) {
            matched = false;
        }
        return matched;
    }

    public long getLastModified() {
        if (this.matchedEntry != null) {
            return this.matchedEntry.getLastModified();
        }
        if (this.matchedZipFile != null) {
            return this.matchedZipFile.getLastModified();
        }
        if (this.matchedFile != null) {
            return this.matchedFile.lastModified();
        }
        return 0L;
    }

    public String getpfedrSearchPath() {
        return this.pfedrRoot;
    }

    public String getedrSearchPath() {
        return this.edrRoot;
    }
}

