/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader.context.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloader.context.internal.ClassloaderContextProviderImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RejectedExecutionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassloaderContextImpl
implements ThreadContext {
    static final TraceComponent tc = Tr.register(ClassloaderContextImpl.class, (String)"ClassloaderContext", (String)"com.ibm.ws.classloader.context.internal.resources.ClassLoaderContextMessages");
    private static final long serialVersionUID = 2429635965226179594L;
    static final String CLASS_LOADER_IDENTIFIER = "I";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("I", String.class)};
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    static final ClassLoader SYSTEM_CLASS_LOADER = priv.getSystemClassLoader();
    transient ClassloaderContextProviderImpl classLoaderContextProvider;
    transient ClassLoader classLoaderToPropagate;
    transient String classLoaderIdentifier;
    private transient ClassLoader previousClassLoader;

    ClassloaderContextImpl(ClassloaderContextProviderImpl provider) {
        this(provider, priv.getContextClassLoader());
    }

    ClassloaderContextImpl(ClassloaderContextProviderImpl provider, String classLoaderIdentifier) {
        this.classLoaderContextProvider = provider;
        this.classLoaderIdentifier = classLoaderIdentifier;
    }

    ClassloaderContextImpl(ClassloaderContextProviderImpl provider, ClassLoader cl) {
        this.classLoaderContextProvider = provider;
        this.classLoaderToPropagate = cl;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public ThreadContext clone() {
        try {
            ClassloaderContextImpl copy = (ClassloaderContextImpl)super.clone();
            copy.previousClassLoader = null;
            return copy;
        }
        catch (CloneNotSupportedException copy) {
            void x;
            FFDCFilter.processException((Throwable)copy, (String)"com.ibm.ws.classloader.context.internal.ClassloaderContextImpl", (String)"120", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)x);
        }
    }

    @Trivial
    public void taskStarting() throws RejectedExecutionException {
        if (this.classLoaderIdentifier != null && this.classLoaderToPropagate == null) {
            this.classLoaderToPropagate = this.classLoaderIdentifier.length() == 0 ? SYSTEM_CLASS_LOADER : this.classLoaderContextProvider.classLoaderIdentifierService.getClassLoader(this.classLoaderIdentifier);
        }
        this.previousClassLoader = priv.getContextClassLoader();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (this.classLoaderToPropagate == SYSTEM_CLASS_LOADER) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("clear     " + this.classLoaderToPropagate + " (system class loader)"), (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("propagate " + this.classLoaderToPropagate), (Object[])new Object[0]);
            }
        }
        AccessController.doPrivileged(new SetClassLoader(this.classLoaderToPropagate));
    }

    @Trivial
    public void taskStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("restore   " + this.previousClassLoader), (Object[])new Object[0]);
        }
        AccessController.doPrivileged(new SetClassLoader(this.previousClassLoader));
        this.previousClassLoader = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.classLoaderIdentifier = (String)fields.get(CLASS_LOADER_IDENTIFIER, null);
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder(100).append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(this.hashCode())).append(' ');
        if (this.classLoaderIdentifier != null) {
            sb.append(this.classLoaderIdentifier);
        } else {
            sb.append(this.classLoaderToPropagate);
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        if (this.classLoaderToPropagate == SYSTEM_CLASS_LOADER) {
            this.classLoaderIdentifier = "";
        } else if (this.classLoaderToPropagate != null) {
            this.classLoaderIdentifier = this.classLoaderContextProvider.getClassLoaderIdentifier(this.classLoaderToPropagate);
            if (this.classLoaderIdentifier == null) {
                throw new NotSerializableException(this.classLoaderToPropagate.getClass().getName());
            }
        }
        ObjectOutputStream.PutField fields = outStream.putFields();
        fields.put(CLASS_LOADER_IDENTIFIER, this.classLoaderIdentifier);
        outStream.writeFields();
    }

    @Trivial
    private class SetClassLoader
    implements PrivilegedAction<Void> {
        private final ClassLoader cl;

        private SetClassLoader(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        @FFDCIgnore(value={SecurityException.class})
        public Void run() {
            Thread t = Thread.currentThread();
            try {
                t.setContextClassLoader(this.cl);
            }
            catch (SecurityException e) {
                if (t instanceof ForkJoinWorkerThread && "InnocuousForkJoinWorkerThreadGroup".equals(t.getThreadGroup().getName())) {
                    throw new SecurityException(Tr.formatMessage((TraceComponent)tc, (String)"cannot.apply.classloader.context", (Object[])new Object[]{t.getName()}), e);
                }
                throw e;
            }
            return null;
        }
    }
}

