/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.util;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.ExtendedTransactionManager;
import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.EventSemaphore;
import com.ibm.tx.jta.impl.LocalTIDTable;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.TranManagerSet;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TxRecoveryAgentImpl;
import com.ibm.tx.jta.impl.UserTransactionImpl;
import com.ibm.tx.jta.util.TxBundleTools;
import com.ibm.tx.util.TMHelper;
import com.ibm.tx.util.TMService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RecLogServiceImpl;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.ws.uow.UOWScopeCallbackAgent;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.tx.UOWEventListener;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TxTMHelper
implements TMService,
UOWScopeCallbackAgent {
    private static final TraceComponent tc = Tr.register(TxTMHelper.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static TMService.TMStates _state = TMService.TMStates.INACTIVE;
    private static TxRecoveryAgentImpl _recoveryAgent;
    protected static final EventSemaphore _asyncRecoverySemaphore;
    protected static RuntimeException _resyncException;
    protected RecLogServiceImpl _recLogService;
    protected RecoveryDirector _recoveryDirector;
    protected boolean _recoverDBLogStarted;
    protected String _recoveryIdentity;
    protected String _recoveryGroup;
    private static boolean _xaResourceFactoryReady;
    private boolean _waitForRecovery;
    private boolean _tmsReady;
    private static boolean _recoveryLogFactoryReady;
    private static RecoveryLogFactory _recoveryLogFactory;
    private static boolean _recoveryLogServiceReady;
    private static boolean _requireDataSourceActive;
    private boolean _localRecoveryFailed;
    protected static BundleContext _bc;

    public static TMService.TMStates getState() {
        return _state;
    }

    public static void setState(TMService.TMStates state) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting state from " + _state + " to " + state), (Object[])new Object[0]);
        }
        _state = state;
    }

    public TxTMHelper() {
        TMHelper.setTMService((TMService)this);
    }

    protected TxTMHelper(boolean dummy) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"NOT Adding shutdown hook", (Object[])new Object[0]);
        }
        TMHelper.setTMService((TMService)this);
    }

    protected void setConfigurationProvider(ConfigurationProvider p) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setConfigurationProvider", (Object[])new Object[]{p});
        }
        try {
            ConfigurationProviderManager.setConfigurationProvider((ConfigurationProvider)p);
            if (_state == TMService.TMStates.STOPPED) {
                this.start();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setConfigurationProvider", (String)"37", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConfigurationProvider");
        }
    }

    protected void unsetConfigurationProvider(ConfigurationProvider p) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetConfigurationProvider", (Object[])new Object[]{p});
        }
        if (p != null && !p.isSQLRecoveryLog()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Logging to a filesytem, shutdown now", (Object[])new Object[0]);
            }
            try {
                this.shutdown();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.TxTMHelper.unsetConfigurationProvider", (String)"138", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetConfigurationProvider");
        }
    }

    protected void setXaResourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setXaResourceFactory", (Object[])new Object[]{"ref " + ref});
        }
        _xaResourceFactoryReady = true;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setXaResourceFactory", (String)"148", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setXaResourceFactory");
        }
    }

    protected void unsetXaResourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetXaResourceFactory, ref " + ref), (Object[])new Object[0]);
        }
    }

    public void setRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setRecoveryLogFactory, factory: " + fac), (Object[])new Object[]{this});
        }
        _recoveryLogFactory = fac;
        _recoveryLogFactoryReady = true;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setRecoveryLogFactory", (String)"206", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryLogFactory");
        }
    }

    public void unsetRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetRecoveryLogFactory, factory: " + fac), (Object[])new Object[]{this});
        }
    }

    public void setRecoveryLogService(ServiceReference<RecLogServiceImpl> ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRecoveryLogService", (Object[])new Object[]{ref});
        }
        this._recLogService = (RecLogServiceImpl)ref.getBundle().getBundleContext().getService(ref);
        _recoveryLogServiceReady = true;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.setRecoveryLogService", (String)"148", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryLogService");
        }
    }

    public void unsetRecoveryLogService(ServiceReference<RecLogServiceImpl> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetRecoveryLogService", (Object[])new Object[]{ref});
        }
    }

    public boolean isProviderInstalled(String providerId) {
        return true;
    }

    public void asynchRecoveryProcessingComplete(Throwable t) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"asynchRecoveryProcessingComplete", (Object[])new Object[]{t});
        }
    }

    public void start(boolean waitForRecovery) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[]{waitForRecovery});
        }
        this.retrieveBundleContext();
        this._tmsReady = true;
        this._waitForRecovery = waitForRecovery;
        if (this.ableToStartRecoveryNow()) {
            try {
                this.startRecovery();
            }
            catch (RecoveryFailedException exc) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Local recovery failed.", (Object[])new Object[0]);
                }
                this._localRecoveryFailed = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.start", (String)"148", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecovery() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startRecovery", (Object[])new Object[0]);
        }
        boolean skipRecovery = false;
        if (this._recoverDBLogStarted) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Tran Logging to an RDBMS, recoveryAgent is: " + _recoveryAgent), (Object[])new Object[0]);
            }
            if (_recoveryAgent != null && _recoveryAgent.isReplayThread()) {
                Tr.debug((TraceComponent)tc, (String)"Thread on which replay will be done - skip recovery processing", (Object[])new Object[0]);
                skipRecovery = true;
            }
        }
        if (!skipRecovery) {
            TxTMHelper txTMHelper = this;
            synchronized (txTMHelper) {
                TMHelper.setTMService((TMService)this);
                ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
                if (cp != null && cp.isSQLRecoveryLog()) {
                    this._recoverDBLogStarted = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Tran Logging to an RDBMS set recoverDBLogStarted flag", (Object[])new Object[0]);
                    }
                }
                if (TxTMHelper.getState() != TMService.TMStates.INACTIVE && TxTMHelper.getState() != TMService.TMStates.STOPPED) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"startRecovery", (Object)"Already started");
                    }
                    return;
                }
                TxTMHelper.setResyncException(null);
                if (this._recLogService != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("We already have a recovery log service: " + this._recLogService), (Object[])new Object[0]);
                    }
                } else {
                    this._recLogService = new RecLogServiceImpl();
                }
                this._recoveryDirector = RecoveryDirectorFactory.createRecoveryDirector();
                if (cp != null) {
                    this._recoveryIdentity = cp.getRecoveryIdentity();
                    this._recoveryGroup = cp.getRecoveryGroup();
                }
                boolean allowRecovery = true;
                if (cp == null) {
                    allowRecovery = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Configuration Provider is null", (Object[])new Object[0]);
                    }
                } else {
                    String sName = cp.getServerName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Retrieved server name " + sName), (Object[])new Object[0]);
                    }
                    if (sName == null || sName.isEmpty()) {
                        allowRecovery = false;
                    }
                }
                if (!allowRecovery) {
                    try {
                        this.shutdown();
                    }
                    catch (RuntimeException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.TxTMHelper.start", (String)"279", (Object)this);
                    }
                    SystemException se = new SystemException();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"startRecovery", (Object)((Object)se));
                    }
                    throw se;
                }
                if (this._recoveryIdentity != null && !this._recoveryIdentity.isEmpty()) {
                    this._recLogService.initialize(this._recoveryIdentity);
                } else {
                    String serverName = null;
                    if (cp != null) {
                        serverName = cp.getServerName();
                    }
                    this._recLogService.initialize(serverName);
                }
                TxRecoveryAgentImpl txAgent = this.createRecoveryAgent(this._recoveryDirector);
                if (this._recoveryGroup != null && !this._recoveryGroup.isEmpty()) {
                    txAgent.setRecoveryGroup(this._recoveryGroup);
                    if (this._recoveryIdentity != null && !this._recoveryIdentity.isEmpty()) {
                        this._recLogService.setPeerRecoverySupported(true);
                        txAgent.setPeerRecoverySupported(true);
                        TransactionImpl.setDisable2PCDefault(false);
                        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Server with identity " + this._recoveryIdentity + " is monitoring its peers for Transaction Peer Recovery"), (Object[])new Object[0]);
                    } else {
                        Tr.audit((TraceComponent)tc, (String)"WTRN0108I: recoveryIdentity is not set. Transaction Peer Recovery is disabled", (Object[])new Object[0]);
                    }
                }
                TxTMHelper.setRecoveryAgent(txAgent);
                RecoveryManager._waitForRecovery = this._waitForRecovery;
                this._recLogService.startRecovery(_recoveryLogFactory);
                TxTMHelper.setState(TMService.TMStates.RECOVERING);
                if (this._waitForRecovery) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for completion of asynchronous recovery", (Object[])new Object[0]);
                    }
                    _asyncRecoverySemaphore.waitEvent();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Asynchronous recovery is complete", (Object[])new Object[0]);
                    }
                    if (_resyncException != null) {
                        try {
                            this.shutdown();
                        }
                        catch (RuntimeException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.util.TxTMHelper.start", (String)"137", (Object)this);
                        }
                        Throwable se = new SystemException().initCause((Throwable)_resyncException);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"startRecovery", (Object)se);
                        }
                        throw (SystemException)se;
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Tran Logging to an RDBMS and we determined that we should skip recovery", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startRecovery");
        }
    }

    private synchronized void shutdown(boolean withCleanup, int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object[])new Object[]{withCleanup, timeout});
        }
        if (_state != TMService.TMStates.STOPPED && _state != TMService.TMStates.INACTIVE) {
            TxTMHelper.setState(TMService.TMStates.STOPPING);
            if (timeout != 0) {
                int timeToWait = timeout;
                int timeSlept = 0;
                while (LocalTIDTable.getAllTransactions().length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("There are " + LocalTIDTable.getAllTransactions().length + " incomplete transactions"), (Object[])new Object[0]);
                    }
                    if (timeout < 0 || timeToWait-- > 0) {
                        try {
                            Thread.sleep(1000L);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Waited " + ++timeSlept + " seconds for transactions to finish"), (Object[])new Object[0]);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Gave up waiting for transactions to finish after " + ++timeSlept + " seconds"), (Object[])new Object[0]);
                    break;
                }
            }
            TransactionImpl[] trans = LocalTIDTable.getAllTransactions();
            if (LocalTIDTable.getAllTransactions().length > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Found " + trans.length + " active transactions."), (Object[])new Object[0]);
                }
                for (int i = 0; i < trans.length; ++i) {
                    TransactionImpl tx = trans[i];
                    int preStatus = tx.getStatus();
                    if (preStatus != 4 && preStatus != 3 && preStatus != 8 && preStatus != 6 && preStatus != 1) {
                        this.rollbackTransaction(tx);
                        int postStatus = tx.getStatus();
                        if (postStatus == 4 || postStatus == 6) {
                            Tr.warning((TraceComponent)tc, (String)"WTRN0034_DURING_SERVER_QUIESCE_TX_ROLLBACK_SUCCEEDED", (Object[])new Object[]{tx.getLocalTID()});
                            continue;
                        }
                        if (postStatus == 1) {
                            Tr.warning((TraceComponent)tc, (String)"WTRN0036_DURING_SERVER_QUIESCE_TX_MARKED_ROLLBACK_ONLY", (Object[])new Object[]{tx.getLocalTID()});
                            continue;
                        }
                        Tr.warning((TraceComponent)tc, (String)"WTRN0035_DURING_SERVER_QUIESCE_TX_ROLLBACK_FAILED", (Object[])new Object[]{tx.getLocalTID()});
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"Tx already committing or rolled back. Skipping.", (Object[])new Object[0]);
                }
            }
            _recoveryAgent.stop(false);
            this._recLogService.stop();
            if (withCleanup) {
                ExtendedTransactionManager tm = TransactionManagerFactory.getTransactionManager();
                ((TranManagerSet)tm).cleanup();
            }
            TxTMHelper.setRecoveryAgent(null);
            RecoveryDirectorFactory.reset();
            LocalTIDTable.clear();
            try {
                _asyncRecoverySemaphore.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TxTMHelper.setResyncException(null);
            _asyncRecoverySemaphore.clear();
            ConfigurationProviderManager.stop((boolean)true);
            TxTMHelper.setState(TMService.TMStates.STOPPED);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    protected static void setRecoveryAgent(TxRecoveryAgentImpl recoveryAgent) {
        _recoveryAgent = recoveryAgent;
    }

    public void shutdown(ConfigurationProvider cp) throws Exception {
        int shutdownDelay = cp != null ? cp.getDefaultMaximumShutdownDelay() : 0;
        this.shutdown(false, shutdownDelay);
    }

    public void shutdown() throws Exception {
        this.shutdown(ConfigurationProviderManager.getConfigurationProvider());
    }

    public void shutdown(int timeout) throws Exception {
        this.shutdown(true, timeout);
    }

    public void start() throws Exception {
        ConfigurationProvider cp;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                Tr.debug((TraceComponent)tc, (String)(" " + ste), (Object[])new Object[0]);
            }
        }
        this.start((cp = ConfigurationProviderManager.getConfigurationProvider()) != null && cp.isWaitForRecovery());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public static synchronized void resyncComplete(RuntimeException r) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resyncComplete", (Object[])new Object[]{r});
        }
        if (_state == TMService.TMStates.RECOVERING) {
            TxTMHelper.setState(TMService.TMStates.ACTIVE);
        }
        TxTMHelper.setResyncException(r);
        _asyncRecoverySemaphore.post();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resyncComplete");
        }
    }

    protected static void setResyncException(RuntimeException r) {
        _resyncException = r;
    }

    public static boolean ready() {
        return _state == TMService.TMStates.ACTIVE || _state == TMService.TMStates.RECOVERING;
    }

    public void checkTMState() throws NotSupportedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTMState", (Object[])new Object[0]);
        }
        if (_state != TMService.TMStates.ACTIVE && _state != TMService.TMStates.RECOVERING) {
            if (_state == TMService.TMStates.INACTIVE) {
                try {
                    TMHelper.start();
                }
                catch (Exception e) {
                    NotSupportedException nse = new NotSupportedException();
                    nse.initCause((Throwable)e);
                    throw nse;
                }
            } else {
                if (_state == TMService.TMStates.STOPPING) {
                    throw new NotSupportedException("JTM is stopping");
                }
                if (_state == TMService.TMStates.STOPPED) {
                    throw new NotSupportedException("JTM is stopped");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTMState");
        }
    }

    @Override
    public void registerCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCallback", (Object[])new Object[]{callback});
        }
        UserTransactionImpl.instance().registerCallback(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    @Override
    public void unregisterCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unregisterCallback", (Object[])new Object[]{callback});
        }
        UserTransactionImpl.instance().unregisterCallback(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregisterCallback");
        }
    }

    public void setUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setUOWEventListener", (Object[])new Object[]{el});
        }
        ((UOWCurrent)((Object)TranManagerSet.instance())).setUOWEventListener(el);
    }

    public void unsetUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetUOWEventListener", (Object[])new Object[]{el});
        }
        try {
            ((UOWCurrent)((Object)TranManagerSet.instance())).unsetUOWEventListener(el);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected TxRecoveryAgentImpl createRecoveryAgent(RecoveryDirector recoveryDirector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoveryAgent", (Object[])new Object[]{recoveryDirector});
        }
        TxRecoveryAgentImpl txAgent = new TxRecoveryAgentImpl(recoveryDirector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoveryAgent", (Object)txAgent);
        }
        return txAgent;
    }

    protected void retrieveBundleContext() {
        BundleContext bc = TxBundleTools.getBundleContext();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("retrieveBundleContext, bc " + bc), (Object[])new Object[0]);
        }
        _bc = bc;
    }

    public static BundleContext getBundleContext() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getBundleContext, bc " + _bc), (Object[])new Object[0]);
        }
        return _bc;
    }

    private boolean ableToStartRecoveryNow() {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ableToStartRecoveryNow", (Object[])new Object[0]);
        }
        boolean recoverNow = false;
        ConfigurationProviderManager.start();
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Working with config provider: " + cp), (Object[])new Object[0]);
        }
        if (cp != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Need to coordinate: " + cp.needToCoordinateServices()), (Object[])new Object[0]);
        }
        if (cp != null && !cp.needToCoordinateServices()) {
            recoverNow = true;
        } else if (this._localRecoveryFailed) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Local recovery has already been marked as failed, do not attempt again", (Object[])new Object[0]);
            }
        } else {
            if (cp != null && cp.isSQLRecoveryLog()) {
                _requireDataSourceActive = true;
            }
            boolean isDataSourceFactorySet = false;
            if (cp != null && cp.isDataSourceFactorySet()) {
                isDataSourceFactorySet = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("_requireRecoveryLogFactory: " + _requireDataSourceActive + ", _waitForRecovery: " + this._waitForRecovery + ", _tmsReady: " + this._tmsReady + ", _recoveryLogServiceReady: " + _recoveryLogServiceReady + ", _dataSourceFactorySet: " + isDataSourceFactorySet + ", _recoveryLogFactoryReady: " + _recoveryLogFactoryReady), (Object[])new Object[0]);
            }
            if (!_requireDataSourceActive) {
                recoverNow = this._waitForRecovery ? this._tmsReady && _xaResourceFactoryReady && _recoveryLogServiceReady && _recoveryLogFactoryReady : this._tmsReady && _recoveryLogServiceReady;
            } else {
                boolean bl = recoverNow = this._tmsReady && _xaResourceFactoryReady && _recoveryLogServiceReady && _recoveryLogFactoryReady && isDataSourceFactorySet;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ableToStartRecoveryNow", (Object)recoverNow);
        }
        return recoverNow;
    }

    private void rollbackTransaction(Transaction tran) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"rollbackTransaction", (Object[])new Object[]{tran});
            }
            try {
                ((TransactionImpl)tran).timeoutTransaction(false);
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.tx.jta.util.impl.TxTMHelper.rollbackTransaction", (String)"831", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught during transaction ROLLBACK!", (Object[])new Object[]{ex});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollbackTransaction");
        }
    }

    static {
        _asyncRecoverySemaphore = new EventSemaphore();
    }
}

