/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.ltc.impl;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.ltc.impl.LocalTranCoordImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.tx.UOWEventListener;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.HashSet;

public class LocalTranCurrentImpl {
    protected static TransactionManager _currentTM = TransactionManagerFactory.getTransactionManager();
    private static HashSet<UOWEventListener> _UOWEventListeners;
    protected LocalTranCoordImpl _coord;
    private static final TraceComponent tc;

    protected LocalTranCurrentImpl() {
    }

    public LocalTransactionCoordinator getLocalTranCoord() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getLocalTranCoord", (Object[])new Object[]{this._coord});
        }
        return this._coord;
    }

    public void begin() throws IllegalStateException {
        this.begin(false);
    }

    public void begin(boolean boundaryIsAS) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"begin", (Object[])new Object[]{boundaryIsAS, this});
        }
        if (this._coord != null) {
            IllegalStateException ise = new IllegalStateException("Cannot begin a LocalTransactionContainment. A LocalTransactionContainment is already active.");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.ltc.LocalTranCurrentImpl.begin", (String)"141", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ERR_BEGIN_LTC_ACT", (Object[])new Object[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"begin", (Object)ise);
            }
            throw ise;
        }
        try {
            this._coord = new LocalTranCoordImpl(boundaryIsAS, this);
        }
        finally {
            this.invokeEventListener(this._coord, 1, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"begin");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(boolean boundaryIsAS, boolean unresActionIsCommit, boolean resolverIsCAB) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"begin", (Object[])new Object[]{boundaryIsAS, unresActionIsCommit, resolverIsCAB, this});
        }
        if (this._coord != null) {
            IllegalStateException ise = new IllegalStateException("Cannot begin a LocalTransactionContainment. A LocalTransactionContainment is already active.");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.ltc.LocalTranCurrentImpl.begin", (String)"205", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ERR_BEGIN_LTC_ACT", (Object[])new Object[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"begin", (Object)ise);
            }
            throw ise;
        }
        try {
            this._coord = new LocalTranCoordImpl(boundaryIsAS, unresActionIsCommit, resolverIsCAB, this);
        }
        finally {
            this.invokeEventListener(this._coord, 1, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"begin");
            }
        }
    }

    public void beginShareable(boolean boundaryIsAS, boolean unresActionIsCommit, boolean resolverIsCAB) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beginShareable", (Object[])new Object[0]);
        }
        this.begin(boundaryIsAS, unresActionIsCommit, resolverIsCAB);
        this._coord.setShareable(true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beginShareable");
        }
    }

    public LocalTransactionCoordinator suspend() {
        LocalTranCoordImpl ltc;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspend", (Object[])new Object[]{this});
        }
        if ((ltc = this._coord) != null) {
            this._coord = null;
            ltc.suspend();
            this.invokeEventListener(ltc, 100, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspend", (Object)ltc);
        }
        return ltc;
    }

    public void resume(LocalTransactionCoordinator ltc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resume", (Object[])new Object[]{ltc, this});
        }
        if (ltc != null && this._coord != null) {
            IllegalStateException ise = new IllegalStateException();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resume", (Object)ise);
            }
            throw ise;
        }
        this._coord = (LocalTranCoordImpl)ltc;
        if (this._coord != null) {
            this._coord.resume(this);
            this.invokeEventListener(this._coord, 110, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume");
        }
    }

    public boolean hasOutstandingWork() {
        boolean retval;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasOutstandingWork", (Object[])new Object[]{this});
        }
        boolean bl = retval = this._coord != null ? this._coord.hasWork() : false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hasOutstandingWork", (Object)retval);
        }
        return retval;
    }

    protected static boolean globalTranExists() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"globalTranExists", (Object[])new Object[0]);
        }
        boolean retval = false;
        try {
            if (_currentTM != null) {
                retval = _currentTM.getTransaction() != null;
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"globalTranExists", (Object)retval);
        }
        return retval;
    }

    public void complete(int endMode) throws InconsistentLocalTranException, RolledbackException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"complete", (Object[])new Object[]{endMode, this});
        }
        if (this._coord == null) {
            IllegalStateException ise = new IllegalStateException("No LocalTransactionCoordinator to complete.");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.ltc.LocalTranCurrentImpl.complete", (String)"382", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ERR_NO_LTC_COMPLETE", (Object[])new Object[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"complete", (Object)ise);
            }
            throw ise;
        }
        try {
            this._coord.complete(endMode);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"complete");
            }
        }
    }

    public void cleanup() throws InconsistentLocalTranException, IllegalStateException, RolledbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup", (Object[])new Object[]{this});
        }
        if (this._coord == null) {
            IllegalStateException ise = new IllegalStateException("No LocalTransactionCoordinator to cleanup.");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.ltc.LocalTranCurrentImpl.cleanup", (String)"421", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ERR_NO_LTC_CLEANUP", (Object[])new Object[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cleanup", (Object)ise);
            }
            throw ise;
        }
        try {
            this._coord.cleanup();
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cleanup");
            }
        }
    }

    public void end(int endMode) throws InconsistentLocalTranException, RolledbackException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"end", (Object[])new Object[]{endMode, this});
        }
        if (this._coord == null) {
            IllegalStateException ise = new IllegalStateException("No LocalTransactionCoordinator to end.");
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.tx.ltc.LocalTranCurrentImpl.end", (String)"469", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ERR_NO_LTC_CLEANUP", (Object[])new Object[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"end", (Object)ise);
            }
            throw ise;
        }
        try {
            this._coord.end(endMode);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"end");
            }
        }
    }

    void setCoordinator(LocalTranCoordImpl ltc) {
        this._coord = ltc;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCoordinator: LTC=" + ltc), (Object[])new Object[0]);
        }
    }

    public UOWCoordinator getUOWCoord() {
        UOWCoordinator uow;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWCoord", (Object[])new Object[]{this});
        }
        if ((uow = this._coord) == null && _currentTM != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getting possible global transaction", (Object[])new Object[]{_currentTM});
            }
            try {
                uow = (UOWCoordinator)_currentTM.getTransaction();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWCoord", (Object)uow);
        }
        return uow;
    }

    public static synchronized void setUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setUOWEventListener", (Object[])new Object[]{el});
        }
        if (_UOWEventListeners == null) {
            _UOWEventListeners = new HashSet();
        }
        _UOWEventListeners.add(el);
    }

    public static synchronized void unsetUOWEventListener(UOWEventListener el) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetUOWEventListener", (Object[])new Object[]{el});
        }
        if (_UOWEventListeners != null) {
            _UOWEventListeners.remove(el);
        }
    }

    protected synchronized void invokeEventListener(UOWCoordinator uowc, int event, Object data) {
        if (_UOWEventListeners != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invokeEventListener", (Object[])new Object[]{uowc, event, data});
            }
            for (UOWEventListener el : _UOWEventListeners) {
                el.UOWEvent(uowc, event, data);
            }
        }
    }

    static {
        tc = Tr.register(LocalTranCurrentImpl.class, (String)"Transaction", (String)"com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");
    }
}

