/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.HomeOfHomes;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ejbcontainer.EJBFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import com.ibm.ws.ffdc.FFDCFilter;
import jakarta.ejb.EJBException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;

public class EJBLinkResolver
implements EJBFactory {
    private static final String CLASS_NAME = EJBLinkResolver.class.getName();
    private static final TraceComponent tc = Tr.register(EJBLinkResolver.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private HomeOfHomes homeOfHomes;
    private J2EENameFactory j2eeNameFactory;

    public EJBLinkResolver initialize(HomeOfHomes homeOfHomes, J2EENameFactory j2eeNameFactory) {
        this.homeOfHomes = homeOfHomes;
        this.j2eeNameFactory = j2eeNameFactory;
        return this;
    }

    @Override
    public Object create(String application, String beanName, String interfaceName) throws EJBException, RemoteException {
        if (application == null) {
            throw new IllegalArgumentException("Application name not specified");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("Bean name not specified");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("Interface name not specified");
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("create : application = " + application + ", beanName = " + beanName + ", interface = " + interfaceName), (Object[])new Object[0]);
        }
        EJSHome home = null;
        try {
            HomeRecord hr = this.homeOfHomes.resolveEJBLink(application, null, beanName);
            home = hr.getHomeAndInitialize();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".create"), (String)"186", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure locating " + beanName, ex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("create: " + ejbex));
            }
            throw ejbex;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("home = " + home.getJ2EEName()), (Object[])new Object[0]);
        }
        Object retObj = this.create(home, interfaceName);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("create : " + retObj.getClass().getName()));
        }
        return retObj;
    }

    @Override
    public Object create(String application, String module, String beanName, String interfaceName) throws EJBException, RemoteException {
        if (application == null) {
            throw new IllegalArgumentException("Application name not specified");
        }
        if (module == null) {
            throw new IllegalArgumentException("Module name not specified");
        }
        if (!module.endsWith(".jar") && !module.endsWith(".war")) {
            throw new IllegalArgumentException("Module must be a .jar or .war file");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("Bean name not specified");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("Interface name not specified");
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("create : application = " + application + ", module = " + module + ", bean = " + beanName + ", interface = " + interfaceName), (Object[])new Object[0]);
        }
        Object retObj = null;
        EJSHome home = null;
        J2EEName j2eeName = null;
        try {
            j2eeName = this.j2eeNameFactory.create(application, module, beanName);
            home = (EJSHome)this.homeOfHomes.getHome(j2eeName);
            if (home == null) {
                throw new EJBNotFoundException("EJB named " + beanName + " not present in module " + module + " of application " + application);
            }
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".create"), (String)"182", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure locating " + j2eeName, ex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("create: " + ejbex));
            }
            throw ejbex;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("home = " + home.getJ2EEName()), (Object[])new Object[0]);
        }
        retObj = this.create(home, interfaceName);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("create : " + retObj.getClass().getName()));
        }
        return retObj;
    }

    private Object create(EJSHome home, String interfaceName) throws EJBException, RemoteException {
        BeanMetaData bmd = home.getBeanMetaData();
        if (interfaceName.equals(bmd.localHomeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"match on local home", (Object[])new Object[0]);
            }
            return home.getWrapper().getLocalObject();
        }
        if (interfaceName.equals(bmd.homeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"match on remote home", (Object[])new Object[0]);
            }
            return this.getRemoteHomeReference(home, interfaceName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"looking for match on business interface", (Object[])new Object[0]);
        }
        return this.createBusinessObject(home, bmd, interfaceName, true);
    }

    @Override
    public Object findByBeanName(String application, String beanName, String interfaceName) throws EJBException, RemoteException {
        if (application == null) {
            throw new IllegalArgumentException("Application name not specified");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("Bean name not specified");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("Interface name not specified");
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findByBeanName : App = " + application + ", bean = " + beanName + ", interface = " + interfaceName), (Object[])new Object[0]);
        }
        Object retObj = null;
        EJSHome home = null;
        try {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"looking for home in all app modules...", (Object[])new Object[0]);
            }
            home = this.homeOfHomes.getHomeByName(application, beanName);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".findByBeanName"), (String)"182", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure locating bean " + beanName + " in application " + application, ex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("findByBeanName: " + ejbex));
            }
            throw ejbex;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("home = " + home.getJ2EEName()), (Object[])new Object[0]);
        }
        BeanMetaData bmd = home.getBeanMetaData();
        if (interfaceName.equals(bmd.localHomeInterfaceClassName)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"match on local home", (Object[])new Object[0]);
            }
            retObj = home.getWrapper().getLocalObject();
        } else if (interfaceName.equals(bmd.homeInterfaceClassName)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"match on remote home", (Object[])new Object[0]);
            }
            retObj = this.getRemoteHomeReference(home, interfaceName);
        } else {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"looking for match on business interface", (Object[])new Object[0]);
            }
            retObj = this.createBusinessObject(home, bmd, interfaceName, true);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findByBeanName : " + retObj.getClass().getName()));
        }
        return retObj;
    }

    @Override
    public Object findByInterface(String application, String interfaceName) throws EJBException, RemoteException {
        if (application == null) {
            throw new IllegalArgumentException("Application name not specified");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("Interface name not specified");
        }
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findByInterface : App = " + application + ", interface = " + interfaceName), (Object[])new Object[0]);
        }
        Object retObj = null;
        EJSHome home = null;
        try {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bean name not specified, auto-link on " + interfaceName), (Object[])new Object[0]);
            }
            home = this.homeOfHomes.getHomeByInterface(application, null, interfaceName);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".findByInterface"), (String)"182", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure locating interface " + interfaceName + " in application " + application, ex);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("findByInterface: " + ejbex));
            }
            throw ejbex;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("home = " + home.getJ2EEName()), (Object[])new Object[0]);
        }
        BeanMetaData bmd = home.getBeanMetaData();
        if (interfaceName.equals(bmd.localHomeInterfaceClassName)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"match on local home", (Object[])new Object[0]);
            }
            retObj = home.getWrapper().getLocalObject();
        } else if (interfaceName.equals(bmd.homeInterfaceClassName)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"match on remote home", (Object[])new Object[0]);
            }
            retObj = this.getRemoteHomeReference(home, interfaceName);
        } else {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"looking for match on business interface", (Object[])new Object[0]);
            }
            retObj = this.createBusinessObject(home, bmd, interfaceName, false);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findByInterface : " + retObj.getClass().getName()));
        }
        return retObj;
    }

    private Object createBusinessObject(EJSHome home, BeanMetaData bmd, String interfaceName, boolean ejblink) throws EJBException, NoSuchObjectException {
        Object retObj = null;
        try {
            retObj = home.createBusinessObject(interfaceName, ejblink);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".createBusinessObject"), (String)"281", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure creating instance of " + home.getJ2EEName() + " of type " + interfaceName, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("createBusinessObject: " + ejbex), (Object[])new Object[0]);
            }
            throw ejbex;
        }
        if (retObj == null) {
            EJBException ejbex = new EJBException("Unable to create instance of " + home.getJ2EEName() + " of type " + interfaceName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("createBusinessObject: " + ejbex), (Object[])new Object[0]);
            }
            throw ejbex;
        }
        return retObj;
    }

    private Object getRemoteHomeReference(EJSHome home, String interfaceName) throws EJBException, NoSuchObjectException {
        Object retObj = null;
        try {
            this.checkHomeSupported(home, interfaceName);
            EJBRuntime runtime = home.getContainer().getEJBRuntime();
            runtime.checkRemoteSupported(home, interfaceName);
            EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
            retObj = runtime.getRemoteReference(wrapper);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getRemoteHomeReference"), (String)"281", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure obtaining remote home reference of " + home.getJ2EEName() + " of type " + interfaceName, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteHomeReference: " + ejbex), (Object[])new Object[0]);
            }
            throw ejbex;
        }
        if (retObj == null) {
            EJBException ejbex = new EJBException("Unable to obtain remote reference of " + home.getJ2EEName() + " of type " + interfaceName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteHomeReference: " + ejbex), (Object[])new Object[0]);
            }
            throw ejbex;
        }
        return retObj;
    }

    protected void checkHomeSupported(EJSHome home, String homeInterface) throws EJBNotFoundException {
    }
}

