/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanNotReentrantException;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.CreateFailureException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.ExceptionMappingStrategy;
import com.ibm.ejs.container.InvalidTransactionLocalException;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIInvalidTransactionException;
import com.ibm.websphere.csi.CSINoSuchObjectException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.OrbUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import jakarta.ejb.AccessLocalException;
import jakarta.ejb.ConcurrentAccessException;
import jakarta.ejb.ConcurrentAccessTimeoutException;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEJBException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.TransactionRequiredLocalException;
import jakarta.ejb.TransactionRolledbackLocalException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.TransactionRequiredException;
import jakarta.transaction.TransactionRolledbackException;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;

public class RemoteExceptionMappingStrategy
extends ExceptionMappingStrategy {
    private static final String CLASS_NAME = RemoteExceptionMappingStrategy.class.getName();
    private static final TraceComponent tc = Tr.register(RemoteExceptionMappingStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    static final ExceptionMappingStrategy INSTANCE = new RemoteExceptionMappingStrategy();

    private RemoteExceptionMappingStrategy() {
    }

    private static OrbUtils getOrbUtils() {
        return EJSContainer.getDefaultContainer().getOrbUtils();
    }

    private Throwable mapException(EJSDeployedSupport s, RemoteException ex) {
        try {
            if (ex instanceof CSIException) {
                CSIException csiex = (CSIException)ex;
                return this.mapCSIException(s, csiex);
            }
            if (ex.detail instanceof CSIException) {
                CSIException csiex = (CSIException)ex.detail;
                return this.mapCSIException(s, csiex);
            }
            if (ex instanceof CreateFailureException) {
                if (!s.ivWrapper.ivInterface.ivORB) {
                    return ex;
                }
                return RemoteExceptionMappingStrategy.getOrbUtils().mapException(ex);
            }
            if (ex instanceof BeanNotReentrantException && (s.ivWrapper.ivInterface == WrapperInterface.BUSINESS_RMI_REMOTE || s.ivWrapper.ivInterface == WrapperInterface.SERVICE_ENDPOINT)) {
                BeanNotReentrantException bnre = (BeanNotReentrantException)ex;
                ConcurrentAccessTimeoutException caex = bnre.isTimeout() ? new ConcurrentAccessTimeoutException(ex.getMessage()) : new ConcurrentAccessException(ex.getMessage());
                caex.setStackTrace(ex.getStackTrace());
                s.rootEx = caex;
                return this.mapEJBException(s, (EJBException)caex);
            }
            if (ex.detail instanceof EJBException) {
                EJBException ejbex = (EJBException)ex.detail;
                return this.mapEJBException(s, ejbex);
            }
            if (!s.ivWrapper.ivInterface.ivORB) {
                return ex;
            }
            return RemoteExceptionMappingStrategy.getOrbUtils().mapException(ex);
        }
        catch (CSIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".mapException"), (String)"119", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_MAP_EXCEPTION_CNTR0013W", (Object[])new Object[]{ex, e});
            return ex;
        }
    }

    @Override
    public final Throwable setUncheckedException(EJSDeployedSupport s, Throwable ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setUncheckedException in param:" + ex), (Object[])new Object[0]);
        }
        if (s.ivException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"setting unchecked exception again", (Object[])new Object[]{ex});
                Tr.event((TraceComponent)tc, (String)"original exception", (Object[])new Object[]{s.ivException});
            }
            return s.ivException;
        }
        Boolean applicationExceptionRollback = null;
        int moduleVersion = s.ivWrapper.bmd.ivModuleVersion;
        if (moduleVersion >= 30 && ex instanceof Exception && !(ex instanceof RemoteException)) {
            applicationExceptionRollback = s.getApplicationExceptionRollback(ex);
        }
        if (applicationExceptionRollback != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"ApplicationException with rollback set to true, changing to a checked exception", (Object[])new Object[]{ex});
            }
            s.exType = ExceptionType.CHECKED_EXCEPTION;
            s.ivException = ex;
            s.rootEx = ex;
            if (applicationExceptionRollback == Boolean.TRUE) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"ApplicationException with rollback set to true, setting rollback only", (Object[])new Object[]{ex});
                }
                s.currentTx.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("setUncheckedException returning: " + s.ivException));
            }
            return s.ivException;
        }
        if (s.preInvokeException && (ex instanceof NoSuchObjectException || ex instanceof NoSuchEJBException || ex instanceof CSIAccessException || ex instanceof BeanNotReentrantException)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception should not cause rollback, changing to checked exception", (Object[])new Object[0]);
            }
            if (ex instanceof BeanNotReentrantException) {
                s.beanO = null;
            } else if (ex instanceof NoSuchEJBException) {
                StackTraceElement[] stack = ex.getStackTrace();
                ex = new NoSuchObjectException(ExceptionUtil.getBaseMessage(ex));
                ex.setStackTrace(stack);
            }
            s.exType = ExceptionType.CHECKED_EXCEPTION;
        } else if (EJSContainer.defaultContainer == null) {
            s.exType = ExceptionType.UNCHECKED_EXCEPTION;
            ex = new RemoteException("The Enterprise JavaBeans (EJB) features have been deactivated. No further EJB processing is allowed");
            ExceptionUtil.logException(tc, ex, s.getEJBMethodMetaData(), s.getBeanO());
        } else {
            s.exType = ExceptionType.UNCHECKED_EXCEPTION;
            ExceptionUtil.logException(tc, ex, s.getEJBMethodMetaData(), s.getBeanO());
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".setUncheckedException"), (String)"200", (Object)this);
        }
        s.rootEx = this.findRootCause(ex);
        if (!(ex instanceof RemoteException)) {
            ex = new RemoteException("", ex);
            ex.setStackTrace(s.rootEx.getStackTrace());
        }
        s.ivException = this.mapException(s, (RemoteException)ex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setUncheckedException returning : " + s.ivException));
        }
        s.ivException.setStackTrace(s.rootEx.getStackTrace());
        return s.ivException;
    }

    private Exception mapCSIException(EJSDeployedSupport s, CSIException e) throws CSIException {
        Throwable rex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapCSIException: " + e), (Object[])new Object[0]);
        }
        Throwable mappedException = null;
        String message = " ";
        if (e instanceof CSITransactionRolledbackException) {
            rex = e.detail instanceof HeuristicMixedException ? new RemoteException("", e.detail) : (ContainerProperties.IncludeNestedExceptionsExtended && (s.began || ContainerProperties.AllowSpecViolationOnRollback) && e.detail instanceof HeuristicRollbackException ? new RemoteException("", e.detail) : new TransactionRolledbackException(message));
        } else if (e instanceof CSIAccessException) {
            rex = new AccessException(message);
        } else if (e instanceof CSIInvalidTransactionException) {
            rex = new InvalidTransactionException(message);
        } else if (e instanceof CSITransactionRequiredException) {
            rex = new TransactionRequiredException(message);
        } else if (e instanceof CSINoSuchObjectException) {
            rex = new NoSuchObjectException(message);
        } else {
            e.detail = null;
            rex = new RemoteException(e.getMessage());
        }
        if (ContainerProperties.IncludeNestedExceptions) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nested exceptions will be included on rollback when possible. " + rex + ": " + s.began), (Object[])new Object[0]);
            }
            if (rex instanceof TransactionRolledbackException && (s.began || ContainerProperties.AllowSpecViolationOnRollback)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Transaction was begun in context of this bean method, or the user allows the spec to be violated (ContainerProperties.AllowSpecViolationOnRollback=" + ContainerProperties.AllowSpecViolationOnRollback + ")."), (Object[])new Object[0]);
                }
                rex = new RemoteException("", rex);
            }
        }
        ((RemoteException)rex).detail = s.rootEx;
        rex.setStackTrace(s.rootEx.getStackTrace());
        if (s.ivWrapper.ivInterface.ivORB) {
            int minorCode;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mapCSIException calling OrbUtils.mapException: " + rex), (Object[])new Object[0]);
            }
            mappedException = (minorCode = e.getMinorCode()) == 0 ? RemoteExceptionMappingStrategy.getOrbUtils().mapException((RemoteException)rex) : RemoteExceptionMappingStrategy.getOrbUtils().mapException((RemoteException)rex, minorCode);
        } else {
            mappedException = rex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapCSIException returning: " + mappedException));
        }
        return mappedException;
    }

    @Override
    public Exception mapCSITransactionRolledBackException(EJSDeployedSupport s, CSITransactionRolledbackException ex) throws CSIException {
        if (s.rootEx == null) {
            s.rootEx = ExceptionUtil.findRootCause(ex);
        }
        Exception mappedEx = this.mapCSIException(s, ex);
        mappedEx.setStackTrace(s.rootEx.getStackTrace());
        return mappedEx;
    }

    private Exception mapEJBException(EJSDeployedSupport s, EJBException e) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mapEJBException: " + (Object)((Object)e)), (Object[])new Object[0]);
        }
        Throwable mappedException = null;
        String message = " ";
        Object rex = e instanceof TransactionRolledbackLocalException ? new TransactionRolledbackException(message) : (e instanceof AccessLocalException ? new AccessException(message) : (e instanceof InvalidTransactionLocalException ? new InvalidTransactionException(message) : (e instanceof NoSuchObjectLocalException ? new NoSuchObjectException(message) : (e instanceof TransactionRequiredLocalException ? new TransactionRequiredException(message) : new RemoteException(message)))));
        ((RemoteException)rex).detail = s.rootEx;
        ((Throwable)rex).setStackTrace(s.rootEx.getStackTrace());
        if (s.ivWrapper.ivInterface.ivORB) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mapEJBException calling OrbUtils.mapException: " + rex), (Object[])new Object[0]);
            }
            mappedException = RemoteExceptionMappingStrategy.getOrbUtils().mapException((RemoteException)rex);
        } else {
            mappedException = rex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("mapEJBException returning: " + mappedException));
        }
        return mappedException;
    }
}

