/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerAS;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBThreadData;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.StatefulActivateTranActivationStrategy;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.failover.SfFailoverCache;
import com.ibm.ws.ffdc.FFDCFilter;
import jakarta.transaction.TransactionRolledbackException;
import java.rmi.RemoteException;

public class StatefulASActivationStrategy
extends StatefulActivateTranActivationStrategy {
    private static final String CLASS_NAME = StatefulASActivationStrategy.class.getName();
    private static final TraceComponent tc = Tr.register(StatefulASActivationStrategy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    public StatefulASActivationStrategy(Activator activator, PassivationPolicy policy, SfFailoverCache failoverCache) {
        super(activator, policy, failoverCache);
    }

    @Override
    BeanO atCreate(ContainerTx tx, BeanO bean) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atCreate (" + tx + ", " + bean + ")"), (Object[])new Object[0]);
        }
        ContainerAS as = tx.getContainerAS();
        super.atCreate(tx, bean);
        if (as != null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("atCreate : running in AS : " + as), (Object[])new Object[0]);
            }
            bean.setContainerTx(tx);
            if (as.enlist(bean)) {
                this.cache.pinElement(((StatefulBeanO)bean).ivCacheElement);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atCreate : null");
        }
        return null;
    }

    @Override
    BeanO atActivate(EJBThreadData threadData, ContainerTx tx, BeanId beanId) throws RemoteException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atActivate (" + tx + ", " + beanId + ")"), (Object[])new Object[0]);
        }
        ContainerAS as = tx.getContainerAS();
        BeanO bean = super.atActivate(threadData, tx, beanId);
        if (as != null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("atActivate : running in AS : " + as), (Object[])new Object[0]);
            }
            bean.setContainerTx(tx);
            if (!as.enlist(bean)) {
                this.cache.unpinElement(((StatefulBeanO)bean).ivCacheElement);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("atActivate : " + bean));
        }
        return bean;
    }

    @Override
    void atCommit(ContainerTx tx, BeanO bean) {
        ContainerAS as;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atCommit (" + tx + ", " + bean + ")"), (Object[])new Object[0]);
        }
        if ((as = ContainerAS.getContainerAS(tx)) == null || !as.isEnlisted(bean.getId())) {
            super.atCommit(tx, bean);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"atCommit");
            }
            return;
        }
        this.resetBeanOContainerTx(bean);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBeanOContainerTx(BeanO bean) {
        Object lock;
        StatefulBeanO sfbean = (StatefulBeanO)bean;
        Object object = lock = sfbean.ivCacheLock;
        synchronized (object) {
            if (bean.ivCacheKey != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resetBeanOContainerTx : " + sfbean), (Object[])new Object[0]);
                }
                this.cache.unpinElement(sfbean.ivCacheElement);
                sfbean.setContainerTx(null);
                sfbean.unlock(lock);
            }
        }
    }

    @Override
    void atRollback(ContainerTx tx, BeanO bean) {
        ContainerAS as;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atRollback (" + tx + ", " + bean + ")"), (Object[])new Object[0]);
        }
        if ((as = ContainerAS.getContainerAS(tx)) == null || !as.isEnlisted(bean.getId())) {
            super.atRollback(tx, bean);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"atRollback");
            }
            return;
        }
        this.resetBeanOContainerTx(bean);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atRollback");
        }
    }

    @Override
    void atEnlist(ContainerTx tx, BeanO bean) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atEnlist (" + tx + ", " + bean + ")"), (Object[])new Object[0]);
        }
        ContainerAS as = ContainerAS.getContainerAS(tx);
        super.atEnlist(tx, bean);
        if (as != null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("atEnlist : running in AS : " + as), (Object[])new Object[0]);
            }
            bean.setContainerTx(tx);
            as.enlist(bean);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atEnlist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void atPostInvoke(ContainerTx tx, BeanO bean) {
        Object lock;
        ContainerAS as;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atPostInvoke (" + tx + ", " + bean + ")"), (Object[])new Object[0]);
        }
        if ((as = ContainerAS.getContainerAS(tx)) == null || !as.isEnlisted(bean.getId())) {
            super.atPostInvoke(tx, bean);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"atPostInvoke");
            }
            return;
        }
        StatefulBeanO sfbean = (StatefulBeanO)bean;
        BeanId id = bean.getId();
        Object object = lock = sfbean.ivCacheLock;
        synchronized (object) {
            if (bean.ivCacheKey != null) {
                if (bean.isRemoved() || bean.isDiscarded()) {
                    this.cache.unpinElement(sfbean.ivCacheElement);
                    if (tx != null) {
                        try {
                            tx.delist(bean);
                        }
                        catch (TransactionRolledbackException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".atPostInvoke"), (String)"258", (Object)this);
                            Tr.debug((TraceComponent)tc, (String)"atPostInvoke : transaction has rolledback", (Object[])new Object[0]);
                        }
                    }
                    bean.setContainerTx(null);
                    as.delist(bean);
                    this.cache.removeElement(sfbean.ivCacheElement, true);
                    sfbean.destroy();
                    bean.ivCacheKey = null;
                    this.reaper.remove(id);
                } else {
                    sfbean.setLastAccessTime(System.currentTimeMillis());
                }
                sfbean.unlock(lock);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atPostInvoke");
        }
    }

    @Override
    void atDiscard(BeanO bean) throws RemoteException {
        ContainerAS as;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atDiscard (" + bean + ")"), (Object[])new Object[0]);
        }
        if ((as = ContainerAS.getCurrentContainerAS()) == null || !as.isEnlisted(bean.getId())) {
            super.atDiscard(bean);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"atDiscard");
            }
            return;
        }
        try {
            BeanId beanId = ((StatefulBeanO)bean).getId();
            StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
            if (!statefulBeanO.isTimedOut()) {
                as.delist(bean);
                bean.setContainerTx(null);
                bean.ivCacheKey = null;
                bean.passivate();
            } else {
                Tr.event((TraceComponent)tc, (String)"Discarding session bean", (Object[])new Object[]{bean});
                this.reaper.remove(beanId);
                statefulBeanO.destroy();
                bean.ivCacheKey = null;
            }
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".atDiscard"), (String)"484", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object[])new Object[]{bean, this, e});
            throw e;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atDiscard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void atUnitOfWorkEnd(ContainerAS as, BeanO bean) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("atUnitOfWorkEnd (" + as + ", " + bean + ")"), (Object[])new Object[0]);
        }
        if (as == null || !as.isEnlisted(bean.getId())) {
            super.atUnitOfWorkEnd(as, bean);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"atUnitOfWorkEnd");
            }
            return;
        }
        Object key = bean.ivCacheKey;
        StatefulBeanO sfbean = null;
        Object object = this.locks.getLock(key);
        synchronized (object) {
            sfbean = (StatefulBeanO)this.cache.find(key);
            if (sfbean != null) {
                this.cache.unpin(key);
                if (!sfbean.isRemoved() && sfbean.getState() != 4) {
                    try {
                        this.cache.remove(key, true);
                        sfbean.ivCacheKey = null;
                        bean.setContainerTx(null);
                        sfbean.passivate();
                    }
                    catch (IllegalOperationException ioe) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Ignoring IllegalOperationException.", (Object[])new Object[0]);
                        }
                        this.cache.unpin(key);
                    }
                    catch (RemoteException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".atUnitOfWorkEnd"), (String)"64", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object[])new Object[]{bean, this, ex});
                    }
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Bean not found in cache", (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"atUnitOfWorkEnd");
        }
    }
}

