/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.security.AccessController;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.concurrent.ContextualScheduledExecutorService;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
class SseEventSourceScheduler {
    private final ContextualScheduledExecutorService scheduledExecutorService;
    private final Phaser phaser;
    private final AtomicBoolean closed;
    static final long serialVersionUID = -6808574189345143355L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    SseEventSourceScheduler(ScheduledExecutorService scheduledExecutorService, String threadName) {
        this.scheduledExecutorService = scheduledExecutorService == null ? ContextualExecutors.scheduledThreadPool(1, new DaemonThreadFactory(threadName)) : ContextualExecutors.wrap(scheduledExecutorService, true);
        this.phaser = new Phaser(1);
        this.closed = new AtomicBoolean(false);
    }

    void schedule(final Runnable runnable, long delay, TimeUnit unit) throws RejectedExecutionException {
        if (this.closed.get()) {
            return;
        }
        try {
            this.scheduledExecutorService.schedule(new Runnable(){
                static final long serialVersionUID = -7603667865698942676L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    if (SseEventSourceScheduler.this.closed.get()) {
                        return;
                    }
                    int registrationPhase = SseEventSourceScheduler.this.phaser.register();
                    try {
                        if (registrationPhase != 0) {
                            return;
                        }
                        runnable.run();
                    }
                    finally {
                        SseEventSourceScheduler.this.phaser.arriveAndDeregister();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceScheduler$1", 1.class, null, null);
                }
            }, delay, unit);
        }
        catch (RejectedExecutionException e) {
            if (!this.scheduledExecutorService.isManaged() && this.closed.get()) {
                return;
            }
            throw e;
        }
    }

    boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.closed.get()) {
            return false;
        }
        try {
            this.phaser.awaitAdvanceInterruptibly(0, timeout, unit);
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    void shutdownNow() {
        if (this.closed.compareAndSet(false, true)) {
            this.phaser.arriveAndDeregister();
            if (!this.scheduledExecutorService.isManaged()) {
                if (System.getSecurityManager() == null) {
                    this.scheduledExecutorService.shutdownNow();
                } else {
                    AccessController.doPrivileged(() -> {
                        this.scheduledExecutorService.shutdownNow();
                        return null;
                    });
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceScheduler", SseEventSourceScheduler.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        static final long serialVersionUID = 96567929918624599L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DaemonThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            return t;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceScheduler$DaemonThreadFactory", DaemonThreadFactory.class, null, null);
        }
    }
}

