/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.security.AccessController;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseHeaders;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class HttpServletResponseWrapper
implements HttpResponse {
    protected final HttpServletResponse response;
    protected int status = 200;
    protected MultivaluedMap<String, Object> outputHeaders;
    protected final ResteasyProviderFactory factory;
    private OutputStream outputStream;
    protected volatile boolean suppressExceptionDuringChunkedTransfer = true;
    protected final HttpServletRequest request;
    protected final Map<Class<?>, Object> contextDataMap;
    static final long serialVersionUID = -4073569807300225907L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public void setSuppressExceptionDuringChunkedTransfer(boolean suppressExceptionDuringChunkedTransfer) {
        this.suppressExceptionDuringChunkedTransfer = suppressExceptionDuringChunkedTransfer;
    }

    @Override
    public boolean suppressExceptionDuringChunkedTransfer() {
        return this.suppressExceptionDuringChunkedTransfer;
    }

    public HttpServletResponseWrapper(HttpServletResponse response, HttpServletRequest request, ResteasyProviderFactory factory) {
        this.response = response;
        this.request = request;
        this.outputHeaders = new HttpServletResponseHeaders(response, factory);
        this.factory = factory;
        this.contextDataMap = ResteasyContext.getContextDataMap();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
        this.response.setStatus(status);
    }

    @Override
    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new DeferredOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public synchronized void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    @Override
    public void sendError(int status) throws IOException {
        this.response.sendError(status);
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        this.response.sendError(status, message);
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void reset() {
        this.response.reset();
        this.outputHeaders = new HttpServletResponseHeaders(this.response, this.factory);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper", HttpServletResponseWrapper.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class AsyncOperationComparator
    implements Comparator<AsyncOperation> {
        static final AsyncOperationComparator INSTANCE;
        static final long serialVersionUID = -7890012819148603045L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AsyncOperationComparator() {
        }

        @Override
        public int compare(AsyncOperation o1, AsyncOperation o2) {
            return Long.compare(o1.id, o2.id);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$AsyncOperationComparator", AsyncOperationComparator.class, null, null);
            INSTANCE = new AsyncOperationComparator();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class WrappedServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegate;
        private final boolean usePrivilegedAction;
        static final long serialVersionUID = -5626151619739210207L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private WrappedServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
            this.usePrivilegedAction = System.getSecurityManager() != null;
        }

        public void print(String s) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.print(s));
            } else {
                this.delegate.print(s);
            }
        }

        public void print(boolean b) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.print(b));
            } else {
                this.delegate.print(b);
            }
        }

        public void print(char c) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.print(c));
            } else {
                this.delegate.print(c);
            }
        }

        public void print(int i) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.print(i));
            } else {
                this.delegate.print(i);
            }
        }

        public void print(long l) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.print(l));
            } else {
                this.delegate.print(l);
            }
        }

        public void print(float f) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.print(f));
            } else {
                this.delegate.print(f);
            }
        }

        public void print(double d) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.print(d));
            } else {
                this.delegate.print(d);
            }
        }

        public void println() throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> ((ServletOutputStream)this.delegate).println());
            } else {
                this.delegate.println();
            }
        }

        public void println(String s) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.println(s));
            } else {
                this.delegate.println(s);
            }
        }

        public void println(boolean b) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.println(b));
            } else {
                this.delegate.println(b);
            }
        }

        public void println(char c) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.println(c));
            } else {
                this.delegate.println(c);
            }
        }

        public void println(int i) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.println(i));
            } else {
                this.delegate.println(i);
            }
        }

        public void println(long l) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.println(l));
            } else {
                this.delegate.println(l);
            }
        }

        public void println(float f) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.println(f));
            } else {
                this.delegate.println(f);
            }
        }

        public void println(double d) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.println(d));
            } else {
                this.delegate.println(d);
            }
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.write(b));
            } else {
                this.delegate.write(b);
            }
        }

        public void write(byte[] b) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.write(b));
            } else {
                this.delegate.write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.write(b, off, len));
            } else {
                this.delegate.write(b, off, len);
            }
        }

        public void flush() throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.flush());
            } else {
                this.delegate.flush();
            }
        }

        public void close() throws IOException {
            if (this.usePrivilegedAction) {
                this.doPrivileged(() -> this.delegate.close());
            } else {
                this.delegate.close();
            }
        }

        private void doPrivileged(IoInvoker invoker) throws IOException {
            try {
                AccessController.doPrivileged(() -> {
                    try {
                        invoker.invoke();
                        return null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$WrappedServletOutputStream", WrappedServletOutputStream.class, null, null);
        }

        @FunctionalInterface
        private static interface IoInvoker {
            public void invoke() throws IOException;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class DeferredOutputStream
    extends AsyncOutputStream
    implements WriteListener {
        private final Queue<AsyncOperation> asyncQueue = new PriorityQueue<AsyncOperation>(AsyncOperationComparator.INSTANCE);
        private final AtomicBoolean asyncRegistered = new AtomicBoolean();
        private volatile boolean asyncListenerCalled;
        private volatile ServletOutputStream lazyOut;
        private long idCounter;
        static final long serialVersionUID = -4747524465304221019L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DeferredOutputStream() throws IOException {
        }

        @Override
        public void write(int i) throws IOException {
            this.getServletOutputStream().write(i);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.getServletOutputStream().write(bytes);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            this.getServletOutputStream().write(bytes, i, i1);
        }

        @Override
        public void flush() throws IOException {
            this.getServletOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public CompletionStage<Void> asyncFlush() {
            FlushOperation op = new FlushOperation(this);
            this.queue(op);
            return op.future;
        }

        @Override
        public CompletionStage<Void> asyncWrite(byte[] bytes, int offset, int length) {
            WriteOperation op = new WriteOperation(this, bytes, offset, length);
            this.queue(op);
            return op.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queue(AsyncOperation op) {
            HttpRequest resteasyRequest = (HttpRequest)HttpServletResponseWrapper.this.contextDataMap.get(HttpRequest.class);
            if (HttpServletResponseWrapper.this.request.isAsyncStarted() && !resteasyRequest.getAsyncContext().isOnInitialRequest()) {
                ServletOutputStream out;
                boolean flush = false;
                try {
                    out = this.getServletOutputStream();
                }
                catch (IOException e) {
                    op.future.completeExceptionally(e);
                    return;
                }
                if (this.asyncRegistered.compareAndSet(false, true)) {
                    out.setWriteListener((WriteListener)this);
                }
                DeferredOutputStream deferredOutputStream = this;
                synchronized (deferredOutputStream) {
                    if (this.asyncListenerCalled && out.isReady()) {
                        this.asyncQueue.add(op);
                        flush = true;
                    } else {
                        this.asyncQueue.add(op);
                    }
                }
                if (flush) {
                    this.flushQueue();
                }
            } else {
                op.work(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushQueue() {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                AsyncOperation op;
                ServletOutputStream out;
                try {
                    out = this.getServletOutputStream();
                }
                catch (IOException e) {
                    this.onError(e);
                    return;
                }
                while (out.isReady() && (op = this.asyncQueue.poll()) != null) {
                    op.work(out);
                }
            }
        }

        public void onWritePossible() {
            this.asyncListenerCalled = true;
            this.flushQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                AsyncOperation op;
                this.asyncListenerCalled = true;
                while ((op = this.asyncQueue.poll()) != null) {
                    if (op.future.isDone()) continue;
                    op.future.completeExceptionally(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServletOutputStream getServletOutputStream() throws IOException {
            if (this.lazyOut == null) {
                DeferredOutputStream deferredOutputStream = this;
                synchronized (deferredOutputStream) {
                    if (this.lazyOut == null) {
                        this.lazyOut = new WrappedServletOutputStream(HttpServletResponseWrapper.this.response.getOutputStream());
                    }
                }
            }
            return this.lazyOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getId() {
            DeferredOutputStream deferredOutputStream = this;
            synchronized (deferredOutputStream) {
                if (this.idCounter == Long.MAX_VALUE) {
                    this.idCounter = 0L;
                }
                return this.idCounter++;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$DeferredOutputStream", DeferredOutputStream.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private class CompletionOperation
    extends AsyncOperation {
        static final long serialVersionUID = 2570491864754595493L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CompletionOperation(AsyncOperation op) {
            super(op.stream, op.future, op.id);
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            if (sos == null || sos.isReady()) {
                if (!this.future.isDone()) {
                    this.future.complete(null);
                }
            } else {
                this.queueComplete(this);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$CompletionOperation", CompletionOperation.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public class FlushOperation
    extends AsyncOperation {
        static final long serialVersionUID = 5322024462215734783L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Deprecated
        public FlushOperation(OutputStream os) {
            super(os);
        }

        public FlushOperation(DeferredOutputStream os) {
            super(os);
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                if (sos == null) {
                    this.stream.flush();
                    this.future.complete(null);
                } else if (sos.isReady()) {
                    this.stream.flush();
                    if (sos.isReady()) {
                        this.future.complete(null);
                    } else {
                        this.queueComplete(this);
                    }
                } else {
                    this.requeue(this);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[flush]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$FlushOperation", FlushOperation.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public class WriteOperation
    extends AsyncOperation {
        private final byte[] bytes;
        private final int offset;
        private final int length;
        static final long serialVersionUID = -4123948489074359617L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Deprecated
        public WriteOperation(OutputStream stream, byte[] bytes, int offset, int length) {
            super(stream);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        private WriteOperation(DeferredOutputStream stream, byte[] bytes, int offset, int length) {
            super(stream);
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        protected void doWork(ServletOutputStream sos) {
            try {
                if (sos == null) {
                    this.stream.write(this.bytes, this.offset, this.length);
                    this.future.complete(null);
                } else if (sos.isReady()) {
                    this.stream.write(this.bytes, this.offset, this.length);
                    if (sos.isReady()) {
                        this.future.complete(null);
                    } else {
                        this.queueComplete(this);
                    }
                } else {
                    this.requeue(this);
                }
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }

        public String toString() {
            return "[write: " + new String(this.bytes) + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$WriteOperation", WriteOperation.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public abstract class AsyncOperation {
        final CompletableFuture<Void> future;
        final OutputStream stream;
        private final long id;
        static final long serialVersionUID = 6651060982759112317L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Deprecated
        public AsyncOperation(OutputStream stream) {
            this(stream, new CompletableFuture<Void>(), stream instanceof DeferredOutputStream ? ((DeferredOutputStream)stream).getId() : -1L);
        }

        private AsyncOperation(DeferredOutputStream stream) {
            this(stream, new CompletableFuture<Void>(), stream.getId());
        }

        private AsyncOperation(OutputStream stream, CompletableFuture<Void> future, long id) {
            this.stream = stream;
            this.future = future;
            this.id = id;
        }

        public void work(ServletOutputStream sos) {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(HttpServletResponseWrapper.this.contextDataMap);){
                this.doWork(sos);
            }
        }

        protected abstract void doWork(ServletOutputStream var1);

        protected void requeue(AsyncOperation op) {
            if (op.future.isDone()) {
                return;
            }
            if (this.stream instanceof DeferredOutputStream) {
                ((DeferredOutputStream)this.stream).queue(op);
            }
        }

        protected void queueComplete(AsyncOperation op) {
            if (op.future.isDone()) {
                return;
            }
            if (this.stream instanceof DeferredOutputStream) {
                AsyncOperation requeue = op instanceof CompletionOperation ? op : new CompletionOperation(op);
                ((DeferredOutputStream)this.stream).queue(requeue);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper$AsyncOperation", AsyncOperation.class, null, null);
        }
    }
}

