/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.ws.security.filemonitor.LTPAFileMonitor;
import com.ibm.ws.security.token.ltpa.LTPAConfiguration;
import com.ibm.ws.security.token.ltpa.LTPAKeyInfoManager;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyCreateTask;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeysChangeNotifier;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.File;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LTPAConfigurationImpl
implements LTPAConfiguration,
FileBasedActionable {
    private static final TraceComponent tc = Tr.register(LTPAConfigurationImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    static final String KEY_LOCATION_SERVICE = "locationService";
    static final String KEY_EXECUTOR_SERVICE = "executorService";
    static final String KEY_CHANGE_SERVICE = "ltpaKeysChangeNotifier";
    static final String DEFAULT_CONFIG_LOCATION = "${server.config.dir}/resources/security/ltpa.keys";
    static final String DEFAULT_CONFIG_DIRECTORY = "${server.config.dir}/resources/security/";
    static final String DEFAULT_OUTPUT_LOCATION = "${server.output.dir}/resources/security/ltpa.keys";
    static final String KEY_AUTH_FILTER_REF = "authFilterRef";
    static final String KEY_EXP_DIFF_ALLOWED = "expirationDifferenceAllowed";
    protected static final String KEY_SERVICE_PID = "service.pid";
    private final AtomicServiceReference<WsLocationAdmin> locationService = new AtomicServiceReference("locationService");
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("executorService");
    private final AtomicServiceReference<LTPAKeysChangeNotifier> ltpaKeysChangeNotifierService = new AtomicServiceReference("ltpaKeysChangeNotifier");
    private ServiceRegistration<LTPAConfiguration> registration = null;
    private volatile ComponentContext cc = null;
    private LTPAKeyCreateTask createTask;
    private TokenFactory factory;
    private LTPAKeyInfoManager ltpaKeyInfoManager;
    private String primaryKeyImportFile;
    private String primaryKeyImportDir;
    @Sensitive
    private String primaryKeyPassword;
    private long keyTokenExpiration;
    private long monitorInterval;
    private LTPAFileMonitor ltpaFileMonitor;
    private ServiceRegistration<FileMonitor> ltpaFileMonitorRegistration;
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    private String authFilterRef;
    private long expirationDifferenceAllowed;
    private boolean monitorDirectory;
    private final List<Properties> validationKeys = new ArrayList<Properties>();
    private List<Properties> configValidationKeys = null;
    private List<Properties> unConfigValidationKeys = null;
    private final Collection<File> currentlyDeletedFiles = new HashSet<File>();
    static final long serialVersionUID = -216335094236772058L;

    protected void setExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorService.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorService.unsetReference(ref);
    }

    protected void setLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationService.setReference(reference);
    }

    protected void unsetLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationService.unsetReference(reference);
    }

    protected void setLtpaKeysChangeNotifier(ServiceReference<LTPAKeysChangeNotifier> ref) {
        this.ltpaKeysChangeNotifierService.setReference(ref);
    }

    protected void unsetLtpaKeysChangeNotifier(ServiceReference<LTPAKeysChangeNotifier> ref) {
        this.ltpaKeysChangeNotifierService.unsetReference(ref);
    }

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.cc = context;
        this.locationService.activate(context);
        this.executorService.activate(context);
        this.ltpaKeysChangeNotifierService.activate(context);
        this.loadConfig(props);
        this.setupRuntimeLTPAInfrastructure();
    }

    @Sensitive
    private void loadConfig(Map<String, Object> props) {
        this.primaryKeyImportFile = (String)props.get("keysFileName");
        SerializableProtectedString sps = (SerializableProtectedString)props.get("keysPassword");
        this.primaryKeyPassword = sps == null ? null : new String(sps.getChars());
        this.keyTokenExpiration = (Long)props.get("expiration");
        this.monitorInterval = (Long)props.get("monitorInterval");
        this.authFilterRef = (String)props.get(KEY_AUTH_FILTER_REF);
        this.expirationDifferenceAllowed = (Long)props.get(KEY_EXP_DIFF_ALLOWED);
        this.monitorDirectory = (Boolean)props.get("monitorDirectory");
        this.resolveActualPrimaryKeysFileLocation();
        Map validationKeysElements = Nester.nest(props, (String[])new String[]{"validationKeys"});
        if (!validationKeysElements.isEmpty()) {
            this.configValidationKeys = this.getConfigValidationKeys(validationKeysElements, "validationKeys", "fileName", "password", "notUseAfterDate");
        }
        if (this.monitorDirectory) {
            if (this.monitorInterval <= 0L) {
                Tr.warning((TraceComponent)tc, (String)"LTPA_MONITOR_DIRECTORY_TRUE_AND_FILE_MONITOR_NOT_ENABLEDONFIG_DIRECTORY", (Object[])new Object[]{this.monitorInterval});
            }
            this.unConfigValidationKeys = this.getUnConfigValidationKeys();
        }
        this.combineValidationKeys();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("primaryKeyImportFile: " + this.primaryKeyImportFile), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("keyTokenExpiration: " + this.keyTokenExpiration), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("monitorInterval: " + this.monitorInterval), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef: " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("monitorDirectory: " + this.monitorDirectory), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("validationKeys: " + (this.validationKeys == null ? "Null" : this.validationKeys.toString())), (Object[])new Object[0]);
        }
    }

    private void combineValidationKeys() {
        if (this.validationKeys != null) {
            this.validationKeys.clear();
        }
        if (this.configValidationKeys != null) {
            this.validationKeys.addAll(this.configValidationKeys);
        }
        if (this.unConfigValidationKeys != null) {
            this.validationKeys.addAll(this.unConfigValidationKeys);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"validationKeys", (Object[])new Object[]{this.validationKeys});
        }
    }

    @Sensitive
    private List<Properties> getUnConfigValidationKeys() {
        ArrayList<Properties> validationKeysInDirectory = new ArrayList<Properties>();
        WsResource keysFileInDirectory = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveResource(this.primaryKeyImportDir);
        Iterator keysFileNames = keysFileInDirectory.getChildren(".*\\.keys");
        while (keysFileNames.hasNext()) {
            Properties properties = new Properties();
            WsResource kfs = keysFileInDirectory.getChild((String)keysFileNames.next());
            String fn = kfs.getName();
            fn = this.primaryKeyImportDir.concat(fn);
            if (this.primaryKeyImportFile.equals(kfs.getName()) || this.isConfiguredValidationKeys(fn)) continue;
            properties.setProperty("fileName", fn);
            properties.setProperty("password", this.primaryKeyPassword);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unconfigured validationKeys file name: " + fn), (Object[])new Object[0]);
            }
            validationKeysInDirectory.add(properties);
        }
        return validationKeysInDirectory;
    }

    private boolean isConfiguredValidationKeys(String fn) {
        for (Properties vKeys : this.configValidationKeys) {
            if (!vKeys.getProperty("fileName").equals(fn)) continue;
            return true;
        }
        return false;
    }

    private void resolveActualPrimaryKeysFileLocation() {
        WsResource keysFileInServerConfig = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveResource(this.primaryKeyImportFile);
        String dir = keysFileInServerConfig.getParent().toRepositoryPath();
        this.primaryKeyImportDir = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveString(dir);
        this.primaryKeyImportFile = this.primaryKeyImportDir + keysFileInServerConfig.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("primaryKeyImportDir: " + this.primaryKeyImportDir), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("primaryKeyImportFile: " + this.primaryKeyImportFile), (Object[])new Object[0]);
        }
    }

    private void setupRuntimeLTPAInfrastructure() {
        this.optionallyCreateFileMonitor();
        this.createTask = new LTPAKeyCreateTask((WsLocationAdmin)this.locationService.getService(), this);
        this.submitTaskToCreateLTPAKeys();
    }

    private void optionallyCreateFileMonitor() {
        if (this.monitorInterval > 0L || this.monitorDirectory) {
            this.createFileMonitor();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createFileMonitor() {
        block4: {
            try {
                this.ltpaFileMonitor = new LTPAFileMonitor((FileBasedActionable)this);
                if (this.monitorDirectory) {
                    this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.ltpaFileMonitor.monitorFiles(Arrays.asList(this.primaryKeyImportDir), Arrays.asList(this.primaryKeyImportFile), this.monitorInterval));
                } else {
                    this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.ltpaFileMonitor.monitorFiles(Arrays.asList(this.primaryKeyImportFile), this.monitorInterval));
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl", (String)"293", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception creating the LTPA file monitor.", (Object[])new Object[]{e});
            }
        }
    }

    public void performFileBasedAction(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        Collection<File> allFiles = this.getAllFiles(createdFiles, modifiedFiles, deletedFiles);
        if (this.noValidationKeys()) {
            if (!deletedFiles.isEmpty()) {
                this.currentlyDeletedFiles.addAll(deletedFiles);
            }
            if (!this.isActionNeeded(createdFiles, modifiedFiles).booleanValue()) {
                return;
            }
        }
        Tr.audit((TraceComponent)tc, (String)"LTPA_KEYS_TO_LOAD", (Object[])new Object[]{this.printLTPAKeys(allFiles)});
        if (this.monitorDirectory) {
            this.validationKeys.clear();
            if (this.configValidationKeys != null || !this.configValidationKeys.isEmpty()) {
                this.validationKeys.addAll(this.configValidationKeys);
            }
            this.unConfigValidationKeys = this.getUnConfigValidationKeys();
            this.combineValidationKeys();
        }
        this.submitTaskToCreateLTPAKeys();
    }

    public void performFileBasedAction(Collection<File> modifiedFiles) {
    }

    private Boolean isActionNeeded(Collection<File> createdFiles, Collection<File> modifiedFiles) {
        boolean actionNeeded = false;
        for (File createdFile : createdFiles) {
            if (!this.currentlyDeletedFiles.contains(createdFile)) continue;
            this.currentlyDeletedFiles.remove(createdFile);
            actionNeeded = true;
        }
        if (!modifiedFiles.isEmpty()) {
            actionNeeded = true;
        }
        return actionNeeded;
    }

    boolean noValidationKeys() {
        return this.validationKeys == null || this.validationKeys.isEmpty();
    }

    private Collection<File> getAllFiles(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        HashSet<File> allFiles = new HashSet<File>();
        if (!createdFiles.isEmpty()) {
            allFiles.addAll(createdFiles);
        }
        if (!modifiedFiles.isEmpty()) {
            allFiles.addAll(modifiedFiles);
        }
        if (!deletedFiles.isEmpty()) {
            allFiles.addAll(deletedFiles);
        }
        return allFiles;
    }

    private String printLTPAKeys(Collection<File> files) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("(");
        for (File file : files) {
            strBuff.append(file);
            strBuff.append(", ");
        }
        int currentIndex = strBuff.lastIndexOf(",");
        strBuff.delete(currentIndex, currentIndex + 2);
        strBuff.append(")");
        return strBuff.toString();
    }

    private void submitTaskToCreateLTPAKeys() {
        CheckpointHook hook;
        CheckpointPhase checkpointPhase = CheckpointPhase.getPhase();
        if (checkpointPhase != CheckpointPhase.INACTIVE && checkpointPhase.addMultiThreadedHook(hook = new CheckpointHook(){
            static final long serialVersionUID = -3427890626690699476L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void restore() {
                ((ExecutorService)LTPAConfigurationImpl.this.executorService.getService()).execute(LTPAConfigurationImpl.this.createTask);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl$1", 1.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
            }
        })) {
            return;
        }
        ((ExecutorService)this.executorService.getService()).execute(this.createTask);
    }

    protected void modified(Map<String, Object> props) {
        String oldKeyImportFile = this.primaryKeyImportFile;
        Long oldKeyTokenExpiration = this.keyTokenExpiration;
        Long oldMonitorInterval = this.monitorInterval;
        Long oldExpirationDifferenceAllowed = this.expirationDifferenceAllowed;
        boolean oldMonitorDirectory = this.monitorDirectory;
        ArrayList<Properties> oldValidationKeys = new ArrayList<Properties>();
        oldValidationKeys.addAll(this.validationKeys);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("oldValidationKeys: " + oldValidationKeys), (Object[])new Object[0]);
        }
        this.loadConfig(props);
        if (this.isKeysConfigChanged(oldKeyImportFile, oldKeyTokenExpiration, oldExpirationDifferenceAllowed, oldMonitorDirectory, oldValidationKeys)) {
            this.unsetFileMonitorRegistration();
            Tr.audit((TraceComponent)tc, (String)"LTPA_KEYS_TO_LOAD", (Object[])new Object[]{this.primaryKeyImportFile});
            this.setupRuntimeLTPAInfrastructure();
        } else if (this.isMonitorIntervalChanged(oldMonitorInterval)) {
            this.unsetFileMonitorRegistration();
            this.optionallyCreateFileMonitor();
        }
    }

    private boolean isKeysConfigChanged(String oldKeyImportFile, Long oldKeyTokenExpiration, Long oldExpirationDifferenceAllowed, boolean oldMonitorDirectory, List<Properties> oldValidationKeys) {
        return !oldKeyImportFile.equals(this.primaryKeyImportFile) || oldKeyTokenExpiration != this.keyTokenExpiration || oldExpirationDifferenceAllowed != this.expirationDifferenceAllowed || oldMonitorDirectory != this.monitorDirectory || this.isValidationKeysConfigured(oldValidationKeys);
    }

    private boolean isValidationKeysConfigured(List<Properties> oldValidationKeys) {
        return oldValidationKeys != null && !oldValidationKeys.isEmpty() || this.validationKeys != null && !this.validationKeys.isEmpty();
    }

    private boolean isMonitorIntervalChanged(Long oldMonitorInterval) {
        return oldMonitorInterval != this.monitorInterval;
    }

    protected void deactivate(ComponentContext context) {
        this.cc = null;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.unsetFileMonitorRegistration();
        this.executorService.deactivate(context);
        this.locationService.deactivate(context);
        this.ltpaKeysChangeNotifierService.deactivate(context);
    }

    protected void unsetFileMonitorRegistration() {
        if (this.ltpaFileMonitorRegistration != null) {
            this.ltpaFileMonitorRegistration.unregister();
            this.ltpaFileMonitorRegistration = null;
        }
    }

    protected void setFileMonitorRegistration(ServiceRegistration<FileMonitor> ltpaFileMonitorRegistration) {
        this.ltpaFileMonitorRegistration = ltpaFileMonitorRegistration;
    }

    public BundleContext getBundleContext() {
        if (this.cc != null) {
            return this.cc.getBundleContext();
        }
        return null;
    }

    void setRegistration(ServiceRegistration<LTPAConfiguration> registration) {
        this.registration = registration;
    }

    void setTokenFactory(TokenFactory factory) {
        this.writeLock.lock();
        try {
            this.factory = factory;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public TokenFactory getTokenFactory() {
        this.readLock.lock();
        try {
            TokenFactory tokenFactory = this.factory;
            return tokenFactory;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void setLTPAKeyInfoManager(LTPAKeyInfoManager ltpaKeyInfoManager) {
        this.ltpaKeyInfoManager = ltpaKeyInfoManager;
    }

    @Override
    public LTPAKeyInfoManager getLTPAKeyInfoManager() {
        return this.ltpaKeyInfoManager;
    }

    @Override
    public String getPrimaryKeyFile() {
        return this.primaryKeyImportFile;
    }

    @Override
    @Sensitive
    public String getPrimaryKeyPassword() {
        return this.primaryKeyPassword;
    }

    @Override
    public long getTokenExpiration() {
        return this.keyTokenExpiration;
    }

    @Override
    public String getAuthFilterRef() {
        return this.authFilterRef;
    }

    @Override
    public long getExpirationDifferenceAllowed() {
        return this.expirationDifferenceAllowed;
    }

    protected void configReady() {
        LTPAKeysChangeNotifier notifier = this.getLTPAKeysChangeNotifier();
        if (notifier != null) {
            notifier.notifyListeners();
        }
    }

    protected LTPAKeysChangeNotifier getLTPAKeysChangeNotifier() {
        return (LTPAKeysChangeNotifier)((Object)this.ltpaKeysChangeNotifierService.getService());
    }

    @Override
    public boolean getMonitorDirectory() {
        return this.monitorDirectory;
    }

    @Override
    @Sensitive
    public List<Properties> getValidationKeys() {
        return this.validationKeys;
    }

    public List<Properties> getConfigValidationKeys(Map<String, List<Map<String, Object>>> listOfNestedElements, String elementName, String ... attrKeys) {
        ArrayList<Properties> listOfValidationKeysProps = new ArrayList<Properties>();
        List<Map<String, Object>> listOfElementMaps = listOfNestedElements.get(elementName);
        if (listOfElementMaps != null && !listOfElementMaps.isEmpty()) {
            for (Map<String, Object> elementProps : listOfElementMaps) {
                Properties properties = this.getValidationKeysProps(elementProps, elementName, attrKeys);
                if (properties == null || properties.isEmpty()) continue;
                listOfValidationKeysProps.add(properties);
            }
        }
        return listOfValidationKeysProps;
    }

    @Sensitive
    private Properties getValidationKeysProps(Map<String, Object> configProps, String elementName, String ... attrKeys) {
        Properties properties = new Properties();
        for (String attrKey : attrKeys) {
            SerializableProtectedString sps;
            String value = null;
            value = attrKey.equals("password") ? ((sps = (SerializableProtectedString)configProps.get("password")) == null ? null : new String(sps.getChars())) : (String)configProps.get(attrKey);
            if (value == null || value.length() <= 0) continue;
            value = (String)this.getValue(value);
            if (attrKey.equals("fileName")) {
                value = this.primaryKeyImportDir.concat(value);
            }
            properties.put(attrKey, value);
        }
        if (properties.isEmpty() || properties.get("fileName") == null || properties.get("password") == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_MISSING_ATTR", (Object[])new Object[]{elementName, this.printAttrKeys(attrKeys)});
            }
            return null;
        }
        if (this.isNotUseAfterDate(configProps)) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configured validationKeys file name: " + properties.get("fileName")), (Object[])new Object[0]);
        }
        return properties;
    }

    private boolean isNotUseAfterDate(Map<String, Object> configProps) {
        String notUseAfterDate = (String)configProps.get("notUseAfterDate");
        boolean result = false;
        if (notUseAfterDate == null) {
            return result;
        }
        OffsetDateTime noUserAfterDateOdt = null;
        try {
            noUserAfterDateOdt = OffsetDateTime.parse(notUseAfterDate);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl", (String)"759", (Object)this, (Object[])new Object[]{configProps});
            Tr.error((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_NOT_USE_AFTER_DATE_INVALID_FORMAT", (Object[])new Object[]{notUseAfterDate, configProps.get("fileName")});
            return true;
        }
        ZoneOffset zone = noUserAfterDateOdt.getOffset();
        OffsetDateTime currentDateTime = OffsetDateTime.now(zone);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("notUseAfterDate: " + noUserAfterDateOdt), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("current date: " + currentDateTime), (Object[])new Object[0]);
        }
        if (currentDateTime.isAfter(noUserAfterDateOdt)) {
            Tr.warning((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_PASSED_NOT_USE_AFTER_DATE", (Object[])new Object[]{notUseAfterDate, configProps.get("fileName")});
            return true;
        }
        return false;
    }

    private String printAttrKeys(String ... attrKeys) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("(");
        for (String attrKey : attrKeys) {
            strBuff.append(attrKey);
            strBuff.append(", ");
        }
        int currentIndex = strBuff.lastIndexOf(",");
        strBuff.delete(currentIndex, currentIndex + 2);
        strBuff.append(")");
        return strBuff.toString();
    }

    private Object getValue(Object value) {
        if (value instanceof String) {
            return ((String)value).trim();
        }
        return value;
    }
}

