/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.hpack;

public class H2HeaderField {
    private String name = null;
    private String value = null;
    private int nameHash;
    private int valueHash;
    private int size;
    private int currentIndex = -1;

    public H2HeaderField(String name, String value) {
        this.name = name;
        this.value = value;
        this.init();
    }

    public H2HeaderField(String name, String value, int index) {
        this.name = name;
        this.value = value;
        this.currentIndex = index;
        this.init();
    }

    private void init() {
        this.nameHash = this.name.hashCode();
        this.valueHash = this.value.hashCode();
        this.setSize();
    }

    private void setSize() {
        this.size = this.name.length() + this.value.length() + 32;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setValue(String value) {
        this.value = value;
        this.valueHash = value.hashCode();
        this.setSize();
    }

    public void setName(String name) {
        this.name = name;
        this.nameHash = name.hashCode();
        this.setSize();
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getNameHash() {
        return this.nameHash;
    }

    public int getValueHash() {
        return this.valueHash;
    }

    public boolean equals(Object o) {
        return o instanceof H2HeaderField && this.getName().equals(((H2HeaderField)o).getName()) && this.getValue().equals(((H2HeaderField)o).getValue());
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

