/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.accessor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import jakarta.validation.ValidatorFactory;
import java.security.AccessController;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BeanValidationAccessor {
    private static final TraceComponent tc = Tr.register(BeanValidationAccessor.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    static final long serialVersionUID = -138240892169367111L;

    public static ValidatorFactory getValidatorFactory() {
        Bundle bundle = FrameworkUtil.getBundle(BeanValidationAccessor.class);
        BeanValidation bv = (BeanValidation)priv.getService(bundle, BeanValidation.class);
        if (bv != null) {
            ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cmd != null) {
                return bv.getValidatorFactoryOrDefault(cmd);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get ValidatorFactory because ComponentMetaData was null", (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unable to get ValidatorFactory because BeanValidation service was null", (Object[])new Object[0]);
        }
        return null;
    }
}

