/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.web.ExternalCacheEntry;
import com.ibm.ws.cache.web.ExternalCacheFragment;
import com.ibm.ws.cache.web.ExternalCacheGroup;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ExternalCacheServices
implements com.ibm.ws.cache.intf.ExternalCacheServices,
Serializable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Tr.register(ExternalCacheServices.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private HashMap externalCacheGroups = new HashMap();
    private HashMap externalURLToECFTable = new HashMap();
    private DependencyTable idDependencyTable = new DependencyTable(1, 200);
    private DependencyTable uriDependencyTable = new DependencyTable(1, 200);

    public Iterator getExternalCacheGroupNames() {
        return this.externalCacheGroups.keySet().iterator();
    }

    public void setExternalCacheGroups(HashMap externalCacheGroups) {
        this.externalCacheGroups = externalCacheGroups;
    }

    public void addExternalCacheAdapter(String groupId, String address, String beanName) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(groupId);
        if (externalCacheGroup == null) {
            Tr.error((TraceComponent)tc, (String)"dynacache.externalnotfound", (Object[])new Object[]{groupId});
            return;
        }
        externalCacheGroup.addExternalCacheAdapter(address, beanName);
    }

    public void removeExternalCacheAdapter(String groupId, String address) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(groupId);
        if (externalCacheGroup == null) {
            return;
        }
        externalCacheGroup.removeExternalCacheAdapter(address);
    }

    public void start() {
        if (this.externalCacheGroups == null) {
            throw new IllegalStateException("externalCacheGroups must be set before start()");
        }
    }

    public void batchUpdate(HashMap invalidateIdEvents, HashMap invalidateTemplateEvents, ArrayList pushECFEvents) {
        this.invalidateExternalCaches(invalidateIdEvents, invalidateTemplateEvents);
        this.writeToExternalCaches(pushECFEvents);
    }

    public void invalidateExternalCaches(HashMap invalidateIdEvents, HashMap invalidateTemplateEvents) {
        boolean templateIdsEmpty;
        if (this.externalCacheGroups == null || this.externalCacheGroups.size() == 0) {
            return;
        }
        ValueSet fullEcfValueSet = new ValueSet(4);
        for (Object id : invalidateIdEvents.keySet()) {
            ValueSet ecfValueSet;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ExternalCacheServices.invalidate id: " + id), (Object[])new Object[0]);
            }
            if ((ecfValueSet = this.idDependencyTable.removeDependency(id)) == null) continue;
            fullEcfValueSet.union(ecfValueSet);
        }
        Iterator it = invalidateTemplateEvents.keySet().iterator();
        HashSet<ValueSet> removedIdsSet = null;
        while (it.hasNext()) {
            ValueSet ecfValueSet;
            ValueSet removedIds;
            InvalidateByTemplateEvent ie;
            String template = (String)it.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ExternalCacheServices.invalidate template: " + template), (Object[])new Object[0]);
            }
            if ((ie = (InvalidateByTemplateEvent)invalidateTemplateEvents.get(template)).isCacheCommand_Clear()) {
                for (ExternalCacheGroup externalCacheGroup : this.externalCacheGroups.values()) {
                    externalCacheGroup.clear(ie);
                }
                this.externalURLToECFTable.clear();
                this.idDependencyTable.clear();
                this.uriDependencyTable.clear();
                return;
            }
            if (ie.isCacheCommand_InvalidateByTemplate() && tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)("Ignored ExternalCacheServices.invalidate template: " + template), (Object[])new Object[0]);
            }
            if ((removedIds = ie.getRemovedIds()) != null && removedIds.size() > 0) {
                if (removedIdsSet == null) {
                    removedIdsSet = new HashSet<ValueSet>(invalidateTemplateEvents.size());
                }
                removedIdsSet.add(removedIds);
            }
            if ((ecfValueSet = this.uriDependencyTable.removeDependency((Object)template)) == null) continue;
            fullEcfValueSet.union(ecfValueSet);
        }
        ValueSet urlValueSet = new ValueSet(10);
        for (ExternalCacheFragment ecf : fullEcfValueSet) {
            String uri = ecf.getUri();
            urlValueSet.add((Object)uri);
            this.externalURLToECFTable.remove(uri);
            Enumeration idEnumeration = ecf.getInvalidationIds();
            while (idEnumeration.hasMoreElements()) {
                Object id = idEnumeration.nextElement();
                this.idDependencyTable.removeEntry(id, (Object)ecf);
            }
            Enumeration uriEnumeration = ecf.getTemplates();
            while (uriEnumeration.hasMoreElements()) {
                String template = (String)uriEnumeration.nextElement();
                this.uriDependencyTable.removeEntry(template, (Object)ecf);
            }
        }
        boolean urlEmpty = urlValueSet.isEmpty();
        boolean idEmpty = invalidateIdEvents.isEmpty();
        boolean bl = templateIdsEmpty = removedIdsSet == null || removedIdsSet.isEmpty();
        if (urlEmpty && idEmpty && templateIdsEmpty) {
            return;
        }
        for (ExternalCacheGroup externalCacheGroup : this.externalCacheGroups.values()) {
            if (!urlEmpty) {
                externalCacheGroup.invalidatePages(urlValueSet);
            }
            if (!idEmpty) {
                externalCacheGroup.invalidateIds(invalidateIdEvents);
            }
            if (templateIdsEmpty) continue;
            externalCacheGroup.invalidateIds(removedIdsSet);
        }
    }

    private void writeToExternalCaches(ArrayList pushECFEvents) {
        if (this.externalCacheGroups == null) {
            return;
        }
        HashMap<String, ArrayList<ExternalCacheEntry>> hashmap = new HashMap<String, ArrayList<ExternalCacheEntry>>();
        int size = pushECFEvents.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<ExternalCacheEntry> contentVector;
            ExternalCacheFragment externalCacheFragment = (ExternalCacheFragment)pushECFEvents.get(i);
            String cacheGroupId = externalCacheFragment.getExternalCacheGroupId();
            Object cacheGroup = this.externalCacheGroups.get(cacheGroupId);
            if (cacheGroup == null) continue;
            String url = externalCacheFragment.getUri();
            boolean newVHost = false;
            ExternalCacheFragment oldExternalCacheFragment = (ExternalCacheFragment)this.externalURLToECFTable.get(url);
            if (oldExternalCacheFragment != null && oldExternalCacheFragment.getTimeStamp() >= externalCacheFragment.getTimeStamp()) {
                if (!oldExternalCacheFragment.getHostList().contains(externalCacheFragment.getHost())) {
                    newVHost = true;
                }
                if (System.currentTimeMillis() - oldExternalCacheFragment.getTimeStamp() < 30000L) continue;
            }
            externalCacheFragment.addHostToList(externalCacheFragment.getHost());
            if (!newVHost) {
                this.externalURLToECFTable.put(url, externalCacheFragment);
                Enumeration idEnumeration = externalCacheFragment.getInvalidationIds();
                while (idEnumeration.hasMoreElements()) {
                    String id = (String)idEnumeration.nextElement();
                    this.idDependencyTable.add((Object)id, (Object)externalCacheFragment);
                }
                Enumeration uriEnumeration = externalCacheFragment.getTemplates();
                while (uriEnumeration.hasMoreElements()) {
                    String template = (String)uriEnumeration.nextElement();
                    this.uriDependencyTable.add((Object)template, (Object)externalCacheFragment);
                }
            }
            if ((contentVector = (ArrayList<ExternalCacheEntry>)hashmap.get(cacheGroupId)) == null) {
                contentVector = new ArrayList<ExternalCacheEntry>();
                hashmap.put(cacheGroupId, contentVector);
            }
            contentVector.add(externalCacheFragment.getEntry());
        }
        for (Map.Entry entry : hashmap.entrySet()) {
            String key = (String)entry.getKey();
            ArrayList contentVector = (ArrayList)entry.getValue();
            ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(key);
            externalCacheGroup.writePages(contentVector);
        }
    }

    public void preInvoke(String cacheGroup, ServletCacheRequest req, HttpServletResponse resp) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(cacheGroup);
        if (externalCacheGroup != null) {
            externalCacheGroup.preInvoke(req, resp);
        }
    }

    public void postInvoke(String cacheGroup, ServletCacheRequest req, HttpServletResponse resp) {
        ExternalCacheGroup externalCacheGroup = (ExternalCacheGroup)this.externalCacheGroups.get(cacheGroup);
        if (externalCacheGroup != null) {
            externalCacheGroup.postInvoke(req, resp);
        }
    }
}

