/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup.config;

import io.smallrye.metrics.setup.config.PropertySingleValueConfiguration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HistogramBucketMaxConfiguration
extends PropertySingleValueConfiguration<Double> {
    private static final String CLASS_NAME = HistogramBucketMaxConfiguration.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);

    public HistogramBucketMaxConfiguration(String metricName, Double value) {
        super(metricName, value);
    }

    public static Collection<HistogramBucketMaxConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<HistogramBucketMaxConfiguration> metricBucketMinMax = new ArrayDeque<HistogramBucketMaxConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketMaxConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length != 2) continue;
            if (keyValueSplit[1].matches("[0-9]+[.]*[0-9]*")) {
                Double value = Double.parseDouble(keyValueSplit[1].trim());
                metricBucketConfiguration = new HistogramBucketMaxConfiguration(metricName, value);
            } else if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.logp(Level.FINER, CLASS_NAME, (String)null, "The value \"{0}\" is invalid for the \"{1}\" property. Only integer and decimal values are accepted.", new Object[]{keyValueSplit[1], "mp.metrics.distribution.histogram.buckets"});
            }
            metricBucketMinMax.addFirst(metricBucketConfiguration);
        }
        return metricBucketMinMax;
    }
}

