/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.validator.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.rest.config.ConfigBasedRESTHandler;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.validator.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.rest.handler.validator", configurationPolicy=ConfigurationPolicy.IGNORE, service={RESTHandler.class}, property={"com.ibm.wsspi.rest.handler.root=/validation/{element}", "com.ibm.wsspi.rest.handler.custom.security=true"})
public class ValidatorRESTHandler
extends ConfigBasedRESTHandler {
    private static final TraceComponent tc = Tr.register(ValidatorRESTHandler.class, (String)"rest.validation", (String)"com.ibm.ws.rest.handler.validator.resources.CWWKOMessages");
    private ComponentContext context;
    @Reference
    VariableRegistry variableRegistry;
    static final long serialVersionUID = 1992297430800432704L;

    @Activate
    protected void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.context = null;
    }

    public final String getAPIRoot() {
        return "/validation";
    }

    public Object handleError(RESTRequest request, String uid, String errorMessage) {
        JSONObject failure = this.toJSONObject("message", errorMessage);
        if (uid == null) {
            return this.toJSONObject("successful", false, "failure", failure);
        }
        return this.toJSONObject("uid", uid, "successful", false, "failure", failure);
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static <S> Collection<ServiceReference<S>> getServiceReferences(final BundleContext bCtx, final Class<S> clazz, final String filter) throws InvalidSyntaxException {
        if (System.getSecurityManager() == null) {
            return bCtx.getServiceReferences(clazz, filter);
        }
        try {
            return (Collection)AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<ServiceReference<S>>>(){
                static final long serialVersionUID = -3415297815278533801L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Collection<ServiceReference<S>> run() throws InvalidSyntaxException {
                    return bCtx.getServiceReferences(clazz, filter);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler$1", 1.class, (String)"rest.validation", (String)"com.ibm.ws.rest.handler.validator.resources.CWWKOMessages");
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InvalidSyntaxException) {
                throw (InvalidSyntaxException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public static ServiceReference<?>[] getServiceReferences(final BundleContext bCtx, final String clazz, final String filter) throws InvalidSyntaxException {
        if (System.getSecurityManager() == null) {
            return bCtx.getServiceReferences(clazz, filter);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceReference<?>[]>(){
                static final long serialVersionUID = 7121508785282884859L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                @Trivial
                public ServiceReference<?>[] run() throws InvalidSyntaxException {
                    return bCtx.getServiceReferences(clazz, filter);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler$2", 2.class, (String)"rest.validation", (String)"com.ibm.ws.rest.handler.validator.resources.CWWKOMessages");
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InvalidSyntaxException) {
                throw (InvalidSyntaxException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static <S> S getService(final ComponentContext ctx, final ServiceReference<S> reference) {
        if (System.getSecurityManager() == null) {
            BundleContext bCtx = ctx.getBundleContext();
            return (S)(bCtx == null ? null : bCtx.getService(reference));
        }
        return (S)AccessController.doPrivileged(new PrivilegedAction<S>(){
            static final long serialVersionUID = -7273318755773875648L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @Trivial
            public S run() {
                BundleContext bCtx = ctx.getBundleContext();
                return bCtx == null ? null : bCtx.getService(reference);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler$3", 3.class, (String)"rest.validation", (String)"com.ibm.ws.rest.handler.validator.resources.CWWKOMessages");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Object handleSingleInstance(RESTRequest request, String uid, String id, Dictionary<String, Object> config) throws IOException {
        Object target;
        ServiceReference<?>[] targetRefs;
        Collection<ServiceReference<Validator>> validatorRefs;
        String configElementPid;
        Object application;
        String jndiName;
        OrderedJSONObject json = new OrderedJSONObject();
        json.put((Object)"uid", (Object)uid);
        if (id != null) {
            json.put((Object)"id", (Object)id);
        }
        if ((jndiName = (String)config.get("jndiName")) != null) {
            json.put((Object)"jndiName", (Object)jndiName);
        }
        if ((application = config.get("application")) != null) {
            json.put((Object)"application", application);
            Object module = config.get("module");
            if (module != null) {
                json.put((Object)"module", module);
                Object component = config.get("component");
                if (component != null) {
                    json.put((Object)"component", component);
                }
            }
        }
        if ((configElementPid = (String)config.get("service.factoryPid")) == null) {
            configElementPid = (String)config.get("service.pid");
        }
        try {
            String filter = FilterUtils.createPropertyFilter((String)"com.ibm.wsspi.rest.handler.config.pid", (String)configElementPid);
            validatorRefs = ValidatorRESTHandler.getServiceReferences(this.context.getBundleContext(), Validator.class, filter);
        }
        catch (InvalidSyntaxException filter) {
            FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler", (String)"198", (Object)((Object)this), (Object[])new Object[]{request, uid, id, config});
            validatorRefs = Collections.emptySet();
        }
        try {
            String filter = "(|" + FilterUtils.createPropertyFilter((String)"service.pid", (String)((String)config.get("service.pid"))) + FilterUtils.createPropertyFilter((String)"ibm.extends.subtype.pid", (String)((String)config.get("service.pid"))) + ")";
            targetRefs = ValidatorRESTHandler.getServiceReferences(this.context.getBundleContext(), (String)null, filter);
        }
        catch (InvalidSyntaxException filter) {
            FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler", (String)"209", (Object)((Object)this), (Object[])new Object[]{request, uid, id, config});
            targetRefs = null;
        }
        ServiceReference<?> targetRef = null;
        if (targetRefs != null) {
            for (ServiceReference<?> ref : targetRefs) {
                if (targetRef != null && ref.getProperty("creates.objectClass") == null) continue;
                targetRef = ref;
            }
        }
        Object v0 = target = validatorRefs.isEmpty() || targetRef == null ? null : ValidatorRESTHandler.getService(this.context, targetRef);
        if (target == null) {
            json.put((Object)"successful", (Object)false);
            json.put((Object)"failure", (Object)this.toJSONObject("message", Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1551_CANNOT_VALIDATE", (Object[])new Object[0])));
        } else {
            Validator validator;
            String loginConfigProps;
            String pass;
            HashMap<String, Object> params = new HashMap<String, Object>();
            boolean headerParamsURLEncoded = false;
            for (String key : request.getParameterMap().keySet()) {
                if ("headerParamsURLEncoded".equals(key)) {
                    headerParamsURLEncoded = Boolean.parseBoolean(request.getParameter(key));
                    continue;
                }
                if (this.isParameter(key)) {
                    params.put(key, this.resolvePotentialVariable(request.getParameter(key)));
                    continue;
                }
                return new HttpErrorInfo(400, "unrecognized query parameter: " + key);
            }
            String user = request.getHeader("X-Validation-User");
            if (user != null) {
                if (headerParamsURLEncoded) {
                    user = URLDecoder.decode(user, "UTF-8");
                }
                params.put("user", this.resolvePotentialVariable(user));
            }
            if ((pass = request.getHeader("X-Validation-Password")) != null) {
                if (headerParamsURLEncoded) {
                    pass = URLDecoder.decode(pass, "UTF-8");
                }
                params.put("password", this.variableRegistry.resolveRawString(pass));
            }
            if ((loginConfigProps = request.getHeader("X-Login-Config-Props")) != null) {
                TreeMap<String, String> lcProps = new TreeMap<String, String>();
                for (String entry : loginConfigProps.split(",")) {
                    int eq = entry.indexOf("=");
                    if (eq > 0) {
                        String name = entry.substring(0, eq);
                        String value = entry.substring(eq + 1);
                        if (headerParamsURLEncoded) {
                            name = URLDecoder.decode(name, "UTF-8");
                            value = URLDecoder.decode(value, "UTF-8");
                        }
                        lcProps.put(this.resolvePotentialVariable(name), this.resolvePotentialVariable(value));
                        continue;
                    }
                    json.put((Object)"successful", (Object)false);
                    json.put((Object)"failure", (Object)this.toJSONObject("message", Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1552_MISSING_DELIMITER", (Object[])new Object[0])));
                }
                params.put("loginConfigProps", lcProps);
            }
            if ((validator = ValidatorRESTHandler.getService(this.context, validatorRefs.iterator().next())) == null) {
                json.put((Object)"successful", (Object)false);
                json.put((Object)"failure", (Object)this.toJSONObject("message", Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1550_VALIDATOR_NOT_FOUND", (Object[])new Object[]{configElementPid})));
            } else if (!json.containsKey((Object)"successful")) {
                Map<String, Object> result;
                try {
                    result = validator.validate(target, params, request.getLocale());
                }
                catch (Throwable throwable) {
                    void x;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler", (String)"283", (Object)((Object)this), (Object[])new Object[]{request, uid, id, config});
                    result = Collections.singletonMap("failure", x);
                }
                Object failure = result.get("failure");
                if (failure instanceof Throwable) {
                    json.put((Object)"successful", (Object)false);
                    json.put((Object)"failure", (Object)this.toJSONObjectForThrowable(result, (Throwable)failure));
                } else if (failure instanceof String) {
                    json.put((Object)"successful", (Object)false);
                    json.put((Object)"failure", (Object)this.toJSONObject("message", failure));
                } else {
                    json.put((Object)"successful", (Object)true);
                    OrderedJSONObject info = new OrderedJSONObject();
                    for (Map.Entry entry : result.entrySet()) {
                        info.put(entry.getKey(), entry.getValue());
                    }
                    json.put((Object)"info", (Object)info);
                }
            }
        }
        return json;
    }

    public boolean isParameter(String name) {
        return "auth".equals(name) || "authAlias".equals(name) || "loginConfig".equals(name);
    }

    @Trivial
    public void populateResponse(RESTResponse response, Object responseInfo) throws IOException {
        JSONArtifact json;
        if (responseInfo instanceof JSONArtifact) {
            json = (JSONArtifact)responseInfo;
        } else if (responseInfo instanceof List) {
            JSONArray ja = new JSONArray();
            for (Object info : (List)responseInfo) {
                if (info instanceof JSONArtifact) {
                    ja.add(info);
                    continue;
                }
                if (info instanceof HttpErrorInfo) {
                    HttpErrorInfo errorInfo = (HttpErrorInfo)info;
                    response.sendError(errorInfo.code, errorInfo.message);
                    return;
                }
                throw new IllegalArgumentException(info.toString());
            }
            json = ja;
        } else {
            if (responseInfo instanceof HttpErrorInfo) {
                HttpErrorInfo errorInfo = (HttpErrorInfo)responseInfo;
                response.sendError(errorInfo.code, errorInfo.message);
                return;
            }
            throw new IllegalArgumentException(responseInfo.toString());
        }
        String jsonString = json.serialize(true);
        jsonString = jsonString.replaceAll("\\\\/", "/");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"populateResponse", (Object[])new Object[]{jsonString});
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getOutputStream().write(jsonString.getBytes("UTF-8"));
    }

    @Trivial
    private JSONObject toJSONObject(Object ... args) {
        OrderedJSONObject json = new OrderedJSONObject();
        for (int i = 0; i < args.length; i += 2) {
            json.put(args[i], args[i + 1]);
        }
        return json;
    }

    @Trivial
    private JSONObject toJSONObjectForThrowable(Map<String, ?> errorInfo, Throwable error) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"toJSONObjectForThrowable", (Object[])new Object[]{errorInfo, error});
        }
        LinkedHashMap<String, List> addedInfo = new LinkedHashMap<String, List>();
        for (Map.Entry<String, ?> entry : errorInfo.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof List)) continue;
            addedInfo.put(entry.getKey(), (List)value);
        }
        OrderedJSONObject json = new OrderedJSONObject();
        int index = 0;
        OrderedJSONObject current = json;
        HashSet<Throwable> causes = new HashSet<Throwable>();
        Throwable cause = error;
        while (cause != null && causes.add(cause)) {
            for (Map.Entry entry : addedInfo.entrySet()) {
                Object value;
                List values = (List)entry.getValue();
                if (values.size() <= index || (value = values.get(index)) == null) continue;
                current.put(entry.getKey(), value);
            }
            current.put((Object)"class", (Object)cause.getClass().getName());
            current.put((Object)"message", (Object)cause.getMessage());
            JSONArray stack = new JSONArray();
            for (StackTraceElement element : cause.getStackTrace()) {
                stack.add((Object)element.toString());
            }
            current.put((Object)"stack", (Object)stack);
            cause = cause.getCause();
            if (cause != null) {
                OrderedJSONObject orderedJSONObject = current;
                current = new OrderedJSONObject();
                orderedJSONObject.put("cause", current);
            }
            ++index;
        }
        return json;
    }

    @Trivial
    private static String read(InputStream input) throws IOException {
        String string;
        BufferedReader buffer = new BufferedReader(new InputStreamReader(input));
        try {
            string = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler", (String)"442", null, (Object[])new Object[]{input});
            try {
                buffer.close();
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler", (String)"442", null, (Object[])new Object[]{input});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        buffer.close();
        return string;
    }

    @Trivial
    private String resolvePotentialVariable(String value) {
        if (value == null) {
            return value;
        }
        String resolvedVariable = this.variableRegistry.resolveRawString(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Was a variable value found for " + value + "?  " + !value.equals(resolvedVariable)), (Object[])new Object[0]);
        }
        return resolvedVariable;
    }

    public final void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        if (!"GET".equals(request.getMethod())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Request method was " + request.getMethod() + " but the validation endpoint is restricted to GET requests only."), (Object[])new Object[0]);
            }
            response.setResponseHeader("Accept", "GET");
            response.sendError(405);
            return;
        }
        if (request.getPath().startsWith("/validation//")) {
            response.sendError(404, Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1553_HANDLER_NOT_FOUND", (Object[])new Object[]{request.getContextPath() + request.getPath()}));
            return;
        }
        super.handleRequest(request, response);
    }

    public boolean requireAdministratorRole() {
        return true;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpErrorInfo {
        private final int code;
        private final String message;
        static final long serialVersionUID = 8507035945452966654L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpErrorInfo(int errorCode, String message) {
            this.code = errorCode;
            this.message = message;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.rest.handler.validator.internal.ValidatorRESTHandler$HttpErrorInfo", HttpErrorInfo.class, (String)"rest.validation", (String)"com.ibm.ws.rest.handler.validator.resources.CWWKOMessages");
        }
    }
}

