/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.common.AppStructureHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class BndExtAdapter<ConfigType>
implements ContainerAdapter<ConfigType> {
    protected static final TraceComponent tc = Tr.register(BndExtAdapter.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    protected static final boolean XMI_UNUSED = false;
    public static final String MODULE_NAME_CHECKS = "module.name.checks";
    public static final String MODULE_NAME_NOT_SPECIFIED = "module.name.not.specified";
    public static final String MODULE_NAME_DUPLICATED = "module.name.duplicated";
    static final long serialVersionUID = 2264217065775032770L;

    public abstract List<? extends ConfigType> getConfigurations();

    protected abstract ConfigType parse(Container var1, Entry var2, boolean var3) throws DDParser.ParseException;

    protected abstract String getParentPid(ConfigType var1);

    protected abstract String getModuleName(ConfigType var1);

    protected abstract String getElementTag();

    protected abstract Class<?> getCacheType();

    protected abstract void setDelegate(ConfigType var1, ConfigType var2);

    protected ConfigType process(Container ddRoot, OverlayContainer ddOverlay, ArtifactContainer ddArtifactRoot, Container ddAdaptRoot, String ddPath, boolean xmi) throws UnableToAdaptException {
        ConfigType fromConfig = this.getConfigOverrides(ddOverlay, ddArtifactRoot);
        ConfigType fromModule = this.parse(ddAdaptRoot, ddPath, xmi);
        if (fromConfig == null) {
            return fromModule;
        }
        if (fromModule != null) {
            this.setDelegate(fromConfig, fromModule);
        }
        return fromConfig;
    }

    protected ConfigType getConfigOverrides(OverlayContainer ddOverlay, ArtifactContainer ddArtifactRoot) throws UnableToAdaptException {
        List<ConfigType> configurations = this.getConfigurations();
        if (configurations == null || configurations.isEmpty()) {
            return null;
        }
        String cachePath = ddArtifactRoot.getPath();
        ApplicationInfo appInfo = (ApplicationInfo)ddOverlay.getFromNonPersistentCache(cachePath, ApplicationInfo.class);
        ModuleInfo moduleInfo = null;
        if (appInfo == null) {
            moduleInfo = (ModuleInfo)ddOverlay.getFromNonPersistentCache(cachePath, ModuleInfo.class);
            if (moduleInfo == null) {
                return null;
            }
            appInfo = moduleInfo.getApplicationInfo();
        }
        if (appInfo == null) {
            return null;
        }
        if (!(appInfo instanceof ExtendedApplicationInfo)) {
            return null;
        }
        ExtendedApplicationInfo extAppInfo = (ExtendedApplicationInfo)appInfo;
        NestedConfigHelper configHelper = extAppInfo.getConfigHelper();
        if (configHelper == null) {
            return null;
        }
        String appServicePid = (String)configHelper.get("service.pid");
        String appExtendsPid = (String)configHelper.get("ibm.extends.source.pid");
        if (moduleInfo == null) {
            ConfigType result = this.getFirstConfig(appInfo, appServicePid, appExtendsPid);
            return result;
        }
        Map<String, ConfigType> configs = this.getConfigOverrides(appInfo, ddOverlay, appServicePid, appExtendsPid);
        if (configs == null) {
            return null;
        }
        ConfigType result = configs.get(moduleInfo.getName());
        return result;
    }

    protected ConfigType getFirstConfig(ApplicationInfo appInfo, String appServicePid, String appExtendsPid) {
        for (ConfigType config : this.getConfigurations()) {
            String parentPid = this.getParentPid(config);
            if (!appServicePid.equals(parentPid) && !parentPid.equals(appExtendsPid)) continue;
            return config;
        }
        return null;
    }

    protected Map<String, ConfigType> getConfigOverrides(ApplicationInfo appInfo, OverlayContainer ddOverlay, String appServicePid, String appExtendsPid) throws UnableToAdaptException {
        HashMap<String, ConfigType> selectedConfigs = null;
        HashSet<String> dupModuleNames = null;
        int absentModuleNames = 0;
        for (ConfigType config : this.getConfigurations()) {
            String parentPid = this.getParentPid(config);
            if (!appServicePid.equals(parentPid) && !parentPid.equals(appExtendsPid)) continue;
            String moduleName = this.getModuleName(config);
            if (moduleName == null) {
                ++absentModuleNames;
                continue;
            }
            moduleName = this.stripExtension(moduleName);
            if (selectedConfigs == null) {
                selectedConfigs = new HashMap<String, ConfigType>(1);
            }
            if (selectedConfigs.put(moduleName, config) == null) continue;
            if (dupModuleNames == null) {
                dupModuleNames = new HashSet<String>(1);
            }
            dupModuleNames.add(moduleName);
        }
        String elementTag = this.getElementTag();
        if (!this.alreadyRecorded(ddOverlay, MODULE_NAME_CHECKS + elementTag)) {
            String appName = null;
            if (absentModuleNames != 0) {
                appName = this.getSimpleName(appInfo);
                Tr.error((TraceComponent)tc, (String)MODULE_NAME_NOT_SPECIFIED, (Object[])new Object[]{appName, elementTag});
            }
            if (dupModuleNames != null) {
                if (appName == null) {
                    appName = this.getSimpleName(appInfo);
                }
                Tr.error((TraceComponent)tc, (String)MODULE_NAME_DUPLICATED, (Object[])new Object[]{appName, elementTag, dupModuleNames});
            }
        }
        return selectedConfigs;
    }

    protected String stripExtension(String moduleName) {
        if (moduleName.endsWith(".war") || moduleName.endsWith(".jar")) {
            return moduleName.substring(0, moduleName.length() - 4);
        }
        return moduleName;
    }

    protected String getSimpleName(ApplicationInfo appInfo) {
        return DDParser.getSimpleName(appInfo.getContainer());
    }

    protected boolean alreadyRecorded(OverlayContainer ddOverlay, String overlayMessage) {
        OverlayContainer messageOverlay;
        Class<?> cacheType = this.getCacheType();
        OverlayContainer appOverlay = ddOverlay.getParentOverlay();
        OverlayContainer overlayContainer = messageOverlay = appOverlay == null ? ddOverlay : appOverlay;
        if (messageOverlay.getFromNonPersistentCache(overlayMessage, cacheType) != null) {
            return true;
        }
        messageOverlay.addToNonPersistentCache(overlayMessage, cacheType, (Object)overlayMessage);
        return false;
    }

    @FFDCIgnore(value={DDParser.ParseException.class})
    protected ConfigType parse(Container ddAdaptRoot, String ddPath, boolean xmi) throws UnableToAdaptException {
        Entry ddEntry = ddAdaptRoot.getEntry(ddPath);
        if (ddEntry == null) {
            return null;
        }
        try {
            return this.parse(ddAdaptRoot, ddEntry, xmi);
        }
        catch (DDParser.ParseException e) {
            throw new UnableToAdaptException((Throwable)e);
        }
    }

    public String getAppVersion(Container ddAdaptRoot) throws UnableToAdaptException {
        return AppStructureHelper.getAppVersion(ddAdaptRoot);
    }

    public String getAppClientVersion(Container ddAdaptRoot) throws UnableToAdaptException {
        return AppStructureHelper.getAppClientVersion(ddAdaptRoot);
    }

    public boolean isWebModule(OverlayContainer ddOverlay, ArtifactContainer ddArtifactRoot) {
        return AppStructureHelper.isWebModule(ddOverlay, ddArtifactRoot);
    }

    public String getWebVersion(Container ddAdaptRoot) throws UnableToAdaptException {
        return AppStructureHelper.getWebVersion(ddAdaptRoot);
    }

    public Integer getEJBVersion(Container ddAdaptRoot) throws UnableToAdaptException {
        return AppStructureHelper.getEJBVersion(ddAdaptRoot);
    }
}

