/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.ormparser;

import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IEntityMappings;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;

public class EntityMappingsDefinition {
    private final URL source;
    private final byte[] fileData;
    private final BigInteger hash;
    private final IEntityMappings entityMappings;

    public EntityMappingsDefinition(URL source, byte[] fileData, BigInteger hash, IEntityMappings entityMappings) {
        if (source == null || hash == null || entityMappings == null) {
            throw new NullPointerException("Constructor cannot accept any null arguments.");
        }
        this.source = source;
        this.fileData = fileData;
        this.hash = hash;
        this.entityMappings = entityMappings;
    }

    public BigInteger getHash() {
        return this.hash;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public URL getSource() {
        return this.source;
    }

    public IEntityMappings getEntityMappings() {
        return this.entityMappings;
    }

    public String getEntityMappingsAsXML() {
        try {
            JAXBContext jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{this.entityMappings.getClass()});
            Marshaller m = jaxbCtx.createMarshaller();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            m.marshal((Object)this.entityMappings, (OutputStream)baos);
            return baos.toString();
        }
        catch (JAXBException e) {
            return "";
        }
    }

    public byte[] getEntityMappingsAsXMLBytes() {
        try {
            JAXBContext jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{this.entityMappings.getClass()});
            Marshaller m = jaxbCtx.createMarshaller();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            m.marshal((Object)this.entityMappings, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (JAXBException e) {
            return new byte[0];
        }
    }

    public String getVersion() {
        return this.entityMappings.getVersion();
    }
}

