/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.puscanner;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.AsmClassAnalyzer;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.ClassScannerException;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.InnerOuterResolver;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.InnerClassesType;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsDefinition;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsFactory;
import com.ibm.ws.jpa.diagnostics.puscanner.PersistenceUnitScannerException;
import com.ibm.ws.jpa.diagnostics.puscanner.PersistenceUnitScannerResults;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PersistenceUnitScanner {
    private final List<PersistenceUnitInfo> puiList;
    private final HashMap<URL, String> pxmlMap;
    private final Set<URL> urlSet = new HashSet<URL>();
    private final HashMap<URL, Set<ClassInfoType>> scannedClassesMap = new HashMap();
    private final HashMap<PersistenceUnitInfo, List<URL>> pu_ormFiles_map = new HashMap();
    private final HashMap<URL, EntityMappingsDefinition> scanned_ormfile_map = new HashMap();
    private final HashMap<PersistenceUnitInfo, List<EntityMappingsDefinition>> pu_ormFileParsed_map = new HashMap();
    private final InnerOuterResolver ioResolver = new InnerOuterResolver();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final byte[] buffer = new byte[4096];

    public static PersistenceUnitScannerResults scan(List<PersistenceUnitInfo> puiList, HashMap<URL, String> pxmlMap) throws PersistenceUnitScannerException {
        PersistenceUnitScanner scanner = new PersistenceUnitScanner(puiList, pxmlMap);
        return scanner.scan();
    }

    private PersistenceUnitScanner(List<PersistenceUnitInfo> puiList, HashMap<URL, String> pxmlMap) {
        this.puiList = puiList;
        this.pxmlMap = pxmlMap;
    }

    private PersistenceUnitScannerResults scan() throws PersistenceUnitScannerException {
        for (PersistenceUnitInfo pui : this.puiList) {
            this.urlSet.add(pui.getPersistenceUnitRootUrl());
            this.urlSet.addAll(pui.getJarFileUrls());
            this.pu_ormFiles_map.put(pui, new ArrayList());
            this.pu_ormFileParsed_map.put(pui, new ArrayList());
        }
        this.scanEntityMappings();
        this.scanClasses();
        return new PersistenceUnitScannerResults(this.puiList, this.pxmlMap, this.urlSet, this.scannedClassesMap, this.scanned_ormfile_map, this.pu_ormFileParsed_map);
    }

    private void scanClasses() throws PersistenceUnitScannerException {
        try {
            for (URL url : this.urlSet) {
                HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
                String urlProtocol = url.getProtocol();
                if ("file".equalsIgnoreCase(urlProtocol)) {
                    Path taPath = Paths.get(url.toURI());
                    if (Files.isDirectory(taPath, new LinkOption[0])) {
                        citSet.addAll(this.processExplodedJarFormat(taPath));
                    } else {
                        citSet.addAll(this.processUnexplodedFile(taPath));
                    }
                } else if (url.toString().startsWith("jar:file")) {
                    citSet.addAll(this.processJarFileURL(url));
                } else {
                    citSet.addAll(this.processJarFormatInputStreamURL(url));
                }
                this.processInnerClasses(citSet);
                this.scannedClassesMap.put(url, citSet);
            }
        }
        catch (Exception e) {
            throw new PersistenceUnitScannerException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<ClassInfoType> processExplodedJarFormat(Path path) throws ClassScannerException {
        HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
        final HashSet archiveFiles = new HashSet();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Files.isRegularFile(file, new LinkOption[0]) && Files.size(file) > 0L && file.getFileName().toString().endsWith(".class")) {
                        archiveFiles.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            for (Path p : archiveFiles) {
                String cName = path.relativize(p).toString().replace("/", ".");
                cName = cName.substring(0, cName.length() - 6);
                try {
                    InputStream is = Files.newInputStream(p, new OpenOption[0]);
                    try {
                        citSet.add(this.scanByteCodeFromInputStream(cName, is));
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Throwable t) {
                    throw new ClassScannerException(t);
                    return citSet;
                }
            }
        }
        catch (ClassScannerException cse) {
            throw cse;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(PersistenceUnitScanner.class.getName() + ".processExplodedJarFormat"), (String)"153");
            throw new ClassScannerException(t);
        }
    }

    private Set<ClassInfoType> processUnexplodedFile(Path path) throws ClassScannerException {
        HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
        if (path == null) {
            throw new ClassScannerException("Null argument is invalid for method processUnexplodedFile().");
        }
        try (ZipFile zf = new ZipFile(path.toFile());){
            Enumeration<? extends ZipEntry> entryEnum = zf.entries();
            while (entryEnum.hasMoreElements()) {
                String entryName;
                ZipEntry entry = entryEnum.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
                InputStream is = zf.getInputStream(entry);
                try {
                    String cName = entryName.replace("/", ".");
                    cName = cName.substring(0, cName.length() - 6);
                    citSet.add(this.scanByteCodeFromInputStream(cName, is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (ClassScannerException cse) {
            throw cse;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(PersistenceUnitScanner.class.getName() + ".processUnexplodedFile"), (String)"199");
            throw new ClassScannerException(t);
        }
        return citSet;
    }

    private Set<ClassInfoType> processJarFileURL(URL jarFileURL) throws ClassScannerException {
        HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
        try {
            JarURLConnection conn = (JarURLConnection)jarFileURL.openConnection();
            try (JarFile jarFile = conn.getJarFile();){
                Enumeration<JarEntry> jarEntryEnum = jarFile.entries();
                while (jarEntryEnum.hasMoreElements()) {
                    JarEntry jEntry = jarEntryEnum.nextElement();
                    String jEntryName = jEntry.getName();
                    if (jEntryName == null || !jEntryName.endsWith(".class")) continue;
                    String name = jEntryName.substring(0, jEntryName.length() - 6).replace("/", ".");
                    InputStream jis = jarFile.getInputStream(jEntry);
                    citSet.add(this.scanByteCodeFromInputStream(name, jis));
                }
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)(PersistenceUnitScanner.class.getName() + ".processJarFileURL"), (String)"227");
            throw new ClassScannerException(e);
        }
        return citSet;
    }

    private Set<ClassInfoType> processJarFormatInputStreamURL(URL jarURL) throws ClassScannerException {
        HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
        try (JarInputStream jis = new JarInputStream(jarURL.openStream(), false);){
            JarEntry jarEntry = null;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                String name = jarEntry.getName();
                if (name == null || !name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6).replace("/", ".");
                citSet.add(this.scanByteCodeFromInputStream(name, jis));
            }
        }
        catch (Throwable t) {
            throw new ClassScannerException(t);
        }
        return citSet;
    }

    private ClassInfoType scanByteCodeFromInputStream(String cName, InputStream is) throws ClassScannerException {
        this.baos.reset();
        try {
            int bytesRead = 0;
            while ((bytesRead = is.read(this.buffer, 0, 4096)) > -1) {
                if (bytesRead <= 0) continue;
                this.baos.write(this.buffer, 0, bytesRead);
            }
            byte[] classByteCode = this.baos.toByteArray();
            this.baos.reset();
            return AsmClassAnalyzer.analyzeClass(cName, classByteCode, this.ioResolver);
        }
        catch (Throwable t) {
            throw new ClassScannerException(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processInnerClasses(Set<ClassInfoType> citSet) throws ClassScannerException {
        HashSet<ClassInfoType> innerClassSet = new HashSet<ClassInfoType>();
        for (ClassInfoType classInfoType : citSet) {
            String string = classInfoType.getClassName();
            if (!string.contains("$")) continue;
            innerClassSet.add(classInfoType);
        }
        if (innerClassSet.size() == 0) {
            return;
        }
        ArrayList innerClassDepthList = new ArrayList();
        for (ClassInfoType classInfoType : innerClassSet) {
            String innerClassName = classInfoType.getClassName();
            String outerClassName = innerClassName.substring(0, innerClassName.lastIndexOf("$"));
            int depth = 1;
            for (char c : outerClassName.toCharArray()) {
                if ('$' != c) continue;
                ++depth;
            }
            if (innerClassDepthList.size() < depth) {
                for (int i = depth - innerClassDepthList.size(); i > 0; --i) {
                    innerClassDepthList.add(new HashSet());
                }
            }
            HashSet innerClassDepthSet = (HashSet)innerClassDepthList.get(depth - 1);
            innerClassDepthSet.add(classInfoType);
        }
        if (innerClassDepthList.size() > 1) {
            void var4_7;
            int n = innerClassDepthList.size() - 1;
            while (var4_7 >= true) {
                HashSet hashSet = (HashSet)innerClassDepthList.get((int)var4_7);
                HashSet innerClassesAtHigherDepth = (HashSet)innerClassDepthList.get((int)(var4_7 - true));
                for (ClassInfoType cit : hashSet) {
                    String innerClassName = cit.getClassName();
                    String outerClassName = innerClassName.substring(0, innerClassName.lastIndexOf("$"));
                    ClassInfoType higherInnerClass = null;
                    for (ClassInfoType uIC : innerClassesAtHigherDepth) {
                        if (!uIC.getClassName().equals(outerClassName)) continue;
                        higherInnerClass = uIC;
                        break;
                    }
                    if (higherInnerClass == null) continue;
                    InnerClassesType ict = higherInnerClass.getInnerclasses();
                    if (ict == null) {
                        ict = new InnerClassesType();
                        higherInnerClass.setInnerclasses(ict);
                    }
                    List<ClassInfoType> innerClassList = ict.getInnerclass();
                    ClassInfoType replaceThis = null;
                    for (ClassInfoType iclCit : innerClassList) {
                        if (!iclCit.getClassName().equals(innerClassName)) continue;
                        replaceThis = iclCit;
                        break;
                    }
                    if (replaceThis == null) {
                        innerClassList.remove(replaceThis);
                    }
                    innerClassList.add(cit);
                }
                --var4_7;
            }
        }
        HashSet hashSet = (HashSet)innerClassDepthList.get(0);
        for (ClassInfoType innerCit : hashSet) {
            String innerClassName = innerCit.getClassName();
            String outerClassName = innerClassName.substring(0, innerClassName.lastIndexOf("$"));
            Object object = citSet.iterator();
            while (object.hasNext()) {
                ClassInfoType cit = (ClassInfoType)object.next();
                if (!cit.getClassName().equals(outerClassName)) continue;
                InnerClassesType ict = cit.getInnerclasses();
                if (ict == null) {
                    ict = new InnerClassesType();
                    cit.setInnerclasses(ict);
                }
                List<ClassInfoType> innerClassList = ict.getInnerclass();
                ClassInfoType replaceThis = null;
                for (ClassInfoType iclCit : innerClassList) {
                    if (!iclCit.getClassName().equals(innerClassName)) continue;
                    replaceThis = iclCit;
                    break;
                }
                if (replaceThis != null) {
                    innerClassList.remove(replaceThis);
                }
                innerClassList.add(innerCit);
            }
        }
        citSet.removeAll(innerClassSet);
    }

    private void scanEntityMappings() throws PersistenceUnitScannerException {
        HashSet<URL> mappingFilesLocated = new HashSet<URL>();
        HashSet<String> searchNames = new HashSet<String>();
        for (PersistenceUnitInfo pui : this.puiList) {
            try {
                mappingFilesLocated.clear();
                searchNames.clear();
                searchNames.add("META-INF/orm.xml");
                if (pui.getMappingFileNames() != null) {
                    searchNames.addAll(pui.getMappingFileNames());
                }
                for (String mappingFile : searchNames) {
                    mappingFilesLocated.addAll(this.findORMResources(pui, mappingFile));
                }
                List<EntityMappingsDefinition> parsedOrmList = this.pu_ormFileParsed_map.get(pui);
                this.pu_ormFiles_map.get(pui).addAll(mappingFilesLocated);
                for (URL mappingFileURL : mappingFilesLocated) {
                    if (this.scanned_ormfile_map.containsKey(mappingFileURL)) {
                        parsedOrmList.add(this.scanned_ormfile_map.get(mappingFileURL));
                        continue;
                    }
                    EntityMappingsDefinition emapdef = EntityMappingsFactory.parseEntityMappings(mappingFileURL);
                    parsedOrmList.add(emapdef);
                    this.scanned_ormfile_map.put(mappingFileURL, emapdef);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(PersistenceUnitScanner.class.getName() + ".scanEntityMappings"), (String)"460");
                throw new PersistenceUnitScannerException(e);
            }
        }
    }

    private List<URL> findORMResources(PersistenceUnitInfo pui, String ormFileName) throws IOException {
        boolean isMetaInfoOrmXML = "META-INF/orm.xml".equals(ormFileName);
        ArrayList<URL> retArr = new ArrayList<URL>();
        URL puu = pui.getPersistenceUnitRootUrl();
        String puRootURL = pui.getPersistenceUnitRootUrl().toExternalForm();
        if (puRootURL.startsWith("wsjpa:")) {
            puRootURL = puRootURL.substring(6);
        }
        Enumeration<URL> ormEnum = pui.getClassLoader().getResources(ormFileName);
        while (ormEnum.hasMoreElements()) {
            URL url = ormEnum.nextElement();
            String urlExtern = url.toExternalForm();
            URL containerURL = new URL(urlExtern.substring(0, urlExtern.length() - "META-INF/orm.xml".length()));
            if (!isMetaInfoOrmXML) {
                retArr.add(url);
                continue;
            }
            if (puu.sameFile(containerURL)) {
                retArr.add(url);
                continue;
            }
            for (URL jarUrl : pui.getJarFileUrls()) {
                String jarUrlExtern = jarUrl.toExternalForm();
                URL jarContainerURL = new URL(jarUrlExtern.substring(0, jarUrlExtern.length() - "META-INF/orm.xml".length()));
                if (!puu.sameFile(jarContainerURL)) continue;
                retArr.add(url);
            }
        }
        return retArr;
    }
}

