/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.annocache.jandex.internal.Jandex_Utils;
import com.ibm.ws.annocache.jandex.internal.SparseClassInfo;
import com.ibm.ws.annocache.jandex.internal.SparseDotName;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Options;
import com.ibm.wsspi.annocache.classsource.ClassSource_Streamer;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class ClassSourceImpl
implements ClassSource {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected static final Logger stateLogger = AnnotationCacheServiceImpl_Logging.ANNO_STATE_LOGGER;
    protected static final Logger jandexLogger = AnnotationCacheServiceImpl_Logging.ANNO_JANDEX_LOGGER;
    public static final String CLASS_NAME = ClassSourceImpl.class.getSimpleName();
    protected final String hashText;
    protected final ClassSourceImpl_Factory factory;
    private final String entryPrefix;
    protected final String name;
    protected final String canonicalName;
    protected ClassSource_Aggregate parentSource;
    private static final int NS_IN_MS = 1000000;
    protected String stamp;
    protected final Util_InternMap internMap;
    protected boolean processedUsingJandex;
    protected boolean readFromCache;
    protected long processTime;
    protected int processCount;
    static final long serialVersionUID = -35582084739072802L;

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static long getTime() {
        return System.currentTimeMillis();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static String getAbsolutePath(String path) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "getAbsolutePath", new Object[]{path});
        }
        String string = new File(path).getAbsolutePath();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "getAbsolutePath", string);
        }
        return string;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String resourceAppend(String head, String tail) {
        if (head.isEmpty()) {
            return tail;
        }
        return head + '/' + tail;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isDirectoryResource(String resourceName) {
        return resourceName.endsWith("/");
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isClassResource(String resourceName) {
        return resourceName.endsWith(".class");
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getClassNameFromResourceName(String resourceName) {
        int endingOffset = resourceName.length() - ".class".length();
        String className = resourceName.substring(0, endingOffset);
        className = className.replace('/', '.');
        return className;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getResourceNameFromClassName(String className) {
        return ClassSourceImpl.resourceNameFromClassName(className);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String resourceNameFromClassName(String className) {
        return className.replace('.', '/') + ".class";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isJava9PackageName(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "isJava9PackageName", new Object[]{packageName});
        }
        if (packageName.endsWith("module-info")) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "isJava9PackageName", bl);
            }
            return bl;
        }
        if (packageName.contains("META-INF")) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "isJava9PackageName", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "isJava9PackageName", bl);
        }
        return bl;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @Trivial
    public String toString() {
        return this.hashText;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ClassSourceImpl(ClassSourceImpl_Factory factory, Util_InternMap internMap, String entryPrefix, String name, String hashTextSuffix) {
        String methodName = "<init>";
        this.internMap = internMap;
        this.factory = factory;
        if (entryPrefix != null) {
            if (entryPrefix.isEmpty()) {
                throw new IllegalArgumentException("Prefix cannot be empty");
            }
            if (entryPrefix.charAt(entryPrefix.length() - 1) != '/') {
                throw new IllegalArgumentException("Prefix [ " + entryPrefix + " ] must have a trailing '/'");
            }
        }
        this.entryPrefix = entryPrefix;
        this.name = name;
        this.canonicalName = factory.getCanonicalName(this.name);
        this.parentSource = null;
        String useHashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        useHashText = useHashText + "(" + this.canonicalName;
        if (hashTextSuffix != null) {
            useHashText = useHashText + ", " + hashTextSuffix;
        }
        this.hashText = useHashText = useHashText + ")";
        this.processedUsingJandex = false;
        this.processTime = 0L;
        this.processCount = 0;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] InternMap [ {1} ]", new Object[]{this.hashText, this.internMap.getHashText()});
            if (this.entryPrefix != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Prefix [ {1} ]", new Object[]{this.hashText, this.entryPrefix});
            }
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEntryPrefix() {
        return this.entryPrefix;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        return this.name;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate getParentSource() {
        return this.parentSource;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setParentSource(ClassSource_Aggregate parentSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "setParentSource", new Object[]{parentSource});
        }
        this.parentSource = parentSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "setParentSource");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Options getOptions() {
        return this.getParentSource().getOptions();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getUseJandex() {
        return this.getOptions().getUseJandex();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getJandexIndexPath() {
        return this.getOptions().getJandexPath();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SparseIndex getSparseJandexIndex() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "getSparseJandexIndex", new Object[0]);
        }
        String methodName = "getSparseJandexIndex";
        long startTime = System.nanoTime();
        SparseIndex jandexIndex = this.basicGetSparseJandexIndex();
        long readTime = System.nanoTime() - startTime;
        if (jandexIndex != null) {
            this.setProcessTime(readTime);
            this.setProcessCount(jandexIndex.getKnownClasses().size());
        }
        boolean doLog = logger.isLoggable(Level.FINER);
        boolean doJandexLog = jandexLogger.isLoggable(Level.FINER);
        if (doLog || doJandexLog) {
            String msg = jandexIndex != null ? MessageFormat.format("[ {0} ] Index [ {1} ] found; [ {2} (ms) ]", this.getHashText(), this.getJandexIndexPath(), readTime / 1000000L) : MessageFormat.format("[ {0} ] Index [ {1} ] not found", this.getHashText(), this.getJandexIndexPath());
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, msg);
            }
            if (doJandexLog) {
                jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, msg);
            }
        }
        SparseIndex sparseIndex = jandexIndex;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sparseIndex = sparseIndex;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "getSparseJandexIndex", sparseIndex);
        }
        return sparseIndex;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SparseIndex basicGetSparseJandexIndex() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "basicGetSparseJandexIndex", new Object[0]);
        }
        SparseIndex sparseIndex = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sparseIndex = sparseIndex;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "basicGetSparseJandexIndex", sparseIndex);
        }
        return sparseIndex;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStamp() {
        if (this.stamp == null) {
            this.stamp = this.computeStamp();
        }
        return this.stamp;
    }

    protected abstract String computeStamp();

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_InternMap getInternMap() {
        return this.internMap;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(String className) {
        return this.getInternMap().intern(className);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(String className, boolean doForce) {
        return this.getInternMap().intern(className, doForce);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean i_maybeAdd(String i_resourceName, Set<String> i_seedClassNamesSet) {
        String methodName = "i_maybeAdd";
        boolean didAdd = !i_seedClassNamesSet.contains(i_resourceName);
        if (didAdd) {
            i_seedClassNamesSet.add(i_resourceName);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Resource [ {1} ]: [ {2} ]", new Object[]{this.getHashText(), i_resourceName, didAdd});
        }
        return didAdd;
    }

    @Override
    public abstract void open() throws ClassSource_Exception;

    @Override
    public abstract void close() throws ClassSource_Exception;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BufferedInputStream openClassResourceStream(String className, String resourceName) throws ClassSource_Exception {
        return this.openResourceStream(className, resourceName, 8192);
    }

    @Override
    public abstract InputStream openResourceStream(String var1, String var2) throws ClassSource_Exception;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BufferedInputStream openResourceStream(String className, String resourceName, int bufferSize) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "openResourceStream", new Object[]{className, resourceName, bufferSize});
        }
        InputStream inputStream = this.openResourceStream(className, resourceName);
        BufferedInputStream bufferedInputStream = inputStream == null ? null : new BufferedInputStream(inputStream, bufferSize);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bufferedInputStream = bufferedInputStream;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "openResourceStream", bufferedInputStream);
        }
        return bufferedInputStream;
    }

    @Override
    public abstract void closeResourceStream(String var1, String var2, InputStream var3);

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logState() {
        if (stateLogger.isLoggable(Level.FINER)) {
            this.log(stateLogger);
        }
    }

    @Override
    public abstract void log(Logger var1);

    @Override
    public abstract void log(TraceComponent var1);

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logCounts(TraceComponent tc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Included classes: [ {0} ]", this.getClassInclusionCount()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Excluded classes: [ {0} ]", this.getClassExclusionCount()), (Object[])new Object[0]);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void process(ClassSource_Streamer streamer) throws ClassSource_Exception {
        String scanTag;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "process", new Object[]{streamer});
        }
        String methodName = "process";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        int initialClasses = this.getInternMap().getSize();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Processing [ {1} ] Initial classes [ {2} ]", new Object[]{this.getHashText(), this.getCanonicalName(), initialClasses});
        }
        if (this.processUsingJandex(streamer)) {
            scanTag = "Existing jandex index";
        } else if (this.processJandexFromScratch(streamer)) {
            scanTag = "New jandex index";
        } else {
            long startScan = System.nanoTime();
            this.setProcessCount(this.processFromScratch(streamer));
            long scanTime = System.nanoTime() - startScan;
            this.setProcessTime(scanTime);
            scanTag = "New scan";
        }
        int finalClasses = this.getInternMap().getSize();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Processing [ {1} ] {2}; Final classes [ {3} ]", new Object[]{this.getHashText(), this.getCanonicalName(), scanTag, finalClasses});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] Added classes", new Object[]{this.getHashText(), finalClasses - initialClasses});
        }
        if (jandexLogger.isLoggable(Level.FINER)) {
            String useHashText = this.getHashText();
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Processing [ {1} ] {2}; Final classes [ {3} ]", new Object[]{useHashText, this.getCanonicalName(), scanTag, finalClasses});
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Added classes [ {1} ]", new Object[]{useHashText, finalClasses - initialClasses});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "process");
        }
    }

    protected abstract int processFromScratch(ClassSource_Streamer var1) throws ClassSource_Exception;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean processJandexFromScratch(ClassSource_Streamer streamer) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processJandexFromScratch", new Object[]{streamer});
        }
        if (!streamer.createJandex()) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processJandexFromScratch", bl);
            }
            return bl;
        }
        long startScan = System.nanoTime();
        Index jandexIndex = this.createIndex();
        Collection jandexClasses = jandexIndex.getKnownClasses();
        for (ClassInfo jandexClassInfo : jandexClasses) {
            streamer.processJandex(jandexClassInfo);
        }
        streamer.storeJandex(jandexIndex);
        this.setProcessCount(jandexClasses.size());
        long scanTime = System.nanoTime() - startScan;
        this.setProcessTime(scanTime);
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processJandexFromScratch", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Index createIndex() throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "createIndex", new Object[0]);
        }
        final Indexer indexer = Jandex_Utils.createIndexer();
        ClassSource_Streamer jandexStreamer = new ClassSource_Streamer(){
            static final long serialVersionUID = 2797697772417165637L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean process(String i_className, InputStream inputStream) throws ClassSource_Exception {
                String methodName = "process";
                try {
                    indexer.index(inputStream);
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl$1", (String)"662", (Object)this, (Object[])new Object[]{i_className, inputStream});
                    throw ClassSourceImpl.this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, "Failed to scan class [ " + i_className + " ] of class source [ " + ClassSourceImpl.this.getCanonicalName() + " ]", (Throwable)e);
                }
                return true;
            }

            @Override
            public boolean doProcess(String className) {
                return true;
            }

            @Override
            public boolean supportsJandex() {
                return false;
            }

            @Override
            public boolean createJandex() {
                return false;
            }

            @Override
            public void storeJandex(Object jandexIndex) {
            }

            @Override
            public void processJandex() {
            }

            @Override
            public boolean processJandex(Object classInfo) throws ClassSource_Exception {
                return false;
            }

            @Override
            public boolean processSparseJandex(Object sparseClassInfo) throws ClassSource_Exception {
                return false;
            }

            @Override
            public boolean doProcess(String className, ClassSource_Aggregate.ScanPolicy scanPolicy) {
                return false;
            }

            @Override
            public boolean process(String sourceName, String className, InputStream inputStream, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                return false;
            }

            @Override
            public boolean process(String sourceName, Object jandexClassInfo, ClassSource_Aggregate.ScanPolicy scanPolicy) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
                return false;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        };
        int classCount = this.processFromScratch(jandexStreamer);
        Index index = indexer.complete();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            index = index;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "createIndex", index);
        }
        return index;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Index getJandexIndex() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "getJandexIndex", new Object[0]);
        }
        String methodName = "getJandexIndex";
        long startTime = System.nanoTime();
        Index jandexIndex = this.basicGetJandexIndex();
        long readTime = System.nanoTime() - startTime;
        if (jandexIndex != null) {
            this.setProcessTime(readTime);
            this.setProcessCount(jandexIndex.getKnownClasses().size());
        }
        boolean doLog = logger.isLoggable(Level.FINER);
        boolean doJandexLog = jandexLogger.isLoggable(Level.FINER);
        if (doLog || doJandexLog) {
            String msg = jandexIndex != null ? MessageFormat.format("[ {0} ] Index [ {1} ] found [ {2} (ms) ]", this.getHashText(), this.getJandexIndexPath(), readTime / 1000000L) : MessageFormat.format("[ {0} ] Index [ {1} ] not found", this.getHashText(), this.getJandexIndexPath());
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, msg);
            }
            if (doJandexLog) {
                jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, msg);
            }
        }
        Index index = jandexIndex;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            index = index;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "getJandexIndex", index);
        }
        return index;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Index basicGetJandexIndex() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "basicGetJandexIndex", new Object[0]);
        }
        Index index = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            index = index;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "basicGetJandexIndex", index);
        }
        return index;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean basicHasJandexIndex() {
        return false;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isProcessedUsingJandex() {
        return this.processedUsingJandex;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadFromCache() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "isReadFromCache", new Object[0]);
        }
        boolean bl = this.readFromCache;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "isReadFromCache", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setReadFromCache(long processTime, int processCount) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "setReadFromCache", new Object[]{processTime, processCount});
        }
        this.readFromCache = true;
        this.processTime = processTime;
        this.processCount = processCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "setReadFromCache");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getProcessTime() {
        return this.processTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setProcessTime(long processTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "setProcessTime", new Object[]{processTime});
        }
        this.processTime = processTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "setProcessTime");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected long addProcessTime(long addProcessTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "addProcessTime", new Object[]{addProcessTime});
        }
        this.processTime += addProcessTime;
        long l = this.processTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "addProcessTime", l);
        }
        return l;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getProcessCount() {
        return this.processCount;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setProcessCount(int processCount) {
        this.processCount = processCount;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean processUsingJandex(ClassSource_Streamer streamer) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processUsingJandex", new Object[]{streamer});
        }
        String methodName = "processUsingJandex";
        if (streamer == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processUsingJandex", bl);
            }
            return bl;
        }
        if (this.getUseJandex()) {
            if (this.processJandexSparse(streamer)) {
                this.processedUsingJandex = true;
                boolean bl = true;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processUsingJandex", bl);
                }
                return bl;
            }
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processUsingJandex", bl);
            }
            return bl;
        }
        boolean doLog = logger.isLoggable(Level.FINER);
        boolean doJandexLog = jandexLogger.isLoggable(Level.FINER);
        if ((doLog || doJandexLog) && this.basicHasJandexIndex()) {
            String msg = MessageFormat.format("[ {0} ] Jandex disabled; Jandex index [ {1} ] found", this.getHashText(), this.getJandexIndexPath());
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, msg);
            }
            if (doJandexLog) {
                jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, msg);
            }
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processUsingJandex", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean processJandexFull(ClassSource_Streamer streamer) {
        String methodName = "processJandexFull";
        if (!this.getUseJandex()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER / RETURN [ false ]: jandex is not enabled");
            }
            return false;
        }
        Index index = this.getJandexIndex();
        if (index == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER / RETURN [ false ]: no index or read failure");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER Classes [ {0} ]", index.getKnownClasses().size());
        }
        long startTime = System.nanoTime();
        streamer.processJandex();
        for (ClassInfo classInfo : index.getKnownClasses()) {
            DotName classDotName = classInfo.name();
            String className = classDotName.toString();
            if (!streamer.doProcess(className)) continue;
            try {
                boolean bl = streamer.processJandex(classInfo);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", (String)"950", (Object)this, (Object[])new Object[]{streamer});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_JANDEX_SCAN_EXCEPTION", new Object[]{this.getHashText(), className, e});
            }
        }
        long addedTime = this.addProcessTime(System.nanoTime() - startTime);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN [ true ]");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean processJandexSparse(ClassSource_Streamer streamer) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processJandexSparse", new Object[]{streamer});
        }
        String methodName = "processJandexSparse";
        SparseIndex sparseIndex = this.getSparseJandexIndex();
        if (sparseIndex == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER / RETURN [ false ]: no index or read failure");
            }
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processJandexSparse", bl);
            }
            return bl;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER Classes [ {0} ]", sparseIndex.getKnownClasses().size());
        }
        long startTime = System.nanoTime();
        streamer.processJandex();
        for (SparseClassInfo sparseClassInfo : sparseIndex.getKnownClasses()) {
            SparseDotName classDotName = sparseClassInfo.name();
            String className = classDotName.toString();
            if (!streamer.doProcess(className)) continue;
            try {
                boolean bl = streamer.processSparseJandex(sparseClassInfo);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", (String)"998", (Object)this, (Object[])new Object[]{streamer});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_JANDEX_SCAN_EXCEPTION", new Object[]{this.getHashText(), className, e});
            }
        }
        long addedTime = this.addProcessTime(System.nanoTime() - startTime);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN [ true ]");
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.classsource.internal.ClassSourceImpl", "processJandexSparse", bl);
        }
        return bl;
    }

    @Override
    public abstract void processSpecific(ClassSource_Streamer var1, Set<String> var2) throws ClassSource_Exception;
}

