/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.jandex.internal.Jandex_Utils;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataFile;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary;
import com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableTimeStampImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_ExternalConstants;
import com.ibm.wsspi.annocache.util.Util_Consumer;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.jboss.jandex.Index;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TargetCacheImpl_DataCon
extends TargetCacheImpl_DataBase
implements TargetCache_ExternalConstants {
    private static final String CLASS_NAME;
    public static final boolean IS_SOURCE = true;
    public static final boolean IS_RESULT = false;
    public static final boolean DO_READ_STRINGS = true;
    public static final boolean DO_READ_FULL = true;
    private final TargetCacheImpl_DataBase parentData;
    private final boolean isSource;
    private final TargetCacheImpl_DataFile stampLink;
    private final TargetCacheImpl_DataFile coreDataLink;
    private TargetsTableImpl targetsTable;
    static final long serialVersionUID = -989788161649446190L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TargetCacheImpl_DataCon(TargetCacheImpl_DataBase parentData, String conName, String e_conName, File conFile, boolean isSource) {
        super(parentData.getFactory(), conName, e_conName, conFile);
        String methodName = "<init>";
        this.parentData = parentData;
        this.isSource = isSource;
        this.stampLink = this.createPeerLink("stamp", "stamp");
        this.coreDataLink = this.getUseJandexFormat() ? this.createPeerLink("jandex.idx", "jandex.idx") : this.createPeerLink("data", "data");
        this.targetsTable = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Container [ {0} ] of [ {1} ]", new Object[]{this.getName(), parentData.getName()});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "IsComponent [ {0} ]", new Object[]{this.isSource});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Use Jandex Format [ {0} ] Use Binary Format [ {1} ]", new Object[]{this.getUseJandexFormat(), this.getUseBinaryFormat()});
            logger.logp(Level.FINER, CLASS_NAME, methodName, "{0}", this.stampLink);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "{0}", this.coreDataLink);
        }
    }

    protected TargetCacheImpl_DataFile createPeerLink(String cacheName, String cacheExt) {
        File peerFile;
        File useDataFile = this.getDataFile();
        if (useDataFile != null) {
            String peerName = useDataFile.getName() + "." + cacheExt;
            peerFile = new File(useDataFile.getParentFile(), peerName);
        } else {
            peerFile = null;
        }
        return new TargetCacheImpl_DataFile(cacheName, peerFile);
    }

    @Trivial
    public TargetCacheImpl_DataBase getParentData() {
        return this.parentData;
    }

    @Trivial
    public boolean getIsSource() {
        return this.isSource;
    }

    @Trivial
    public boolean getIsResult() {
        return !this.isSource;
    }

    @Trivial
    public boolean getUseJandexFormat() {
        if (!this.getIsSource()) {
            return false;
        }
        return this.getCacheOptions().getUseJandexFormat();
    }

    @Trivial
    public boolean getAlwaysValid() {
        return this.getCacheOptions().getAlwaysValid();
    }

    @Trivial
    public boolean getUseBinaryFormat() {
        return this.getCacheOptions().getUseBinaryFormat();
    }

    @Trivial
    public int getWriteLimit() {
        return this.getCacheOptions().getWriteLimit();
    }

    public boolean readCoreData(TargetsTableImpl targetData) {
        if (this.getUseJandexFormat()) {
            return this.basicReadJandex(targetData);
        }
        return this.basicReadCoreData(targetData);
    }

    public void writeData(TargetCacheImpl_DataMod modData, TargetsTableImpl targetData) {
        if (!this.shouldWrite("Full data")) {
            return;
        }
        if (targetData.getUsedJandex()) {
            return;
        }
        if (this.getUseJandexFormat()) {
            this.writeJandex(modData, targetData.consumeJandexIndex());
        } else {
            this.writeCoreData(modData, targetData);
        }
    }

    @Trivial
    protected TargetCacheImpl_DataFile getStampLink() {
        return this.stampLink;
    }

    @Trivial
    public File getStampFile() {
        return this.stampLink.getFile();
    }

    @Trivial
    public boolean getHasStampFile() {
        return this.stampLink.getHasFile();
    }

    protected void setHasStampFile(boolean hasStampFile) {
        this.stampLink.setHasFile(hasStampFile);
    }

    public boolean readStamp(final TargetsTableTimeStampImpl useStampTable) {
        boolean didRead;
        long readStart = System.nanoTime();
        File stampFile = this.getStampFile();
        if (this.getUseBinaryFormat()) {
            Util_Consumer<TargetCacheImpl_ReaderBinary, IOException> readAction = new Util_Consumer<TargetCacheImpl_ReaderBinary, IOException>(){
                static final long serialVersionUID = -6629077035825255202L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_ReaderBinary reader) throws IOException {
                    reader.readEntire(useStampTable);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = this.readBinary(stampFile, false, false, readAction);
        } else {
            didRead = this.read(stampFile, useStampTable);
        }
        long readDuration = this.addReadTime(readStart, "Stamp");
        return didRead;
    }

    private void writeStamp(TargetCacheImpl_DataMod modData, final TargetsTableTimeStampImpl useStampTable) {
        Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeActionBinary;
        Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction;
        if (this.getUseBinaryFormat()) {
            writeAction = null;
            writeActionBinary = new Util_Consumer<TargetCacheImpl_WriterBinary, IOException>(){
                static final long serialVersionUID = -9020437469839569276L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_WriterBinary useWriter) throws IOException {
                    useWriter.writeEntire(useStampTable);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon$2", 2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
        } else {
            writeAction = new Util_Consumer<TargetCacheImpl_Writer, IOException>(){
                static final long serialVersionUID = -8977166889071478712L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_Writer useWriter) throws IOException {
                    useWriter.write(useStampTable);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon$3", 3.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            writeActionBinary = null;
        }
        modData.scheduleWrite("Stamp", this.getStampFile(), true, writeAction, writeActionBinary);
    }

    @Trivial
    protected TargetCacheImpl_DataFile getCoreDataLink() {
        return this.coreDataLink;
    }

    @Trivial
    public File getCoreDataFile() {
        return this.coreDataLink.getFile();
    }

    @Trivial
    public boolean getHasCoreDataFile() {
        return this.coreDataLink.getHasFile();
    }

    protected void setHasCoreDataFile(boolean hasCombinedFile) {
        this.coreDataLink.setHasFile(hasCombinedFile);
    }

    public boolean basicReadCoreData(final TargetsTableImpl targetData) {
        boolean didRead;
        long readStart = System.nanoTime();
        File coreDataFile = this.getCoreDataFile();
        if (this.getUseBinaryFormat()) {
            Util_Consumer<TargetCacheImpl_ReaderBinary, IOException> readAction = new Util_Consumer<TargetCacheImpl_ReaderBinary, IOException>(){
                static final long serialVersionUID = -5008191246161616575L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_ReaderBinary reader) throws IOException {
                    reader.readEntire(targetData.getClassTable(), targetData.getAnnotationTable());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon$4", 4.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = this.readBinary(coreDataFile, true, true, readAction);
        } else {
            didRead = this.read(coreDataFile, targetData.getClassTable(), targetData.getAnnotationTable());
        }
        long readDuration = this.addReadTime(readStart, "Core Data");
        return didRead;
    }

    private void writeCoreData(TargetCacheImpl_DataMod modData, final TargetsTableImpl targetData) {
        Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeActionBinary;
        Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction;
        if (this.getUseBinaryFormat()) {
            writeAction = null;
            writeActionBinary = new Util_Consumer<TargetCacheImpl_WriterBinary, IOException>(){
                static final long serialVersionUID = 7869011965647106853L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_WriterBinary useWriter) throws IOException {
                    useWriter.writeEntire(targetData.getClassTable(), targetData.getAnnotationTable());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon$5", 5.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
        } else {
            writeAction = new Util_Consumer<TargetCacheImpl_Writer, IOException>(){
                static final long serialVersionUID = -6494545588678850736L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_Writer useWriter) throws IOException {
                    useWriter.write(targetData.getClassTable());
                    useWriter.write(targetData.getAnnotationTable());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon$6", 6.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            writeActionBinary = null;
        }
        modData.scheduleWrite("Core data", this.getCoreDataFile(), true, writeAction, writeActionBinary);
    }

    /*
     * WARNING - void declaration
     */
    private boolean basicReadJandex(TargetsTableImpl targetData) {
        boolean didRead;
        String methodName = "readJandex";
        long readStart = System.nanoTime();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Container [ " + this.getName() + " ] Jandex File [ " + this.getCoreDataLink() + " ]");
        }
        File coreDataFile = this.getCoreDataFile();
        String coreDataPath = coreDataFile.getPath();
        try {
            SparseIndex sparseIndex = Jandex_Utils.basicReadSparseIndex(coreDataPath);
            targetData.transfer(sparseIndex);
            didRead = true;
        }
        catch (IOException sparseIndex) {
            void e;
            FFDCFilter.processException((Throwable)sparseIndex, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon", (String)"462", (Object)this, (Object[])new Object[]{targetData});
            List<TargetCache_ParseError> errors = Collections.emptyList();
            this.readError(coreDataFile, (Exception)e, errors);
            didRead = false;
        }
        long readDuration = this.addReadTime(readStart, "Jandex");
        return didRead;
    }

    private void writeJandex(TargetCacheImpl_DataMod modData, final Index jandexIndex) {
        Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction = new Util_Consumer<TargetCacheImpl_Writer, IOException>(){
            static final long serialVersionUID = -5007613807355101484L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void accept(TargetCacheImpl_Writer useWriter) throws IOException {
                useWriter.write(jandexIndex);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon$7", 7.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        };
        modData.scheduleWrite("Jandex", this.getCoreDataFile(), true, writeAction, null);
    }

    public TargetsTableImpl getTargetsTable() {
        return this.targetsTable;
    }

    public void setTargetsTable(TargetsTableImpl targetsTable) {
        this.targetsTable = targetsTable;
    }

    @Override
    public boolean shouldRead(String inputDescription) {
        if (!this.getParentData().shouldRead(inputDescription)) {
            return false;
        }
        return super.shouldRead(inputDescription);
    }

    @Override
    public boolean shouldWrite(String outputDescription) {
        if (!this.getParentData().shouldWrite(outputDescription)) {
            return false;
        }
        return super.shouldWrite(outputDescription);
    }

    private void clearFiles() {
        this.stampLink.setHasFile(false);
        this.coreDataLink.setHasFile(false);
    }

    public boolean hasCoreDataFile() {
        if (!this.shouldRead("Full read")) {
            return false;
        }
        return this.getHasCoreDataFile();
    }

    public void writeStamp(TargetCacheImpl_DataMod modData, TargetsTableImpl targetData) {
        if (!this.shouldWrite("Time stamp")) {
            return;
        }
        this.writeStamp(modData, targetData.getStampTable());
    }

    public String isValid(TargetsScannerOverallImpl scanner, String classSourceName, String currentStamp) {
        boolean useAlwaysValid = this.getAlwaysValid();
        if ((currentStamp.equals("** UNRECORDED **") || currentStamp.equals("** UNAVAILABLE **")) && !useAlwaysValid) {
            return "Stamp unavailable";
        }
        TargetsTableImpl useTable = this.getTargetsTable();
        if (useTable != null) {
            if (useAlwaysValid) {
                return null;
            }
            if (currentStamp.equals(useTable.getStamp())) {
                return null;
            }
            return "Stamp change";
        }
        if (!this.getHasStampFile()) {
            return "No stamp file";
        }
        if (useAlwaysValid) {
            return null;
        }
        TargetsTableTimeStampImpl useStampTable = new TargetsTableTimeStampImpl(classSourceName);
        if (!this.readStamp(useStampTable)) {
            return "Stamp read failure";
        }
        if (!useStampTable.getStamp().equals(currentStamp)) {
            return "Stamp change";
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon", TargetCacheImpl_DataCon.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = TargetCacheImpl_DataCon.class.getSimpleName();
    }
}

